/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.DIBToImage;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.jmmf.DIBInfoHeader;
import nl.mpi.jmmf.JMMFException;
import nl.mpi.jmmf.JMMFPanel;
import nl.mpi.jmmf.JMMFPlayer;

public class JMMFMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener,
VideoFrameGrabber,
ActionListener,
PreferencesListener {
    private JMMFPlayer jmmfPlayer;
    private JMMFPanel jmmfPanel;
    private MediaDescriptor mediaDescriptor;
    private long offset = 0L;
    private long stopTime;
    private long duration;
    private long origDuration;
    private long eomBuffer = 0L;
    private float origAspectRatio = 0.0f;
    private float aspectRatio = 0.0f;
    private double millisPerSample;
    private PlayerStateWatcher stopThread = null;
    private EndOfTimeWatcher endTimeWatcher = null;
    private boolean isInited = false;
    private float cachedVolume = 1.0f;
    private float cachedRate = 1.0f;
    private boolean frameRateAutoDetected = true;
    private boolean frameStepsToFrameBegin = false;
    private ElanLayoutManager layoutManager;
    private JPopupMenu popup;
    private JMenuItem durationItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem saveItem;
    private JMenu arMenu;
    private JRadioButtonMenuItem origRatioItem;
    private JRadioButtonMenuItem ratio_4_3_Item;
    private JRadioButtonMenuItem ratio_3_2_Item;
    private JRadioButtonMenuItem ratio_16_9_Item;
    private JRadioButtonMenuItem ratio_185_1_Item;
    private JRadioButtonMenuItem ratio_235_1_Item;
    private JMenuItem copyOrigTimeItem;
    private boolean detached;
    private JMenu zoomMenu;
    private JRadioButtonMenuItem zoom100;
    private JRadioButtonMenuItem zoom150;
    private JRadioButtonMenuItem zoom200;
    private JRadioButtonMenuItem zoom300;
    private JRadioButtonMenuItem zoom400;
    private float videoScaleFactor = 1.0f;
    private int dragX = 0;
    private int dragY = 0;
    private int SET_MT_TIMEOUT = 1000;

    public JMMFMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        this.offset = mediaDescriptor.timeOrigin;
        String urlString = mediaDescriptor.mediaURL;
        if (urlString.startsWith("file:") && !urlString.startsWith("file:///")) {
            urlString = urlString.substring(5);
        }
        try {
            this.jmmfPlayer = new JMMFPlayer(urlString);
            if (this.jmmfPlayer.isVisualMedia()) {
                this.jmmfPanel = new JMMFPanel(this.jmmfPlayer);
                this.initPopupMenu();
                MouseHandler mh = new MouseHandler();
                this.jmmfPanel.addMouseListener(mh);
                this.jmmfPanel.addMouseMotionListener(mh);
                Object val = Preferences.get("Windows.JMMFPlayer.CorrectAtPause", null);
                if (val instanceof Boolean) {
                    JMMFPlayer.correctAtPause((Boolean)val);
                }
            }
        }
        catch (JMMFException je) {
            throw new NoPlayerException("JMMFPlayer cannot handle the file: " + je.getMessage());
        }
        catch (Throwable tr) {
            throw new NoPlayerException("JMMFPlayer cannot handle the file: " + tr.getMessage());
        }
    }

    @Override
    public void cleanUpOnClose() {
        if (this.jmmfPlayer != null) {
            if (this.endTimeWatcher != null) {
                this.endTimeWatcher.close();
            }
            if (this.jmmfPanel != null) {
                this.jmmfPanel.setPlayer(null);
            }
            if (this.layoutManager != null) {
                this.layoutManager.getViewerManager().disconnectListener(this);
            }
            this.jmmfPlayer.cleanUpOnClose();
            this.jmmfPlayer = null;
        }
    }

    @Override
    public float getAspectRatio() {
        if (this.aspectRatio != 0.0f) {
            return this.aspectRatio;
        }
        if (this.jmmfPlayer != null) {
            if (this.origAspectRatio == 0.0f) {
                this.origAspectRatio = this.jmmfPlayer.getAspectRatio();
            }
            this.aspectRatio = this.origAspectRatio;
        }
        return this.aspectRatio;
    }

    @Override
    public String getFrameworkDescription() {
        return "JMMF - Java with Microsoft Media Foundation Player";
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    @Override
    public long getMediaDuration() {
        if (this.duration <= 0L && this.jmmfPlayer != null) {
            if (this.origDuration == 0L) {
                this.origDuration = this.jmmfPlayer.getDuration();
            }
            this.duration = this.origDuration - this.offset;
        }
        return this.duration;
    }

    @Override
    public long getMediaTime() {
        if (this.jmmfPlayer != null) {
            return this.jmmfPlayer.getMediaTime() - this.offset;
        }
        return 0L;
    }

    @Override
    public long getMilliSecondsPerSample() {
        if (this.millisPerSample == 0.0 && this.jmmfPlayer != null) {
            this.millisPerSample = this.jmmfPlayer.getTimePerFrame();
            if (this.millisPerSample == 0.0) {
                this.millisPerSample = 40.0;
                this.frameRateAutoDetected = false;
            }
        }
        return (long)this.millisPerSample;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public float getRate() {
        if (this.jmmfPlayer != null) {
            return this.jmmfPlayer.getRate();
        }
        return 1.0f;
    }

    @Override
    public int getSourceHeight() {
        if (this.jmmfPlayer != null) {
            return this.jmmfPlayer.getSourceHeight();
        }
        return 0;
    }

    @Override
    public int getSourceWidth() {
        if (this.jmmfPlayer != null) {
            return this.jmmfPlayer.getSourceWidth();
        }
        return 0;
    }

    @Override
    public Component getVisualComponent() {
        if (!this.isInited) {
            new InitWaitThread().start();
        }
        return this.jmmfPanel;
    }

    @Override
    public float getVolume() {
        if (this.jmmfPlayer != null) {
            return this.jmmfPlayer.getVolume();
        }
        return 0.0f;
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return this.frameRateAutoDetected;
    }

    @Override
    public boolean isPlaying() {
        if (this.jmmfPlayer != null) {
            return this.jmmfPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void nextFrame() {
        if (this.jmmfPlayer != null) {
            if (this.jmmfPlayer.isPlaying()) {
                this.stop();
            }
            if (this.frameStepsToFrameBegin) {
                long curFrame = (long)((double)this.getMediaTime() / this.millisPerSample);
                this.setMediaTime((long)((double)(curFrame + 1L) * this.millisPerSample));
            } else {
                long curTime = this.jmmfPlayer.getMediaTime();
                curTime = (long)((double)curTime + this.millisPerSample);
                this.jmmfPlayer.setMediaTime(curTime);
                long sysTime = System.currentTimeMillis();
                while (this.jmmfPlayer.getState() == JMMFPlayer.PlayerState.SEEKING.value) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - sysTime <= (long)this.SET_MT_TIMEOUT) continue;
                }
                this.setControllersMediaTime(curTime - this.offset);
            }
        }
    }

    @Override
    public void playInterval(long startTime, long stopTime) {
        if (this.jmmfPlayer != null) {
            if (this.jmmfPlayer.isPlaying()) {
                this.stop();
            }
            this.setStopTime(stopTime);
            if (this.getMediaTime() != startTime + this.offset) {
                this.setMediaTimeAndWait(startTime);
            }
            this.startInterval();
        }
    }

    void startInterval() {
        if (this.jmmfPlayer != null) {
            if (this.jmmfPlayer.isPlaying()) {
                return;
            }
            this.startControllers();
            if (this.stopThread != null && this.stopThread.isAlive()) {
                this.stopThread.setStopped();
            }
            this.stopThread = new PlayerStateWatcher(200);
            this.stopThread.start();
            this.jmmfPlayer.start();
        }
    }

    @Override
    public void previousFrame() {
        if (this.jmmfPlayer != null) {
            if (this.jmmfPlayer.isPlaying()) {
                this.stop();
            }
            if (this.frameStepsToFrameBegin) {
                long curFrame = (long)((double)this.getMediaTime() / this.millisPerSample);
                if (curFrame > 0L) {
                    this.setMediaTime((long)((double)(curFrame - 1L) * this.millisPerSample));
                } else {
                    this.setMediaTime(0L);
                }
            } else {
                long curTime = this.jmmfPlayer.getMediaTime();
                if ((curTime = (long)((double)curTime - this.millisPerSample)) < 0L) {
                    curTime = 0L;
                }
                this.jmmfPlayer.setMediaTime(curTime);
                long sysTime = System.currentTimeMillis();
                while (this.jmmfPlayer.getState() == JMMFPlayer.PlayerState.SEEKING.value) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - sysTime <= (long)this.SET_MT_TIMEOUT) continue;
                }
                this.setControllersMediaTime(curTime - this.offset);
            }
        }
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        if (this.layoutManager != null) {
            this.detached = !this.layoutManager.isAttached(this);
            this.layoutManager.getViewerManager().connectListener(this);
        }
    }

    @Override
    public void setMediaTime(long time) {
        if (this.jmmfPlayer != null) {
            if (this.jmmfPlayer.isPlaying()) {
                this.stop();
            }
            if (time < 0L) {
                time = 0L;
            }
            if (time > this.duration - this.eomBuffer) {
                time = this.duration - this.eomBuffer;
            }
            this.jmmfPlayer.setMediaTime(time + this.offset);
            long curTime = System.currentTimeMillis();
            while (this.jmmfPlayer.getState() == JMMFPlayer.PlayerState.SEEKING.value) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - curTime <= (long)this.SET_MT_TIMEOUT) continue;
            }
            this.setControllersMediaTime(time);
        }
    }

    private void setMediaTimeAndWait(long time) {
        if (this.jmmfPlayer != null) {
            if (this.jmmfPlayer.isPlaying()) {
                this.stop();
            }
            if (time < 0L) {
                time = 0L;
            }
            if (time > this.duration) {
                time = this.duration;
            }
            this.jmmfPlayer.setMediaTime(time + this.offset);
            long sysTime = System.currentTimeMillis();
            while (this.jmmfPlayer.getState() == JMMFPlayer.PlayerState.SEEKING.value) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - sysTime <= (long)this.SET_MT_TIMEOUT) continue;
            }
            this.setControllersMediaTime(time);
        }
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.frameRateAutoDetected) {
            this.millisPerSample = milliSeconds;
        }
    }

    @Override
    public void setOffset(long offset) {
        long diff = this.offset - offset;
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        if (this.jmmfPlayer != null) {
            if (this.origDuration == 0L) {
                this.origDuration = this.jmmfPlayer.getDuration();
            }
            this.duration = this.origDuration - offset;
        }
        this.stopTime += diff;
        this.setStopTime(this.stopTime);
    }

    @Override
    public void setRate(float rate) {
        if (!this.isInited) {
            this.cachedRate = rate;
        }
        if (this.jmmfPlayer != null) {
            this.jmmfPlayer.setRate(rate);
        }
        this.setControllersRate(rate);
    }

    @Override
    public void setStopTime(long stopTime) {
        long nFrames;
        this.stopTime = stopTime;
        long msps = this.getMilliSecondsPerSample();
        if (msps != 0L && (nFrames = (stopTime + this.offset) / msps) * msps == stopTime + this.offset) {
            ++this.stopTime;
        }
        if (this.jmmfPlayer != null) {
            this.jmmfPlayer.setStopTime(this.stopTime + this.offset);
        }
        this.setControllersStopTime(this.stopTime);
    }

    @Override
    public void setVolume(float level) {
        if (!this.isInited) {
            this.cachedVolume = level;
        }
        if (this.jmmfPlayer != null) {
            this.jmmfPlayer.setVolume(level);
        }
    }

    @Override
    public void start() {
        if (this.jmmfPlayer != null) {
            if (this.jmmfPlayer.isPlaying()) {
                return;
            }
            if (this.getMediaDuration() - this.getMediaTime() < 40L) {
                this.setMediaTime(0L);
            }
            this.jmmfPlayer.start();
            long sysTime = System.currentTimeMillis();
            while (this.jmmfPlayer.getState() != JMMFPlayer.PlayerState.STARTED.value) {
                try {
                    Thread.sleep(4L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - sysTime <= (long)this.SET_MT_TIMEOUT) continue;
            }
            this.startControllers();
            if (this.endTimeWatcher == null) {
                this.endTimeWatcher = new EndOfTimeWatcher(250);
                this.endTimeWatcher.setNormalPlayback(true);
                this.endTimeWatcher.setPlaying(true);
                this.endTimeWatcher.start();
            } else {
                this.endTimeWatcher.setNormalPlayback(true);
                this.endTimeWatcher.setPlaying(true);
            }
        }
    }

    @Override
    public void stop() {
        if (this.jmmfPlayer != null) {
            if (!this.jmmfPlayer.isPlaying()) {
                return;
            }
            if (this.stopThread != null) {
                this.stopThread.setStopped();
            }
            this.jmmfPlayer.pause();
            this.stopControllers();
            if (this.endTimeWatcher != null) {
                this.endTimeWatcher.setPlaying(false);
            }
            long sysTime = System.currentTimeMillis();
            while (this.jmmfPlayer.getState() != JMMFPlayer.PlayerState.PAUSED.value) {
                try {
                    Thread.sleep(4L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - sysTime <= (long)this.SET_MT_TIMEOUT) continue;
            }
            this.setControllersMediaTime(this.getMediaTime());
            this.jmmfPlayer.repaintVideo();
            if (this.jmmfPlayer.getStopTime() != this.duration - 10L) {
                this.setStopTime(this.duration - 10L);
            }
        }
    }

    @Override
    public void updateLocale() {
        if (this.popup != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
            this.infoItem.setText(ElanLocale.getString("Player.Info"));
            this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
            this.saveItem.setText(ElanLocale.getString("Player.SaveFrame"));
            this.origRatioItem.setText(ElanLocale.getString("Player.ResetAspectRatio"));
            this.arMenu.setText(ElanLocale.getString("Player.ForceAspectRatio"));
            if (this.copyOrigTimeItem != null) {
                this.copyOrigTimeItem.setText(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
            }
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public Image getCurrentFrameImage() {
        return this.getFrameImageForTime(this.getMediaTime());
    }

    @Override
    public Image getFrameImageForTime(long time) {
        if (this.jmmfPlayer == null) {
            return null;
        }
        if (this.jmmfPlayer.isPlaying()) {
            this.stop();
        }
        if (time != this.getMediaTime()) {
            this.setMediaTime(time);
        }
        BufferedImage image = null;
        DIBInfoHeader dih = new DIBInfoHeader();
        byte[] data = this.jmmfPlayer.getCurrentImageData(dih);
        image = DIBToImage.DIBDataToBufferedImage(dih, data);
        return image;
    }

    private void initPopupMenu() {
        if (this.jmmfPanel == null) {
            return;
        }
        this.popup = new JPopupMenu();
        this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.detach"));
        this.detachItem.addActionListener(this);
        this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
        this.infoItem.addActionListener(this);
        this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.duration));
        this.durationItem.setEnabled(false);
        this.saveItem = new JMenuItem(ElanLocale.getString("Player.SaveFrame"));
        this.saveItem.addActionListener(this);
        this.origRatioItem = new JRadioButtonMenuItem(ElanLocale.getString("Player.ResetAspectRatio"), true);
        this.origRatioItem.setActionCommand("ratio_orig");
        this.origRatioItem.addActionListener(this);
        this.ratio_4_3_Item = new JRadioButtonMenuItem("4:3");
        this.ratio_4_3_Item.setActionCommand("ratio_4_3");
        this.ratio_4_3_Item.addActionListener(this);
        this.ratio_3_2_Item = new JRadioButtonMenuItem("3:2");
        this.ratio_3_2_Item.setActionCommand("ratio_3_2");
        this.ratio_3_2_Item.addActionListener(this);
        this.ratio_16_9_Item = new JRadioButtonMenuItem("16:9");
        this.ratio_16_9_Item.setActionCommand("ratio_16_9");
        this.ratio_16_9_Item.addActionListener(this);
        this.ratio_185_1_Item = new JRadioButtonMenuItem("1.85:1");
        this.ratio_185_1_Item.setActionCommand("ratio_185_1");
        this.ratio_185_1_Item.addActionListener(this);
        this.ratio_235_1_Item = new JRadioButtonMenuItem("2.35:1");
        this.ratio_235_1_Item.setActionCommand("ratio_235_1");
        this.ratio_235_1_Item.addActionListener(this);
        this.arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
        ButtonGroup arbg = new ButtonGroup();
        arbg.add(this.origRatioItem);
        arbg.add(this.ratio_4_3_Item);
        arbg.add(this.ratio_3_2_Item);
        arbg.add(this.ratio_16_9_Item);
        arbg.add(this.ratio_185_1_Item);
        arbg.add(this.ratio_235_1_Item);
        this.arMenu.add(this.origRatioItem);
        this.arMenu.addSeparator();
        this.arMenu.add(this.ratio_4_3_Item);
        this.arMenu.add(this.ratio_3_2_Item);
        this.arMenu.add(this.ratio_16_9_Item);
        this.arMenu.add(this.ratio_185_1_Item);
        this.arMenu.add(this.ratio_235_1_Item);
        this.copyOrigTimeItem = new JMenuItem(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
        this.copyOrigTimeItem.addActionListener(this);
        this.zoomMenu = new JMenu(ElanLocale.getString("Menu.Zoom"));
        this.zoom100 = new JRadioButtonMenuItem("100%", this.videoScaleFactor == 1.0f);
        this.zoom100.setActionCommand("zoom100");
        this.zoom100.addActionListener(this);
        this.zoom150 = new JRadioButtonMenuItem("150%", (double)this.videoScaleFactor == 1.5);
        this.zoom150.setActionCommand("zoom150");
        this.zoom150.addActionListener(this);
        this.zoom200 = new JRadioButtonMenuItem("200%", this.videoScaleFactor == 2.0f);
        this.zoom200.setActionCommand("zoom200");
        this.zoom200.addActionListener(this);
        this.zoom300 = new JRadioButtonMenuItem("300%", this.videoScaleFactor == 3.0f);
        this.zoom300.setActionCommand("zoom300");
        this.zoom300.addActionListener(this);
        this.zoom400 = new JRadioButtonMenuItem("400%", this.videoScaleFactor == 4.0f);
        this.zoom400.setActionCommand("zoom400");
        this.zoom400.addActionListener(this);
        ButtonGroup zbg = new ButtonGroup();
        zbg.add(this.zoom100);
        zbg.add(this.zoom150);
        zbg.add(this.zoom200);
        zbg.add(this.zoom300);
        zbg.add(this.zoom400);
        this.zoomMenu.add(this.zoom100);
        this.zoomMenu.add(this.zoom150);
        this.zoomMenu.add(this.zoom200);
        this.zoomMenu.add(this.zoom300);
        this.zoomMenu.add(this.zoom400);
        this.popup.add(this.detachItem);
        this.popup.addSeparator();
        this.popup.add(this.saveItem);
        this.popup.add(this.infoItem);
        this.popup.add(this.arMenu);
        this.popup.add(this.zoomMenu);
        this.popup.add(this.durationItem);
        this.popup.add(this.copyOrigTimeItem);
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void preferencesChanged() {
        Object val = Preferences.get("Windows.JMMFPlayer.CorrectAtPause", null);
        if (val instanceof Boolean) {
            JMMFPlayer.correctAtPause((Boolean)val);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.detached = true;
            }
            this.getVisualComponent().addNotify();
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.saveItem) {
            ImageExporter export = new ImageExporter();
            export.exportImage((BufferedImage)this.getCurrentFrameImage());
        } else if (e.getActionCommand().startsWith("ratio")) {
            if (e.getSource() == this.origRatioItem) {
                this.aspectRatio = this.origAspectRatio;
            } else if (e.getSource() == this.ratio_4_3_Item) {
                this.aspectRatio = 1.33f;
            } else if (e.getSource() == this.ratio_3_2_Item) {
                this.aspectRatio = 1.66f;
            } else if (e.getSource() == this.ratio_16_9_Item) {
                this.aspectRatio = 1.78f;
            } else if (e.getSource() == this.ratio_185_1_Item) {
                this.aspectRatio = 1.85f;
            } else if (e.getSource() == this.ratio_235_1_Item) {
                this.aspectRatio = 2.35f;
            }
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getActionCommand().startsWith("zoom")) {
            if (e.getSource() == this.zoom100) {
                this.videoScaleFactor = 1.0f;
            } else if (e.getSource() == this.zoom150) {
                this.videoScaleFactor = 1.5f;
            } else if (e.getSource() == this.zoom200) {
                this.videoScaleFactor = 2.0f;
            } else if (e.getSource() == this.zoom300) {
                this.videoScaleFactor = 3.0f;
            } else if (e.getSource() == this.zoom400) {
                this.videoScaleFactor = 4.0f;
            }
            this.jmmfPlayer.setVideoScaleFactor(this.videoScaleFactor);
            this.layoutManager.setPreference("VideoZoom(" + this.mediaDescriptor.mediaURL + ")", new Float(this.videoScaleFactor), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.copyOrigTimeItem) {
            long t = this.getMediaTime() + this.offset;
            Object val = Preferences.get("CurrentTime.Copy.TimeFormat", null);
            String timeFormat = null;
            String currentTime = null;
            currentTime = val instanceof String ? ((timeFormat = val.toString()).equals("hh:mm:ss.ms") ? TimeFormatter.toString(t) : (timeFormat.equals("ss.ms") ? TimeFormatter.toSSMSString(t) : (timeFormat.equals("NTSC") ? TimeFormatter.toTimecodeNTSC(t) : (timeFormat.equals("PAL") ? TimeFormatter.toTimecodePAL(t) : Long.toString(t))))) : Long.toString(t);
            this.copyToClipboard(currentTime);
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private final DecimalFormat format = new DecimalFormat("#.###");

        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (JMMFMediaPlayer.this.layoutManager != null) {
                    JMMFMediaPlayer.this.layoutManager.setFirstPlayer(JMMFMediaPlayer.this);
                }
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            try {
                int[] vidDest = JMMFMediaPlayer.this.jmmfPlayer.getVideoDestinationPos();
                if (vidDest != null) {
                    int nx = e.getX() - vidDest[0];
                    int ny = e.getY() - vidDest[1];
                    if (JMMFMediaPlayer.this.videoScaleFactor > 1.0f) {
                        int[] vidCoords = JMMFMediaPlayer.this.jmmfPlayer.getVideoTranslation();
                        int[] vidSize = JMMFMediaPlayer.this.jmmfPlayer.getScaledVideoRect();
                        nx = e.getX() - vidCoords[0];
                        ny = e.getY() - vidCoords[1];
                        if (vidSize[0] != 0 && vidSize[1] != 0) {
                            nx = (int)((float)vidDest[2] * ((float)nx / (float)vidSize[0]));
                            ny = (int)((float)vidDest[3] * ((float)ny / (float)vidSize[1]));
                        }
                    }
                    if (e.isAltDown()) {
                        JMMFMediaPlayer.this.copyToClipboard(this.format.format((float)nx / (float)vidDest[2]) + "," + this.format.format((float)ny / (float)vidDest[3]));
                    } else if (e.isShiftDown()) {
                        JMMFMediaPlayer.this.copyToClipboard("" + (int)((float)JMMFMediaPlayer.this.jmmfPlayer.getSourceWidth() / (float)vidDest[2] * (float)nx) + "," + (int)((float)JMMFMediaPlayer.this.jmmfPlayer.getSourceHeight() / (float)vidDest[3] * (float)ny));
                    } else {
                        JMMFMediaPlayer.this.copyToClipboard("" + (int)((float)JMMFMediaPlayer.this.jmmfPlayer.getSourceWidth() / (float)vidDest[2] * (float)nx) + "," + (int)((float)JMMFMediaPlayer.this.jmmfPlayer.getSourceHeight() / (float)vidDest[3] * (float)ny) + " [" + JMMFMediaPlayer.this.jmmfPlayer.getSourceWidth() + "," + JMMFMediaPlayer.this.jmmfPlayer.getSourceHeight() + "]");
                    }
                }
            }
            catch (Exception exep) {
                exep.printStackTrace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point cl = e.getPoint();
            if (SwingUtilities.isRightMouseButton(e)) {
                if (JMMFMediaPlayer.this.layoutManager.isAttached(JMMFMediaPlayer.this) && JMMFMediaPlayer.this.detached) {
                    JMMFMediaPlayer.this.detached = false;
                    JMMFMediaPlayer.this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                }
                JMMFMediaPlayer.this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(JMMFMediaPlayer.this.duration));
                JMMFMediaPlayer.this.popup.show(JMMFMediaPlayer.this.getVisualComponent(), (int)cl.getX(), (int)cl.getY());
                return;
            }
            JMMFMediaPlayer.this.dragX = (int)cl.getX();
            JMMFMediaPlayer.this.dragY = (int)cl.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int dx = JMMFMediaPlayer.this.dragX - e.getX();
            int dy = JMMFMediaPlayer.this.dragY - e.getY();
            JMMFMediaPlayer.this.dragX = e.getX();
            JMMFMediaPlayer.this.dragY = e.getY();
            JMMFMediaPlayer.this.jmmfPlayer.moveVideoPos(-dx, -dy);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private Point adjustCoords(Component comp, Point org) {
            try {
                Point p = comp.getLocationOnScreen();
                return new Point((int)(p.getX() + org.getX()), (int)(p.getY() + org.getY()));
            }
            catch (Exception exception) {
                return org;
            }
        }
    }

    private class EndOfTimeWatcher
    extends Thread {
        private int sleepInterval = 250;
        private volatile boolean normalPlayback = true;
        private volatile boolean isPlaying = false;
        private boolean closed = false;

        EndOfTimeWatcher(int sleepInterval) {
            if (sleepInterval > 0) {
                this.sleepInterval = sleepInterval;
            }
        }

        public synchronized void setNormalPlayback(boolean normalPlayback) {
            this.normalPlayback = normalPlayback;
        }

        public synchronized void setPlaying(boolean isPlaying) {
            this.isPlaying = isPlaying;
            if (isPlaying) {
                this.notify();
            }
        }

        public void close() {
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.closed) {
                try {
                    Thread.sleep(this.sleepInterval);
                    EndOfTimeWatcher endOfTimeWatcher = this;
                    synchronized (endOfTimeWatcher) {
                        while (!this.isPlaying || !this.normalPlayback) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                long curMediaTime = JMMFMediaPlayer.this.getMediaTime();
                if (curMediaTime >= JMMFMediaPlayer.this.getMediaDuration() - JMMFMediaPlayer.this.eomBuffer) {
                    if (JMMFMediaPlayer.this.jmmfPlayer.isPlaying()) {
                        JMMFMediaPlayer.this.stop();
                        JMMFMediaPlayer.this.stopControllers();
                        this.isPlaying = false;
                        continue;
                    }
                    JMMFMediaPlayer.this.stopControllers();
                    this.isPlaying = false;
                    continue;
                }
                if (curMediaTime == 0L) {
                    if (JMMFMediaPlayer.this.jmmfPlayer.isPlaying()) {
                        JMMFMediaPlayer.this.stop();
                        JMMFMediaPlayer.this.stopControllers();
                        this.isPlaying = false;
                        continue;
                    }
                    JMMFMediaPlayer.this.stopControllers();
                    this.isPlaying = false;
                    continue;
                }
                if (JMMFMediaPlayer.this.jmmfPlayer.getState() != JMMFPlayer.PlayerState.PAUSED.value && JMMFMediaPlayer.this.jmmfPlayer.getState() != JMMFPlayer.PlayerState.STOPPED.value || !this.isPlaying) continue;
                JMMFMediaPlayer.this.stop();
                JMMFMediaPlayer.this.stopControllers();
                this.isPlaying = false;
            }
        }
    }

    private class PlayerStateWatcher
    extends Thread {
        private int sleepInterval = 250;
        private boolean stopped = false;

        public PlayerStateWatcher(int sleepInterval) {
            if (sleepInterval > 0) {
                this.sleepInterval = sleepInterval;
            }
        }

        public void setStopped() {
            this.stopped = true;
        }

        @Override
        public void run() {
            long refTime = JMMFMediaPlayer.this.stopTime + JMMFMediaPlayer.this.offset;
            while (!this.stopped && JMMFMediaPlayer.this.getMediaTime() < refTime) {
                try {
                    Thread.sleep(this.sleepInterval);
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (JMMFMediaPlayer.this.jmmfPlayer.isPlaying()) continue;
            }
            if (this.stopped) {
                return;
            }
            if (JMMFMediaPlayer.this.jmmfPlayer.isPlaying()) {
                JMMFMediaPlayer.this.stop();
                JMMFMediaPlayer.this.stopControllers();
                JMMFMediaPlayer.this.jmmfPlayer.setMediaTime(refTime);
                JMMFMediaPlayer.this.setControllersMediaTime(JMMFMediaPlayer.this.getMediaTime());
                JMMFMediaPlayer.this.setStopTime(JMMFMediaPlayer.this.duration - JMMFMediaPlayer.this.eomBuffer);
            } else {
                JMMFMediaPlayer.this.stopControllers();
                JMMFMediaPlayer.this.jmmfPlayer.setMediaTime(refTime);
                JMMFMediaPlayer.this.setControllersMediaTime(JMMFMediaPlayer.this.getMediaTime());
                JMMFMediaPlayer.this.setStopTime(JMMFMediaPlayer.this.duration - JMMFMediaPlayer.this.eomBuffer);
            }
        }
    }

    private class InitWaitThread
    extends Thread {
        final int MAX_TRIES = 30;
        int count = 0;

        private InitWaitThread() {
        }

        @Override
        public void run() {
            int state = 0;
            do {
                state = JMMFMediaPlayer.this.jmmfPlayer.getState();
                ++this.count;
                if (state >= JMMFPlayer.PlayerState.STARTED.value && state < JMMFPlayer.PlayerState.CLOSING.value) {
                    JMMFMediaPlayer.this.isInited = true;
                    System.out.println("JMMFMediaPlayer: Init Session");
                    System.out.println("Aspect Ratio: " + JMMFMediaPlayer.this.jmmfPlayer.getAspectRatio());
                    System.out.println("Duration: " + JMMFMediaPlayer.this.jmmfPlayer.getDuration());
                    System.out.println("Time per frame: " + JMMFMediaPlayer.this.jmmfPlayer.getTimePerFrame());
                    JMMFMediaPlayer.this.origDuration = JMMFMediaPlayer.this.jmmfPlayer.getDuration();
                    int[] ar = JMMFMediaPlayer.this.jmmfPlayer.getPreferredAspectRatio();
                    if (ar != null && ar.length == 2) {
                        JMMFMediaPlayer.this.origAspectRatio = (float)ar[0] / (float)ar[1];
                        if (JMMFMediaPlayer.this.origAspectRatio != JMMFMediaPlayer.this.jmmfPlayer.getAspectRatio()) {
                            System.out.println("Preferred Aspect Ratio: " + JMMFMediaPlayer.this.origAspectRatio);
                        }
                    }
                    JMMFMediaPlayer.this.millisPerSample = JMMFMediaPlayer.this.jmmfPlayer.getTimePerFrame();
                    JMMFMediaPlayer.this.eomBuffer = (long)(5.0 * JMMFMediaPlayer.this.millisPerSample);
                    if (JMMFMediaPlayer.this.durationItem != null) {
                        JMMFMediaPlayer.this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(JMMFMediaPlayer.this.getMediaDuration()));
                    }
                    JMMFMediaPlayer.this.setVolume(JMMFMediaPlayer.this.cachedVolume);
                    JMMFMediaPlayer.this.setRate(JMMFMediaPlayer.this.cachedRate);
                    JMMFMediaPlayer.this.layoutManager.doLayout();
                    break;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.count <= 30);
        }
    }
}

