/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import com.jniwrapper.ArrayParameter;
import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.DoubleFloat;
import com.jniwrapper.ExternalArrayPointer;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt8;
import com.jniwrapper.win32.automation.IDispatch;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.types.ClsCtx;
import com.jniwrapper.win32.com.types.LongPtr;
import com.jniwrapper.win32.ole.OleFunctions;
import com.jniwrapper.win32.ui.WindowTools;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.FilgraphManager;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.IBasicAudio;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.IBasicVideo2;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.IMediaControl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.IMediaEventEx;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.IMediaPosition;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.IMediaTypeInfo;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.IVideoWindow;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IAMCollectionImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IBasicAudioImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IBasicVideo2Impl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IBasicVideoImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IFilterInfoImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IMediaEventExImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IMediaPositionImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IMediaTypeInfoImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IPinInfoImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IRegFilterInfoImpl;
import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.IVideoWindowImpl;
import mpi.eudico.client.annotator.player.DIBToImage;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;

public class NativeMediaPlayerWindowsDS
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener,
VideoFrameGrabber,
ActionListener {
    private static final int STATE_STOP = 0;
    private static final int STATE_PAUSE = 1;
    private static final int STATE_RUN = 2;
    private static final int DIRECT_SHOW_TRUE = -1;
    private static final String CALLBACK_WINDOW_CLASS_NAME = "CallbackWindowClass";
    private static final String MEDIA_TYPE_WAVE = "{e436eb8b-524f-11ce-9f53-0020af0ba770}";
    private static final String MEDIA_TYPE_MPG1 = "{e436eb84-524f-11ce-9f53-0020af0ba770}";
    private static final String MEDIA_TYPE_MPG2 = "{e06d8022-db46-11cf-b4d1-00805f6cbbea}";
    private MediaDescriptor mediaDescriptor;
    private IMediaControl mediaControl;
    private IMediaPosition mediaPosition;
    private IBasicAudio basicAudio;
    private IBasicVideo2 basicVideo;
    private IVideoWindow videoWindow;
    private IMediaEventEx mediaEvent;
    private IMediaTypeInfo mediaTypeInfo;
    private VisualComponent visualComponent;
    private Wnd videoWnd;
    private boolean playing;
    private long offset;
    private long duration;
    private long stopTime;
    private boolean adjustedStopTime;
    private float aspectRatio;
    private double millisPerSample;
    private JPopupMenu popup;
    private JMenuItem durationItem;
    private JMenuItem copyOrigTimeItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem saveItem;
    private JMenuItem ratio_4_3_Item;
    private JMenuItem ratio_3_2_Item;
    private JMenuItem ratio_16_9_Item;
    private JMenuItem ratio_185_1_Item;
    private JMenuItem ratio_235_1_Item;
    private ElanLayoutManager layoutManager;
    private boolean detached;
    private boolean isWaveMedia;
    private boolean isMpeg1Media;
    private boolean isMpeg2Media;
    private boolean mediaInfoDetected;
    private static boolean regFiltersPrinted = false;
    private boolean frameRateAutoDetected = true;
    private boolean frameStepsToFrameBegin = false;
    private static String initError = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NativeMediaPlayerWindowsDS(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        if (initError != null) {
            throw new NoPlayerException(initError);
        }
        try {
            this.mediaDescriptor = mediaDescriptor;
            String URLString = mediaDescriptor.mediaURL;
            if (URLString.startsWith("file:") && !URLString.startsWith("file:///")) {
                URLString = URLString.substring(5);
            }
            OleFunctions.oleInitialize();
            this.mediaControl = FilgraphManager.create(ClsCtx.INPROC_SERVER);
            this.printRegisteredFilters();
            this.mediaControl.renderFile(new BStr(URLString));
            IMediaPositionImpl mp = new IMediaPositionImpl();
            this.mediaControl.queryInterface(mp.getIID(), (IUnknown)mp);
            this.mediaPosition = mp;
            IVideoWindowImpl vw = new IVideoWindowImpl();
            this.mediaControl.queryInterface(vw.getIID(), (IUnknown)vw);
            this.videoWindow = vw;
            IBasicVideo2Impl bv = new IBasicVideo2Impl();
            this.mediaControl.queryInterface(bv.getIID(), (IUnknown)bv);
            this.basicVideo = bv;
            IBasicAudioImpl ba = new IBasicAudioImpl();
            this.mediaControl.queryInterface(ba.getIID(), (IUnknown)ba);
            this.basicAudio = ba;
            IMediaEventExImpl me = new IMediaEventExImpl();
            this.mediaControl.queryInterface(me.getIID(), (IUnknown)me);
            this.mediaEvent = me;
            this.detectMediaType();
            try {
                if (!this.isMpeg1Media) {
                    // empty if block
                }
            }
            catch (ComException cex) {
                System.out.println("Could not adjust media filters...");
                cex.printStackTrace();
            }
            if (this.isWaveMedia || mediaDescriptor.mimeType.equals("audio/*")) {
                this.visualComponent = null;
                this.millisPerSample = 40.0;
                this.frameRateAutoDetected = false;
            } else {
                this.visualComponent = new VisualComponent();
                this.visualComponent.addMouseListener(new MouseHandler());
                this.mediaControl.pause();
                Int32 plX = new Int32();
                Int32 plY = new Int32();
                this.basicVideo.getPreferredAspectRatio(plX, plY);
                this.aspectRatio = (float)plX.getValue() / (float)plY.getValue();
                if ((double)this.aspectRatio == 0.0) {
                    this.aspectRatio = (float)this.basicVideo.getSourceWidth().getValue() / (float)this.basicVideo.getSourceHeight().getValue();
                }
                System.out.println("Aspect Ratio: " + this.aspectRatio);
                double tpf = this.basicVideo.getAvgTimePerFrame().getValue();
                this.millisPerSample = 1000.0 * tpf;
                System.out.println("Millis per Sample: " + this.millisPerSample);
                if (this.millisPerSample == 0.0) {
                    this.millisPerSample = 40.0;
                    this.frameRateAutoDetected = false;
                }
            }
            this.offset = mediaDescriptor.timeOrigin;
            System.out.println("offset: " + this.offset);
            this.duration = (long)(1000.0 * this.mediaPosition.getDuration().getValue()) - this.offset;
            System.out.println("duration: " + this.duration);
            this.stopTime = this.duration;
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.popup = new JPopupMenu();
            this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
            this.infoItem.addActionListener(this);
            this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
            this.durationItem.setEnabled(false);
            this.saveItem = new JMenuItem(ElanLocale.getString("Player.SaveFrame"));
            this.saveItem.addActionListener(this);
            this.ratio_4_3_Item = new JMenuItem("4:3");
            this.ratio_4_3_Item.addActionListener(this);
            this.ratio_3_2_Item = new JMenuItem("3:2");
            this.ratio_3_2_Item.addActionListener(this);
            this.ratio_16_9_Item = new JMenuItem("16:9");
            this.ratio_16_9_Item.addActionListener(this);
            this.ratio_185_1_Item = new JMenuItem("1.85:1");
            this.ratio_185_1_Item.addActionListener(this);
            this.ratio_235_1_Item = new JMenuItem("2.35:1");
            this.ratio_235_1_Item.addActionListener(this);
            JMenu arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
            arMenu.add(this.ratio_4_3_Item);
            arMenu.add(this.ratio_3_2_Item);
            arMenu.add(this.ratio_16_9_Item);
            arMenu.add(this.ratio_185_1_Item);
            arMenu.add(this.ratio_235_1_Item);
            this.copyOrigTimeItem = new JMenuItem(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
            this.copyOrigTimeItem.addActionListener(this);
            this.popup.addSeparator();
            this.popup.add(this.saveItem);
            this.popup.add(this.infoItem);
            this.popup.add(arMenu);
            this.popup.add(this.durationItem);
            this.popup.add(this.copyOrigTimeItem);
            return;
        }
        catch (ComException e) {
            e.printStackTrace();
            throw new NoPlayerException("Problem while creating directshow based media player: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoPlayerException("Problem while creating directshow based media player: " + e.getMessage());
        }
        catch (Throwable tr) {
            throw new NoPlayerException("Problem while creating directshow based media player: " + tr.getMessage());
        }
    }

    public void finalize() throws Throwable {
        System.out.println("Finalize media player...");
        OleFunctions.oleUninitialize();
        super.finalize();
    }

    @Override
    public void cleanUpOnClose() {
        System.out.println("Clean up media player...");
        OleFunctions.oleUninitialize();
        this.mediaControl = null;
        this.mediaPosition = null;
        this.basicAudio = null;
        this.basicVideo = null;
        this.videoWindow = null;
    }

    private void detectMediaType() {
        if (this.mediaInfoDetected) {
            return;
        }
        this.mediaControl.stop();
        IFilterInfoImpl filterInfo = new IFilterInfoImpl();
        IPinInfoImpl pinInfo = new IPinInfoImpl();
        IAMCollectionImpl filterColl = new IAMCollectionImpl();
        IAMCollectionImpl pinColl = new IAMCollectionImpl();
        IMediaTypeInfoImpl mediaInfo = new IMediaTypeInfoImpl();
        this.mediaControl.stop();
        this.mediaControl.getFilterCollection().queryInterface(filterColl.getIID(), (IUnknown)filterColl);
        long nFilters = filterColl.getCount().getValue();
        int i = 0;
        while ((long)i < nFilters) {
            filterColl.item(new Int32(i)).queryInterface(filterInfo.getIID(), (IUnknown)filterInfo);
            if (filterInfo.getIsFileSource().getValue() == -1L) {
                filterInfo.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
                long nPins = pinColl.getCount().getValue();
                int j = 0;
                while ((long)j < nPins) {
                    pinColl.item(new Int32(j)).queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                    if (pinInfo.getName().getValue().equalsIgnoreCase("output")) {
                        pinInfo.getConnectionMediaType().queryInterface(mediaInfo.getIID(), (IUnknown)mediaInfo);
                        if (mediaInfo.getSubtype().getValue().equalsIgnoreCase(MEDIA_TYPE_WAVE)) {
                            this.isWaveMedia = true;
                        } else if (mediaInfo.getSubtype().getValue().equalsIgnoreCase(MEDIA_TYPE_MPG1)) {
                            this.isMpeg1Media = true;
                        } else if (mediaInfo.getSubtype().getValue().equalsIgnoreCase(MEDIA_TYPE_MPG2)) {
                            this.isMpeg2Media = true;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.mediaInfoDetected = true;
        this.printFilterInfo();
    }

    private void printFilterInfo() {
        try {
            this.mediaControl.stop();
            System.out.println("Filters in the filter chain: ");
            IFilterInfoImpl filterInfo = new IFilterInfoImpl();
            IPinInfoImpl pinInfo = new IPinInfoImpl();
            IAMCollectionImpl filterColl = new IAMCollectionImpl();
            IAMCollectionImpl pinColl = new IAMCollectionImpl();
            this.mediaControl.stop();
            this.mediaControl.getFilterCollection().queryInterface(filterColl.getIID(), (IUnknown)filterColl);
            long nFilters = filterColl.getCount().getValue();
            int i = 0;
            while ((long)i < nFilters) {
                filterColl.item(new Int32(i)).queryInterface(filterInfo.getIID(), (IUnknown)filterInfo);
                System.out.println("index: " + i + "  name: " + filterInfo.getName().getValue());
                filterInfo.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
                long nPins = pinColl.getCount().getValue();
                int j = 0;
                while ((long)j < nPins) {
                    pinColl.item(new Int32(j)).queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                    System.out.println("\tpin: " + j + "  name: " + pinInfo.getName().getValue());
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Could not print the filter chain...");
            System.out.println(e.getMessage());
        }
    }

    private void printRegisteredFilters() {
        if (regFiltersPrinted) {
            return;
        }
        System.out.println("Filters listed in the registry...");
        try {
            IAMCollectionImpl filterColl = new IAMCollectionImpl();
            IRegFilterInfoImpl filterInfo = new IRegFilterInfoImpl();
            this.mediaControl.getRegFilterCollection().queryInterface(filterColl.getIID(), (IUnknown)filterColl);
            long nFilters = filterColl.getCount().getValue();
            int i = 0;
            while ((long)i < nFilters) {
                filterColl.item(new Int32(i)).queryInterface(filterInfo.getIID(), (IUnknown)filterInfo);
                System.out.println("Filter: " + i + ": " + filterInfo.getName().getValue());
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("Could not get complete information on registered media filters");
            System.out.println(ex.getMessage());
            regFiltersPrinted = true;
        }
        regFiltersPrinted = true;
    }

    private void adjustFiltersIfNeeded() throws NoPlayerException, ComException {
        this.mediaControl.stop();
        IFilterInfoImpl filterInfo = new IFilterInfoImpl();
        IFilterInfoImpl currentSplitterFilterInfo = new IFilterInfoImpl();
        IFilterInfoImpl defaultSplitterFilterInfo = new IFilterInfoImpl();
        IAMCollectionImpl splitterPinColl = new IAMCollectionImpl();
        IPinInfoImpl pinInfo = new IPinInfoImpl();
        IPinInfoImpl fileSourceOutputPinInfo = new IPinInfoImpl();
        IPinInfoImpl audioDecoderInputPinInfo = new IPinInfoImpl();
        IPinInfoImpl videoDecoderInputPinInfo = new IPinInfoImpl();
        IMediaTypeInfoImpl mediaInfo = new IMediaTypeInfoImpl();
        IAMCollectionImpl filterColl = new IAMCollectionImpl();
        IAMCollectionImpl pinColl = new IAMCollectionImpl();
        this.mediaControl.getFilterCollection().queryInterface(filterColl.getIID(), (IUnknown)filterColl);
        long nFilters = filterColl.getCount().getValue();
        int i = 0;
        while ((long)i < nFilters) {
            filterColl.item(new Int32(i)).queryInterface(filterInfo.getIID(), (IUnknown)filterInfo);
            if (filterInfo.getIsFileSource().getValue() == -1L) {
                filterInfo.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
                long nPins = pinColl.getCount().getValue();
                int j = 0;
                while ((long)j < nPins) {
                    pinColl.item(new Int32(j)).queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                    if (pinInfo.getName().getValue().equalsIgnoreCase("output")) {
                        pinColl.item(new Int32(j)).queryInterface(fileSourceOutputPinInfo.getIID(), (IUnknown)fileSourceOutputPinInfo);
                        fileSourceOutputPinInfo.getConnectedTo().queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                        pinInfo.getFilterInfo().queryInterface(currentSplitterFilterInfo.getIID(), (IUnknown)currentSplitterFilterInfo);
                        currentSplitterFilterInfo.getPins().queryInterface(splitterPinColl.getIID(), (IUnknown)splitterPinColl);
                        System.out.println("Media splitter filter name: " + currentSplitterFilterInfo.getName().getValue());
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (currentSplitterFilterInfo != null && !currentSplitterFilterInfo.isNull() && "MPEG-I Stream Splitter".equals(currentSplitterFilterInfo.getName().getValue())) {
            return;
        }
        if (currentSplitterFilterInfo != null && !currentSplitterFilterInfo.isNull() && "Elecard MPEG Demultiplexer".equals(currentSplitterFilterInfo.getName().getValue())) {
            System.out.println("Current splitter: Elecard MPEG Demultiplexer. Not removed from the chain");
            return;
        }
        if (this.isMpeg1Media) {
            Vector<String> problemSplitters = new Vector<String>();
            problemSplitters.add("Moonlight-Elecard MPEG2 Demultiplexer");
            problemSplitters.add("Elecard MPEG2 Demultiplexer");
            String currentSplitter = currentSplitterFilterInfo.getName().getValue();
            if (problemSplitters.contains(currentSplitter)) {
                JOptionPane.showMessageDialog(null, ElanLocale.getString("NativeMediaPlayerWindows.Warning1") + "\"" + currentSplitter + "\"", ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            long nPins = splitterPinColl.getCount().getValue();
            int i2 = 0;
            while ((long)i2 < nPins) {
                splitterPinColl.item(new Int32(i2)).queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                String pinName = pinInfo.getName().getValue().toLowerCase();
                if (pinName.indexOf("input") >= 0) {
                    pinInfo.getConnectedTo().queryInterface(fileSourceOutputPinInfo.getIID(), (IUnknown)fileSourceOutputPinInfo);
                } else if (pinName.indexOf("audio") >= 0) {
                    pinInfo.getConnectedTo().queryInterface(audioDecoderInputPinInfo.getIID(), (IUnknown)audioDecoderInputPinInfo);
                } else if (pinName.indexOf("video") >= 0) {
                    pinInfo.getConnectedTo().queryInterface(videoDecoderInputPinInfo.getIID(), (IUnknown)videoDecoderInputPinInfo);
                }
                ++i2;
            }
            boolean defaultSplitterAvailable = false;
            IRegFilterInfoImpl regFilterInfo = new IRegFilterInfoImpl();
            this.mediaControl.getRegFilterCollection().queryInterface(filterColl.getIID(), (IUnknown)filterColl);
            nFilters = filterColl.getCount().getValue();
            int i3 = 0;
            while ((long)i3 < nFilters) {
                filterColl.item(new Int32(i3)).queryInterface(regFilterInfo.getIID(), (IUnknown)regFilterInfo);
                if (regFilterInfo.getName().getValue().equalsIgnoreCase("MPEG-I Stream Splitter")) {
                    regFilterInfo.filter().queryInterface(defaultSplitterFilterInfo.getIID(), (IUnknown)defaultSplitterFilterInfo);
                    defaultSplitterAvailable = true;
                    break;
                }
                ++i3;
            }
            if (defaultSplitterAvailable) {
                try {
                    fileSourceOutputPinInfo.disconnect();
                    System.out.println("== Removed MPEG-2 splitter from chain: " + currentSplitter);
                    defaultSplitterFilterInfo.getPins().queryInterface(splitterPinColl.getIID(), (IUnknown)splitterPinColl);
                    nPins = splitterPinColl.getCount().getValue();
                    splitterPinColl.item(new Int32(0)).queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                    fileSourceOutputPinInfo.connect((IUnknown)pinInfo);
                    System.out.println("== Connected default splitter: " + defaultSplitterFilterInfo.getName().getValue());
                    defaultSplitterFilterInfo.getPins().queryInterface(splitterPinColl.getIID(), (IUnknown)splitterPinColl);
                    nPins = splitterPinColl.getCount().getValue();
                    i3 = 0;
                    while ((long)i3 < nPins) {
                        splitterPinColl.item(new Int32(i3)).queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                        String pinName = pinInfo.getName().getValue().toLowerCase();
                        if (pinName.indexOf("audio") >= 0) {
                            pinInfo.render();
                        } else if (pinName.indexOf("video") >= 0) {
                            pinInfo.render();
                        }
                        ++i3;
                    }
                    this.printFilterInfo();
                }
                catch (ComException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, ElanLocale.getString("NativeMediaPlayerWindows.Error1"), ElanLocale.getString("Message.Error"), 0);
                    throw new NoPlayerException("Problem while creating directshow based media player");
                }
            }
        }
    }

    private void createDefaultGrapgh() throws ComException {
        this.mediaControl = FilgraphManager.create(ClsCtx.INPROC_SERVER);
        String URLString = this.mediaDescriptor.mediaURL;
        if (URLString.startsWith("file:") && !URLString.startsWith("file:///")) {
            URLString = URLString.substring(5);
        }
        IDispatch sourceDispatch = this.mediaControl.addSourceFilter(new BStr(URLString));
        IFilterInfoImpl filterInfo = new IFilterInfoImpl();
        IFilterInfoImpl fileSourceFI = new IFilterInfoImpl();
        IFilterInfoImpl defaultSplitterFI = new IFilterInfoImpl();
        IFilterInfoImpl videoDecoderFI = new IFilterInfoImpl();
        IFilterInfoImpl audioDecoderFI = new IFilterInfoImpl();
        IFilterInfoImpl videoRendererFI = new IFilterInfoImpl();
        IFilterInfoImpl audioRendererFI = new IFilterInfoImpl();
        IAMCollectionImpl splitterPinColl = new IAMCollectionImpl();
        IPinInfoImpl pinInfo = new IPinInfoImpl();
        IPinInfoImpl fileSourceOutputPinInfo = new IPinInfoImpl();
        IAMCollectionImpl filterColl = new IAMCollectionImpl();
        IAMCollectionImpl pinColl = new IAMCollectionImpl();
        try {
            IRegFilterInfoImpl regFilterInfo = new IRegFilterInfoImpl();
            this.mediaControl.getRegFilterCollection().queryInterface(filterColl.getIID(), (IUnknown)filterColl);
            long nFilters = filterColl.getCount().getValue();
            int i = 0;
            while ((long)i < nFilters) {
                filterColl.item(new Int32(i)).queryInterface(regFilterInfo.getIID(), (IUnknown)regFilterInfo);
                if (regFilterInfo.getName().getValue().equalsIgnoreCase("MPEG-I Stream Splitter")) {
                    regFilterInfo.filter().queryInterface(defaultSplitterFI.getIID(), (IUnknown)defaultSplitterFI);
                } else if (regFilterInfo.getName().getValue().equalsIgnoreCase("MPEG Video Decoder")) {
                    regFilterInfo.filter().queryInterface(videoDecoderFI.getIID(), (IUnknown)videoDecoderFI);
                } else if (regFilterInfo.getName().getValue().equalsIgnoreCase("MPEG Audio Decoder")) {
                    regFilterInfo.filter().queryInterface(audioDecoderFI.getIID(), (IUnknown)audioDecoderFI);
                } else if (regFilterInfo.getName().getValue().equalsIgnoreCase("Video Renderer")) {
                    regFilterInfo.filter().queryInterface(videoRendererFI.getIID(), (IUnknown)videoRendererFI);
                } else if (regFilterInfo.getName().getValue().equalsIgnoreCase("Default DirectSound Device")) {
                    regFilterInfo.filter().queryInterface(audioRendererFI.getIID(), (IUnknown)audioRendererFI);
                }
                ++i;
            }
            sourceDispatch.queryInterface(fileSourceFI.getIID(), (IUnknown)fileSourceFI);
            System.out.println("New source filter: " + fileSourceFI.getName().getValue());
            fileSourceFI.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
            pinColl.item(new Int32(0)).queryInterface(fileSourceOutputPinInfo.getIID(), (IUnknown)fileSourceOutputPinInfo);
            IPinInfoImpl pinInfoIn = new IPinInfoImpl();
            IPinInfoImpl pinInfoOut = new IPinInfoImpl();
            IDispatch pinDisp = defaultSplitterFI.findPin(new BStr("Input"));
            pinDisp.queryInterface(pinInfoIn.getIID(), (IUnknown)pinInfoIn);
            fileSourceOutputPinInfo.connect((IUnknown)pinInfoIn);
            System.out.println("Filter: " + defaultSplitterFI.getName().getValue() + " In: " + pinInfoIn.getName().getValue());
            defaultSplitterFI.getPins().queryInterface(splitterPinColl.getIID(), (IUnknown)splitterPinColl);
            long outCount = splitterPinColl.getCount().getValue();
            int i2 = 0;
            while ((long)i2 < outCount) {
                splitterPinColl.item(new Int32(i2)).queryInterface(pinInfo.getIID(), (IUnknown)pinInfo);
                if (pinInfo.getDirection().getValue() != 0L) {
                    if (pinInfo.getName().getValue().equals("Video")) {
                        System.out.println("Filter: " + defaultSplitterFI.getName().getValue() + " Pin: " + pinInfo.getName().getValue() + " - " + pinInfo.getDirection().getValue());
                        videoDecoderFI.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
                        pinColl.item(new Int32(0)).queryInterface(pinInfoIn.getIID(), (IUnknown)pinInfoIn);
                        System.out.println("Filter: " + videoDecoderFI.getName().getValue() + " Pin: " + pinInfoIn.getName().getValue() + " - " + pinInfoIn.getDirection().getValue());
                        pinInfo.connect((IUnknown)pinInfoIn);
                        pinColl.item(new Int32(1)).queryInterface(pinInfoOut.getIID(), (IUnknown)pinInfoOut);
                        System.out.println("Filter: " + videoDecoderFI.getName().getValue() + " Pin: " + pinInfoOut.getName().getValue() + " - " + pinInfoOut.getDirection().getValue());
                        videoRendererFI.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
                        pinColl.item(new Int32(0)).queryInterface(pinInfoIn.getIID(), (IUnknown)pinInfoIn);
                        System.out.println("Filter: " + videoRendererFI.getName().getValue() + " Pin: " + pinInfoIn.getName().getValue() + " - " + pinInfoIn.getDirection().getValue());
                        pinInfoOut.connect((IUnknown)pinInfoIn);
                    } else if (pinInfo.getName().getValue().equals("Audio")) {
                        System.out.println("Filter: " + defaultSplitterFI.getName().getValue() + " Pin: " + pinInfo.getName().getValue() + " - " + pinInfo.getDirection().getValue());
                        audioDecoderFI.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
                        pinColl.item(new Int32(0)).queryInterface(pinInfoIn.getIID(), (IUnknown)pinInfoIn);
                        System.out.println("Filter: " + audioDecoderFI.getName().getValue() + " Pin: " + pinInfoIn.getName().getValue() + " - " + pinInfoIn.getDirection().getValue());
                        pinInfo.connect((IUnknown)pinInfoIn);
                        pinColl.item(new Int32(1)).queryInterface(pinInfoOut.getIID(), (IUnknown)pinInfoOut);
                        System.out.println("Filter: " + audioDecoderFI.getName().getValue() + " Pin: " + pinInfoOut.getName().getValue() + " - " + pinInfoOut.getDirection().getValue());
                        audioRendererFI.getPins().queryInterface(pinColl.getIID(), (IUnknown)pinColl);
                        pinColl.item(new Int32(0)).queryInterface(pinInfoIn.getIID(), (IUnknown)pinInfoIn);
                        System.out.println("Filter: " + audioRendererFI.getName().getValue() + " Pin: " + pinInfoIn.getName().getValue() + " - " + pinInfoIn.getDirection().getValue());
                        pinInfoOut.connect((IUnknown)pinInfoIn);
                    }
                }
                ++i2;
            }
            IMediaPositionImpl mp = new IMediaPositionImpl();
            this.mediaControl.queryInterface(mp.getIID(), (IUnknown)mp);
            this.mediaPosition = mp;
            IVideoWindowImpl vw = new IVideoWindowImpl();
            this.mediaControl.queryInterface(vw.getIID(), (IUnknown)vw);
            this.videoWindow = vw;
            IBasicVideo2Impl bv = new IBasicVideo2Impl();
            this.mediaControl.queryInterface(bv.getIID(), (IUnknown)bv);
            this.basicVideo = bv;
            IBasicAudioImpl ba = new IBasicAudioImpl();
            this.mediaControl.queryInterface(ba.getIID(), (IUnknown)ba);
            this.basicAudio = ba;
            IMediaEventExImpl me = new IMediaEventExImpl();
            this.mediaControl.queryInterface(me.getIID(), (IUnknown)me);
            this.mediaEvent = me;
        }
        catch (ComException comex) {
            System.out.println("Could not create default filter graph: " + comex.getMessage());
            comex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("Any error: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    @Override
    public String getFrameworkDescription() {
        return "Native Windows Media Framework DS01";
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public Component getVisualComponent() {
        return this.visualComponent;
    }

    @Override
    public int getSourceHeight() {
        if (this.basicVideo != null) {
            return (int)this.basicVideo.getSourceHeight().getValue();
        }
        return 0;
    }

    @Override
    public int getSourceWidth() {
        if (this.basicVideo != null) {
            return (int)this.basicVideo.getSourceWidth().getValue();
        }
        return 0;
    }

    @Override
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public synchronized void playInterval(long startTime, long stopTime) {
        this.setStopTime(stopTime);
        this.setMediaTime(startTime);
        this.start();
    }

    @Override
    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
        long nFrames = (stopTime + this.offset) / this.getMilliSecondsPerSample();
        long extra = 0L;
        if (nFrames * this.getMilliSecondsPerSample() == stopTime + this.offset) {
            extra = 1L;
            ++this.stopTime;
        }
        this.mediaPosition.setStopTime(new DoubleFloat((double)(((float)stopTime + (float)this.offset + (float)extra) / 1000.0f)));
        this.setControllersStopTime(stopTime);
    }

    @Override
    public synchronized void start() {
        if (this.playing) {
            return;
        }
        if (this.getMediaDuration() - this.getMediaTime() < 40L) {
            this.setMediaTime(0L);
        }
        this.playing = true;
        this.mediaControl.run();
        this.startControllers();
        Thread tw = new Thread(new PlayerStateWatcher());
        tw.start();
    }

    @Override
    public synchronized void stop() {
        if (!this.playing) {
            return;
        }
        this.mediaControl.pause();
        this.stopControllers();
        this.setControllersMediaTime(this.getMediaTime());
        this.playing = false;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public long getMilliSecondsPerSample() {
        return (long)this.millisPerSample;
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.frameRateAutoDetected) {
            this.millisPerSample = milliSeconds;
        }
    }

    @Override
    public float getVolume() {
        try {
            Int32 volume = this.basicAudio.getVolume();
            return ((float)volume.getValue() + 10000.0f) / 10000.0f;
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    @Override
    public void setVolume(float level) {
        try {
            this.basicAudio.setVolume(new Int32((int)(level * 10000.0f - 10000.0f)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        this.stopTime = this.duration = (long)(1000.0 * this.mediaPosition.getDuration().getValue()) - offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public synchronized void setMediaTime(long time) {
        if (this.mediaControl.getState(new Int32(0)).getValue() != 1L) {
            this.mediaControl.pause();
        }
        if (time < 0L) {
            time = 0L;
        }
        if (time > this.duration) {
            time = this.duration;
        }
        this.mediaPosition.setCurrentPosition(new DoubleFloat((double)(((float)time + (float)this.offset) / 1000.0f)));
        this.setControllersMediaTime(time);
    }

    @Override
    public void nextFrame() {
        if (this.mediaControl.getState(new Int32(0)).getValue() != 1L) {
            this.mediaControl.pause();
        }
        if (this.frameStepsToFrameBegin) {
            long curFrame = (long)((double)this.getMediaTime() / this.millisPerSample);
            this.setMediaTime((long)((double)(curFrame + 1L) * this.millisPerSample));
        } else {
            double pos = this.mediaPosition.getCurrentPosition().getValue();
            if ((pos += this.millisPerSample / 1000.0) > (double)(((float)this.duration + (float)this.offset) / 1000.0f)) {
                pos = ((float)this.duration + (float)this.offset) / 1000.0f;
            }
            this.mediaPosition.setCurrentPosition(new DoubleFloat(pos));
            this.setControllersMediaTime(this.getMediaTime());
        }
    }

    @Override
    public void previousFrame() {
        if (this.mediaControl.getState(new Int32(0)).getValue() != 1L) {
            this.mediaControl.pause();
        }
        if (this.frameStepsToFrameBegin) {
            long curFrame = (long)((double)this.getMediaTime() / this.millisPerSample);
            if (curFrame > 0L) {
                this.setMediaTime((long)((double)(curFrame - 1L) * this.millisPerSample));
            } else {
                this.setMediaTime(0L);
            }
        } else {
            double pos = this.mediaPosition.getCurrentPosition().getValue();
            if ((pos -= this.millisPerSample / 1000.0) < 0.0) {
                pos = 0.0;
            }
            this.mediaPosition.setCurrentPosition(new DoubleFloat(pos));
            this.setControllersMediaTime(this.getMediaTime());
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public long getMediaTime() {
        double pos = 5.0E-4 + this.mediaPosition.getCurrentPosition().getValue();
        return (long)(1000.0 * pos) - this.offset;
    }

    @Override
    public float getRate() {
        return (float)this.mediaPosition.getRate().getValue();
    }

    @Override
    public synchronized void setRate(float rate) {
        this.mediaPosition.setRate(new DoubleFloat((double)rate));
        this.setControllersRate(rate);
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return this.frameRateAutoDetected;
    }

    @Override
    public long getMediaDuration() {
        return this.duration;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
        if (this.layoutManager == null) {
            this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.detach"));
            this.detachItem.addActionListener(this);
            this.popup.insert(this.detachItem, 0);
        }
        this.layoutManager = layoutManager;
    }

    @Override
    public void updateLocale() {
        this.infoItem.setText(ElanLocale.getString("Player.Info"));
        this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        this.saveItem.setText(ElanLocale.getString("Player.SaveFrame"));
        if (this.detachItem != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
        }
        if (this.copyOrigTimeItem != null) {
            this.copyOrigTimeItem.setText(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.detached = true;
            }
            this.getVisualComponent().addNotify();
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.saveItem) {
            ImageExporter export = new ImageExporter();
            export.exportImage((BufferedImage)this.getCurrentFrameImage());
        } else if (e.getSource() == this.ratio_4_3_Item) {
            this.aspectRatio = 1.33f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_3_2_Item) {
            this.aspectRatio = 1.66f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_16_9_Item) {
            this.aspectRatio = 1.78f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_185_1_Item) {
            this.aspectRatio = 1.85f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_235_1_Item) {
            this.aspectRatio = 2.35f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.copyOrigTimeItem) {
            long t = this.getMediaTime() + this.offset;
            Object val = Preferences.get("CurrentTime.Copy.TimeFormat", null);
            String timeFormat = null;
            String currentTime = null;
            currentTime = val instanceof String ? ((timeFormat = val.toString()).equals("hh:mm:ss.ms") ? TimeFormatter.toString(t) : (timeFormat.equals("ss.ms") ? TimeFormatter.toSSMSString(t) : (timeFormat.equals("NTSC") ? TimeFormatter.toTimecodeNTSC(t) : (timeFormat.equals("PAL") ? TimeFormatter.toTimecodePAL(t) : Long.toString(t))))) : Long.toString(t);
            this.copyToClipboard(currentTime);
        }
    }

    @Override
    public Image getCurrentFrameImage() {
        return this.getFrameImageForTime(this.getMediaTime());
    }

    @Override
    public Image getFrameImageForTime(long time) {
        if (time != this.getMediaTime()) {
            this.setMediaTime(time);
        }
        BufferedImage image = null;
        try {
            this.mediaControl.pause();
            Int32 bufSize = new Int32();
            Int32 imPointer = null;
            this.basicVideo.getCurrentImage(bufSize, imPointer);
            int bufferSize = (int)bufSize.getValue();
            PrimitiveArray myArray = new PrimitiveArray(UInt8.class, bufferSize);
            ExternalArrayPointer pArray = new ExternalArrayPointer((ArrayParameter)myArray);
            Parameter[] params = new Parameter[]{new Pointer((Parameter)new Int32(bufferSize)), pArray};
            ((IBasicVideoImpl)((Object)this.basicVideo)).getCurrentImage2(params);
            byte[] data = myArray.getBytes();
            image = DIBToImage.DIBDataToBufferedImage(data);
        }
        catch (ComException ce) {
            ce.printStackTrace();
        }
        return image;
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static {
        try {
            if (DefaultLibraryLoader.getInstance().findLibrary("jniwrap") == null) {
                DefaultLibraryLoader.getInstance().addPath("lib/java/jniwrapper");
                DefaultLibraryLoader.getInstance().loadLibrary("jniwrap");
            }
        }
        catch (UnsatisfiedLinkError ue) {
            initError = ue.getMessage();
        }
        catch (ComException ce) {
            initError = ce.getMessage();
        }
        catch (Throwable tr) {
            initError = tr.getMessage();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private final DecimalFormat format = new DecimalFormat("#.###");

        MouseHandler() {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (NativeMediaPlayerWindowsDS.this.layoutManager != null) {
                    NativeMediaPlayerWindowsDS.this.layoutManager.setFirstPlayer(NativeMediaPlayerWindowsDS.this);
                }
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                if (NativeMediaPlayerWindowsDS.this.layoutManager != null && NativeMediaPlayerWindowsDS.this.layoutManager.isAttached(NativeMediaPlayerWindowsDS.this) && NativeMediaPlayerWindowsDS.this.detached) {
                    NativeMediaPlayerWindowsDS.this.detached = false;
                    NativeMediaPlayerWindowsDS.this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                }
                NativeMediaPlayerWindowsDS.this.popup.show(NativeMediaPlayerWindowsDS.this.getVisualComponent(), e.getPoint().x, e.getPoint().y);
                return;
            }
            try {
                if (e.isAltDown()) {
                    NativeMediaPlayerWindowsDS.this.copyToClipboard(this.format.format((float)e.getX() / (float)NativeMediaPlayerWindowsDS.this.visualComponent.getWidth()) + "," + this.format.format((float)e.getY() / (float)NativeMediaPlayerWindowsDS.this.visualComponent.getHeight()));
                } else if (e.isShiftDown()) {
                    NativeMediaPlayerWindowsDS.this.copyToClipboard("" + (int)((float)NativeMediaPlayerWindowsDS.this.basicVideo.getSourceWidth().getValue() / (float)NativeMediaPlayerWindowsDS.this.visualComponent.getWidth() * (float)e.getX()) + "," + (int)((float)NativeMediaPlayerWindowsDS.this.basicVideo.getSourceHeight().getValue() / (float)NativeMediaPlayerWindowsDS.this.visualComponent.getHeight() * (float)e.getY()));
                } else {
                    NativeMediaPlayerWindowsDS.this.copyToClipboard("" + (int)((float)NativeMediaPlayerWindowsDS.this.basicVideo.getSourceWidth().getValue() / (float)NativeMediaPlayerWindowsDS.this.visualComponent.getWidth() * (float)e.getX()) + "," + (int)((float)NativeMediaPlayerWindowsDS.this.basicVideo.getSourceHeight().getValue() / (float)NativeMediaPlayerWindowsDS.this.visualComponent.getHeight() * (float)e.getY()) + " [" + NativeMediaPlayerWindowsDS.this.basicVideo.getSourceWidth().getValue() + "," + NativeMediaPlayerWindowsDS.this.basicVideo.getSourceHeight().getValue() + "]");
                }
            }
            catch (Exception exep) {
                exep.printStackTrace();
            }
        }
    }

    private class PlayerStateWatcher
    implements Runnable {
        private PlayerStateWatcher() {
        }

        @Override
        public void run() {
            while (NativeMediaPlayerWindowsDS.this.playing && NativeMediaPlayerWindowsDS.this.getMediaTime() < NativeMediaPlayerWindowsDS.this.stopTime) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (NativeMediaPlayerWindowsDS.this.playing) {
                NativeMediaPlayerWindowsDS.this.mediaControl.stopWhenReady();
                NativeMediaPlayerWindowsDS.this.stopControllers();
                if (NativeMediaPlayerWindowsDS.this.getMediaTime() == NativeMediaPlayerWindowsDS.this.stopTime + 1L) {
                    NativeMediaPlayerWindowsDS.this.setMediaTime(NativeMediaPlayerWindowsDS.this.stopTime);
                } else {
                    NativeMediaPlayerWindowsDS.this.setMediaTime(NativeMediaPlayerWindowsDS.this.getMediaTime());
                }
                NativeMediaPlayerWindowsDS.this.setStopTime(NativeMediaPlayerWindowsDS.this.duration);
                if (NativeMediaPlayerWindowsDS.this.isWaveMedia) {
                    NativeMediaPlayerWindowsDS.this.setMediaTime(NativeMediaPlayerWindowsDS.this.getMediaTime());
                }
                NativeMediaPlayerWindowsDS.this.mediaControl.pause();
                NativeMediaPlayerWindowsDS.this.playing = false;
            }
        }
    }

    private class VisualComponent
    extends Panel
    implements ComponentListener,
    HierarchyListener {
        public VisualComponent() {
            NativeMediaPlayerWindowsDS.this.videoWindow.setWindowStyle(new Int32(0x40000000));
            this.addComponentListener(this);
            this.addHierarchyListener(this);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (NativeMediaPlayerWindowsDS.this.videoWindow.getVisible().getValue() != -1L) {
                return;
            }
            Int32 left = new Int32();
            left.setValue(0L);
            Int32 top = new Int32();
            top.setValue(0L);
            Int32 width = new Int32();
            width.setValue((long)this.getWidth());
            Int32 height = new Int32();
            height.setValue((long)this.getHeight());
            NativeMediaPlayerWindowsDS.this.videoWindow.setWindowPosition(left, top, width, height);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (this.isDisplayable()) {
                long handle = WindowTools.getWindowHandle((Component)this);
                LongPtr ownerWindow = new LongPtr();
                ownerWindow.setValue(handle);
                if (NativeMediaPlayerWindowsDS.this.videoWindow != null) {
                    NativeMediaPlayerWindowsDS.this.videoWindow.setOwner(ownerWindow);
                    NativeMediaPlayerWindowsDS.this.videoWindow.setMessageDrain(ownerWindow);
                    this.setVisible(true);
                    NativeMediaPlayerWindowsDS.this.videoWindow.setVisible(new Int32(-1));
                }
            }
        }

        @Override
        public void addNotify() {
            super.addNotify();
            long handle = WindowTools.getWindowHandle((Component)this);
            LongPtr ownerWindow = new LongPtr();
            ownerWindow.setValue(handle);
            if (NativeMediaPlayerWindowsDS.this.videoWindow != null) {
                NativeMediaPlayerWindowsDS.this.videoWindow.setOwner(ownerWindow);
                NativeMediaPlayerWindowsDS.this.videoWindow.setMessageDrain(ownerWindow);
            }
        }

        @Override
        public void removeNotify() {
            if (NativeMediaPlayerWindowsDS.this.videoWindow != null) {
                NativeMediaPlayerWindowsDS.this.videoWindow.setVisible(new Int32(0));
                NativeMediaPlayerWindowsDS.this.videoWindow.setOwner(new LongPtr());
            }
            super.removeNotify();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        protected void finalize() throws Throwable {
            System.out.println("finalize visual component");
            super.finalize();
        }
    }
}

