/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.Int32;
import com.jniwrapper.win32.automation.Automation;
import com.jniwrapper.win32.automation.OleContainer;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.com.ComException;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.types.CLSID;
import com.jniwrapper.win32.ole.OleFunctions;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;

public class NativeMediaPlayerWindowsQT
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener,
ActionListener {
    private static final String QTActiveXPlugin_INTERFACE_ID = "{02BF25D5-8C17-4B23-BC80-D3488ABDDC6B}";
    private MediaDescriptor mediaDescriptor;
    private boolean playing;
    private long offset;
    private long duration;
    private float aspectRatio;
    private long millisPerSample;
    private JPopupMenu popup;
    private JMenuItem durationItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem ratio_4_3_Item;
    private JMenuItem ratio_3_2_Item;
    private JMenuItem ratio_16_9_Item;
    private JMenuItem ratio_185_1_Item;
    private JMenuItem ratio_235_1_Item;
    private ElanLayoutManager layoutManager;
    private boolean detached;
    private final OleContainer oleContainer;
    private Automation automation;
    private VisualComponent visualComponent;
    private long now;
    private float rate;
    private float timeScale;
    private long stopTime;
    private boolean frameStepsToFrameBegin = false;
    private static String initError = null;

    public NativeMediaPlayerWindowsQT(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        if (initError != null) {
            throw new NoPlayerException(initError);
        }
        try {
            this.mediaDescriptor = mediaDescriptor;
            String URLString = mediaDescriptor.mediaURL;
            System.out.println("url: " + URLString);
            OleFunctions.oleInitialize();
            this.oleContainer = new OleContainer();
            this.oleContainer.createObject(CLSID.create((String)QTActiveXPlugin_INTERFACE_ID));
            JFrame sample = new JFrame("Streaming Video");
            sample.getContentPane().add((Component)this.oleContainer);
            sample.setSize(640, 480);
            sample.setVisible(true);
            this.oleContainer.doVerb(-1);
            this.automation = new Automation((IUnknown)this.oleContainer.getOleObject());
            this.automation.invoke("SetURL", new Object[]{new BStr(URLString)});
            this.automation.invoke("SetControllerVisible", new Object[]{new Int32(0)});
            this.automation.invoke("SetTime", new Object[]{new Int32(0)});
            this.timeScale = (float)this.automation.invoke("GetTimeScale").getLVal().getValue() / 1000.0f;
            System.out.println("time scale " + this.automation.invoke("GetTimeScale").getLVal().getValue());
            System.out.println("time scale " + this.timeScale);
            System.out.println("movie size " + this.automation.invoke("GetMovieSize").getLVal().getValue());
            this.aspectRatio = 1.0f;
            this.duration = (long)((float)this.automation.invoke("GetDuration").getLVal().getValue() / this.timeScale);
            this.millisPerSample = 40L;
            this.rate = 1.0f;
            this.start();
            this.stop();
            this.automation.invoke("SetTime", new Object[]{new Int32(0)});
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.popup = new JPopupMenu();
            this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
            this.infoItem.addActionListener(this);
            this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
            this.durationItem.setEnabled(false);
            this.ratio_4_3_Item = new JMenuItem("4:3");
            this.ratio_4_3_Item.addActionListener(this);
            this.ratio_3_2_Item = new JMenuItem("3:2");
            this.ratio_3_2_Item.addActionListener(this);
            this.ratio_16_9_Item = new JMenuItem("16:9");
            this.ratio_16_9_Item.addActionListener(this);
            this.ratio_185_1_Item = new JMenuItem("1.85:1");
            this.ratio_185_1_Item.addActionListener(this);
            this.ratio_235_1_Item = new JMenuItem("2.35:1");
            this.ratio_235_1_Item.addActionListener(this);
            JMenu arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
            arMenu.add(this.ratio_4_3_Item);
            arMenu.add(this.ratio_3_2_Item);
            arMenu.add(this.ratio_16_9_Item);
            arMenu.add(this.ratio_185_1_Item);
            arMenu.add(this.ratio_235_1_Item);
            this.popup.addSeparator();
            this.popup.add(this.infoItem);
            this.popup.add(arMenu);
            this.popup.add(this.durationItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoPlayerException("Problem while creating Quicktime based native player");
        }
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    public void finalize() {
        OleFunctions.oleUninitialize();
    }

    @Override
    public String getFrameworkDescription() {
        return "Native Windows Media Framework QT Plugin";
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public synchronized void playInterval(long startTime, long stopTime) {
        System.out.println("play interval " + startTime + " - " + stopTime);
        this.setMediaTime(startTime);
        System.out.println("SetEndTime " + (int)((float)stopTime * this.timeScale + (float)this.offset));
        this.setStopTime(stopTime);
        this.start();
    }

    @Override
    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
        this.automation.invoke("SetEndTime", new Object[]{new Int32((int)((float)stopTime * this.timeScale + (float)this.offset))});
    }

    @Override
    public Component getVisualComponent() {
        return this.visualComponent;
    }

    @Override
    public int getSourceHeight() {
        try {
            Variant wi = this.automation.invoke("GetRectangle");
            if (wi != null) {
                BStr bs = (BStr)wi.getValue();
                System.out.println("Bstr: " + bs.getValue());
                StringTokenizer tokenizer = new StringTokenizer(bs.getValue(), ",");
                tokenizer.nextToken();
                int y = Integer.valueOf(tokenizer.nextToken());
                tokenizer.nextToken();
                int th = Integer.valueOf(tokenizer.nextToken());
                System.out.println("Height: " + (th - y));
                return th - y;
            }
        }
        catch (Exception ex) {
            System.out.println("Could not get height: " + ex.getMessage());
        }
        return 240;
    }

    @Override
    public int getSourceWidth() {
        try {
            Variant wi = this.automation.invoke("GetRectangle");
            if (wi != null) {
                BStr bs = (BStr)wi.getValue();
                StringTokenizer tokenizer = new StringTokenizer(bs.getValue(), ",");
                int x = Integer.valueOf(tokenizer.nextToken());
                tokenizer.nextToken();
                int tw = Integer.valueOf(tokenizer.nextToken());
                return tw - x;
            }
        }
        catch (Exception ex) {
            System.out.println("Could not get width: " + ex.getMessage());
        }
        return 320;
    }

    @Override
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public synchronized void start() {
        System.out.println("start duration: " + this.getMediaDuration());
        System.out.println("start current:  " + this.getMediaTime());
        if (this.getMediaDuration() - this.getMediaTime() < 40L) {
            this.setMediaTime(0L);
        }
        this.automation.invoke("Play");
        this.startControllers();
        while (this.getRate() == 0.0f) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.playing = true;
        new Thread(new PlayerStateWatcher()).start();
    }

    @Override
    public synchronized void stop() {
        this.automation.invoke("Stop");
        this.stopControllers();
        while (this.getRate() > 0.0f) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.playing = false;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public long getMilliSecondsPerSample() {
        return this.millisPerSample;
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        this.millisPerSample = milliSeconds;
    }

    @Override
    public float getVolume() {
        float volume = this.automation.invoke("GetVolume").getLVal().getValue();
        return volume / 255.0f;
    }

    @Override
    public void setVolume(float level) {
        this.automation.invoke("SetVolume", new Object[]{new Int32((int)(level * 255.0f))});
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public synchronized void setMediaTime(long time) {
        if (this.isPlaying()) {
            this.stop();
        }
        if ((time = (long)((float)time * this.timeScale)) < 0L) {
            time = 0L;
        }
        System.out.println("SetTime " + time);
        this.automation.invoke("SetTime", new Object[]{new Int32((int)(time + this.offset))});
        this.setControllersMediaTime(time);
    }

    @Override
    public void nextFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.millisPerSample;
            this.setMediaTime((curFrame + 1L) * this.millisPerSample);
        } else {
            this.setMediaTime(this.getMediaTime() + this.getMilliSecondsPerSample());
        }
    }

    @Override
    public void previousFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.millisPerSample;
            if (curFrame > 0L) {
                this.setMediaTime((curFrame - 1L) * this.millisPerSample);
            } else {
                this.setMediaTime(0L);
            }
        } else {
            this.setMediaTime(this.getMediaTime() - this.getMilliSecondsPerSample());
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public long getMediaTime() {
        long t = this.automation.invoke("GetTime").getLVal().getValue();
        t = (long)(0.5 + (double)((float)t / this.timeScale));
        return t - this.offset;
    }

    @Override
    public float getRate() {
        return (float)this.automation.invoke("GetRate").getFltVal().getValue();
    }

    @Override
    public synchronized void setRate(float rate) {
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return false;
    }

    @Override
    public long getMediaDuration() {
        return this.duration;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
        if (this.layoutManager == null) {
            this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.detach"));
            this.detachItem.addActionListener(this);
            this.popup.insert(this.detachItem, 0);
        }
        this.layoutManager = layoutManager;
    }

    @Override
    public void updateLocale() {
        this.infoItem.setText(ElanLocale.getString("Player.Info"));
        this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        if (this.detachItem != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.detached = true;
            }
            this.getVisualComponent().addNotify();
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.ratio_4_3_Item) {
            this.aspectRatio = 1.33f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_3_2_Item) {
            this.aspectRatio = 1.66f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_16_9_Item) {
            this.aspectRatio = 1.78f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_185_1_Item) {
            this.aspectRatio = 1.85f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_235_1_Item) {
            this.aspectRatio = 2.35f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        }
    }

    @Override
    public void cleanUpOnClose() {
    }

    static {
        try {
            if (DefaultLibraryLoader.getInstance().findLibrary("jniwrap") == null) {
                DefaultLibraryLoader.getInstance().addPath("lib/java/jniwrapper");
                DefaultLibraryLoader.getInstance().loadLibrary("jniwrap");
            }
        }
        catch (UnsatisfiedLinkError ue) {
            initError = ue.getMessage();
        }
        catch (ComException ce) {
            initError = ce.getMessage();
        }
        catch (Throwable tr) {
            initError = tr.getMessage();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (NativeMediaPlayerWindowsQT.this.layoutManager != null) {
                    NativeMediaPlayerWindowsQT.this.layoutManager.setFirstPlayer(NativeMediaPlayerWindowsQT.this);
                }
                return;
            }
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            if (SwingUtilities.isRightMouseButton(e)) {
                NativeMediaPlayerWindowsQT.this.popup.show(NativeMediaPlayerWindowsQT.this.getVisualComponent(), e.getPoint().x, e.getPoint().y);
            }
        }
    }

    private class PlayerStateWatcher
    implements Runnable {
        private PlayerStateWatcher() {
        }

        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (NativeMediaPlayerWindowsQT.this.getRate() > 0.0f);
            NativeMediaPlayerWindowsQT.this.stop();
            NativeMediaPlayerWindowsQT.this.setStopTime((long)((float)NativeMediaPlayerWindowsQT.this.getMediaDuration() * NativeMediaPlayerWindowsQT.this.timeScale));
        }
    }

    private class VisualComponent
    extends Panel
    implements ComponentListener,
    HierarchyListener {
        public VisualComponent() {
            this.addComponentListener(this);
            this.addHierarchyListener(this);
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            System.out.println("hierar");
            if (this.isDisplayable()) {
                System.out.println("disp");
                NativeMediaPlayerWindowsQT.this.oleContainer.doVerb(-1);
            }
        }

        @Override
        public void addNotify() {
            System.out.println("addNotify");
            super.addNotify();
            NativeMediaPlayerWindowsQT.this.oleContainer.doVerb(-1);
        }

        @Override
        public void removeNotify() {
            System.out.println("removeNotify");
            NativeMediaPlayerWindowsQT.this.oleContainer.doVerb(-3);
            super.removeNotify();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            System.out.println("compShown");
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            System.out.println("compHidden");
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }
    }
}

