/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.io.File;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.player.CocoaQTMediaPlayer;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.ImagePlayer;
import mpi.eudico.client.annotator.player.JDSMediaPlayer;
import mpi.eudico.client.annotator.player.JMFGraphicMediaPlayer;
import mpi.eudico.client.annotator.player.JMFMediaPlayer;
import mpi.eudico.client.annotator.player.JMMFMediaPlayer;
import mpi.eudico.client.annotator.player.NativeMediaPlayerWindowsDS;
import mpi.eudico.client.annotator.player.NativeMediaPlayerWindowsQT;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.QTMediaPlayer;
import mpi.eudico.client.annotator.player.QTStreamingPlayer;
import mpi.eudico.client.annotator.svg.SVGPrefs;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class PlayerFactory {
    public static final String JMF_MEDIA_FRAMEWORK = "JMF";
    public static final String QT_MEDIA_FRAMEWORK = "QT";
    public static final String NATIVE_WINDOWS_MEDIA_FRAMEWORK = "NativeWindows";
    public static final String COCOA_QT = "CocoaQT";
    public static final String JDS = "JDS";
    public static final String JMMF = "JMMF";
    public static final String[] MMF_EXTENSIONS = new String[]{"asf", "wma", "wmv", "m4a", "m4v", "mp4"};

    public static ElanMediaPlayer createElanMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        StringBuilder sb;
        boolean jmmfTried;
        String preferredMF;
        block44: {
            String mediaURL = mediaDescriptor.mediaURL;
            if (mediaURL.startsWith("file")) {
                if (!new File(mediaURL.substring(5)).exists()) {
                    throw new NoPlayerException("Media File not found: " + mediaURL);
                }
            } else if (mediaURL.startsWith("rtsp")) {
                if (SystemReporting.isMacOS()) {
                    return PlayerFactory.createQTStreamingPlayer(mediaDescriptor);
                }
                return PlayerFactory.createQTStreamingPlayer(mediaDescriptor);
            }
            if (mediaDescriptor.mimeType != null && mediaDescriptor.mimeType.startsWith("image")) {
                return new ImagePlayer(mediaDescriptor);
            }
            preferredMF = System.getProperty("PreferredMediaFramework");
            jmmfTried = false;
            boolean jdsTried = false;
            String tempPreferredMF = preferredMF;
            sb = new StringBuilder();
            try {
                if (preferredMF != null) {
                    if (preferredMF.equals(JMF_MEDIA_FRAMEWORK)) {
                        return PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
                    }
                    if (preferredMF.equals(QT_MEDIA_FRAMEWORK)) {
                        return PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                    }
                    if (preferredMF.equals(NATIVE_WINDOWS_MEDIA_FRAMEWORK)) {
                        return PlayerFactory.createNativeMediaPlayerDS(mediaDescriptor);
                    }
                    if (preferredMF.equals(COCOA_QT)) {
                        try {
                            return PlayerFactory.createCocoaQTMediaPlayer(mediaDescriptor);
                        }
                        catch (NoPlayerException npe) {
                            System.out.println("Could not create a Cocoa based player...");
                            sb.append("Could not create a Cocoa QT based player for: " + mediaDescriptor.mediaURL + "\n");
                            return PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                        }
                    }
                    if (preferredMF.equals(JDS) || preferredMF.equals(JMMF)) {
                        String playerType = PlayerFactory.checkLoadJdsOrJmmf(mediaDescriptor);
                        if (playerType == JMMF) {
                            preferredMF = JMMF;
                            jmmfTried = true;
                            return PlayerFactory.createJMMFPlayer(mediaDescriptor);
                        }
                        jdsTried = true;
                        return PlayerFactory.createJDSPlayer(mediaDescriptor);
                    }
                }
            }
            catch (NoPlayerException npe) {
                System.out.println("Preferred media framework '" + preferredMF + "' can not handle: " + mediaDescriptor.mediaURL);
                sb.append("Preferred media framework '" + preferredMF + "' can not handle: " + mediaDescriptor.mediaURL + "\n");
                if (!jmmfTried) break block44;
                preferredMF = tempPreferredMF;
            }
        }
        if (SystemReporting.isWindows()) {
            ElanMediaPlayer player = null;
            if (!JDS.equals(preferredMF)) {
                String playerType = PlayerFactory.checkLoadJdsOrJmmf(mediaDescriptor);
                if (playerType == JMMF && !jmmfTried) {
                    try {
                        player = PlayerFactory.createJMMFPlayer(mediaDescriptor);
                    }
                    catch (NoPlayerException npe) {
                        System.out.println(npe.getMessage());
                        sb.append(npe.getMessage() + "\n");
                        try {
                            player = PlayerFactory.createJDSPlayer(mediaDescriptor);
                        }
                        catch (NoPlayerException nnpe) {
                            System.out.println(nnpe.getMessage());
                            sb.append(nnpe.getMessage() + "\n");
                        }
                    }
                } else {
                    try {
                        player = PlayerFactory.createJDSPlayer(mediaDescriptor);
                    }
                    catch (NoPlayerException npe) {
                        System.out.println(npe.getMessage());
                        sb.append(npe.getMessage() + "\n");
                    }
                }
            }
            if (player == null && !NATIVE_WINDOWS_MEDIA_FRAMEWORK.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createNativeMediaPlayerDS(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println(npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !QT_MEDIA_FRAMEWORK.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("No QT: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player == null && !JMF_MEDIA_FRAMEWORK.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("No JMF: " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                }
            }
            if (player != null) {
                return player;
            }
            throw new NoPlayerException("Could not create any media player for: " + mediaDescriptor.mediaURL + "\n" + sb.toString());
        }
        if (SystemReporting.isMacOS()) {
            ElanMediaPlayer player = null;
            if (!COCOA_QT.equals(preferredMF)) {
                try {
                    player = PlayerFactory.createCocoaQTMediaPlayer(mediaDescriptor);
                }
                catch (NoPlayerException npe) {
                    System.out.println("Could not create a Cocoa based player... " + npe.getMessage());
                    sb.append(npe.getMessage() + "\n");
                    try {
                        player = PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                    }
                    catch (NoPlayerException np) {
                        sb.append(np.getMessage());
                    }
                }
            }
            if (player != null) {
                return player;
            }
            throw new NoPlayerException("Could not create any media player for: " + mediaDescriptor.mediaURL + "\n" + sb.toString());
        }
        return PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createNativeMediaPlayerDS(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            System.out.println("Using Windows Native Media Player DS for " + mediaDescriptor.mediaURL);
            return new NativeMediaPlayerWindowsDS(mediaDescriptor);
        }
        return PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createNativeMediaPlayerQT(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
            System.out.println("Using Windows Native Media Player QT for " + mediaDescriptor.mediaURL);
            return new NativeMediaPlayerWindowsQT(mediaDescriptor);
        }
        throw new NoPlayerException("No Native Media Framework Available for " + System.getProperty("os.name"));
    }

    public static ElanMediaPlayer createJMFMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JMF Media Player for " + mediaDescriptor.mediaURL);
        if (SVGPrefs.getUseSVG()) {
            return new JMFGraphicMediaPlayer(mediaDescriptor);
        }
        return new JMFMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createQTMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using QT Media Player for " + mediaDescriptor.mediaURL);
        try {
            return new QTMediaPlayer(mediaDescriptor);
        }
        catch (Throwable tr) {
            throw new NoPlayerException(tr.getMessage());
        }
    }

    public static ElanMediaPlayer createCocoaQTMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using Cocoa QT Media Player for " + mediaDescriptor.mediaURL);
        return new CocoaQTMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createQTStreamingPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using QT Streaming Player for " + mediaDescriptor.mediaURL);
        return new QTStreamingPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createJDSPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JDS Player for " + mediaDescriptor.mediaURL);
        return new JDSMediaPlayer(mediaDescriptor);
    }

    public static ElanMediaPlayer createJMMFPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        System.out.println("Using JMMF Player for " + mediaDescriptor.mediaURL);
        return new JMMFMediaPlayer(mediaDescriptor);
    }

    private static String checkLoadJdsOrJmmf(MediaDescriptor mediaDescriptor) {
        String lower = mediaDescriptor.mediaURL.toLowerCase();
        int extIndex = lower.lastIndexOf(46);
        if (extIndex > -1 && extIndex < lower.length() - 1) {
            String ext = lower.substring(extIndex + 1);
            int fileTypeIndex = -1;
            for (int i = 0; i < MMF_EXTENSIONS.length; ++i) {
                if (!MMF_EXTENSIONS[i].equals(ext)) continue;
                fileTypeIndex = i;
                break;
            }
            if (fileTypeIndex > -1) {
                String jmmfPref = System.getProperty("JMMFEnabled");
                if (jmmfPref != null && "false".equals(jmmfPref.toLowerCase())) {
                    return JDS;
                }
                Object jmmfUserPref = Preferences.get("Windows.JMMFEnabled", null);
                if (jmmfUserPref instanceof Boolean && !((Boolean)jmmfUserPref).booleanValue()) {
                    return JDS;
                }
                boolean isVista = SystemReporting.isWindowsVista();
                boolean isWin7 = SystemReporting.isWindows7OrHigher();
                if (isVista && fileTypeIndex <= 2) {
                    return JMMF;
                }
                if (isWin7) {
                    return JMMF;
                }
            }
        }
        return JDS;
    }
}

