/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import mpi.eudico.client.annotator.prefs.ObjectPref;
import mpi.eudico.client.annotator.prefs.Pref;
import mpi.eudico.client.annotator.prefs.PrefConstants;
import mpi.eudico.client.annotator.prefs.PrefObjectConverter;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PreferencesReader
implements ContentHandler,
PrefConstants {
    private final int BL_TYPE = 0;
    private final int INT_TYPE = 1;
    private final int LONG_TYPE = 2;
    private final int FLOAT_TYPE = 3;
    private final int DOUBLE_TYPE = 4;
    private final int STR_TYPE = 5;
    private final int OBJ_TYPE = 6;
    private XMLReader reader;
    private ArrayList<Pref> preferences;
    private Stack<Map> mapStack;
    private HashMap curMap;
    private Pref curMapPref;
    private ArrayList curList;
    private Pref curListPref;
    private Pref curPref;
    private ObjectPref curObj;
    private String curKey;
    private String content;
    private int curType = -1;
    private PrefObjectConverter converter = new PrefObjectConverter();

    public PreferencesReader() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            try {
                this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
                this.reader.setFeature("http://xml.org/sax/features/validation", true);
                this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (Exception e) {
                ClientLogger.LOG.warning("Could not set feature: " + e.getMessage());
            }
            try {
                this.reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getResource("/mpi/eudico/resources/Prefs_v1.1.xsd").openStream());
            }
            catch (Exception ee) {
                ClientLogger.LOG.warning("Could not set property: " + ee.getMessage());
            }
            this.reader.setContentHandler(this);
        }
        catch (SAXException se) {
            ClientLogger.LOG.severe("Could not create xml reader: " + se.getMessage());
            se.printStackTrace();
        }
        this.curMap = null;
        this.curList = null;
        this.content = "";
        this.mapStack = new Stack();
    }

    public synchronized Map parse(String fileName) {
        this.preferences = new ArrayList();
        if (this.reader == null || fileName == null) {
            ClientLogger.LOG.warning("Cannot parse preferences file: " + fileName);
            return new HashMap(0);
        }
        if (this.curMap != null) {
            this.curMap.clear();
        }
        if (this.curList != null) {
            this.curList.clear();
        }
        this.curPref = null;
        this.curObj = null;
        this.content = "";
        this.mapStack.clear();
        File pf = new File(fileName);
        if (pf.exists()) {
            try {
                FileInputStream fis = new FileInputStream(pf);
                InputSource source = new InputSource(fis);
                this.reader.parse(source);
                ClientLogger.LOG.info("Reading preferences: " + fileName);
            }
            catch (Exception e) {
                ClientLogger.LOG.warning("Exception while parsing preferences file: " + pf.getAbsolutePath());
                ClientLogger.LOG.warning(e.getMessage());
            }
        } else {
            ClientLogger.LOG.warning("Preferences file does not exist: " + fileName);
            return new HashMap(0);
        }
        HashMap<String, Object> prefMap = new HashMap<String, Object>(this.preferences.size());
        for (int i = 0; i < this.preferences.size(); ++i) {
            Pref iterPref = this.preferences.get(i);
            if (iterPref.getKey().equals("LastUsedShoeboxMarkers")) continue;
            prefMap.put(iterPref.getKey(), iterPref.getValue());
        }
        return prefMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.content = "";
        if (localName.equals("pref")) {
            if (this.curMap == null) {
                this.curPref = new Pref(atts.getValue("key"), null);
                this.preferences.add(this.curPref);
            } else {
                this.curKey = atts.getValue("key");
            }
        } else if (localName.equals("prefGroup")) {
            this.curMap = new HashMap();
            if (this.mapStack.empty()) {
                this.curMapPref = new Pref(atts.getValue("key"), this.curMap);
                this.preferences.add(this.curMapPref);
            } else {
                this.mapStack.peek().put(atts.getValue("key"), this.curMap);
            }
            this.mapStack.push(this.curMap);
        } else if (localName.equals("prefList")) {
            this.curList = new ArrayList();
            if (this.mapStack.empty()) {
                this.curListPref = new Pref(atts.getValue("key"), this.curList);
                this.preferences.add(this.curListPref);
            } else {
                this.mapStack.peek().put(atts.getValue("key"), this.curList);
            }
        } else if (localName.equals("Boolean")) {
            this.curType = 0;
        } else if (localName.equals("Int")) {
            this.curType = 1;
        } else if (localName.equals("Long")) {
            this.curType = 2;
        } else if (localName.equals("Float")) {
            this.curType = 3;
        } else if (localName.equals("Double")) {
            this.curType = 4;
        } else if (localName.equals("String")) {
            this.curType = 5;
        } else if (localName.equals("Object")) {
            this.curType = 6;
            this.curObj = new ObjectPref(atts.getValue("class"), null);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("pref")) {
            if (this.curObj != null) {
                if (this.curObj.getObject() != null) {
                    if (this.curMap != null) {
                        this.curMap.put(this.curKey, this.curObj.getObject());
                    } else {
                        this.curPref.setValue(this.curObj.getObject());
                    }
                } else if (this.curMap == null) {
                    this.preferences.remove(this.curPref);
                }
                this.curObj = null;
            } else {
                Object value = this.getCurrentValue();
                if (this.curMap != null) {
                    if (value != null) {
                        this.curMap.put(this.curKey, value);
                    }
                } else if (value != null) {
                    this.curPref.setValue(value);
                } else {
                    this.preferences.remove(this.curPref);
                }
            }
            this.curPref = null;
            if (this.content.length() > 0) {
                this.content = "";
            }
        } else if (localName.equals("prefGroup")) {
            if (!this.mapStack.empty()) {
                this.mapStack.pop();
                if (this.mapStack.empty()) {
                    this.curMap = null;
                    this.curMapPref = null;
                } else {
                    this.curMap = (HashMap)this.mapStack.peek();
                }
            } else {
                this.curMap = null;
                this.curMapPref = null;
            }
        } else if (localName.equals("prefList")) {
            this.curList = null;
            this.curListPref = null;
        } else if (localName.equals("Object")) {
            Object value = this.getCurrentValue();
            if (value instanceof String) {
                this.curObj.setValue((String)value);
                if (this.curList != null) {
                    this.curList.add(this.curObj);
                    this.curObj = null;
                }
            } else if (this.curList != null) {
                this.curList.add(value);
                this.curObj = null;
            } else {
                this.curObj.setObject(value);
            }
            this.content = "";
        } else if (this.curList != null) {
            Object value = this.getCurrentValue();
            if (value != null) {
                this.curList.add(value);
            }
            this.content = "";
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content = this.content + new String(ch, start, length);
    }

    private Object getCurrentValue() {
        if (this.content == null || this.content.length() == 0) {
            return null;
        }
        this.content = this.content.trim();
        Object vl = null;
        switch (this.curType) {
            case 0: {
                vl = new Boolean(this.content);
                break;
            }
            case 1: {
                try {
                    vl = new Integer(this.content);
                }
                catch (NumberFormatException nfe) {}
                break;
            }
            case 2: {
                try {
                    vl = new Long(this.content);
                }
                catch (NumberFormatException nfe) {}
                break;
            }
            case 3: {
                try {
                    vl = new Float(this.content);
                }
                catch (NumberFormatException nfe) {}
                break;
            }
            case 4: {
                try {
                    vl = new Double(this.content);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 6: {
                if (this.curObj != null) {
                    vl = this.converter.stringToObject(this.curObj.getClassName(), this.content);
                    break;
                }
                vl = this.content;
                break;
            }
            default: {
                vl = this.content;
            }
        }
        return vl;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private class PrefErrorHandler
    implements ErrorHandler {
        private PrefErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage() + "\n" + exception.getLineNumber() + " " + exception.getColumnNumber());
            System.out.println("systemID: " + exception.getSystemId());
            System.out.println("publicID: " + exception.getPublicId());
            exception.printStackTrace();
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

