/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.util.FileUtility;

public class MediaNavPanel
extends JPanel
implements PreferenceEditor,
ChangeListener,
ActionListener {
    private boolean origFrameStepToFrameBegin = false;
    private String curMediaLocation = "-";
    private boolean origVideoSameSize = false;
    private boolean videoInCentre = false;
    private boolean origAltMediaLocSetsDirty = true;
    private String origTimeFormat = "ms";
    private boolean origPromptForFilename = true;
    private boolean origOnlyClipFirstMediaFile = false;
    private boolean origClipInParallel = true;
    private JCheckBox frameStepCB;
    private JCheckBox videosSameSizeCB;
    private JCheckBox videosInCentreCB;
    private JLabel setDirLabel;
    private JLabel curDirLabel;
    private JButton defaultDirButton;
    private JButton resetDirButton;
    private JCheckBox changedMediaLocCB;
    private JLabel timeFormatLabel;
    private JComboBox timeFormatComboBox;
    private JCheckBox promptForFilenameCB;
    private JCheckBox onlyClipFirstMediaFileCB;
    private JCheckBox clipInParallelCB;
    private String HH_MM_SS_MS = ElanLocale.getString("TimeCodeFormat.Hours");
    private String SS_MS = ElanLocale.getString("TimeCodeFormat.Seconds");
    private String MS = ElanLocale.getString("TimeCodeFormat.MilliSec");
    private String NTSC = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC");
    private String PAL = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL");
    private Map<String, String> tcMap = new HashMap<String, String>(5);
    private int origTimeFormatIndex;

    public MediaNavPanel() {
        this.tcMap.put(this.HH_MM_SS_MS, "hh:mm:ss.ms");
        this.tcMap.put(this.SS_MS, "ss.ms");
        this.tcMap.put(this.MS, "ms");
        this.tcMap.put(this.NTSC, "NTSC");
        this.tcMap.put(this.PAL, "PAL");
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("MediaNavigation.FrameStepToFrameBegin", null);
        if (val instanceof Boolean) {
            this.origFrameStepToFrameBegin = (Boolean)val;
        }
        if ((val = Preferences.get("DefaultMediaLocation", null)) instanceof String) {
            this.curMediaLocation = (String)val;
        }
        if ((val = Preferences.get("Media.VideosSameSize", null)) instanceof Boolean) {
            this.origVideoSameSize = (Boolean)val;
        }
        if ((val = Preferences.get("Media.VideosCentre", null)) instanceof Boolean) {
            this.videoInCentre = (Boolean)val;
        }
        if ((val = Preferences.get("MediaLocation.AltLocationSetsChanged", null)) instanceof Boolean) {
            this.origAltMediaLocSetsDirty = (Boolean)val;
        }
        if ((val = Preferences.get("CurrentTime.Copy.TimeFormat", null)) instanceof String) {
            String storedPref = (String)val;
            if (this.tcMap.containsKey(storedPref)) {
                this.origTimeFormat = this.tcMap.get(storedPref);
            } else if (this.tcMap.values().contains(storedPref)) {
                this.origTimeFormat = storedPref;
            }
        }
        if ((val = Preferences.get("Media.PromptForFilename", null)) instanceof Boolean) {
            this.origPromptForFilename = (Boolean)val;
        }
        if ((val = Preferences.get("Media.OnlyClipFirstMediaFile", null)) instanceof Boolean) {
            this.origOnlyClipFirstMediaFile = (Boolean)val;
        }
        if ((val = Preferences.get("Media.ClipInParallel", null)) instanceof Boolean) {
            this.origClipInParallel = (Boolean)val;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel mediaNavPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        this.frameStepCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.MediaNav.FrameBegin"), this.origFrameStepToFrameBegin);
        this.frameStepCB.setFont(this.frameStepCB.getFont().deriveFont(0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.gridwidth = 3;
        mediaNavPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Category.MediaNav")), gbc);
        gbc.gridy = 1;
        mediaNavPanel.add((Component)this.frameStepCB, gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(12, 0, 2, 0);
        mediaNavPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.VideoDisplay")), gbc);
        this.videosSameSizeCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.VideoSize"), this.origVideoSameSize);
        gbc.gridy = 3;
        gbc.insets = insets;
        this.videosSameSizeCB.setFont(this.videosSameSizeCB.getFont().deriveFont(0));
        mediaNavPanel.add((Component)this.videosSameSizeCB, gbc);
        this.videosInCentreCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.VideoCentre"), this.videoInCentre);
        this.videosInCentreCB.addActionListener(this);
        gbc.gridy = 4;
        gbc.insets = insets;
        this.videosInCentreCB.setFont(this.videosInCentreCB.getFont().deriveFont(0));
        mediaNavPanel.add((Component)this.videosInCentreCB, gbc);
        gbc.gridy = 5;
        gbc.insets = new Insets(12, 0, 2, 0);
        mediaNavPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.Location")), gbc);
        this.setDirLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"));
        this.setDirLabel.setFont(this.setDirLabel.getFont().deriveFont(0));
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        gbc.insets = insets;
        mediaNavPanel.add((Component)this.setDirLabel, gbc);
        this.curDirLabel = new JLabel(this.curMediaLocation);
        this.curDirLabel.setFont(this.curDirLabel.getFont().deriveFont(0));
        gbc.gridy = 7;
        mediaNavPanel.add((Component)this.curDirLabel, gbc);
        this.defaultDirButton = new JButton(ElanLocale.getString("Button.Browse"));
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 12;
        mediaNavPanel.add((Component)this.defaultDirButton, gbc);
        this.defaultDirButton.addActionListener(this);
        this.resetDirButton = new JButton();
        ImageIcon resetIcon = null;
        try {
            resetIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
            this.resetDirButton.setIcon(resetIcon);
        }
        catch (Exception ex) {
            this.resetDirButton.setText("X");
        }
        this.resetDirButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
        this.resetDirButton.setPreferredSize(new Dimension(this.resetDirButton.getPreferredSize().width, this.defaultDirButton.getPreferredSize().height));
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 10, 2, 0);
        mediaNavPanel.add((Component)this.resetDirButton, gbc);
        this.resetDirButton.addActionListener(this);
        this.changedMediaLocCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.SaveAltLocation"));
        this.changedMediaLocCB.setFont(this.changedMediaLocCB.getFont().deriveFont(0));
        this.changedMediaLocCB.setSelected(this.origAltMediaLocSetsDirty);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        mediaNavPanel.add((Component)this.changedMediaLocCB, gbc);
        this.timeFormatLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Media.TimeFormat"));
        gbc.gridy = 10;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(12, 0, 2, 0);
        mediaNavPanel.add((Component)this.timeFormatLabel, gbc);
        this.timeFormatComboBox = new JComboBox();
        this.timeFormatComboBox.addItem(this.HH_MM_SS_MS);
        this.timeFormatComboBox.addItem(this.SS_MS);
        this.timeFormatComboBox.addItem(this.MS);
        this.timeFormatComboBox.addItem(this.NTSC);
        this.timeFormatComboBox.addItem(this.PAL);
        boolean prefRestored = false;
        Iterator<String> tcIt = this.tcMap.keySet().iterator();
        String tcConst = null;
        while (tcIt.hasNext()) {
            String key = tcIt.next();
            tcConst = this.tcMap.get(key);
            if (!tcConst.equals(this.origTimeFormat)) continue;
            this.timeFormatComboBox.setSelectedItem(key);
            prefRestored = true;
            break;
        }
        if (!prefRestored) {
            this.timeFormatComboBox.setSelectedItem(this.MS);
        }
        this.origTimeFormatIndex = this.timeFormatComboBox.getSelectedIndex();
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        mediaNavPanel.add((Component)this.timeFormatComboBox, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.insets = new Insets(2, 0, 2, 0);
        gbc.gridx = 0;
        gbc.gridy = 12;
        mediaNavPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.Clipping")), gbc);
        this.promptForFilenameCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.PromptForFilename"), this.origPromptForFilename);
        gbc.gridy = 13;
        this.promptForFilenameCB.setFont(this.promptForFilenameCB.getFont().deriveFont(0));
        mediaNavPanel.add((Component)this.promptForFilenameCB, gbc);
        this.onlyClipFirstMediaFileCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.OnlyClipFirstMediaFile"), this.origOnlyClipFirstMediaFile);
        gbc.gridy = 14;
        this.onlyClipFirstMediaFileCB.setFont(this.onlyClipFirstMediaFileCB.getFont().deriveFont(0));
        mediaNavPanel.add((Component)this.onlyClipFirstMediaFileCB, gbc);
        this.clipInParallelCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.ClipInParallel"), this.origClipInParallel);
        gbc.gridy = 15;
        this.clipInParallelCB.setFont(this.clipInParallelCB.getFont().deriveFont(0));
        mediaNavPanel.add((Component)this.clipInParallelCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 16;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        mediaNavPanel.add((Component)new JPanel(), gbc);
        JScrollPane scrollPane = new JScrollPane(mediaNavPanel);
        scrollPane.setBorder(new TitledBorder(ElanLocale.getString("PreferencesDialog.Category.Media")));
        scrollPane.setBackground(mediaNavPanel.getBackground());
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.add((Component)scrollPane, gbc);
    }

    @Override
    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(4);
            if (this.frameStepCB.isSelected() != this.origFrameStepToFrameBegin) {
                chMap.put("MediaNavigation.FrameStepToFrameBegin", new Boolean(this.frameStepCB.isSelected()));
            }
            if (this.videosSameSizeCB.isSelected() != this.origVideoSameSize) {
                chMap.put("Media.VideosSameSize", new Boolean(this.videosSameSizeCB.isSelected()));
            }
            if (this.videosInCentreCB.isSelected() != this.videoInCentre) {
                chMap.put("Media.VideosCentre", new Boolean(this.videosInCentreCB.isSelected()));
            }
            if (this.curDirLabel.getText() != null && !this.curDirLabel.getText().equals("-")) {
                chMap.put("DefaultMediaLocation", this.curDirLabel.getText());
            } else {
                chMap.put("DefaultMediaLocation", null);
            }
            if (this.changedMediaLocCB.isSelected() != this.origAltMediaLocSetsDirty) {
                chMap.put("MediaLocation.AltLocationSetsChanged", new Boolean(this.changedMediaLocCB.isSelected()));
            }
            if (this.origTimeFormatIndex != this.timeFormatComboBox.getSelectedIndex()) {
                chMap.put("CurrentTime.Copy.TimeFormat", this.tcMap.get(this.timeFormatComboBox.getSelectedItem()));
            }
            if (this.promptForFilenameCB.isSelected() != this.origPromptForFilename) {
                chMap.put("Media.PromptForFilename", new Boolean(this.promptForFilenameCB.isSelected()));
            }
            if (this.onlyClipFirstMediaFileCB.isSelected() != this.origOnlyClipFirstMediaFile) {
                chMap.put("Media.OnlyClipFirstMediaFile", new Boolean(this.onlyClipFirstMediaFileCB.isSelected()));
            }
            if (this.clipInParallelCB.isSelected() != this.origClipInParallel) {
                chMap.put("Media.ClipInParallel", new Boolean(this.clipInParallelCB.isSelected()));
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return this.frameStepCB.isSelected() != this.origFrameStepToFrameBegin || !this.curMediaLocation.equals(this.curDirLabel.getText()) || this.videosSameSizeCB.isSelected() != this.origVideoSameSize || this.videosInCentreCB.isSelected() != this.videoInCentre || this.changedMediaLocCB.isSelected() != this.origAltMediaLocSetsDirty || this.origTimeFormatIndex != this.timeFormatComboBox.getSelectedIndex() || this.promptForFilenameCB.isSelected() != this.origPromptForFilename || this.onlyClipFirstMediaFileCB.isSelected() != this.origOnlyClipFirstMediaFile || this.clipInParallelCB.isSelected() != this.origClipInParallel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultDirButton) {
            File dir;
            FileChooser chooser = new FileChooser(this);
            if (this.curMediaLocation.length() > 1 && (dir = new File(FileUtility.urlToAbsPath(this.curMediaLocation))).exists() && dir.isDirectory()) {
                chooser.setCurrentDirectory(dir.getAbsolutePath());
            }
            chooser.createAndShowFileDialog(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"), 0, ElanLocale.getString("Button.Select"), null, null, true, null, 1, null);
            File selFile = chooser.getSelectedFile();
            if (selFile != null) {
                this.curDirLabel.setText(selFile.getAbsolutePath());
                this.curDirLabel.setText(FileUtility.pathToURLString(selFile.getAbsolutePath()));
            }
        } else if (e.getSource() == this.resetDirButton) {
            this.curDirLabel.setText("-");
        } else if (e.getSource() == this.videosInCentreCB) {
            Preferences.set("Media.VideosCentre.Temporary", this.videosInCentreCB.isSelected(), null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.videosInCentreCB) {
            Preferences.set("Media.VideosCentre.Temporary", this.videosInCentreCB.isSelected(), null);
        }
    }
}

