/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.util.SystemReporting;

public class PlatformPanel
extends JPanel
implements PreferenceEditor,
ChangeListener {
    private JCheckBox macScreenBarCB;
    private boolean origMacUseScreenBar = true;
    private JCheckBox macLAndFCB;
    private boolean origMacLF = true;
    private JCheckBox macFileDialogCB;
    private boolean origMacFileDialog = true;
    private JRadioButton cocoaQTB;
    private JRadioButton qtB;
    private String origMacPrefFramework = "CocoaQT";
    private boolean origPermDetached = false;
    private JCheckBox permDetachedCB;
    private JRadioButton jdsRB;
    private JCheckBox jmmfCB;
    private JRadioButton dsShowRB;
    private JRadioButton winQTRB;
    private JRadioButton jmfRB;
    private String origWinPrefFramework = "JDS";
    private JCheckBox winLAndFCB;
    private boolean origWinLF = false;
    private boolean origJMMFEnabled = true;
    private JCheckBox correctAtPauseCB;
    private boolean origCorrectAtPause = true;

    public PlatformPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = null;
        if (SystemReporting.isMacOS()) {
            val = Preferences.get("OS.Mac.useScreenMenuBar", null);
            if (val instanceof Boolean) {
                this.origMacUseScreenBar = (Boolean)val;
            }
            if ((val = Preferences.get("UseMacLF", null)) instanceof Boolean) {
                this.origMacLF = (Boolean)val;
            }
            if ((val = Preferences.get("UseMacFileDialog", null)) instanceof Boolean) {
                this.origMacFileDialog = (Boolean)val;
            }
            if ((val = Preferences.get("Mac.PrefMediaFramework", null)) instanceof String) {
                this.origMacPrefFramework = (String)val;
            }
            if ((val = Preferences.get("PreferredMediaWindow", null)) instanceof Boolean) {
                this.origPermDetached = (Boolean)val;
            }
        } else if (SystemReporting.isWindows()) {
            val = Preferences.get("Windows.PrefMediaFramework", null);
            if (val instanceof String) {
                this.origWinPrefFramework = (String)val;
            }
            if ((val = Preferences.get("UseWinLF", null)) instanceof Boolean) {
                this.origWinLF = (Boolean)val;
            }
            if ((val = Preferences.get("Windows.JMMFEnabled", null)) instanceof Boolean) {
                this.origJMMFEnabled = (Boolean)val;
            }
            if ((val = Preferences.get("Windows.JMMFPlayer.CorrectAtPause", null)) instanceof Boolean) {
                this.origCorrectAtPause = (Boolean)val;
            }
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        Font plainFont = null;
        int gy = 0;
        if (SystemReporting.isMacOS()) {
            this.macScreenBarCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.ScreenMenuBar"));
            this.macScreenBarCB.setSelected(this.origMacUseScreenBar);
            plainFont = this.macScreenBarCB.getFont().deriveFont(0);
            this.macScreenBarCB.setFont(plainFont);
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.gridy = gy++;
            gbc.insets = insets;
            this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.OS.Mac")), gbc);
            gbc.gridy = gy++;
            gbc.gridwidth = 1;
            this.add((Component)this.macScreenBarCB, gbc);
            JLabel relaunchLabel = new JLabel();
            ImageIcon relaunchIcon = null;
            try {
                relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
                relaunchLabel.setIcon(relaunchIcon);
            }
            catch (Exception ex) {
                relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.macScreenBarCB.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.add((Component)relaunchLabel, gbc);
            this.macLAndFCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.LF"));
            this.macLAndFCB.setSelected(this.origMacLF);
            this.macLAndFCB.setFont(plainFont);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.macLAndFCB, gbc);
            JLabel relaunchLabel2 = new JLabel();
            if (relaunchIcon != null) {
                relaunchLabel2.setIcon(relaunchIcon);
            } else {
                relaunchLabel2.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel2.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.macLAndFCB.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            gbc.gridx = 1;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.add((Component)relaunchLabel2, gbc);
            this.macFileDialogCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.FileDialog"));
            this.macFileDialogCB.setSelected(this.origMacFileDialog);
            this.macFileDialogCB.setFont(plainFont);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.macFileDialogCB, gbc);
            JLabel frameworkLabel = new JLabel(ElanLocale.getString("Player.Framework"));
            frameworkLabel.setFont(plainFont);
            this.cocoaQTB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.Cocoa"));
            this.cocoaQTB.setFont(plainFont);
            this.qtB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.QTJ"));
            this.qtB.setFont(plainFont);
            if (this.origMacPrefFramework.equals("CocoaQT")) {
                this.cocoaQTB.setSelected(true);
            } else {
                this.qtB.setSelected(true);
            }
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.cocoaQTB);
            gr.add(this.qtB);
            gbc.gridx = 0;
            gbc.gridy = gy++;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(12, 0, 2, 0);
            this.add((Component)frameworkLabel, gbc);
            gbc.gridy = gy++;
            gbc.insets = insets;
            this.add((Component)this.cocoaQTB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.qtB, gbc);
            this.permDetachedCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Mac.DetachedMedia"), this.origPermDetached);
            this.permDetachedCB.setFont(plainFont);
            gbc.gridy = gy++;
            this.add((Component)this.permDetachedCB, gbc);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)new JPanel(), gbc);
        } else if (SystemReporting.isWindows()) {
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.gridy = gy++;
            gbc.insets = new Insets(12, 0, 2, 0);
            this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.OS.Windows")), gbc);
            gbc.insets = insets;
            ButtonGroup winBG = new ButtonGroup();
            this.jdsRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JDS"), true);
            this.jmmfCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.JMMF"), this.origJMMFEnabled);
            this.correctAtPauseCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.JMMF.CorrectAtPause"), this.origCorrectAtPause);
            this.dsShowRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.WMP"));
            this.winQTRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.QTJ"));
            this.jmfRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.Media.JMF"));
            winBG.add(this.jdsRB);
            winBG.add(this.dsShowRB);
            winBG.add(this.winQTRB);
            winBG.add(this.jmfRB);
            plainFont = this.dsShowRB.getFont().deriveFont(0);
            JLabel winMedia = new JLabel(ElanLocale.getString("Player.Framework"));
            winMedia.setFont(plainFont);
            gbc.gridy = gy++;
            this.add((Component)winMedia, gbc);
            if (this.origWinPrefFramework.equals("NativeWindows")) {
                this.dsShowRB.setSelected(true);
            } else if (this.origWinPrefFramework.equals("QT")) {
                this.winQTRB.setSelected(true);
            } else if (this.origWinPrefFramework.equals("JMF")) {
                this.jmfRB.setSelected(true);
            }
            this.jdsRB.setFont(plainFont);
            this.jmmfCB.setFont(plainFont);
            this.dsShowRB.setFont(plainFont);
            this.winQTRB.setFont(plainFont);
            this.jmfRB.setFont(plainFont);
            this.correctAtPauseCB.setFont(plainFont);
            gbc.insets = insets;
            gbc.gridy = gy++;
            this.add((Component)this.jdsRB, gbc);
            Insets ins = new Insets(insets.top, insets.left + 16, insets.bottom, insets.right);
            gbc.gridy = gy++;
            gbc.insets = ins;
            this.add((Component)this.jmmfCB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.correctAtPauseCB, gbc);
            gbc.insets = insets;
            gbc.gridy = gy++;
            this.add((Component)this.dsShowRB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.winQTRB, gbc);
            gbc.gridy = gy++;
            this.add((Component)this.jmfRB, gbc);
            JLabel relaunchLabel = new JLabel();
            ImageIcon relaunchIcon = null;
            try {
                relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
                relaunchLabel.setIcon(relaunchIcon);
            }
            catch (Exception ex) {
                relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
            }
            relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
            this.winLAndFCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.OS.Windows.LF"), this.origWinLF);
            this.winLAndFCB.setFont(plainFont);
            gbc.insets = new Insets(12, 0, 2, 0);
            gbc.gridwidth = 1;
            gbc.gridy = gy++;
            this.add((Component)this.winLAndFCB, gbc);
            gbc.gridx = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.add((Component)relaunchLabel, gbc);
            gbc.gridy = gy++;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)new JPanel(), gbc);
            if (SystemReporting.isWindows7OrHigher() || SystemReporting.isWindowsVista()) {
                this.jdsRB.addChangeListener(this);
                this.dsShowRB.addChangeListener(this);
                this.jmfRB.addChangeListener(this);
                this.jmmfCB.setEnabled(this.jdsRB.isSelected());
                this.correctAtPauseCB.setEnabled(this.jdsRB.isSelected());
            } else {
                this.jmmfCB.setEnabled(false);
                this.jmmfCB.setVisible(false);
                this.correctAtPauseCB.setVisible(false);
            }
        }
    }

    @Override
    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(4);
            if (SystemReporting.isMacOS()) {
                if (this.macScreenBarCB.isSelected() != this.origMacUseScreenBar) {
                    chMap.put("OS.Mac.useScreenMenuBar", new Boolean(this.macScreenBarCB.isSelected()));
                }
                if (this.macLAndFCB.isSelected() != this.origMacLF) {
                    chMap.put("UseMacLF", new Boolean(this.macLAndFCB.isSelected()));
                }
                if (this.macFileDialogCB.isSelected() != this.origMacFileDialog) {
                    chMap.put("UseMacFileDialog", new Boolean(this.macFileDialogCB.isSelected()));
                }
                String tmp = "CocoaQT";
                if (this.qtB.isSelected()) {
                    tmp = "QT";
                }
                if (!this.origMacPrefFramework.equals(tmp)) {
                    chMap.put("Mac.PrefMediaFramework", tmp);
                    System.setProperty("PreferredMediaFramework", tmp);
                }
                if (this.origPermDetached != this.permDetachedCB.isSelected()) {
                    chMap.put("PreferredMediaWindow", new Boolean(this.permDetachedCB.isSelected()));
                }
            } else if (SystemReporting.isWindows()) {
                String winTmp = "JDS";
                if (this.dsShowRB.isSelected()) {
                    winTmp = "NativeWindows";
                } else if (this.winQTRB.isSelected()) {
                    winTmp = "QT";
                } else if (this.jmfRB.isSelected()) {
                    winTmp = "JMF";
                }
                if (!this.origWinPrefFramework.equals(winTmp)) {
                    chMap.put("Windows.PrefMediaFramework", winTmp);
                    System.setProperty("PreferredMediaFramework", winTmp);
                }
                if (this.origWinLF != this.winLAndFCB.isSelected()) {
                    chMap.put("UseWinLF", this.winLAndFCB.isSelected());
                }
                if (this.origJMMFEnabled != this.jmmfCB.isSelected()) {
                    chMap.put("Windows.JMMFEnabled", this.jmmfCB.isSelected());
                }
                if (this.origCorrectAtPause != this.correctAtPauseCB.isSelected()) {
                    chMap.put("Windows.JMMFPlayer.CorrectAtPause", this.correctAtPauseCB.isSelected());
                }
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        if (SystemReporting.isMacOS()) {
            if (this.macScreenBarCB.isSelected() != this.origMacUseScreenBar || this.macLAndFCB.isSelected() != this.origMacLF || this.macFileDialogCB.isSelected() != this.origMacFileDialog || this.permDetachedCB.isSelected() != this.origPermDetached) {
                return true;
            }
            String tmp = "CocoaQT";
            if (this.qtB.isSelected()) {
                tmp = "QT";
            }
            if (!this.origMacPrefFramework.equals(tmp)) {
                return true;
            }
        } else if (SystemReporting.isWindows()) {
            String winTmp = "JDS";
            if (this.dsShowRB.isSelected()) {
                winTmp = "NativeWindows";
            } else if (this.winQTRB.isSelected()) {
                winTmp = "QT";
            } else if (this.jmfRB.isSelected()) {
                winTmp = "JMF";
            }
            if (!this.origWinPrefFramework.equals(winTmp)) {
                return true;
            }
            if (this.origWinLF != this.winLAndFCB.isSelected()) {
                return true;
            }
            if (this.origJMMFEnabled != this.jmmfCB.isSelected()) {
                return true;
            }
            if (this.origCorrectAtPause != this.correctAtPauseCB.isSelected()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.jmmfCB.setEnabled(this.jdsRB.isSelected());
        this.correctAtPauseCB.setEnabled(this.jdsRB.isSelected());
    }
}

