/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.client.annotator.util.ClientLogger;

public class LocalRecognizer
implements Recognizer {
    protected RecognizerHost host;
    protected String runCommand;
    protected List<Param> paramList;
    protected List<String> mediaPaths;
    protected String name;
    protected int recognizerType;
    protected File baseDir;
    protected Process process;
    protected OutputStream outStream;
    protected InputStream inStream;
    protected BufferedReader reader;
    protected StringBuilder reportBuilder;
    protected boolean isRunning = false;
    protected long lastStartTime = 0L;
    protected volatile long lastReadSucces = 0L;

    public LocalRecognizer() {
    }

    public LocalRecognizer(String runCommand) {
        this.runCommand = runCommand;
    }

    public void setParamList(List<Param> paramList) {
        this.paramList = paramList;
    }

    @Override
    public boolean canCombineMultipleFiles() {
        if (this.paramList == null || this.paramList.isEmpty()) {
            return false;
        }
        int numAudio = 0;
        int numVideo = 0;
        for (Param p : this.paramList) {
            if (!(p instanceof FileParam)) continue;
            FileParam fp = (FileParam)p;
            if (fp.ioType == 'i' && fp.contentType == 0) {
                ++numAudio;
                continue;
            }
            if (fp.ioType != 'i' || fp.contentType != 1) continue;
            ++numVideo;
        }
        return numAudio + numVideo > 1;
    }

    @Override
    public boolean setMedia(List<String> mediaFilePaths) {
        return false;
    }

    @Override
    public boolean canHandleMedia(String mediaFilePath) {
        return true;
    }

    @Override
    public void dispose() {
        this.reportBuilder = null;
    }

    @Override
    public JPanel getControlPanel() {
        return null;
    }

    @Override
    public void validateParameters() throws RecognizerConfigurationException {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getParameterValue(String param) {
        if (param == null) {
            return null;
        }
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (p instanceof NumParam) {
                    if (((NumParam)p).current > Float.MIN_VALUE) {
                        return new Float(((NumParam)p).current);
                    }
                    return new Float(((NumParam)p).def);
                }
                if (p instanceof TextParam) {
                    String val = ((TextParam)p).curValue;
                    if (val == null) {
                        return ((TextParam)p).defValue;
                    }
                    return val;
                }
                if (!(p instanceof FileParam)) continue;
                return ((FileParam)p).filePath;
            }
        }
        return null;
    }

    @Override
    public int getRecognizerType() {
        return this.recognizerType;
    }

    public void setRecognizerType(int type) {
        this.recognizerType = type;
    }

    @Override
    public String getReport() {
        if (this.reportBuilder != null) {
            return this.reportBuilder.toString();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameterValue(String param, String value) {
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (p instanceof TextParam) {
                    ((TextParam)p).curValue = value;
                    break;
                }
                if (!(p instanceof FileParam)) break;
                ((FileParam)p).filePath = value;
                break;
            }
        }
    }

    @Override
    public void setParameterValue(String param, float value) {
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (!(p instanceof NumParam)) break;
                ((NumParam)p).current = value;
                break;
            }
        }
    }

    @Override
    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    @Override
    public void start() {
        if (this.runCommand == null || this.runCommand.length() == 0) {
            if (this.host != null) {
                ClientLogger.LOG.severe("No run command found");
                this.host.errorOccurred("No run command found");
            }
            return;
        }
        try {
            this.isRunning = true;
            this.host.setProgress(-1.0f);
            this.reportBuilder = new StringBuilder();
            this.lastStartTime = System.currentTimeMillis();
            StringTokenizer tokenizer = new StringTokenizer(this.runCommand);
            ArrayList<String> cmds = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                cmds.add(tokenizer.nextToken());
            }
            ProcessBuilder pBuilder = new ProcessBuilder(cmds);
            pBuilder.redirectErrorStream(true);
            pBuilder.directory(this.baseDir);
            this.process = pBuilder.start();
            ClientLogger.LOG.info("Created process..." + this.runCommand);
            this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            new ReaderThread().start();
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream())), true);
            if (this.paramList != null && this.paramList.size() > 0) {
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
                for (Param p : this.paramList) {
                    String path;
                    writer.print("<param name=\"" + p.id + "\">");
                    if (p instanceof NumParam) {
                        writer.print(((NumParam)p).current);
                    } else if (p instanceof TextParam) {
                        String value = ((TextParam)p).curValue;
                        if (value == null) {
                            value = ((TextParam)p).defValue;
                        }
                        if (value != null && value.length() > 0) {
                            writer.print(value);
                        }
                    } else if (p instanceof FileParam && (path = ((FileParam)p).filePath) != null) {
                        if (path.startsWith("file:")) {
                            path = path.substring(5);
                        }
                        if (path.length() > 5 && path.substring(0, 5).matches("///[a-zA-Z]:")) {
                            path = path.substring(3).replace('/', '\\');
                        }
                        writer.print(path);
                    }
                    writer.println("</param>");
                }
                writer.println("</PARAM>");
            }
            writer.close();
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Could not run the recognizer: " + ioe.getMessage());
            this.reportBuilder.append("Could not run the recognizer: " + ioe.getMessage());
            this.reportBuilder.append("\n");
            this.host.errorOccurred("Could not run the recognizer: " + ioe.getMessage());
        }
    }

    @Override
    public void stop() {
        if (this.isRunning && this.process != null) {
            ClientLogger.LOG.info("Stopping recognizer...");
            this.process.destroy();
            this.isRunning = false;
            this.convertTiers();
        }
    }

    protected void convertTiers() {
        if (this.paramList != null && this.paramList.size() > 0) {
            for (Param p : this.paramList) {
                File xmlFile;
                List<Segmentation> segm;
                if (!(p instanceof FileParam)) continue;
                FileParam fileParam = (FileParam)p;
                if (fileParam.ioType != 'o') continue;
                if (fileParam.filePath == null || fileParam.filePath.length() == 0) {
                    if (fileParam.optional || this.reportBuilder == null) continue;
                    this.reportBuilder.append("Warning: no output file found for parameter: " + fileParam.id);
                    this.reportBuilder.append('\n');
                    continue;
                }
                if (fileParam.contentType == 3) {
                    CsvTierIO cio;
                    File csvFile = new File(fileParam.filePath);
                    if (!csvFile.exists() || !csvFile.canRead() || csvFile.lastModified() <= this.lastStartTime || (segm = (cio = new CsvTierIO()).read(csvFile)) == null || segm.size() <= 0) continue;
                    for (Segmentation s : segm) {
                        this.host.addSegmentation(s);
                    }
                    continue;
                }
                if (fileParam.contentType != 2 && fileParam.contentType != 7 || !(xmlFile = new File(fileParam.filePath)).exists() || !xmlFile.canRead() || xmlFile.lastModified() <= this.lastStartTime) continue;
                XmlTierIO xio = new XmlTierIO(xmlFile);
                segm = null;
                try {
                    segm = xio.parse();
                }
                catch (Exception exe) {
                    JOptionPane.showMessageDialog(null, exe.getMessage(), ElanLocale.getString("Message.Error"), 0);
                }
                if (segm == null || segm.size() <= 0) continue;
                for (Segmentation s : segm) {
                    this.host.addSegmentation(s);
                }
            }
        }
    }

    @Override
    public void updateLocale(Locale locale) {
    }

    public String getRunCommand() {
        return this.runCommand;
    }

    public void setRunCommand(String runCommand) {
        this.runCommand = runCommand;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    class ReaderThread
    extends Thread {
        private final String DONE = "RESULT: DONE.";
        private final String FAIL = "RESULT: FAILED.";
        private final String PROG = "PROGRESS:";
        private final String PROG2 = "INFO: PROGRESS:";
        private final String INFO = "INFO:";
        private final String RESULT = "RESULT:";
        private float lastProg = -1.0f;

        ReaderThread() {
        }

        private float convertToFloat(String progValue) {
            float prog = -1.0f;
            try {
                if (progValue.endsWith("%")) {
                    prog = Float.parseFloat(progValue.substring(0, progValue.length() - 1));
                    prog /= 100.0f;
                } else {
                    prog = Float.parseFloat(progValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return prog;
        }

        @Override
        public void run() {
            while (LocalRecognizer.this.isRunning && LocalRecognizer.this.reader != null) {
                block28: {
                    try {
                        if (!LocalRecognizer.this.reader.ready()) break block28;
                        String line = LocalRecognizer.this.reader.readLine();
                        if (line != null) {
                            LocalRecognizer.this.lastReadSucces = System.currentTimeMillis();
                            if (LocalRecognizer.this.reportBuilder != null) {
                                LocalRecognizer.this.reportBuilder.append(line);
                                LocalRecognizer.this.reportBuilder.append('\n');
                            }
                            if (line.equals("RESULT: DONE.")) {
                                LocalRecognizer.this.convertTiers();
                                LocalRecognizer.this.host.setProgress(1.0f);
                                break;
                            }
                            if (line.equals("RESULT: FAILED.")) {
                                ClientLogger.LOG.warning("Recognizer failed...");
                                LocalRecognizer.this.host.errorOccurred("Recognizer failed.");
                                break;
                            }
                            if (line.startsWith("PROGRESS:") || line.startsWith("INFO: PROGRESS:")) {
                                int colIndex = line.indexOf(58);
                                if (line.startsWith("INFO: PROGRESS:")) {
                                    colIndex = line.indexOf(58, colIndex);
                                }
                                String message = null;
                                float prog = -1.0f;
                                if (colIndex < line.length() - 2) {
                                    String remains = line.substring(colIndex + 1).trim();
                                    int space = remains.indexOf(32);
                                    if (space > -1) {
                                        prog = this.convertToFloat(remains.substring(0, space));
                                        if (space < remains.length() - 1) {
                                            message = remains.substring(space).trim();
                                        }
                                    } else {
                                        prog = this.convertToFloat(remains);
                                    }
                                    if (prog > this.lastProg) {
                                        this.lastProg = prog;
                                    } else {
                                        prog = this.lastProg;
                                    }
                                    if (message == null) {
                                        LocalRecognizer.this.host.setProgress(prog);
                                    } else {
                                        LocalRecognizer.this.host.setProgress(prog, message);
                                    }
                                }
                                break block28;
                            }
                            if (line.length() != 1) break block28;
                            if (line.charAt(0) == '\u0004') {
                                ClientLogger.LOG.warning("Recognizer failed... end of transmission");
                                LocalRecognizer.this.host.errorOccurred("Recognizer failed, end of transmission.");
                                if (LocalRecognizer.this.reportBuilder == null) break;
                                LocalRecognizer.this.reportBuilder.append("Recognizer failed, end of transmission.");
                                LocalRecognizer.this.reportBuilder.append('\n');
                                break;
                            }
                            try {
                                int eof = Integer.parseInt(line);
                                if (eof == -1) {
                                    ClientLogger.LOG.warning("Recognizer failed... end of transmission");
                                    LocalRecognizer.this.host.errorOccurred("Recognizer failed, end of transmission.");
                                    if (LocalRecognizer.this.reportBuilder == null) break;
                                    LocalRecognizer.this.reportBuilder.append("Recognizer failed, end of transmission.");
                                    LocalRecognizer.this.reportBuilder.append('\n');
                                    break;
                                }
                                if (eof == 0) {
                                    ClientLogger.LOG.info("Recognizer terminated successfully, but did not send the corresponding RESULT code");
                                    if (LocalRecognizer.this.reportBuilder != null) {
                                        LocalRecognizer.this.reportBuilder.append("Recognizer terminated successfully...");
                                        LocalRecognizer.this.reportBuilder.append('\n');
                                    }
                                    LocalRecognizer.this.host.setProgress(1.0f);
                                    break;
                                }
                                break block28;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break block28;
                            }
                        }
                        ClientLogger.LOG.info("No line read from recognizer");
                    }
                    catch (IOException ioe) {
                        ClientLogger.LOG.info("Exception while reading the recognizer output: " + ioe.getMessage());
                    }
                }
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ie) {}
            }
            if (LocalRecognizer.this.reader != null) {
                try {
                    LocalRecognizer.this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LocalRecognizer.this.isRunning = false;
        }
    }
}

