/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.recognizer.api.RecogAvailabilityDetector;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.data.BoundarySegmentation;
import mpi.eudico.client.annotator.recognizer.data.MediaDescriptor;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.gui.AbstractRecognizerPanel;

public class AudioRecognizerPanel
extends AbstractRecognizerPanel {
    public AudioRecognizerPanel(ViewerManager2 viewerManager, ArrayList<String> audioFilePaths) {
        super(viewerManager, audioFilePaths);
    }

    @Override
    protected void initComponents() {
        this.mode = 0;
        super.initComponents();
    }

    @Override
    protected HashMap<String, Recognizer> getAvailableRecognizers() {
        return RecogAvailabilityDetector.getAudioRecognizers();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.startStopButton) && this.currentRecognizer != null && !this.isRunning && this.viewerManager.getSignalViewer() != null) {
            this.viewerManager.getSignalViewer().setSegmentationChannel1(null);
            this.viewerManager.getSignalViewer().setSegmentationChannel2(null);
        }
        super.actionPerformed(e);
    }

    public ArrayList<String> getAudioFilePaths() {
        return this.mediaFilePaths;
    }

    public void setAudioFilePaths(ArrayList<String> audioFilePaths) {
        this.mediaFilePaths.clear();
        for (int i = 0; i < audioFilePaths.size(); ++i) {
            String path = audioFilePaths.get(i);
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if (this.mediaFilePaths.contains(path)) continue;
            this.mediaFilePaths.add(path);
        }
        this.segmentations = new HashMap();
        this.updateMediaFiles();
    }

    @Override
    public void addSegmentation(Segmentation segmentation) {
        super.addSegmentation(segmentation);
        if (this.viewerManager.getSignalViewer() != null) {
            int channel = 0;
            ArrayList<MediaDescriptor> mediaDescriptors = segmentation.getMediaDescriptors();
            for (int i = 0; i < mediaDescriptors.size(); ++i) {
                MediaDescriptor descriptor = mediaDescriptors.get(i);
                channel += descriptor.channel;
            }
            if (channel == 0 && mediaDescriptors.size() <= 1) {
                this.viewerManager.getSignalViewer().setSegmentation(new BoundarySegmentation(segmentation));
            } else if (channel == 1) {
                if (this.notMono) {
                    this.viewerManager.getSignalViewer().setSegmentationChannel1(new BoundarySegmentation(segmentation));
                } else {
                    this.viewerManager.getSignalViewer().setSegmentation(new BoundarySegmentation(segmentation));
                }
            } else if (channel == 2) {
                this.viewerManager.getSignalViewer().setSegmentationChannel2(new BoundarySegmentation(segmentation));
            } else if (channel == 3) {
                // empty if block
            }
        }
    }
}

