/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.impl.TestRecognizerPanel;
import mpi.eudico.client.util.WAVSampler;

public class TestRecognizer
implements Recognizer {
    private RecognizerHost host;
    private TestRecognizerPanel controlPanel;
    private String currentMediaFilePath;
    private WAVSampler sampler;
    private int nrOfChannels;
    private int sampleFrequency;
    private long nrOfSamples;
    private float duration;
    private float normalizationFactor;
    private boolean canHandleMedia;
    private long sampleBufferBeginTime;
    private int sampleBufferDuration;
    private boolean keepRunning;

    @Override
    public String getName() {
        return "Test Recognizer";
    }

    @Override
    public JPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new TestRecognizerPanel();
        }
        return this.controlPanel;
    }

    @Override
    public boolean setMedia(List<String> mediaFilePaths) {
        if (mediaFilePaths == null) {
            return false;
        }
        this.currentMediaFilePath = mediaFilePaths.get(0);
        this.canHandleMedia = false;
        try {
            this.sampler = new WAVSampler(this.currentMediaFilePath);
            this.nrOfChannels = this.sampler.getWavHeader().getNumberOfChannels();
            this.sampleFrequency = this.sampler.getSampleFrequency();
            this.nrOfSamples = this.sampler.getNrOfSamples();
            this.duration = this.sampler.getDuration();
            this.normalizationFactor = this.sampler.getPossibleMaxSample() + 1;
            this.sampleBufferBeginTime = -1L;
            this.sampleBufferDuration = 0;
            this.canHandleMedia = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.canHandleMedia;
    }

    @Override
    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    private void getSamples(long from, long to, int channel, float[] samples) {
        try {
            long sampleBufferEndTime = this.sampleBufferBeginTime + (long)this.sampleBufferDuration;
            if (from < this.sampleBufferBeginTime || from >= sampleBufferEndTime || to < this.sampleBufferBeginTime || to >= sampleBufferEndTime) {
                this.sampleBufferDuration = 10000;
                while (to - from > (long)this.sampleBufferDuration) {
                    this.sampleBufferDuration += 1000;
                }
                int nSamples = this.sampleBufferDuration * this.sampleFrequency / 1000;
                this.sampleBufferBeginTime = from;
                this.sampler.seekTime(this.sampleBufferBeginTime);
                this.sampler.readInterval(nSamples, this.nrOfChannels);
            }
            Arrays.fill(samples, 0.0f);
            int srcPos = (int)((from - this.sampleBufferBeginTime) * (long)this.sampleFrequency / 1000L);
            int length = (int)((to - from) * (long)this.sampleFrequency / 1000L);
            if (channel == 1) {
                int[] intSamples = this.sampler.getFirstChannelArray();
                for (int i = 0; i < length; ++i) {
                    samples[i] = (float)intSamples[i + srcPos] / this.normalizationFactor;
                }
            } else {
                int[] intSamples = this.sampler.getSecondChannelArray();
                for (int i = 0; i < length; ++i) {
                    samples[i] = (float)intSamples[i + srcPos] / this.normalizationFactor;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        this.keepRunning = true;
        this.recog();
    }

    @Override
    public void stop() {
        this.keepRunning = false;
    }

    public void recog() {
        int stepSize = 10;
        int stepDuration = 25;
        int nSamplesInStep = stepDuration * this.sampleFrequency / 1000;
        int powerOf2Size = (int)Math.pow(2.0, Math.floor(Math.log(nSamplesInStep) / Math.log(2.0)) + 1.0);
        System.out.println("samps: " + nSamplesInStep + " pow: " + powerOf2Size);
        float[] samples1R = new float[powerOf2Size];
        float[] samples1C = new float[powerOf2Size];
        float[] power1 = new float[12];
        float[] samples2R = new float[powerOf2Size];
        float[] samples2C = new float[powerOf2Size];
        float[] power2 = new float[12];
        long time = 0L;
        while ((float)(time + (long)stepDuration) < this.duration) {
            this.host.setProgress((float)time / this.duration);
            System.out.print(time + "  ");
            Arrays.fill(samples1C, 0.0f);
            this.getSamples(time, time + (long)stepDuration, 1, samples1R);
            this.hann(samples1R, nSamplesInStep);
            this.complexToComplex(1, powerOf2Size, samples1R, samples1C);
            this.power(samples1R, samples1C, power1, 8000);
            if (!this.keepRunning) break;
            time += (long)stepSize;
        }
        if (this.keepRunning) {
            this.host.setProgress(1.0f);
        }
    }

    public void power(float[] real, float[] complex, float[] power, int maxFreq) {
        int nBands = power.length;
        int samplesToMaxFreq = real.length * this.sampleFrequency / (2 * maxFreq);
        int samplesPerBand = (samplesToMaxFreq - 1) / nBands;
        float sum = 0.0f;
        for (int i = 0; i < nBands; ++i) {
            double pow = 0.0;
            for (int j = 0; j < samplesPerBand; ++j) {
                int index = 1 + nBands * samplesPerBand + j;
                pow += Math.sqrt(real[i] * real[i] + complex[i] * complex[i]);
            }
            power[i] = (float)pow / (float)samplesPerBand;
            sum += power[i];
        }
        System.out.println(sum);
    }

    public void complexToComplex(int sign, int n, float[] ar, float[] ai) {
        int i;
        float scale = (float)Math.sqrt(1.0f / (float)n);
        int j = 0;
        for (i = 0; i < n; ++i) {
            int m;
            if (j >= i) {
                float tempr = ar[j] * scale;
                float tempi = ai[j] * scale;
                ar[j] = ar[i] * scale;
                ai[j] = ai[i] * scale;
                ar[i] = tempr;
                ai[i] = tempi;
            }
            for (m = n / 2; m >= 1 && j >= m; j -= m, m /= 2) {
            }
            j += m;
        }
        int mmax = 1;
        int istep = 2 * mmax;
        while (mmax < n) {
            float delta = (float)sign * (float)Math.PI / (float)mmax;
            for (int m = 0; m < mmax; ++m) {
                float w = (float)m * delta;
                float wr = (float)Math.cos(w);
                float wi = (float)Math.sin(w);
                for (i = m; i < n; i += istep) {
                    j = i + mmax;
                    float tr = wr * ar[j] - wi * ai[j];
                    float ti = wr * ai[j] + wi * ar[j];
                    ar[j] = ar[i] - tr;
                    ai[j] = ai[i] - ti;
                    int n2 = i;
                    ar[n2] = ar[n2] + tr;
                    int n3 = i;
                    ai[n3] = ai[n3] + ti;
                }
            }
            mmax = istep;
            mmax = istep;
            istep = 2 * mmax;
        }
    }

    private void hamming(float[] samples, int N) {
        int i = 0;
        while (i < N) {
            double x = Math.PI * 2 * (double)i / (double)(N - 1);
            int n = i++;
            samples[n] = (float)((double)samples[n] * (0.53836 - 0.46164 * Math.cos(x)));
        }
    }

    private void hann(float[] samples, int N) {
        int i = 0;
        while (i < N) {
            double x = Math.PI * 2 * (double)i / (double)(N - 1);
            int n = i++;
            samples[n] = (float)((double)samples[n] * (0.5 * (1.0 - Math.cos(x))));
        }
    }

    @Override
    public void updateLocale(Locale locale) {
    }

    @Override
    public boolean canCombineMultipleFiles() {
        return false;
    }

    @Override
    public boolean canHandleMedia(String mediaFilePath) {
        if (mediaFilePath == null) {
            return false;
        }
        try {
            WAVSampler wavs = new WAVSampler(mediaFilePath);
            short nc = wavs.getWavHeader().getNumberOfChannels();
            if (nc == 0) {
                return false;
            }
        }
        catch (IOException ioe) {
            return false;
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.controlPanel = null;
        this.sampler = null;
        this.host = null;
    }

    @Override
    public Object getParameterValue(String param) {
        return null;
    }

    @Override
    public int getRecognizerType() {
        return 0;
    }

    @Override
    public String getReport() {
        return null;
    }

    @Override
    public void setParameterValue(String param, String value) {
    }

    @Override
    public void setParameterValue(String param, float value) {
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void validateParameters() throws RecognizerConfigurationException {
    }
}

