/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.load;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import mpi.eudico.client.annotator.util.ClientLogger;

public class RecognizerLoader
extends URLClassLoader {
    private URL[] nativeLibs;
    private Map<String, URL> libMap;

    public RecognizerLoader(URL[] urls, URL[] nativeLibs) {
        super(urls);
        this.nativeLibs = nativeLibs;
        this.extractLibNames();
    }

    public RecognizerLoader(URL[] urls, URL[] nativeLibs, ClassLoader parent) {
        super(urls, parent);
        this.nativeLibs = nativeLibs;
        this.extractLibNames();
    }

    private void extractLibNames() {
        if (this.nativeLibs != null) {
            this.libMap = new HashMap<String, URL>(this.nativeLibs.length);
            for (int i = 0; i < this.nativeLibs.length; ++i) {
                URL url = this.nativeLibs[i];
                if (url == null) continue;
                this.addNativeLib(url);
            }
        }
    }

    private void addNativeLib(URL url) {
        String mapped;
        String exForm;
        String fileName = exForm = url.toExternalForm();
        int index = exForm.lastIndexOf(47);
        if (index > -1 && index < exForm.length() - 1) {
            fileName = exForm.substring(index + 1);
        }
        index = fileName.lastIndexOf(46);
        int beginIndex = 0;
        if (fileName.startsWith("lib")) {
            beginIndex = 3;
        }
        if (index > -1) {
            exForm = fileName.substring(beginIndex, index);
        }
        if (fileName.equals(mapped = System.mapLibraryName(exForm)) && !this.libMap.containsKey(exForm)) {
            this.libMap.put(exForm, url);
        }
    }

    @Override
    protected String findLibrary(String libname) {
        if (libname == null || this.libMap == null) {
            return null;
        }
        URL url = this.libMap.get(libname);
        if (url != null) {
            if (url.getProtocol() != null && url.getProtocol().equals("file")) {
                return url.getPath();
            }
            return url.toExternalForm();
        }
        return super.findLibrary(libname);
    }

    public void loadNativeLibs() {
        if (this.libMap != null) {
            for (URL url : this.libMap.values()) {
                try {
                    System.load(url.getPath());
                }
                catch (SecurityException se) {
                    ClientLogger.LOG.warning("Cannot load library: " + url.getFile() + ". " + se.getMessage());
                }
                catch (UnsatisfiedLinkError ue) {
                    ClientLogger.LOG.warning("Cannot load library: " + url.getFile() + ". " + ue.getMessage());
                }
            }
        }
    }

    public void addNativeLibs(URL[] nativeLibs) {
        if (nativeLibs == null) {
            return;
        }
        if (this.libMap == null) {
            this.libMap = new HashMap<String, URL>(nativeLibs.length);
        }
        for (URL url : nativeLibs) {
            if (url == null) continue;
            this.addNativeLib(url);
        }
    }

    public void addLibs(URL[] urls) {
        if (urls == null) {
            return;
        }
        for (URL u : urls) {
            this.addURL(u);
        }
    }
}

