/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.silence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.AudioSegment;
import mpi.eudico.client.annotator.recognizer.data.MediaDescriptor;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.silence.SilenceRecognizerPanel;
import mpi.eudico.client.util.WAVSampler;

public class SilenceRecognizer
implements Recognizer {
    private static final int SILENCE = -1;
    private static final int NON_SILENCE = 1;
    private static final String SILENCE_LABEL = "s";
    private static final String NON_SILENCE_LABEL = "x";
    public static final int DEFAULT_SILENCE_DURATION = 400;
    public static final int DEFAULT_NON_SILENCE_DURATION = 300;
    public static final float DEFAULT_NOISE_THRESHOLD_1 = 400.0f;
    public static final float DEFAULT_NOISE_THRESHOLD_2 = 400.0f;
    private static final int stepDuration = 20;
    private int nSteps;
    private String name = "Silence Recognizer MPI-PL";
    private RecognizerHost host;
    private SilenceRecognizerPanel controlPanel;
    private String currentMediaFilePath;
    private WAVSampler sampler;
    private int nrOfChannels;
    private int sampleFrequency;
    private long nrOfSamples;
    private float duration;
    boolean canHandleMedia;
    private long sampleBufferBeginTime;
    private int sampleBufferDuration;
    private boolean keepRunning;
    private float[] averageEnergy1;
    private int[] samples1;
    private float[] averageEnergy2;
    private int[] samples2;
    private float noiseThreshold1 = 400.0f;
    private float noiseThreshold2 = 400.0f;
    private boolean noiseThr2Set = false;
    private int silenceDur = 400;
    private int nonSilenceDur = 300;
    private StringBuilder reportBuilder;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JPanel getControlPanel() {
        return this.getSilRecPanel();
    }

    @Override
    public void validateParameters() throws RecognizerConfigurationException {
        this.getSilRecPanel().validateParameters();
    }

    private SilenceRecognizerPanel getSilRecPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new SilenceRecognizerPanel(this.host.getSelectionPanel(null));
        }
        return this.controlPanel;
    }

    @Override
    public boolean setMedia(List<String> mediaFilePaths) {
        this.getSilRecPanel().updateMediaFiles(mediaFilePaths);
        return true;
    }

    @Override
    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    private StringBuilder getReportBuilder() {
        if (this.reportBuilder == null) {
            this.reportBuilder = new StringBuilder();
        }
        return this.reportBuilder;
    }

    private void getSamples(long from, long to, int channel, int[] samples) {
        try {
            long sampleBufferEndTime = this.sampleBufferBeginTime + (long)this.sampleBufferDuration;
            if (from < this.sampleBufferBeginTime || from >= sampleBufferEndTime || to < this.sampleBufferBeginTime || to >= sampleBufferEndTime) {
                this.sampleBufferDuration = 10000;
                while (to - from > (long)this.sampleBufferDuration) {
                    this.sampleBufferDuration += 1000;
                }
                int nSamples = this.sampleBufferDuration * this.sampleFrequency / 1000;
                this.sampleBufferBeginTime = from;
                this.sampler.seekTime(this.sampleBufferBeginTime);
                this.sampler.readInterval(nSamples, this.nrOfChannels);
            }
            Arrays.fill(samples, 0);
            int srcPos = (int)((from - this.sampleBufferBeginTime) * (long)this.sampleFrequency / 1000L);
            int length = (int)((to - from) * (long)this.sampleFrequency / 1000L);
            if (channel == 1) {
                System.arraycopy(this.sampler.getFirstChannelArray(), srcPos, samples, 0, length);
            } else {
                System.arraycopy(this.sampler.getSecondChannelArray(), srcPos, samples, 0, length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private float max(int[] samples) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < samples.length; ++i) {
            if (max >= samples[i]) continue;
            max = samples[i];
        }
        return max;
    }

    private int zeroCrossings(int[] samples) {
        int crossings = 0;
        int i = 0;
        while (i + 1 < samples.length) {
            if (samples[i] * samples[i + 1] < 0) {
                ++crossings;
            }
            ++i;
        }
        return crossings;
    }

    private float averageEnergy(int[] samples) {
        if (samples.length == 0) {
            return 0.0f;
        }
        double average = 0.0;
        for (int i = 0; i < samples.length; ++i) {
            int sample = samples[i];
            average += (double)(sample * sample);
        }
        return (float)Math.sqrt(average / (double)samples.length);
    }

    private float averageEnergy(int channel, int step) {
        if (channel == 1) {
            if (this.averageEnergy1 == null) {
                this.averageEnergy1 = new float[this.nSteps];
                for (int i = 0; i < this.nSteps; ++i) {
                    this.averageEnergy1[i] = -1.0f;
                }
                this.samples1 = new int[this.sampleFrequency * 20 / 1000];
            }
            if (this.averageEnergy1[step] < 0.0f) {
                long time = step * 20;
                this.getSamples(time, time + 20L, 1, this.samples1);
                this.averageEnergy1[step] = this.averageEnergy(this.samples1);
            }
            return this.averageEnergy1[step];
        }
        if (channel == 2) {
            if (this.averageEnergy2 == null) {
                this.averageEnergy2 = new float[this.nSteps];
                for (int i = 0; i < this.nSteps; ++i) {
                    this.averageEnergy2[i] = -1.0f;
                }
                this.samples2 = new int[this.sampleFrequency * 20 / 1000];
            }
            if (this.averageEnergy2[step] < 0.0f) {
                long time = step * 20;
                this.getSamples(time, time + 20L, 2, this.samples2);
                this.averageEnergy2[step] = this.averageEnergy(this.samples2);
            }
            return this.averageEnergy2[step];
        }
        return 0.0f;
    }

    @Override
    public void start() {
        this.keepRunning = true;
        this.recog();
    }

    @Override
    public void stop() {
        this.keepRunning = false;
    }

    public void recog() {
        Segmentation seg;
        this.currentMediaFilePath = this.getSilRecPanel().getSelectedMediaFile();
        if (this.currentMediaFilePath == null) {
            System.out.println("No media available");
            this.stop();
            return;
        }
        this.averageEnergy1 = null;
        this.averageEnergy2 = null;
        try {
            this.sampler = new WAVSampler(this.currentMediaFilePath);
            this.nrOfChannels = this.sampler.getWavHeader().getNumberOfChannels();
            this.sampleFrequency = this.sampler.getSampleFrequency();
            this.nrOfSamples = this.sampler.getNrOfSamples();
            this.duration = this.sampler.getDuration();
            this.nSteps = (int)(this.duration / 20.0f);
            this.sampleBufferBeginTime = -1L;
            this.sampleBufferDuration = 0;
            this.canHandleMedia = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getReportBuilder().delete(0, this.getReportBuilder().length());
        long curTime = System.currentTimeMillis();
        this.host.setProgress(0.01f, "Retrieving noise thresholds...");
        float maxEnergyChannel1 = -2.1474836E9f;
        float maxEnergyChannel2 = -2.1474836E9f;
        boolean lookAtChannel1 = false;
        boolean lookAtChannel2 = false;
        int[] samples = new int[this.sampleFrequency * 20 / 1000];
        this.host.setProgress(0.01f, "Loading selection/tier objects...");
        ArrayList<RSelection> selections = this.getSilRecPanel().getSelections();
        if (selections == null) {
            this.getReportBuilder().append("No selections available");
            this.host.errorOccurred("No selections available");
            return;
        }
        if (selections != null && selections.size() > 0) {
            for (int i = 0; i < selections.size(); ++i) {
                RSelection selection = selections.get(i);
                for (long time = selection.beginTime; time < selection.endTime; time += 20L) {
                    float energy;
                    long to = time + 20L;
                    if (to > selection.endTime) {
                        to = selection.endTime;
                    }
                    if (selection instanceof AudioSegment && ((AudioSegment)selection).channel == 2) {
                        this.getSamples(time, to, 2, samples);
                        energy = this.averageEnergy(samples);
                        if (!(energy > maxEnergyChannel2)) continue;
                        maxEnergyChannel2 = energy;
                        continue;
                    }
                    this.getSamples(time, to, 1, samples);
                    energy = this.averageEnergy(samples);
                    if (!(energy > maxEnergyChannel1)) continue;
                    maxEnergyChannel1 = energy;
                }
            }
            this.noiseThreshold1 = maxEnergyChannel1;
            if (maxEnergyChannel2 > -2.1474836E9f) {
                this.noiseThreshold2 = maxEnergyChannel2;
            }
            lookAtChannel1 = maxEnergyChannel1 > -2.1474836E9f;
            lookAtChannel2 = maxEnergyChannel2 > -2.1474836E9f;
        } else {
            lookAtChannel1 = true;
            if (this.nrOfChannels > 1 && this.noiseThr2Set) {
                lookAtChannel2 = true;
            }
        }
        this.getReportBuilder().append("Noise level 1:\t");
        this.getReportBuilder().append(this.noiseThreshold1);
        this.getReportBuilder().append('\n');
        if (lookAtChannel2) {
            this.getReportBuilder().append("Noise level 2:\t");
            this.getReportBuilder().append(this.noiseThreshold2);
            this.getReportBuilder().append("\n\n");
        }
        this.getReportBuilder().append("Minimal silence duration :\t");
        this.getReportBuilder().append(this.getSilRecPanel().getMinimalSilenceDuration());
        this.getReportBuilder().append(" ms\n");
        this.getReportBuilder().append("Minimal non-silence duration :\t");
        this.getReportBuilder().append(this.getSilRecPanel().getMinimalNonSilenceDuration());
        this.getReportBuilder().append(" ms\n");
        this.host.setProgress(0.1f, "Calculating averages per frame....");
        int nSteps = (int)(this.duration / 20.0f);
        int[] steps1 = new int[nSteps];
        int[] steps2 = new int[nSteps];
        for (int step = 0; step < nSteps; ++step) {
            long time = step * 20;
            this.host.setProgress(0.1f + 0.8f * ((float)time / this.duration));
            if (lookAtChannel1) {
                int n = steps1[step] = this.averageEnergy(1, step) < this.noiseThreshold1 ? -1 : 1;
            }
            if (lookAtChannel2) {
                int n = steps2[step] = this.averageEnergy(2, step) < this.noiseThreshold2 ? -1 : 1;
            }
            if (!this.keepRunning) break;
        }
        this.host.setProgress(0.9f, "Pruning segments...");
        if (lookAtChannel1) {
            this.prune(steps1, 20);
        }
        if (lookAtChannel2) {
            this.prune(steps2, 20);
        }
        this.host.setProgress(0.97f, "Creating segmentations...");
        if (lookAtChannel1) {
            ArrayList<RSelection> segments = this.createSegmentation(steps1, 20);
            MediaDescriptor descriptor = new MediaDescriptor(this.currentMediaFilePath, 1);
            seg = new Segmentation("Channel1", segments, descriptor);
            this.host.addSegmentation(seg);
            this.getReportBuilder().append("Number of segments channel 1:\t");
            this.getReportBuilder().append(segments.size());
            this.getReportBuilder().append('\n');
        }
        if (lookAtChannel2) {
            ArrayList<RSelection> segments = this.createSegmentation(steps2, 20);
            MediaDescriptor descriptor = new MediaDescriptor(this.currentMediaFilePath, 2);
            seg = new Segmentation("Channel2", segments, descriptor);
            this.host.addSegmentation(seg);
            this.getReportBuilder().append("Number of segments channel 2:\t");
            this.getReportBuilder().append(segments.size());
            this.getReportBuilder().append('\n');
        }
        this.getReportBuilder().append("\nProcessing took:\t");
        this.getReportBuilder().append(System.currentTimeMillis() - curTime);
        this.getReportBuilder().append(" ms\n");
        if (this.keepRunning) {
            this.host.setProgress(1.0f);
        }
    }

    private void prune(int[] steps, int stepDuration) {
        int step = 1;
        while (step + 1 < steps.length) {
            if (steps[step] > 0 && steps[step - 1] < 0 && steps[step + 1] < 0) {
                steps[step] = -1;
            }
            ++step;
        }
        step = 2;
        while (step + 3 < steps.length) {
            if (steps[step] > 0 && steps[step + 1] > 0 && steps[step - 1] < 0 && steps[step - 2] < 0 && steps[step + 2] < 0 && steps[step + 3] < 0) {
                steps[step] = -1;
                steps[step + 1] = -1;
            }
            ++step;
        }
        step = 1;
        while (step + 1 < steps.length) {
            if (steps[step] < 0 && steps[step - 1] > 0 && steps[step + 1] > 0) {
                steps[step] = 1;
            }
            ++step;
        }
        step = 2;
        while (step + 3 < steps.length) {
            if (steps[step] < 0 && steps[step + 1] < 0 && steps[step - 1] > 0 && steps[step - 2] > 0 && steps[step + 2] > 0 && steps[step + 3] > 0) {
                steps[step] = 1;
                steps[step + 1] = 1;
            }
            ++step;
        }
        int minimalNonSilenceSteps = 1 + this.nonSilenceDur / stepDuration;
        minimalNonSilenceSteps = 1 + this.getSilRecPanel().getMinimalNonSilenceDuration() / stepDuration;
        for (int step2 = 0; step2 < steps.length; ++step2) {
            int to;
            if (steps[step2] < 1) continue;
            for (to = step2 + 1; to < steps.length && steps[to] >= 1; ++to) {
            }
            if (to - step2 < minimalNonSilenceSteps) {
                for (int j = step2; j < to; ++j) {
                    steps[j] = -1;
                }
            }
            step2 = to - 1;
        }
        int minimalSilenceSteps = 1 + this.silenceDur / stepDuration;
        minimalSilenceSteps = 1 + this.getSilRecPanel().getMinimalSilenceDuration() / stepDuration;
        for (int step3 = 0; step3 < steps.length; ++step3) {
            int to;
            if (steps[step3] > -1) continue;
            for (to = step3 + 1; to < steps.length && steps[to] <= -1; ++to) {
            }
            if (to - step3 < minimalSilenceSteps) {
                for (int j = step3; j < to; ++j) {
                    steps[j] = 1;
                }
            }
            step3 = to - 1;
        }
    }

    private ArrayList<RSelection> createSegmentation(int[] steps, int stepDuration) {
        ArrayList<RSelection> segments = new ArrayList<RSelection>();
        Segment segment = new Segment();
        segment.beginTime = 0L;
        int current = steps[0];
        segment.label = current <= -1 ? SILENCE_LABEL : NON_SILENCE_LABEL;
        for (int step = 1; step < steps.length; ++step) {
            if (steps[step] == current) continue;
            segment.endTime = step * stepDuration;
            segments.add(segment);
            segment = new Segment();
            segment.beginTime = step * stepDuration;
            current = steps[step];
            segment.label = current <= -1 ? SILENCE_LABEL : NON_SILENCE_LABEL;
        }
        segment.endTime = (long)this.duration;
        segments.add(segment);
        return segments;
    }

    @Override
    public void updateLocale(Locale locale) {
        this.getSilRecPanel().updateLocale();
    }

    @Override
    public boolean canCombineMultipleFiles() {
        return false;
    }

    @Override
    public boolean canHandleMedia(String mediaFilePath) {
        if (mediaFilePath == null) {
            return false;
        }
        try {
            WAVSampler wavs = new WAVSampler(mediaFilePath);
            short nc = wavs.getWavHeader().getNumberOfChannels();
            if (nc == 0) {
                return false;
            }
        }
        catch (IOException ioe) {
            return false;
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    @Override
    public int getRecognizerType() {
        return 0;
    }

    @Override
    public String getReport() {
        if (this.reportBuilder != null) {
            return this.reportBuilder.toString();
        }
        return null;
    }

    @Override
    public void setParameterValue(String param, String value) {
    }

    @Override
    public void setParameterValue(String param, float value) {
        if (param == null) {
            return;
        }
        if (param.equals("threshold_1")) {
            this.noiseThreshold1 = value;
        } else if (param.equals("threshold_2")) {
            this.noiseThreshold2 = value;
        } else if (param.equals("silence_dur")) {
            this.silenceDur = (int)value;
        } else if (param.equals("non_silence_dur")) {
            this.nonSilenceDur = (int)value;
        }
    }

    @Override
    public Object getParameterValue(String param) {
        if (param == null) {
            return null;
        }
        if (param.equals("threshold_1")) {
            return new Float(this.noiseThreshold1);
        }
        if (param.equals("threshold_2")) {
            return new Float(this.noiseThreshold2);
        }
        if (param.equals("silence_dur")) {
            return new Float(this.silenceDur);
        }
        if (param.equals("non_silence_dur")) {
            return new Float(this.nonSilenceDur);
        }
        return null;
    }

    @Override
    public void dispose() {
        this.controlPanel = null;
        this.averageEnergy1 = null;
        this.samples1 = null;
        this.averageEnergy2 = null;
        this.samples2 = null;
        if (this.reportBuilder != null) {
            this.reportBuilder.delete(0, this.reportBuilder.length());
            this.reportBuilder = null;
        }
        this.host = null;
    }
}

