/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.silence;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.gui.TierSelectionPanel;

public class SilenceRecognizerPanel
extends JPanel
implements ChangeListener,
ParamPreferences {
    private JLabel minimalSilenceDurationLabel;
    private JSlider minimalSilenceDuration;
    private JLabel minimalNonSilenceDurationLabel;
    private JSlider minimalNonSilenceDuration;
    private JComboBox mediaFilesComboBox;
    private JPanel settingsPanel;
    private TierSelectionPanel selectionPanel;
    private ArrayList<String> mediaFilesList;

    public SilenceRecognizerPanel(TierSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
        this.selectionPanel.setDefaultOption("Selections");
        this.initComponents();
    }

    private void initComponents() {
        this.mediaFilesComboBox = new JComboBox();
        JPanel filePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 1, 1);
        filePanel.add((Component)new JLabel("Files List :"), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        filePanel.add((Component)this.mediaFilesComboBox, gbc);
        JPanel selPanel = new JPanel(new GridBagLayout());
        selPanel.setBorder(new TitledBorder("Selection Panel"));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.weightx = 1.0;
        selPanel.add((Component)this.selectionPanel, gbc);
        this.initializeSettingsPanel();
        JPanel settingPanel = new JPanel(new GridBagLayout());
        settingPanel.setBorder(new TitledBorder("Settings"));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 1, 1);
        settingPanel.add((Component)this.settingsPanel, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 2, 4, 2);
        this.add((Component)filePanel, gbc);
        gbc.gridy = 1;
        this.add((Component)selPanel, gbc);
        gbc.gridy = 2;
        this.add((Component)settingPanel, gbc);
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JPanel(), gbc);
    }

    private void initializeSettingsPanel() {
        int initialSilenceDuration = 400;
        int initialNonSilenceDuration = 300;
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 1));
        this.settingsPanel.add(Box.createVerticalStrut(4));
        this.minimalSilenceDurationLabel = new JLabel(ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + initialSilenceDuration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        this.settingsPanel.add(this.minimalSilenceDurationLabel);
        this.minimalSilenceDuration = new JSlider(0, 0, 1000, initialSilenceDuration);
        this.minimalSilenceDuration.setMajorTickSpacing(200);
        this.minimalSilenceDuration.setMinorTickSpacing(25);
        this.minimalSilenceDuration.setPaintTicks(true);
        this.minimalSilenceDuration.setPaintLabels(true);
        this.minimalSilenceDuration.addChangeListener(this);
        this.settingsPanel.add(this.minimalSilenceDuration);
        this.settingsPanel.add(Box.createVerticalStrut(4));
        this.minimalNonSilenceDurationLabel = new JLabel(ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + initialNonSilenceDuration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        this.settingsPanel.add(this.minimalNonSilenceDurationLabel);
        this.minimalNonSilenceDuration = new JSlider(0, 0, 1000, initialNonSilenceDuration);
        this.minimalNonSilenceDuration.setMajorTickSpacing(200);
        this.minimalNonSilenceDuration.setMinorTickSpacing(25);
        this.minimalNonSilenceDuration.setPaintTicks(true);
        this.minimalNonSilenceDuration.setPaintLabels(true);
        this.minimalNonSilenceDuration.addChangeListener(this);
        this.settingsPanel.add(this.minimalNonSilenceDuration);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int duration = source.getValue();
        if (source == this.minimalSilenceDuration) {
            this.minimalSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        } else if (source == this.minimalNonSilenceDuration) {
            this.minimalNonSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        }
    }

    public int getMinimalSilenceDuration() {
        return this.minimalSilenceDuration.getValue();
    }

    public int getMinimalNonSilenceDuration() {
        return this.minimalNonSilenceDuration.getValue();
    }

    public void updateLocale() {
        int duration = this.minimalSilenceDuration.getValue();
        this.minimalSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        duration = this.minimalNonSilenceDuration.getValue();
        this.minimalNonSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        this.selectionPanel.updateLocale();
    }

    public void updateMediaFiles(List<String> mediaFiles) {
        if (this.mediaFilesComboBox == null) {
            this.mediaFilesComboBox = new JComboBox();
        }
        if (this.mediaFilesList == null) {
            this.mediaFilesList = new ArrayList();
        }
        this.mediaFilesComboBox.removeAllItems();
        this.mediaFilesList.clear();
        if (mediaFiles != null && mediaFiles.size() > 0) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (String media : mediaFiles) {
                String fileName = this.fileNameFromPath(media);
                if (fileNameList.contains(fileName)) {
                    this.mediaFilesComboBox.addItem(media);
                } else {
                    this.mediaFilesComboBox.addItem(fileName);
                    fileNameList.add(fileName);
                }
                this.mediaFilesList.add(media);
            }
            this.mediaFilesComboBox.setSelectedIndex(0);
        }
    }

    private String fileNameFromPath(String path) {
        if (path == null) {
            return "Unknown";
        }
        int index = path.lastIndexOf(47);
        if (index > -1 && index < path.length() - 1) {
            return path.substring(index + 1);
        }
        return path;
    }

    @Override
    public Map<String, Object> getParamPreferences() {
        HashMap<String, Object> sps = new HashMap<String, Object>(4);
        sps.put("MinimalSilenceDuration", new Integer(this.minimalSilenceDuration.getValue()));
        sps.put("MinimalNonSilenceDuration", new Integer(this.minimalNonSilenceDuration.getValue()));
        sps.put("SelectionPanelPref", this.selectionPanel.getStorableParamPreferencesMap(this.selectionPanel.getParamValue()));
        return sps;
    }

    @Override
    public void setParamPreferences(Map<String, Object> storedPrefs) {
        if (storedPrefs != null) {
            Object val = storedPrefs.get("MinimalSilenceDuration");
            if (val instanceof Integer) {
                this.minimalSilenceDuration.setValue((Integer)val);
            }
            if ((val = storedPrefs.get("MinimalNonSilenceDuration")) instanceof Integer) {
                this.minimalNonSilenceDuration.setValue((Integer)val);
            }
            if ((val = storedPrefs.get("SelectionPanelPref")) instanceof HashMap) {
                this.selectionPanel.setParamValue((HashMap)val);
            }
        }
    }

    public String getSelectedMediaFile() {
        return this.mediaFilesList.get(this.mediaFilesComboBox.getSelectedIndex());
    }

    public void validateParameters() throws RecognizerConfigurationException {
        if (this.getSelections() == null) {
            throw new RecognizerConfigurationException(ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Selection"));
        }
    }

    public ArrayList<RSelection> getSelections() {
        Object value = this.selectionPanel.getSelectionedValue();
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        return null;
    }
}

