/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.model;

import java.io.File;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.client.annotator.search.model.EAFMultipleFileSearchHandler;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.model.ProgressListener;
import mpi.search.model.SearchEngine;
import mpi.search.query.model.Query;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EAFMultipleFileSearchEngine
implements SearchEngine {
    private final ProgressListener progressListener;

    public EAFMultipleFileSearchEngine(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public static ContentQuery createQuery(String regex, File[] files) throws Exception {
        AnchorConstraint ac = new AnchorConstraint("", regex, 0L, 0L, "", true, false, null);
        ContentQuery query = new ContentQuery(ac, new EAFType(), files);
        return query;
    }

    public void executeThread(ContentQuery query) throws Exception {
        EAFMultipleFileSearchHandler handler = new EAFMultipleFileSearchHandler(query);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        File[] files = query.getFiles();
        try {
            SAXParser saxParser = factory.newSAXParser();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                handler.newFile(file);
                try {
                    saxParser.parse(file, (DefaultHandler)handler);
                }
                catch (SAXException e) {
                    throw new SAXException(file.toString() + ":\n" + e.getMessage());
                }
                if (this.progressListener == null) continue;
                this.progressListener.setProgress((int)((double)(i + 1) * 100.0 / (double)files.length));
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        ArrayList<String> dirs = new ArrayList<String>();
        ArrayList paths = new ArrayList();
        dirs.add(System.getProperty("user.dir") + "/resources/testdata/elan");
    }

    @Override
    public void performSearch(Query query) throws Exception {
        this.executeThread((ContentQuery)query);
    }
}

