/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.smfsearch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableFrame;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.prefs.MultipleFileDomains;
import mpi.eudico.client.annotator.search.viewer.EAFMultipleFileUtilities;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.search.SearchLocale;
import nl.mpi.annot.search.mfsearch.SearchApplication;
import nl.mpi.annot.search.mfsearch.SearchApplicationMediator;

public class StructuredMultipleFileSearchFrame
extends ClosableFrame
implements SearchApplication {
    protected static final String PREFERENCES_DIRS_KEY = "MultipleFileSearchDirs";
    protected static final String PREFERENCES_PATHS_KEY = "MultipleFileSearchPaths";
    protected static final String PREFERENCES_LAST_DOMAIN = "LastUsedMFSearchDomain";
    private ArrayList searchDirs;
    private ArrayList searchPaths;
    private File[] searchFiles;
    private JComponent defPanel;

    public StructuredMultipleFileSearchFrame(ElanFrame2 elanFrame) {
        super(SearchLocale.getString("MultipleFileSearch.Title"));
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));
        if (icon != null) {
            this.setIconImage(icon.getImage());
        } else {
            this.setIconImage(null);
        }
        ArrayList curDomain = this.loadDomain();
        if (curDomain == null) {
            return;
        }
        SearchApplicationMediator mediator = new SearchApplicationMediator((SearchApplication)this, curDomain);
        this.defPanel = mediator.getSearchComponent();
        this.initComponents();
        this.pack();
        this.postInit();
        this.setLocationRelativeTo(elanFrame);
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.defPanel, gbc);
    }

    private void postInit() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(this.getSize().width > dim.width - 40 ? dim.width - 40 : this.getSize().width, this.getSize().height > dim.height - 40 ? dim.height - 40 : this.getSize().height);
    }

    private ArrayList loadDomain() {
        Object val = Preferences.get(PREFERENCES_LAST_DOMAIN, null);
        if (val instanceof String) {
            String domainName = (String)val;
            Map<String, List<String>> domain = MultipleFileDomains.getInstance().getDomain(domainName);
            if (domain != null) {
                List<String> paths;
                List<String> dirs = domain.get(domainName + ".Dirs");
                if (dirs != null) {
                    this.searchDirs = (ArrayList)dirs;
                }
                if ((paths = domain.get(domainName + ".Paths")) != null) {
                    this.searchPaths = (ArrayList)paths;
                }
            }
        }
        if (this.searchDirs == null && this.searchPaths == null) {
            this.searchDirs = Preferences.get(PREFERENCES_DIRS_KEY, null) != null ? (ArrayList)Preferences.get(PREFERENCES_DIRS_KEY, null) : new ArrayList(0);
            this.searchPaths = Preferences.get(PREFERENCES_PATHS_KEY, null) != null ? (ArrayList)Preferences.get(PREFERENCES_PATHS_KEY, null) : new ArrayList(0);
        } else {
            if (this.searchDirs == null) {
                this.searchDirs = new ArrayList(0);
            }
            if (this.searchPaths == null) {
                this.searchPaths = new ArrayList(0);
            }
        }
        this.searchFiles = EAFMultipleFileUtilities.getUniqueEAFFilesIn(this.searchDirs, this.searchPaths);
        if (this.searchFiles.length == 0) {
            EAFMultipleFileUtilities.specifyDomain(this, this.searchDirs, this.searchPaths);
            this.searchFiles = EAFMultipleFileUtilities.getUniqueEAFFilesIn(this.searchDirs, this.searchPaths);
            if (this.searchFiles.length == 0) {
                return null;
            }
        }
        ArrayList<File> domain = new ArrayList<File>(this.searchFiles.length);
        for (int i = 0; i < this.searchFiles.length; ++i) {
            domain.add(this.searchFiles[i]);
        }
        return domain;
    }

    public void showInViewer(String filePath, final String tierName, final long beginTime, final long endTime) {
        if (filePath != null) {
            final ElanFrame2 newElanFrame = FrameManager.getInstance().getFrameFor(filePath);
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (newElanFrame != null) {
                if (newElanFrame.getViewerManager() != null || !newElanFrame.isFullyInitialized()) {
                    Annotation ann;
                    newElanFrame.getViewerManager().getSelection().setSelection(beginTime, endTime);
                    newElanFrame.getViewerManager().getMasterMediaPlayer().setMediaTime(beginTime);
                    TierImpl t = (TierImpl)newElanFrame.getViewerManager().getTranscription().getTierWithId(tierName);
                    if (t != null && (ann = t.getAnnotationAtTime(beginTime)) != null) {
                        newElanFrame.getViewerManager().getActiveAnnotation().setAnnotation(ann);
                    }
                } else {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Annotation ann;
                            long timeOut = System.currentTimeMillis() + 30000L;
                            while (!newElanFrame.isFullyInitialized() && System.currentTimeMillis() < timeOut) {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException ie) {}
                            }
                            newElanFrame.getViewerManager().getSelection().setSelection(beginTime, endTime);
                            newElanFrame.getViewerManager().getMasterMediaPlayer().setMediaTime(beginTime);
                            TierImpl t = (TierImpl)newElanFrame.getViewerManager().getTranscription().getTierWithId(tierName);
                            if (t != null && (ann = t.getAnnotationAtTime(beginTime)) != null) {
                                newElanFrame.getViewerManager().getActiveAnnotation().setAnnotation(ann);
                            }
                        }
                    }).start();
                }
                newElanFrame.toFront();
                this.toFront();
            }
        }
    }

    public ArrayList getDomain() {
        MFDomainDialog mfDialog = new MFDomainDialog(this, ElanLocale.getString("MultipleFileSearch.SearchDomain"), true);
        mfDialog.setSearchDirs(this.searchDirs);
        mfDialog.setSearchPaths(this.searchPaths);
        mfDialog.setVisible(true);
        this.searchDirs = (ArrayList)mfDialog.getSearchDirs();
        this.searchPaths = (ArrayList)mfDialog.getSearchPaths();
        this.searchFiles = EAFMultipleFileUtilities.getUniqueEAFFilesIn(this.searchDirs, this.searchPaths);
        if (this.searchFiles.length == 0) {
            return null;
        }
        ArrayList<File> domain = new ArrayList<File>(this.searchFiles.length);
        for (int i = 0; i < this.searchFiles.length; ++i) {
            if (this.searchFiles[i] == null) continue;
            domain.add(this.searchFiles[i]);
        }
        if (domain.size() == 0) {
            return null;
        }
        return domain;
    }

    public Color getBackgroundColor() {
        return UIManager.getColor("Panel.background");
    }

    public void putPersistent(String key, String value) {
        Preferences.set(key, value, null);
    }

    public String getPersistent(String key) {
        return (String)Preferences.get(key, null);
    }

    public void deletePersistent(String key) {
        Preferences.set(key, null, null);
    }
}

