/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import mpi.eudico.client.annotator.svg.GraphicNode2D;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class GraphicTier2D {
    private TierImpl tier;
    private ArrayList nodeList;
    private boolean isActiveTier;
    private boolean isVisible;
    private int currentIndex = -1;

    public GraphicTier2D(TierImpl tier) {
        this.tier = tier;
        this.isActiveTier = false;
        this.isVisible = true;
        this.nodeList = new ArrayList(20);
    }

    public TierImpl getTier() {
        return this.tier;
    }

    public Iterator getNodes() {
        return this.nodeList.iterator();
    }

    public ArrayList getNodeList() {
        return this.nodeList;
    }

    public void insertNode(GraphicNode2D node2d) {
        if (node2d != null) {
            node2d.setTier2D(this);
            if (this.nodeList.size() == 0) {
                this.nodeList.add(node2d);
            } else {
                int pos = Collections.binarySearch(this.nodeList, node2d);
                if (pos < 0) {
                    if (-pos > this.nodeList.size()) {
                        this.nodeList.add(node2d);
                    } else {
                        this.nodeList.add(-pos - 1, node2d);
                    }
                }
            }
        }
    }

    public void removeNode(GraphicNode2D node2d) {
        if (node2d != null) {
            this.nodeList.remove(node2d);
            this.currentIndex = -1;
        }
    }

    public void setActive(boolean active) {
        this.isActiveTier = active;
    }

    public boolean isActive() {
        return this.isActiveTier;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index < this.nodeList.size() ? index : -1;
    }
}

