/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import javax.media.util.ImageToBuffer;
import mpi.eudico.client.annotator.svg.JMFSVGViewer;

public class JMFSVGEffect
implements Effect {
    protected Format rgbFormat = new RGBFormat();
    protected Format[] supportedIns = new Format[]{this.rgbFormat};
    protected Format[] supportedOuts = new Format[]{this.rgbFormat};
    protected Format input = null;
    protected Format output = null;
    protected JMFSVGViewer viewer;
    protected BufferedImage inImg;
    protected BufferedImage outImg;
    protected BufferToImage bti;
    protected Graphics2D bufG2d;
    protected float rate = 25.0f;
    protected int imgW;
    protected int imgH;
    protected long currentFrameTime = 0L;
    protected int msPerFrame = 40;

    public Format[] getSupportedInputFormats() {
        return this.supportedIns;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.supportedOuts;
        }
        Format[] outs = new Format[]{in};
        return outs;
    }

    public Format setInputFormat(Format in) {
        this.input = in;
        this.bti = new BufferToImage((VideoFormat)this.input);
        RGBFormat form = (RGBFormat)in;
        this.imgW = form.getSize().width;
        this.imgH = form.getSize().height;
        this.rate = form.getFrameRate();
        this.msPerFrame = (int)(1000.0f / this.rate);
        this.outImg = new BufferedImage(this.imgW, this.imgH, 1);
        return this.input;
    }

    public Format setOutputFormat(Format out) {
        this.output = out;
        return this.output;
    }

    public void connectViewer(JMFSVGViewer viewer) {
        this.viewer = viewer;
    }

    public void disconnectViewer() {
        this.viewer = null;
    }

    public int process(Buffer in, Buffer out) {
        if (this.viewer == null) {
            Object data = in.getData();
            in.setData(out.getData());
            out.setData(data);
            out.setFormat(in.getFormat());
            out.setLength(in.getLength());
            out.setOffset(in.getOffset());
            return 0;
        }
        this.inImg = (BufferedImage)this.bti.createImage(in);
        Buffer outBuffer = null;
        if (this.inImg != null) {
            this.bufG2d = this.outImg.createGraphics();
            this.bufG2d.drawImage((Image)this.inImg, 0, 0, null);
            if (this.viewer != null) {
                this.viewer.paintAnnotations(this.bufG2d);
            }
            outBuffer = ImageToBuffer.createBuffer((Image)this.outImg, (float)this.rate);
        } else {
            System.out.println("Effect: Image = null");
        }
        Object data = in.getData();
        in.setData(out.getData());
        if (outBuffer != null) {
            out.setData(outBuffer.getData());
            out.setFormat(outBuffer.getFormat());
            out.setLength(outBuffer.getLength());
            out.setOffset(outBuffer.getOffset());
        } else {
            out.setData(data);
            out.setFormat(in.getFormat());
            out.setLength(in.getLength());
            out.setOffset(in.getOffset());
        }
        return 0;
    }

    public String getName() {
        return "Graphic Annotation Codec";
    }

    public void open() throws ResourceUnavailableException {
    }

    public void close() {
    }

    public void reset() {
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }
}

