/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import mpi.eudico.client.annotator.svg.AbstractSVGViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import quicktime.QTException;
import quicktime.qd.PixMap;
import quicktime.qd.QDColor;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Atom;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.SpriteDescription;
import quicktime.std.movies.media.SpriteMedia;
import quicktime.std.movies.media.SpriteMediaHandler;
import quicktime.util.EncodedImage;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class QTSVGViewer
extends AbstractSVGViewer {
    private static final Logger LOG = Logger.getLogger(QTSVGViewer.class.getName());
    private Movie movie;
    private Map trackTable = new Hashtable();
    private SpriteDescription spriteDesc;
    private int qtDuration;
    private int qtMediaWidth;
    private int qtMediaHeight;
    private QDRect qtMediaRect;
    private QDRect fileMediaRect;
    private final QDColor QD_STROKE_COLOR;

    public QTSVGViewer(Transcription transcription) {
        super(transcription);
        try {
            this.spriteDesc = new SpriteDescription();
        }
        catch (QTException qte) {
            // empty catch block
        }
        float[] colors = new float[3];
        colors = this.STROKE_COLOR.getRGBColorComponents(colors);
        this.QD_STROKE_COLOR = new QDColor(colors[0], colors[1], colors[2]);
    }

    public void setMovie(Movie movie) {
        this.movie = movie;
        try {
            this.qtDuration = movie.getDuration();
            this.qtMediaWidth = movie.getNaturalBoundsRect().getWidth();
            this.qtMediaHeight = movie.getNaturalBoundsRect().getHeight();
        }
        catch (QTException qte) {
            this.qtMediaWidth = 320;
            this.qtMediaHeight = 240;
            this.qtDuration = Integer.MAX_VALUE;
        }
        this.qtMediaRect = new QDRect(0, 0, this.qtMediaWidth, this.qtMediaHeight);
        this.fileMediaRect = new QDRect(0, 0, 352, 288);
        this.initViewer();
    }

    public void setMediaFileDimension(Dimension d) {
        this.fileMediaRect = d == null ? new QDRect(0, 0, 352, 288) : new QDRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
    }

    @Override
    void initViewer() {
        if (this.movie == null) {
            return;
        }
        for (TierImpl tier : this.transcription.getTiers()) {
            this.createTrackFromTier(tier);
        }
        QTUtils.reclaimMemory();
    }

    private void createTrackFromTier(TierImpl tier) {
        if (tier == null || tier.getLinguisticType() == null || !tier.getLinguisticType().hasGraphicReferences()) {
            return;
        }
        try {
            int duration;
            AtomContainer emptyAC;
            Annotation ann;
            String tierName = tier.getName();
            Track track = null;
            SpriteMedia spriteMedia = null;
            if (this.trackTable.containsKey(tierName) && (track = (Track)this.trackTable.get(tierName)) != null) {
                this.movie.removeTrack(track);
                this.trackTable.remove(tierName);
                track.disposeQTObject();
            }
            track = this.movie.newTrack((float)this.qtMediaWidth, (float)this.qtMediaHeight, 0.0f);
            spriteMedia = new SpriteMedia(track, this.movie.getTimeScale(), null);
            Vector annos = tier.getAnnotations();
            long curEndTime = 0L;
            Iterator annIt = annos.iterator();
            spriteMedia.beginEdits();
            while (annIt.hasNext() && (ann = (Annotation)annIt.next()) instanceof SVGAlignableAnnotation) {
                AtomContainer sampleContainer;
                SVGAlignableAnnotation svgAnn = (SVGAlignableAnnotation)ann;
                if (svgAnn.getShape() == null) continue;
                if (curEndTime < svgAnn.getBeginTimeBoundary()) {
                    emptyAC = new AtomContainer();
                    duration = (int)(svgAnn.getBeginTimeBoundary() - curEndTime);
                    spriteMedia.addSample((QTHandleRef)emptyAC, 0, emptyAC.getSize(), duration, (SampleDescription)this.spriteDesc, 1, 0);
                }
                if ((sampleContainer = this.createSample(svgAnn)) != null) {
                    duration = (int)(svgAnn.getEndTimeBoundary() - svgAnn.getBeginTimeBoundary());
                    spriteMedia.addSample((QTHandleRef)sampleContainer, 0, sampleContainer.getSize(), duration, (SampleDescription)this.spriteDesc, 1, 0);
                }
                curEndTime = svgAnn.getEndTimeBoundary();
            }
            if (curEndTime < (long)this.qtDuration) {
                duration = (int)((long)this.qtDuration - curEndTime);
                emptyAC = new AtomContainer();
                spriteMedia.addSample((QTHandleRef)emptyAC, 0, emptyAC.getSize(), duration, (SampleDescription)this.spriteDesc, 1, 0);
            }
            spriteMedia.endEdits();
            track.insertMedia(0, 0, spriteMedia.getDuration(), 1.0f);
            AtomContainer spriteTrackProperties = new AtomContainer();
            spriteTrackProperties.insertChild(new Atom(0), 104, 1, 1, EndianOrder.flipNativeToBigEndian16((short)1));
            spriteMedia.setPropertyAtom(spriteTrackProperties);
            SpriteMediaHandler handler = spriteMedia.getSpriteHandler();
            handler.setGraphicsMode(new GraphicsMode(36, QDColor.black));
            Track t = this.trackTable.put(tierName, track);
            QTUtils.reclaimMemory();
        }
        catch (QTException qte) {
            LOG.warning("Unable to create track for tier: " + qte.getMessage());
        }
    }

    private AtomContainer createSample(SVGAlignableAnnotation svgAnn) {
        if (svgAnn == null || svgAnn.getShape() == null) {
            return null;
        }
        AtomContainer sampleContainer = null;
        try {
            sampleContainer = new AtomContainer();
            QTHandle imageHandle = this.createImageHandleForShape(svgAnn.getShape());
            if (imageHandle != null) {
                int spriteID = 1;
                Atom spriteSharedDataAtom = sampleContainer.insertChild(new Atom(0), 1684434036, spriteID, 0);
                if (spriteSharedDataAtom == null) {
                    return null;
                }
                Atom spriteImageContainerAtom = sampleContainer.insertChild(spriteSharedDataAtom, 1768776564, spriteID, 0);
                if (spriteImageContainerAtom == null) {
                    return null;
                }
                Atom spriteImageAtom = sampleContainer.insertChild(spriteImageContainerAtom, 1768776039, spriteID, 0);
                if (spriteImageAtom == null) {
                    return null;
                }
                sampleContainer.insertChild(spriteImageAtom, 1768776801, spriteID, 0, (QTHandleRef)imageHandle);
                sampleContainer.insertChild(spriteImageAtom, 1768777586, spriteID, 0, EndianOrder.flipNativeToBigEndian32((int)1));
                Atom spritePropAtom = sampleContainer.insertChild(new Atom(0), 1936749172, spriteID, 0);
                sampleContainer.insertChild(spritePropAtom, 4, spriteID, 0, EndianOrder.flipNativeToBigEndian16((short)1));
                sampleContainer.insertChild(spritePropAtom, 100, 1, 0, EndianOrder.flipNativeToBigEndian16((short)((short)spriteID)));
                sampleContainer.insertChild(spritePropAtom, 5, 1, 0, EndianOrder.flipNativeToBigEndian16((short)0));
            }
        }
        catch (QTException qte) {
            LOG.warning("Could not create sample from annotation: " + qte.getMessage());
        }
        return sampleContainer;
    }

    private QTHandle createImageHandleForShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        try {
            QDGraphics qdg = new QDGraphics(QDGraphics.kDefaultPixelFormat, this.qtMediaRect);
            qdg.setForeColor(this.QD_STROKE_COLOR);
            float scaleX = this.qtMediaRect.getWidthF() / (float)this.fileMediaRect.getWidth();
            float scaleY = this.qtMediaRect.getHeightF() / (float)this.fileMediaRect.getHeight();
            if (shape instanceof RectangularShape) {
                RectangularShape rs = (RectangularShape)shape;
                QDRect shapeRect = new QDRect((float)(rs.getX() * (double)scaleX), (float)(rs.getY() * (double)scaleY), (float)(rs.getWidth() * (double)scaleX), (float)(rs.getHeight() * (double)scaleY));
                if (shape instanceof Ellipse2D) {
                    qdg.frameOval(shapeRect);
                } else if (shape instanceof Rectangle2D) {
                    qdg.frameRect(shapeRect);
                }
            } else if (shape instanceof Line2D) {
                Point2D p1 = ((Line2D)shape).getP1();
                Point2D p2 = ((Line2D)shape).getP2();
                int p1x = (int)((double)scaleX * p1.getX());
                int p1y = (int)((double)scaleY * p1.getY());
                int p2x = (int)((double)scaleX * p2.getX());
                int p2y = (int)((double)scaleY * p2.getY());
                qdg.moveTo(p1x, p1y);
                qdg.lineTo(p2x, p2y);
            }
            PixMap pixmap = PixMap.fromQDGraphics((QDGraphics)qdg);
            RawEncodedImage encodedImage = pixmap.getPixelData();
            ImageDescription imageDescription = new ImageDescription(pixmap);
            EndianOrder.flipNativeToBigEndian((Object)imageDescription, (int)0, (EndianDescriptor)ImageDescription.getEndianDescriptor());
            return new QTHandle((QTHandleRef)imageDescription, (QTHandleRef)QTHandle.fromEncodedImage((EncodedImage)encodedImage));
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private void removeTrack(String tierName) {
        if (this.trackTable.containsKey(tierName)) {
            Track track = (Track)this.trackTable.get(tierName);
            if (track != null) {
                try {
                    this.movie.removeTrack(track);
                    track.disposeQTObject();
                }
                catch (StdQTException sqte) {
                    LOG.warning("Cannot remove track: " + sqte.getMessage());
                }
                catch (QTException qte) {
                    LOG.warning("Cannot remove track: " + qte.getMessage());
                }
            }
            this.trackTable.remove(tierName);
        }
    }

    @Override
    public void setVisibleTiers(Vector tiers) {
    }

    @Override
    void tierAdded(TierImpl tier) {
        this.createTrackFromTier(tier);
        this.requestRepaint();
    }

    @Override
    void tierRemoved(TierImpl tier) {
        if (tier != null && tier.getLinguisticType() != null && tier.getLinguisticType().hasGraphicReferences()) {
            this.removeTrack(tier.getName());
        }
    }

    @Override
    void annotationAdded(SVGAlignableAnnotation annotation) {
        if (annotation != null) {
            int mode = this.transcription.getTimeChangePropagationMode();
            if (mode != 2) {
                TierImpl tier = (TierImpl)annotation.getTier();
                Vector depTiers = tier.getDependentTiers();
                depTiers.add(0, tier);
                for (int i = 0; i < depTiers.size(); ++i) {
                    tier = (TierImpl)depTiers.get(i);
                    this.createTrackFromTier(tier);
                }
            } else {
                this.transcriptionChanged();
            }
            this.requestRepaint();
        }
    }

    @Override
    void transcriptionChanged() {
        Vector tiers = this.transcription.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            TierImpl tier = (TierImpl)tiers.get(i);
            this.createTrackFromTier(tier);
        }
        this.requestRepaint();
    }

    @Override
    void linguisticTypeChanged() {
        Vector tiers = this.transcription.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            TierImpl tier = (TierImpl)tiers.get(i);
            String tierName = tier.getName();
            LinguisticType type = tier.getLinguisticType();
            if (type != null && type.hasGraphicReferences()) {
                if (this.trackTable.containsKey(tierName)) continue;
                this.createTrackFromTier(tier);
                continue;
            }
            if (!this.trackTable.containsKey(tierName)) continue;
            this.removeTrack(tierName);
        }
        this.requestRepaint();
    }

    @Override
    void annotationTimeChanged(SVGAlignableAnnotation annotation) {
        if (annotation != null) {
            int mode = this.transcription.getTimeChangePropagationMode();
            if (mode != 2) {
                TierImpl tier = (TierImpl)annotation.getTier();
                Vector depTiers = tier.getDependentTiers();
                depTiers.add(0, tier);
                for (int i = 0; i < depTiers.size(); ++i) {
                    tier = (TierImpl)depTiers.get(i);
                    this.createTrackFromTier(tier);
                }
            } else {
                this.transcriptionChanged();
                return;
            }
            this.requestRepaint();
        }
    }

    @Override
    void annotationGraphicChanged(SVGAlignableAnnotation annotation) {
        if (annotation != null) {
            TierImpl tier = (TierImpl)annotation.getTier();
            this.createTrackFromTier(tier);
            this.requestRepaint();
        }
    }

    @Override
    void requestRepaint() {
        if (this.movie != null) {
            try {
                this.movie.update();
            }
            catch (QTException qTException) {
                // empty catch block
            }
        }
    }

    @Override
    void paintAnnotations(Graphics2D big2d) {
    }

    @Override
    void paintAnnotations() {
    }

    @Override
    public void setVisibleTiers(List tiers) {
    }
}

