/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.AddTypeCommand;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.server.corpora.util.SimpleReport;
import mpi.eudico.util.TimeFormatter;

public class AnnotationFromOverlaps
implements ClientLogger,
ProcessReporter {
    public static final int OVERLAP_CRITERIA_OVERLAP = 0;
    public static final int OVERLAP_CRITERIA_VALUES_EQUAL = 1;
    public static final int OVERLAP_CRITERIA_VALUES_NOT_EQUAL = 2;
    public static final int OVERLAP_CRITERIA_USE_SPECIFIED_CONSTRAINTS = 3;
    public static final int SINGLE_FILE_MODE = 0;
    public static final int MULTI_FILE_MODE = 1;
    protected String commandName;
    protected TranscriptionImpl transcription;
    protected String[] sourceTiers;
    protected String destTierName;
    protected String destLingType;
    protected int annotationValueType;
    protected String timeFormat;
    protected String annWithValue;
    protected String annFromTier;
    protected int transcriptionMode;
    protected String[] filenames;
    protected boolean usePalFormat;
    protected String parentTierName;
    protected boolean destTierCreated = false;
    protected List<AnnotationDataRecord> createdAnnos;
    protected String createAnnotations = ElanLocale.getString("OverlapsDialog.CreatingAnn");
    protected String calculating = ElanLocale.getString("OverlapsDialog.Calculating");
    private int overlapsCriteria;
    private List<String[]> tierValueConstraints;
    private List listeners;
    protected ProcessReport report;
    protected int numInspected = 0;
    protected int numFailed = 0;
    protected int numChanged = 0;

    public AnnotationFromOverlaps(String name) {
        this.commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        int i;
        this.transcription = (TranscriptionImpl)receiver;
        Object[] objectArray = (Object[])arguments[0];
        this.sourceTiers = new String[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.sourceTiers[i2] = objectArray[i2].toString();
        }
        this.destTierName = (String)arguments[1];
        this.destLingType = (String)arguments[2];
        this.annotationValueType = (Integer)arguments[3];
        this.timeFormat = (String)arguments[4];
        this.annWithValue = (String)arguments[5];
        this.annFromTier = (String)arguments[6];
        List tierOrder = (List)arguments[7];
        if (tierOrder != null && this.annotationValueType == 4) {
            this.sourceTiers = new String[tierOrder.size()];
            for (i = 0; i < tierOrder.size(); ++i) {
                this.sourceTiers[i] = tierOrder.get(i).toString();
            }
        }
        this.overlapsCriteria = (Integer)arguments[8];
        this.tierValueConstraints = (List)arguments[9];
        this.transcriptionMode = (Integer)arguments[10];
        this.usePalFormat = (Boolean)arguments[12];
        objectArray = (Object[])arguments[11];
        if (objectArray != null) {
            this.filenames = new String[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                this.filenames[i] = objectArray[i].toString();
            }
        }
        this.parentTierName = (String)arguments[13];
        this.report = new SimpleReport(ElanLocale.getString("OverlapsDialog.Report.Title"));
        int noOfFiles = 1;
        if (this.transcriptionMode == 1) {
            noOfFiles = this.filenames.length;
        }
        this.report("Number of files to process:  " + noOfFiles);
        this.report("Selected Tiers : ");
        for (String tierName : this.sourceTiers) {
            this.report("\t" + tierName);
        }
        this.report("Selected Linguistic Type Name : " + this.destLingType);
        if (this.parentTierName != null) {
            this.report("Parent Tier Name : " + this.parentTierName);
        }
        this.execute();
    }

    protected void execute() {
        CalcOverLapsThread calcThread = new CalcOverLapsThread(AnnotationFromOverlaps.class.getName());
        try {
            calcThread.start();
        }
        catch (Exception exc) {
            LOG.severe("Exception in calculation: " + exc.getMessage());
            this.progressInterrupt("An exception occurred: " + exc.getMessage());
            this.report("An exception occurred: " + exc.getMessage());
        }
    }

    public String getName() {
        return this.commandName;
    }

    private boolean createAnnotations(TranscriptionImpl transcription) {
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>();
        TierImpl parentTier = null;
        if (this.parentTierName != null && (parentTier = (TierImpl)transcription.getTierWithId(this.parentTierName)) == null) {
            ClientLogger.LOG.severe("The parent tier selected is not found in this transcription" + transcription.getName());
            this.report("File skipped.Could not find the parent tier in this transcription");
            ++this.numFailed;
            return false;
        }
        LinguisticType typeToUse = transcription.getLinguisticTypeByName(this.destLingType);
        if (this.transcriptionMode == 1) {
            if (typeToUse == null) {
                IncludedIn c = this.parentTierName == null ? null : new IncludedIn();
                AddTypeCommand com = new AddTypeCommand("Menu.Type.AddNewType");
                Object[] args = new Object[]{this.destLingType, c, null, new Boolean(true), new Boolean(false)};
                com.execute(transcription, args);
                typeToUse = transcription.getLinguisticTypeByName(this.destLingType);
                this.report("Selected Linguistic type is created in this transcription.");
            } else {
                boolean validType = true;
                if (this.parentTierName == null) {
                    if (typeToUse.getConstraints() != null) {
                        validType = false;
                    }
                } else if (typeToUse.getConstraints() == null || typeToUse.getConstraints().getStereoType() != 1) {
                    validType = false;
                }
                if (!validType) {
                    ClientLogger.LOG.severe("Linguistic type for the tier to be created in this transcription is not compatible with the selected type: " + transcription.getName());
                    this.report("Skipping file : " + transcription.getName() + ".Cannot create the new tier.Linguistic types in this transcription is not compatible with the selected type");
                    ++this.numFailed;
                    return false;
                }
            }
        }
        for (int i = 0; i < this.sourceTiers.length; ++i) {
            TierImpl tier = (TierImpl)transcription.getTierWithId(this.sourceTiers[i]);
            if (tier == null) continue;
            tierList.add(tier);
        }
        String participant = null;
        Locale locale = null;
        if (parentTier != null) {
            participant = parentTier.getParticipant();
            locale = parentTier.getDefaultLocale();
        } else {
            boolean checkParticpant = true;
            boolean checkLocale = true;
            for (int i = 0; i < tierList.size(); ++i) {
                if (i == 0) {
                    participant = ((TierImpl)tierList.get(i)).getParticipant();
                    locale = ((TierImpl)tierList.get(i)).getDefaultLocale();
                } else {
                    if (checkParticpant) {
                        if (((TierImpl)tierList.get(i)).getParticipant() != null) {
                            if (participant == null || !participant.equals(((TierImpl)tierList.get(i)).getParticipant())) {
                                participant = null;
                                checkParticpant = false;
                            }
                        } else if (participant != null) {
                            participant = null;
                            checkParticpant = false;
                        }
                    }
                    if (checkLocale) {
                        if (((TierImpl)tierList.get(i)).getDefaultLocale() != null) {
                            if (locale == null || !locale.equals(((TierImpl)tierList.get(i)).getDefaultLocale())) {
                                locale = null;
                                checkLocale = false;
                            }
                        } else if (locale != null) {
                            locale = null;
                            checkLocale = false;
                        }
                    }
                }
                if (!checkLocale && !checkParticpant) break;
            }
        }
        TierImpl dTier = new TierImpl(parentTier, this.destTierName, participant, transcription, typeToUse);
        dTier.setDefaultLocale(locale);
        transcription.addTier(dTier);
        this.report("Destination tier created.");
        this.destTierCreated = true;
        int curPropMode = transcription.getTimeChangePropagationMode();
        transcription.setNotifying(false);
        if (curPropMode != 0) {
            transcription.setTimeChangePropagationMode(0);
        }
        ArrayList<AnnotationValuesRecord> annValRecordList = this.getComputedAnnRecord(tierList, transcription);
        if (tierList.size() <= 0) {
            this.report("Source tiers not found in this transcription");
        }
        AlignableAnnotation aa = null;
        int numAnnCreated = 0;
        float perAnn = 25.0f;
        if (this.transcriptionMode == 0) {
            if (annValRecordList.size() > 0) {
                perAnn = 25.0f / (float)annValRecordList.size();
            }
            this.progressUpdate(70, this.createAnnotations);
        }
        this.createdAnnos = new ArrayList<AnnotationDataRecord>();
        for (int i = 0; i < annValRecordList.size(); ++i) {
            AnnotationValuesRecord overlap = annValRecordList.get(i);
            long beginTime = overlap.getBeginTime();
            long endTime = overlap.getEndTime();
            if (endTime <= beginTime) {
                ClientLogger.LOG.warning("Cannot create annotation, begin time >= end time: " + beginTime + " - " + endTime);
                continue;
            }
            aa = (AlignableAnnotation)dTier.createAnnotation(beginTime, endTime);
            if (aa != null) {
                switch (this.annotationValueType) {
                    case 0: {
                        aa.setValue(this.getTimeString(endTime - beginTime));
                        break;
                    }
                    case 1: {
                        aa.setValue(this.annWithValue);
                        break;
                    }
                    default: {
                        String value = overlap.getNewLabelValue();
                        if (value == null) {
                            value = overlap.getValue();
                        }
                        aa.setValue(value);
                    }
                }
                ++numAnnCreated;
                if (this.transcriptionMode != 0) continue;
                this.createdAnnos.add(new AnnotationDataRecord(aa));
                this.progressUpdate((int)(70.0f + (float)i * perAnn), this.createAnnotations);
                continue;
            }
            ClientLogger.LOG.warning("Annotation could not be created " + beginTime + "-" + endTime);
        }
        this.report("Number of annotations created: " + numAnnCreated);
        if (this.transcriptionMode == 0) {
            ClientLogger.LOG.info("Number of annotations created: " + numAnnCreated);
        }
        if (transcription.getTimeChangePropagationMode() != curPropMode) {
            transcription.setTimeChangePropagationMode(curPropMode);
        }
        transcription.setNotifying(true);
        return true;
    }

    private String getTimeString(long time) {
        if ("hh:mm:ss.ms".equals(this.timeFormat)) {
            return TimeFormatter.toString(time);
        }
        if ("ss.ms".equals(this.timeFormat)) {
            return TimeFormatter.toSSMSString(time);
        }
        if ("hh:mm:ss:ff".equals(this.timeFormat)) {
            if (this.usePalFormat) {
                return TimeFormatter.toTimecodePAL(time);
            }
            return TimeFormatter.toTimecodeNTSC(time);
        }
        return String.valueOf(time);
    }

    protected ArrayList<AnnotationValuesRecord> getComputedAnnRecord(ArrayList<TierImpl> tierList, TranscriptionImpl transcription) {
        AnnotationValuesRecord record;
        long beginTime;
        int i;
        ArrayList<AnnotationValuesRecord> overlapList = new ArrayList<AnnotationValuesRecord>();
        if (tierList.size() <= 0) {
            return overlapList;
        }
        long timeSoFar = 0L;
        TierImpl currentTier = tierList.get(0);
        Vector annotations = currentTier.getAnnotations();
        int annCount = currentTier.getNumberOfAnnotations();
        float perAnn = 60.0f;
        if (this.transcriptionMode == 0) {
            if (annCount > 0) {
                perAnn = 60.0f / (float)annCount;
            }
            this.progressUpdate(10, this.calculating);
        }
        if (annotations.size() <= 0) {
            return overlapList;
        }
        String constraint = this.getConstraint(currentTier.getName());
        for (i = 0; i < annotations.size(); ++i) {
            AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(i);
            beginTime = abstrAnnotation.getBeginTimeBoundary();
            long endTime = abstrAnnotation.getEndTimeBoundary();
            if (this.overlapsCriteria == 3 && (constraint == null || !constraint.equals(abstrAnnotation.getValue()))) continue;
            record = new AnnotationValuesRecord(null, null, beginTime, endTime);
            record.setNewLabelValue(abstrAnnotation.getValue());
            overlapList.add(record);
        }
        block1: for (i = 1; i < tierList.size(); ++i) {
            if (this.transcriptionMode == 0) {
                this.progressUpdate((int)(10.0f + (float)i * perAnn), this.calculating);
            }
            if (overlapList.size() <= 0) break;
            currentTier = tierList.get(i);
            annotations = currentTier.getAnnotations();
            constraint = this.getConstraint(currentTier.getName());
            boolean valueFromCurrentTier = this.annotationValueType == 2 && currentTier.getName().equals(this.annFromTier);
            for (int overlapNr = 0; overlapNr < overlapList.size(); ++overlapNr) {
                String newValue;
                if (annotations.size() <= 0) {
                    for (int j = overlapList.size() - 1; j >= overlapNr; --j) {
                        overlapList.remove(j);
                    }
                    continue block1;
                }
                AbstractAnnotation abstrAnnotation = (AbstractAnnotation)annotations.get(0);
                beginTime = abstrAnnotation.getBeginTimeBoundary();
                long endTime = abstrAnnotation.getEndTimeBoundary();
                record = overlapList.get(overlapNr);
                constraint = this.getConstraint(currentTier.getName());
                boolean matchConstraint = this.checkConstraint(record.getNewLabelValue(), abstrAnnotation.getValue(), this.overlapsCriteria, constraint);
                if (!matchConstraint) {
                    if (endTime < record.getEndTime()) {
                        annotations.remove(0);
                    } else {
                        overlapList.remove(overlapNr);
                    }
                    --overlapNr;
                    continue;
                }
                if (endTime < record.getBeginTime()) {
                    annotations.remove(0);
                    --overlapNr;
                    continue;
                }
                if (beginTime < record.getBeginTime() && endTime <= record.getEndTime()) {
                    if (endTime < record.getEndTime()) {
                        record = new AnnotationValuesRecord(null, null, record.getBeginTime(), endTime);
                        record.setNewLabelValue(overlapList.get(overlapNr).getNewLabelValue());
                        overlapList.add(overlapNr, record);
                        overlapList.get(overlapNr + 1).setBeginTime(endTime);
                    } else {
                        record.setEndTime(endTime);
                    }
                    newValue = null;
                    newValue = valueFromCurrentTier ? abstrAnnotation.getValue() : (this.annotationValueType == 3 ? abstrAnnotation.getValue() + " " + record.getNewLabelValue() : (this.annotationValueType == 4 ? record.getNewLabelValue() + " " + abstrAnnotation.getValue() : record.getNewLabelValue()));
                    if (!newValue.equals(record.getNewLabelValue())) {
                        record.setNewLabelValue(newValue);
                    }
                    annotations.remove(0);
                    continue;
                }
                if (beginTime >= record.getBeginTime() && endTime <= record.getEndTime()) {
                    if (endTime < record.getEndTime()) {
                        record = new AnnotationValuesRecord(null, null, beginTime, endTime);
                        record.setNewLabelValue(overlapList.get(overlapNr).getNewLabelValue());
                        overlapList.add(overlapNr, record);
                        overlapList.get(overlapNr + 1).setBeginTime(endTime);
                    } else {
                        record.setBeginTime(beginTime);
                    }
                    newValue = null;
                    newValue = valueFromCurrentTier ? abstrAnnotation.getValue() : (this.annotationValueType == 3 || this.annotationValueType == 4 ? record.getNewLabelValue() + " " + abstrAnnotation.getValue() : record.getNewLabelValue());
                    if (!newValue.equals(record.getNewLabelValue())) {
                        record.setNewLabelValue(newValue);
                    }
                    annotations.remove(0);
                    continue;
                }
                if (beginTime >= record.getEndTime()) {
                    overlapList.remove(overlapNr);
                    --overlapNr;
                    continue;
                }
                if (beginTime >= record.getBeginTime() && endTime > record.getEndTime()) {
                    record.setBeginTime(beginTime);
                    newValue = valueFromCurrentTier ? abstrAnnotation.getValue() : (this.annotationValueType == 3 || this.annotationValueType == 4 ? record.getNewLabelValue() + " " + abstrAnnotation.getValue() : record.getNewLabelValue());
                    if (newValue.equals(record.getNewLabelValue())) continue;
                    record.setNewLabelValue(newValue);
                    continue;
                }
                if (beginTime >= record.getBeginTime() || endTime <= record.getEndTime() || (newValue = valueFromCurrentTier ? abstrAnnotation.getValue() : (this.annotationValueType == 3 ? abstrAnnotation.getValue() + " " + record.getNewLabelValue() : (this.annotationValueType == 4 ? record.getNewLabelValue() + " " + abstrAnnotation.getValue() : record.getNewLabelValue()))).equals(record.getNewLabelValue())) continue;
                record.setNewLabelValue(newValue);
            }
        }
        return overlapList;
    }

    private boolean checkConstraint(String overlapValue, String newValue, int overlapsCriteria, String constraint) {
        if (overlapsCriteria == 0) {
            return true;
        }
        if (overlapsCriteria == 1) {
            return overlapValue.equals(newValue);
        }
        if (overlapsCriteria == 2) {
            return !overlapValue.equals(newValue);
        }
        if (overlapsCriteria == 3) {
            return constraint == null || newValue.equals(constraint);
        }
        return true;
    }

    private String getConstraint(String tierName) {
        for (int i = 0; i < this.tierValueConstraints.size(); ++i) {
            if (!this.tierValueConstraints.get(i)[0].equals(tierName)) continue;
            return this.tierValueConstraints.get(i)[1];
        }
        return null;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    protected void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressUpdated(this, percent, message);
            }
        }
    }

    protected void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressCompleted(this, message);
            }
        }
    }

    protected void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressInterrupted(this, message);
            }
        }
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.report;
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.report = report;
    }

    @Override
    public void report(String message) {
        if (this.report != null) {
            this.report.append(message);
        }
    }

    private class CalcOverLapsThread
    extends Thread {
        public CalcOverLapsThread() {
        }

        public CalcOverLapsThread(String name) {
            super(name);
        }

        @Override
        public void interrupt() {
            super.interrupt();
            AnnotationFromOverlaps.this.progressInterrupt("Operation interrupted...");
            AnnotationFromOverlaps.this.report("Operation interrupted...");
        }

        @Override
        public void run() {
            if (AnnotationFromOverlaps.this.transcriptionMode == 0) {
                AnnotationFromOverlaps.this.createAnnotations(AnnotationFromOverlaps.this.transcription);
                AnnotationFromOverlaps.this.progressComplete("Operation complete...");
            } else if (AnnotationFromOverlaps.this.transcriptionMode == 1) {
                float perFile = 25.0f;
                if (AnnotationFromOverlaps.this.filenames.length > 0) {
                    perFile = 25.0f / (float)AnnotationFromOverlaps.this.filenames.length;
                }
                String total = "Total no of files : " + AnnotationFromOverlaps.this.filenames.length;
                String processed = "Processed files : ";
                String processing = "processing file : ";
                String buffer = null;
                for (int i = 0; i < AnnotationFromOverlaps.this.filenames.length; ++i) {
                    TranscriptionImpl t = new TranscriptionImpl(AnnotationFromOverlaps.this.filenames[i]);
                    AnnotationFromOverlaps.this.report("\nFile " + i + " : " + t.getName());
                    buffer = total + "\n" + processed + i + "\n" + processing + t.getName();
                    AnnotationFromOverlaps.this.progressUpdate((int)((float)i * perFile), buffer);
                    boolean annotationsCreated = AnnotationFromOverlaps.this.createAnnotations(t);
                    String directoryToSave = t.getPathName();
                    try {
                        if (annotationsCreated) {
                            ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(t, null, new Vector(), directoryToSave, 0);
                            ++AnnotationFromOverlaps.this.numChanged;
                        }
                    }
                    catch (IOException e) {
                        ClientLogger.LOG.warning("Can not write transcription to file with directory/filename: " + directoryToSave);
                        if (annotationsCreated) {
                            ++AnnotationFromOverlaps.this.numFailed;
                        }
                        AnnotationFromOverlaps.this.report("Can not write transcription ' " + t.getName() + "' to file with directory/filename: " + directoryToSave);
                    }
                    buffer = total + "\n" + processed + (i + 1);
                }
                AnnotationFromOverlaps.this.progressComplete(buffer + '\n' + "Operation complete...");
                AnnotationFromOverlaps.this.report("\nSummary: ");
                AnnotationFromOverlaps.this.report("Number of files in domain:  " + AnnotationFromOverlaps.this.filenames.length);
                AnnotationFromOverlaps.this.report("Number of files changed:  " + AnnotationFromOverlaps.this.numChanged);
                AnnotationFromOverlaps.this.report("Number of files failed:  " + AnnotationFromOverlaps.this.numFailed);
            }
            new ReportDialog(AnnotationFromOverlaps.this.report).setVisible(true);
        }
    }
}

