/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.tier.AnnotationFromOverlaps;
import mpi.eudico.client.annotator.util.AnnotationSlicer;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.util.SimpleReport;

public class AnnotationFromSubtraction
extends AnnotationFromOverlaps {
    private String referenceTierName;

    public AnnotationFromSubtraction(String name) {
        super(name);
        this.calculating = ElanLocale.getString("SubtractAnnotationDialog.Calculating");
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        int i;
        this.transcription = (TranscriptionImpl)receiver;
        Object[] objectArray = (Object[])arguments[0];
        this.sourceTiers = new String[objectArray.length];
        for (i = 0; i < objectArray.length; ++i) {
            this.sourceTiers[i] = objectArray[i].toString();
        }
        this.destTierName = (String)arguments[1];
        this.destLingType = (String)arguments[2];
        this.annotationValueType = (Integer)arguments[3];
        this.timeFormat = (String)arguments[4];
        this.annWithValue = (String)arguments[5];
        this.transcriptionMode = (Integer)arguments[6];
        objectArray = (Object[])arguments[7];
        if (objectArray != null) {
            this.filenames = new String[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                this.filenames[i] = objectArray[i].toString();
            }
        }
        this.usePalFormat = (Boolean)arguments[8];
        this.parentTierName = (String)arguments[9];
        this.referenceTierName = (String)arguments[10];
        this.report = new SimpleReport(ElanLocale.getString("SubtractAnnotationDialog.Report.Title"));
        int noOfFiles = 1;
        if (this.transcriptionMode == 1) {
            noOfFiles = this.filenames.length;
        }
        this.report("Number of files to process:  " + noOfFiles);
        this.report("Selected Tiers : ");
        for (String tierName : this.sourceTiers) {
            this.report("\t" + tierName);
        }
        this.report("Selected Linguistic Type Name : " + this.destLingType);
        if (this.parentTierName != null) {
            this.report("Parent Tier Name : " + this.parentTierName);
        }
        if (this.referenceTierName != null) {
            this.report("Reference Tier Name : " + this.referenceTierName);
        }
        this.execute();
    }

    @Override
    protected ArrayList<AnnotationValuesRecord> getComputedAnnRecord(ArrayList<TierImpl> tierList, TranscriptionImpl transcription) {
        if (this.referenceTierName == null) {
            return this.getExclusiveSubtractedList(tierList);
        }
        return this.getSubtractsList(tierList, transcription);
    }

    private ArrayList<AnnotationValuesRecord> getSubtractsList(ArrayList<TierImpl> tierList, TranscriptionImpl transcription) {
        long annEnd;
        long annBegin;
        ArrayList<AnnotationValuesRecord> subtractionList = new ArrayList<AnnotationValuesRecord>();
        if (tierList.size() <= 0) {
            return subtractionList;
        }
        TierImpl currentTier = null;
        currentTier = (TierImpl)transcription.getTierWithId(this.referenceTierName);
        if (currentTier == null) {
            ClientLogger.LOG.severe("The reference tier from which the other tiers to be subtracted is not found in this transcription" + transcription.getName());
            this.report("Could not find the reference tier in this transcription");
            return subtractionList;
        }
        ArrayList<AnnotationValuesRecord> resultList = null;
        AbstractAnnotation ann = null;
        AbstractAnnotation nextAnn = null;
        AnnotationValuesRecord sub = null;
        Vector annotations = currentTier.getAnnotations();
        for (int x = 0; x < annotations.size(); ++x) {
            ann = (AbstractAnnotation)annotations.get(x);
            annBegin = ann.getBeginTimeBoundary();
            annEnd = ann.getEndTimeBoundary();
            subtractionList.add(new AnnotationValuesRecord(null, ann.getValue(), annBegin, annEnd));
        }
        int annCount = currentTier.getNumberOfAnnotations();
        float perAnn = 60.0f;
        if (this.transcriptionMode == 0) {
            if (annCount > 0) {
                perAnn = 60.0f / (float)annCount;
            }
            this.progressUpdate(10, this.calculating);
        }
        block1: for (int i = 0; i < tierList.size(); ++i) {
            long timeSoFar = 0L;
            if (this.transcriptionMode == 0) {
                this.progressUpdate((int)(10.0f + (float)i * perAnn), this.calculating);
            }
            if (this.referenceTierName.equals((currentTier = tierList.get(i)).getName())) continue;
            annotations = currentTier.getAnnotations();
            resultList = new ArrayList<AnnotationValuesRecord>();
            if (annotations.size() <= 0) continue;
            for (int subNr = 0; subNr < subtractionList.size(); ++subNr) {
                if (annotations.size() <= 0) {
                    for (int a = subNr; a < subtractionList.size(); ++a) {
                        sub = subtractionList.get(a);
                        resultList.add(new AnnotationValuesRecord(null, sub.getValue(), sub.getBeginTime(), sub.getEndTime()));
                    }
                    subtractionList = resultList;
                    continue block1;
                }
                ann = (AbstractAnnotation)annotations.get(0);
                annBegin = ann.getBeginTimeBoundary();
                annEnd = ann.getEndTimeBoundary();
                sub = subtractionList.get(subNr);
                long subBegin = sub.getBeginTime();
                long subEnd = sub.getEndTime();
                if (timeSoFar > annBegin) {
                    annBegin = timeSoFar;
                }
                if (timeSoFar > subBegin) {
                    subBegin = timeSoFar;
                }
                if (annBegin < subBegin && annEnd < subBegin) {
                    timeSoFar = annEnd;
                    annotations.remove(0);
                    --subNr;
                    continue;
                }
                if (subBegin < annBegin && subEnd < annBegin) {
                    resultList.add(new AnnotationValuesRecord(null, sub.getValue(), subBegin, subEnd));
                    timeSoFar = subEnd;
                    continue;
                }
                if (annBegin < subBegin) {
                    timeSoFar = subBegin;
                } else if (subBegin < annBegin) {
                    resultList.add(new AnnotationValuesRecord(null, sub.getValue(), subBegin, annBegin));
                    timeSoFar = annBegin;
                }
                if (annEnd < subEnd) {
                    if (annotations.size() >= 2) {
                        nextAnn = (AbstractAnnotation)annotations.get(1);
                        long nextAnnBegin = nextAnn.getBeginTimeBoundary();
                        if (nextAnnBegin < subEnd) {
                            if (annEnd < nextAnnBegin) {
                                resultList.add(new AnnotationValuesRecord(null, sub.getValue(), annEnd, nextAnnBegin));
                            }
                            timeSoFar = nextAnnBegin;
                            --subNr;
                        } else {
                            resultList.add(new AnnotationValuesRecord(null, sub.getValue(), annEnd, subEnd));
                            timeSoFar = subEnd;
                        }
                    } else {
                        resultList.add(new AnnotationValuesRecord(null, sub.getValue(), annEnd, subEnd));
                        timeSoFar = subEnd;
                    }
                    annotations.remove(0);
                    continue;
                }
                if (subEnd < annEnd) {
                    timeSoFar = subEnd;
                    continue;
                }
                annotations.remove(0);
            }
            subtractionList = resultList;
        }
        return subtractionList;
    }

    private ArrayList<AnnotationValuesRecord> getExclusiveSubtractedList(ArrayList<TierImpl> tierList) {
        ArrayList<AnnotationValuesRecord> subtractionList = new ArrayList<AnnotationValuesRecord>();
        if (tierList.size() <= 0) {
            return subtractionList;
        }
        ArrayList<Long> timeValues = AnnotationSlicer.getTimeValues(tierList);
        HashMap<Long, ArrayList<Annotation>> map = AnnotationSlicer.getAnnotationMap(timeValues, tierList);
        for (int i = 0; i < timeValues.size(); ++i) {
            long currTimeValue = timeValues.get(i);
            ArrayList<Annotation> annList = map.get(currTimeValue);
            if (annList.size() % 2 == 0) continue;
            if (annList.size() == 1) {
                subtractionList.add(new AnnotationValuesRecord(null, annList.get(0).getValue(), currTimeValue, timeValues.get(i + 1)));
                continue;
            }
            subtractionList.add(new AnnotationValuesRecord(null, "", currTimeValue, timeValues.get(i + 1)));
        }
        return subtractionList;
    }
}

