/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AnnotatorCompareUtil {
    public TableModel getComparisonTable(TranscriptionImpl transcription, String tier1, String tier2) {
        long et2;
        long bt2;
        long bt1;
        int i;
        if (transcription == null || tier1 == null || tier2 == null) {
            return null;
        }
        TierImpl t1 = (TierImpl)transcription.getTierWithId(tier1);
        TierImpl t2 = (TierImpl)transcription.getTierWithId(tier2);
        if (!t1.isTimeAlignable()) {
            throw new IllegalArgumentException("First tier is not time alignable: " + tier1);
        }
        if (!t2.isTimeAlignable()) {
            throw new IllegalArgumentException("Second tier is not time alignable: " + tier2);
        }
        ArrayList annList1 = new ArrayList(t1.getAnnotations());
        ArrayList annList2 = new ArrayList(t2.getAnnotations());
        int numAnn1 = annList1.size();
        int numAnn2 = annList2.size();
        DefaultTableModel model = new DefaultTableModel(0, 9);
        AlignableAnnotation aa1 = null;
        AlignableAnnotation aa2 = null;
        int lastInserted1 = 0;
        int lastInserted2 = -1;
        ArrayList<AlignableAnnotation> overlapList = new ArrayList<AlignableAnnotation>(5);
        ArrayList<AlignableAnnotation> addedList2 = new ArrayList<AlignableAnnotation>(numAnn2);
        for (i = 0; i < numAnn1; ++i) {
            overlapList.clear();
            aa1 = (AlignableAnnotation)annList1.get(i);
            bt1 = ((AbstractAnnotation)aa1).getBeginTimeBoundary();
            long et1 = ((AbstractAnnotation)aa1).getEndTimeBoundary();
            for (int j = lastInserted2 + 1; j < numAnn2; ++j) {
                aa2 = (AlignableAnnotation)annList2.get(j);
                bt2 = ((AbstractAnnotation)aa2).getBeginTimeBoundary();
                if (this.overlaps(bt1, et1, bt2, et2 = ((AbstractAnnotation)aa2).getEndTimeBoundary())) {
                    if (addedList2.contains(aa2)) continue;
                    overlapList.add(aa2);
                    continue;
                }
                if (bt2 <= et1) continue;
                lastInserted2 = j - 1 - overlapList.size();
                break;
            }
            if (overlapList.size() == 0) {
                model.addRow(new String[]{aa1.getValue(), String.valueOf(bt1), String.valueOf(et1), "-", "-", "-", "0", "0", "0.00"});
                continue;
            }
            if (overlapList.size() == 1) {
                aa2 = (AlignableAnnotation)overlapList.get(0);
                bt2 = ((AbstractAnnotation)aa2).getBeginTimeBoundary();
                et2 = ((AbstractAnnotation)aa2).getEndTimeBoundary();
                long ov = this.calcOverlap(bt1, et1, bt2, et2);
                long te = this.calcExtent(bt1, et1, bt2, et2);
                model.addRow(new String[]{aa1.getValue(), String.valueOf(bt1), String.valueOf(et1), aa2.getValue(), String.valueOf(bt2), String.valueOf(et2), String.valueOf(ov), String.valueOf(te), String.valueOf((float)ov / (float)te)});
                addedList2.add(aa2);
                continue;
            }
            long lov = 0L;
            int indexLov = 0;
            for (int j = 0; j < overlapList.size(); ++j) {
                aa2 = (AlignableAnnotation)overlapList.get(j);
                long ov = this.calcOverlap(bt1, et1, ((AbstractAnnotation)aa2).getBeginTimeBoundary(), ((AbstractAnnotation)aa2).getEndTimeBoundary());
                if (ov <= lov) continue;
                lov = ov;
                indexLov = j;
            }
            aa2 = (AlignableAnnotation)overlapList.get(indexLov);
            bt2 = ((AbstractAnnotation)aa2).getBeginTimeBoundary();
            et2 = ((AbstractAnnotation)aa2).getEndTimeBoundary();
            long te = this.calcExtent(bt1, et1, bt2, et2);
            model.addRow(new String[]{aa1.getValue(), String.valueOf(bt1), String.valueOf(et1), aa2.getValue(), String.valueOf(bt2), String.valueOf(et2), String.valueOf(lov), String.valueOf(te), String.valueOf((float)lov / (float)te)});
            addedList2.add(aa2);
        }
        for (int j = 0; j < numAnn2; ++j) {
            aa2 = (AlignableAnnotation)annList2.get(j);
            if (addedList2.contains(aa2)) continue;
            bt2 = ((AbstractAnnotation)aa2).getBeginTimeBoundary();
            et2 = ((AbstractAnnotation)aa2).getEndTimeBoundary();
            int index = 0;
            for (i = lastInserted1; i < model.getRowCount(); ++i) {
                String val = (String)model.getValueAt(i, 4);
                try {
                    bt1 = Long.parseLong(val);
                    if (bt1 <= bt2) continue;
                    index = i;
                    lastInserted1 = i;
                    break;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            model.insertRow(index, new String[]{"-", "-", "-", aa2.getValue(), String.valueOf(bt2), String.valueOf(et2), "0", "0", "0.00"});
        }
        model.setColumnIdentifiers(new String[]{tier1, ElanLocale.getString("Frame.GridFrame.ColumnBeginTime"), ElanLocale.getString("Frame.GridFrame.ColumnEndTime"), tier2, ElanLocale.getString("Frame.GridFrame.ColumnBeginTime"), ElanLocale.getString("Frame.GridFrame.ColumnEndTime"), ElanLocale.getString("CompareAnnotatorsDialog.Label.Overlap"), ElanLocale.getString("CompareAnnotatorsDialog.Label.Extent"), ElanLocale.getString("CompareAnnotatorsDialog.Label.Quotient")});
        return model;
    }

    private boolean overlaps(long bt1, long et1, long bt2, long et2) {
        return bt1 < et2 && et1 > bt2;
    }

    private long calcOverlap(long bt1, long et1, long bt2, long et2) {
        return Math.min(et1, et2) - Math.max(bt1, bt2);
    }

    private long calcExtent(long bt1, long et1, long bt2, long et2) {
        return Math.max(et1, et2) - Math.min(bt1, bt2);
    }
}

