/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.RadioButtonCellEditor;
import mpi.eudico.client.util.RadioButtonTableCellRenderer;
import mpi.eudico.client.util.SelectEnableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CreateAnnsOnDependentTiersStep2
extends StepPane
implements MouseListener {
    private TranscriptionImpl transcription;
    private Command com;
    private JTable tierTable;
    private DefaultTableModel model;
    private JCheckBox overWriteCB;
    private List selectedParentTiers;
    private List emptyAnnTierList = new ArrayList();
    private List annWithValTierList = new ArrayList();
    private final String TIER_NAME_COLUMN = "Tiers";
    private final String EMPTY_ANNOTATION_COLUMN = "Empty Annotations";
    private final String ANNOTATION_WITH_VAL_COLUMN = "Annotation With Value of Parent";

    public CreateAnnsOnDependentTiersStep2(MultiStepPane multiPane, TranscriptionImpl trans) {
        super(multiPane);
        this.transcription = trans;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.model = new TierExportTableModel();
        this.model.setColumnCount(4);
        this.model.setColumnIdentifiers(new String[]{"", "Tiers", "Empty Annotations", "Annotation With Value of Parent"});
        this.tierTable = new JTable(this.model);
        DefaultCellEditor cellEd = new DefaultCellEditor(new JCheckBox());
        this.tierTable.getColumnModel().getColumn(0).setCellEditor(cellEd);
        this.tierTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.tierTable.getColumn("Empty Annotations").setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.tierTable.getColumn("Empty Annotations").setCellRenderer(new RadioButtonTableCellRenderer());
        this.tierTable.getColumn("Empty Annotations").setWidth(75);
        this.tierTable.getColumn("Annotation With Value of Parent").setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.tierTable.getColumn("Annotation With Value of Parent").setCellRenderer(new RadioButtonTableCellRenderer());
        this.tierTable.getColumn("Annotation With Value of Parent").setWidth(150);
        this.tierTable.addMouseListener(this);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension tableDim = new Dimension(450, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)tierScrollPane, gridBagConstraints);
        this.overWriteCB = new JCheckBox(ElanLocale.getString("CreateAnnsOnDependentTiersDlg.Label.Overwrite"));
        this.overWriteCB.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.add((Component)this.overWriteCB, gridBagConstraints);
    }

    private void extractTiers() {
        this.model.setRowCount(0);
        if (this.transcription != null) {
            for (int i = 0; i < this.selectedParentTiers.size(); ++i) {
                TierImpl t = (TierImpl)this.transcription.getTierWithId((String)this.selectedParentTiers.get(i));
                Vector v = t.getDependentTiers();
                for (int x = 0; x < v.size(); ++x) {
                    t = (TierImpl)v.get(x);
                    SelectEnableObject emptySEO = new SelectEnableObject("", true, false);
                    SelectEnableObject withValSEO = new SelectEnableObject("", false, false);
                    if (i == 0 && x == 0) {
                        emptySEO.setEnabled(true);
                        withValSEO.setEnabled(true);
                        this.model.addRow(new Object[]{Boolean.TRUE, t.getName(), emptySEO, withValSEO});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, t.getName(), emptySEO, withValSEO});
                }
            }
        }
    }

    private void updateSelectedTierList() {
        Object selObj = null;
        Object nameObj = null;
        this.emptyAnnTierList.clear();
        this.annWithValTierList.clear();
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            selObj = this.tierTable.getValueAt(i, 0);
            if (selObj != Boolean.TRUE) continue;
            SelectEnableObject emptyAnnSEO = (SelectEnableObject)this.tierTable.getValueAt(i, 2);
            nameObj = this.tierTable.getValueAt(i, 1);
            if (nameObj == null) continue;
            if (emptyAnnSEO.isSelected()) {
                this.emptyAnnTierList.add(nameObj);
                continue;
            }
            this.annWithValTierList.add(nameObj);
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CreateAnnsOnDependentTiersDlg.Title");
    }

    @Override
    public void enterStepForward() {
        this.selectedParentTiers = (List)this.multiPane.getStepProperty("SelectedParentTiers");
        this.extractTiers();
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(3, true);
        this.multiPane.setButtonEnabled(4, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public void enterStepBackward() {
    }

    @Override
    public boolean leaveStepForward() {
        return true;
    }

    @Override
    public boolean leaveStepBackward() {
        this.multiPane.setButtonEnabled(3, false);
        this.overWriteCB.setEnabled(false);
        return true;
    }

    @Override
    public boolean doFinish() {
        this.updateSelectedTierList();
        Object[] args = new Object[]{this.emptyAnnTierList, this.annWithValTierList, this.overWriteCB.isSelected()};
        Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsOnDependentTiers");
        command.execute(this.transcription, args);
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.updateSelectedTierList();
        if (this.emptyAnnTierList.size() > 0 || this.annWithValTierList.size() > 0) {
            this.multiPane.setButtonEnabled(3, true);
        } else {
            this.multiPane.setButtonEnabled(3, false);
        }
        if (this.annWithValTierList.size() > 0) {
            this.overWriteCB.setEnabled(true);
        } else {
            this.overWriteCB.setEnabled(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int selectedRowIndex = this.tierTable.getSelectedRow();
        int selectedColumnIndex = this.tierTable.getSelectedColumn();
        if (selectedColumnIndex == 0) {
            if (((Boolean)this.model.getValueAt(selectedRowIndex, 0)).booleanValue()) {
                ((SelectEnableObject)this.model.getValueAt(selectedRowIndex, 2)).setEnabled(true);
                ((SelectEnableObject)this.model.getValueAt(selectedRowIndex, 3)).setEnabled(true);
            } else {
                ((SelectEnableObject)this.model.getValueAt(selectedRowIndex, 2)).setEnabled(false);
                ((SelectEnableObject)this.model.getValueAt(selectedRowIndex, 3)).setEnabled(false);
            }
        }
        if (this.tierTable.getValueAt(selectedRowIndex, selectedColumnIndex) instanceof SelectEnableObject) {
            SelectEnableObject seo1 = (SelectEnableObject)this.tierTable.getValueAt(selectedRowIndex, selectedColumnIndex);
            if (seo1.isSelected()) {
                SelectEnableObject seo2 = null;
                if (selectedColumnIndex == 2) {
                    seo2 = (SelectEnableObject)this.tierTable.getValueAt(selectedRowIndex, 3);
                } else if (selectedColumnIndex == 3) {
                    seo2 = (SelectEnableObject)this.tierTable.getValueAt(selectedRowIndex, 2);
                }
                if (seo2 != null && seo2.isEnabled()) {
                    seo2.setSelected(false);
                }
            } else {
                seo1.setSelected(true);
            }
        }
        this.tierTable.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

