/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ExportOverlapsMultiCommand;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.util.FileExtension;

public class ExportOverlapsStep2
extends ProgressStepPane {
    protected String encoding = "UTF-8";

    public ExportOverlapsStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void enterStepForward() {
        this.doFinish();
    }

    @Override
    public boolean doFinish() {
        this.completed = false;
        this.multiPane.setButtonEnabled(8, false);
        File f = this.promptForFile(ElanLocale.getString("ExportTabDialog.Title"), null, FileExtension.TEXT_EXT, true, null);
        if (f != null) {
            String refTier = (String)this.multiPane.getStepProperty("Tier-1");
            List selTiers2 = (List)this.multiPane.getStepProperty("Tiers-2");
            ArrayList files = (ArrayList)this.multiPane.getStepProperty("files");
            ArrayList<String> filePaths = new ArrayList<String>(files.size());
            for (File ff : files) {
                filePaths.add(ff.getAbsolutePath());
            }
            ExportOverlapsMultiCommand expCom = new ExportOverlapsMultiCommand("ExportOverlapMulti");
            expCom.addProgressListener(this);
            expCom.execute(null, new Object[]{filePaths, refTier, selTiers2, f.getAbsolutePath(), this.encoding});
        } else {
            this.multiPane.setButtonEnabled(4, true);
            this.multiPane.previousStep();
        }
        return false;
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportOverlapsDialog.Exporting");
    }

    protected File promptForFile(String chooserTitle, List<String[]> extensions, String[] mainExt, boolean showEncodingBox, String[] encodings) {
        FileChooser chooser = new FileChooser(null);
        if (showEncodingBox) {
            chooser.createAndShowFileAndEncodingDialog(chooserTitle, 1, extensions, mainExt, "LastUsedExportDir", encodings, null, null);
            this.encoding = chooser.getSelectedEncoding();
        } else {
            chooser.createAndShowFileDialog(chooserTitle, 1, extensions, mainExt, "LastUsedExportDir", null);
        }
        return chooser.getSelectedFile();
    }
}

