/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.svg.SVGAnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TierCopier
implements ClientLogger {
    public static final int SAME = 0;
    public static final int ANY_TO_ROOT = 1;
    public static final int ROOT_TO_TIMESUB = 2;
    public static final int ROOT_TO_SYMSUB = 3;
    public static final int ROOT_TO_ASSOC = 4;
    public static final int TIMESUB_TO_SYMSUB = 5;
    public static final int TIMESUB_TO_ASSOC = 6;
    public static final int SYMSUB_TO_TIMESUB = 7;
    public static final int SYMSUB_TO_ASSOC = 8;
    public static final int ASSOC_TO_TIMESUB = 9;
    public static final int ASSOC_TO_SYMSUB = 10;
    public static final int ROOT_TO_INCLUDED_IN = 11;
    public static final int TIMESUB_TO_INCLUDED_IN = 12;
    public static final int SYMSUB_TO_INCLUDED_IN = 13;
    public static final int ASSOC_TO_INCLUDED_IN = 14;
    public static final int INCLUDED_IN_TO_TIMESUB = 15;
    public static final int INCLUDED_IN_TO_SYMSUB = 16;
    public static final int INCLUDED_IN_TO_ASSOC = 17;
    private boolean keepSiblingsTogether = false;
    private boolean appendSubdivisionSiblings = true;

    public AbstractAnnotation createAnnotationFromTree(Transcription trans, DefaultMutableTreeNode root, HashMap tierMapping) {
        long end;
        long begin;
        DefaultMutableTreeNode node;
        if (trans == null || root == null || tierMapping == null) {
            return null;
        }
        AbstractAnnotation annotation = null;
        AnnotationDataRecord annData = null;
        String tierName = null;
        TierImpl tier = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        int linStereoType = -1;
        long[] timeBounds = new long[]{0L, 0L};
        annData = (AnnotationDataRecord)root.getUserObject();
        tierName = (String)tierMapping.get(annData.getTierName());
        tier = (TierImpl)trans.getTierWithId(tierName);
        if (tier == null) {
            LOG.warning("Cannot recreate annotations: tier copy does not exist: " + tierName);
            return null;
        }
        if (tier.hasParentTier()) {
            Vector overlap = ((TierImpl)tier.getParentTier()).getOverlappingAnnotations(annData.getBeginTime(), annData.getEndTime());
            if (overlap.size() > 0) {
                long overl = 0L;
                int index = 0;
                for (int i = 0; i < overlap.size(); ++i) {
                    an = (Annotation)overlap.get(i);
                    long ol = 0L;
                    ol = an.getBeginTimeBoundary() > annData.getBeginTime() ? (an.getEndTimeBoundary() > annData.getEndTime() ? annData.getEndTime() - an.getBeginTimeBoundary() : an.getEndTimeBoundary() - an.getBeginTimeBoundary()) : (an.getEndTimeBoundary() > annData.getEndTime() ? annData.getEndTime() - annData.getBeginTime() : an.getEndTimeBoundary() - annData.getBeginTime());
                    if (ol <= overl) continue;
                    overl = ol;
                    index = i;
                }
                an = (Annotation)overlap.get(index);
                timeBounds[0] = an.getBeginTimeBoundary();
                timeBounds[1] = an.getEndTimeBoundary();
                if (timeBounds[0] == 0L && timeBounds[1] == 0L) {
                    return null;
                }
            } else {
                return null;
            }
        }
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            aa = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (!tier.isTimeAlignable() || !annData.isBeginTimeAligned()) continue;
            begin = annData.getBeginTime();
            end = annData.getEndTime();
            if (begin < timeBounds[0]) {
                begin = timeBounds[0];
            }
            if (end > timeBounds[1]) {
                end = timeBounds[1];
            }
            if (!annData.isEndTimeAligned() && end == begin) {
                ++end;
            }
            aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
            if (node == root) {
                annotation = aa;
            }
            if (aa != null) {
                aa.setValue(annData.getValue());
                if (annData.getExtRef() != null) {
                    aa.setExtRef(annData.getExtRef());
                }
                if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                if (svgRec.getShape() != null) {
                    ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                }
                if (svgRec.getSvgElementId() == null) continue;
                ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                continue;
            }
            LOG.warning("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime() + " et: " + annData.getEndTime());
        }
        en = root.breadthFirstEnumeration();
        Annotation prevAnn = null;
        while (en.hasMoreElements()) {
            aa = null;
            an = null;
            ra = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                if (!annData.isBeginTimeAligned()) {
                    if (!(prevAnn == null || prevAnn.getTier().getName().equals((String)tierMapping.get(annData.getTierName())) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        begin = annData.getBeginTime();
                        end = annData.getEndTime();
                        if (begin < timeBounds[0]) {
                            begin = timeBounds[0];
                        }
                        if (end > timeBounds[1]) {
                            end = timeBounds[1];
                        }
                        if ((an = tier.getAnnotationAtTime(begin)) != null) {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                            prevAnn = aa;
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
                            prevAnn = aa;
                        }
                    } else {
                        aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = aa;
                    }
                    if (node == root) {
                        annotation = aa;
                    }
                    if (aa != null) {
                        aa.setValue(annData.getValue());
                        if (annData.getExtRef() != null) {
                            aa.setExtRef(annData.getExtRef());
                        }
                        if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                        SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                        if (svgRec.getShape() != null) {
                            ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                        }
                        if (svgRec.getSvgElementId() == null) continue;
                        ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                        continue;
                    }
                    LOG.warning("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                    continue;
                }
                prevAnn = null;
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (begin < timeBounds[0] && annData.getEndTime() > timeBounds[0]) {
                    begin = timeBounds[0];
                }
                if (prevAnn != null && !prevAnn.getTier().getName().equals((String)tierMapping.get(annData.getTierName()))) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    an = tier.getAnnotationAtTime(begin);
                    ra = an != null ? (an.getBeginTimeBoundary() == begin ? (RefAnnotation)tier.createAnnotationBefore(an) : (RefAnnotation)tier.createAnnotationAfter(an)) : (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (node == root) {
                    annotation = ra;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() == null) continue;
                    ra.setExtRef(annData.getExtRef());
                    continue;
                }
                LOG.warning("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                System.out.println("Begin: " + begin);
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            if (begin < timeBounds[0] && annData.getEndTime() > timeBounds[0]) {
                begin = timeBounds[0];
            }
            if ((an = tier.getAnnotationAtTime(begin)) == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            if (node == root) {
                annotation = ra;
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() == null) continue;
                ra.setExtRef(annData.getExtRef());
                continue;
            }
            LOG.warning("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
        return annotation;
    }

    public AbstractAnnotation createRootAnnotationFromTree(Transcription trans, DefaultMutableTreeNode root, HashMap tierMapping) {
        long end;
        long begin;
        DefaultMutableTreeNode node;
        if (trans == null || root == null || tierMapping == null) {
            return null;
        }
        AbstractAnnotation annotation = null;
        AnnotationDataRecord annData = null;
        String tierName = null;
        TierImpl tier = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        int linStereoType = -1;
        annData = (AnnotationDataRecord)root.getUserObject();
        tierName = (String)tierMapping.get(annData.getTierName());
        tier = (TierImpl)trans.getTierWithId(tierName);
        if (tier == null) {
            LOG.warning("Cannot recreate annotations: tier copy does not exist: " + tierName);
        }
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            aa = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (!tier.isTimeAlignable() || !annData.isBeginTimeAligned()) continue;
            begin = annData.getBeginTime();
            end = annData.getEndTime();
            if (!annData.isEndTimeAligned() && end == begin) {
                ++end;
            }
            aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
            if (node == root) {
                annotation = aa;
            }
            if (aa != null) {
                aa.setValue(annData.getValue());
                if (annData.getExtRef() != null) {
                    aa.setExtRef(annData.getExtRef());
                }
                if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                if (svgRec.getShape() != null) {
                    ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                }
                if (svgRec.getSvgElementId() == null) continue;
                ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                continue;
            }
            LOG.warning("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime() + " et: " + annData.getEndTime());
        }
        en = root.breadthFirstEnumeration();
        Annotation prevAnn = null;
        while (en.hasMoreElements()) {
            aa = null;
            an = null;
            ra = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                if (!annData.isBeginTimeAligned()) {
                    if (!(prevAnn == null || prevAnn.getTier().getName().equals((String)tierMapping.get(annData.getTierName())) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        begin = annData.getBeginTime();
                        end = annData.getEndTime();
                        an = tier.getAnnotationAtTime(begin);
                        if (an != null) {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                            prevAnn = aa;
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
                            prevAnn = aa;
                        }
                    } else {
                        aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = aa;
                    }
                    if (node == root) {
                        annotation = aa;
                    }
                    if (aa != null) {
                        aa.setValue(annData.getValue());
                        if (annData.getExtRef() != null) {
                            aa.setExtRef(annData.getExtRef());
                        }
                        if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                        SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                        if (svgRec.getShape() != null) {
                            ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                        }
                        if (svgRec.getSvgElementId() == null) continue;
                        ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                        continue;
                    }
                    LOG.warning("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                    continue;
                }
                prevAnn = null;
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (prevAnn != null && !prevAnn.getTier().getName().equals((String)tierMapping.get(annData.getTierName()))) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    an = tier.getAnnotationAtTime(begin);
                    ra = an != null ? (an.getBeginTimeBoundary() == begin ? (RefAnnotation)tier.createAnnotationBefore(an) : (RefAnnotation)tier.createAnnotationAfter(an)) : (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (node == root) {
                    annotation = ra;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() == null) continue;
                    ra.setExtRef(annData.getExtRef());
                    continue;
                }
                LOG.warning("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            an = tier.getAnnotationAtTime(begin);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            if (node == root) {
                annotation = ra;
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() == null) continue;
                ra.setExtRef(annData.getExtRef());
                continue;
            }
            LOG.warning("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
        return annotation;
    }

    public void createAnnotationsSequentially(Transcription trans, ArrayList group, HashMap tierMapping) {
        if (trans == null || group == null || group.size() == 0 || tierMapping == null) {
            return;
        }
        AnnotationDataRecord annData = null;
        String tierName = null;
        TierImpl tier = null;
        LinguisticType linType = null;
        int linStereoType = -1;
        Annotation an = null;
        long[] timeBounds = new long[]{0L, 0L};
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)group.get(0);
        annData = (AnnotationDataRecord)node.getUserObject();
        tierName = (String)tierMapping.get(annData.getTierName());
        tier = (TierImpl)trans.getTierWithId(tierName);
        if (tier == null || tier.getParentTier() == null) {
            LOG.warning("Cannot recreate annotations: tier copy or it's parent does not exist: " + tierName);
            return;
        }
        linType = tier.getLinguisticType();
        if (linType.getConstraints() != null) {
            linStereoType = linType.getConstraints().getStereoType();
        }
        AnnotationDataRecord annData2 = (AnnotationDataRecord)((DefaultMutableTreeNode)group.get(group.size() - 1)).getUserObject();
        Vector overlap = tier.getRootTier().getOverlappingAnnotations(annData.getBeginTime(), annData2.getEndTime());
        if (overlap.size() > 0) {
            for (int i = 0; i < overlap.size(); ++i) {
                an = (Annotation)overlap.get(i);
                if (tier.getOverlappingAnnotations(an.getBeginTimeBoundary(), an.getEndTimeBoundary()).size() != 0) continue;
                timeBounds[0] = an.getBeginTimeBoundary();
                timeBounds[1] = an.getEndTimeBoundary();
                break;
            }
            if (timeBounds[0] == 0L && timeBounds[1] == 0L) {
                return;
            }
        } else {
            return;
        }
        if (linStereoType == 0 || linStereoType == 1) {
            DefaultMutableTreeNode pNode = new DefaultMutableTreeNode("p");
            for (int i = 0; i < group.size(); ++i) {
                node = (DefaultMutableTreeNode)group.get(i);
                annData = (AnnotationDataRecord)node.getUserObject();
                if (annData.getBeginTime() > timeBounds[1] || annData.getEndTime() < timeBounds[0]) continue;
                if (!annData.isBeginTimeAligned() || !annData.isEndTimeAligned()) {
                    annData.setBeginTimeAligned(true);
                    annData.setEndTimeAligned(true);
                }
                pNode.add(node);
            }
            this.createTimeSubAnnotationsSkipRoot(trans, pNode, tierMapping);
        } else if (linStereoType == 3) {
            DefaultMutableTreeNode pNode = new DefaultMutableTreeNode("p");
            for (int i = 0; i < group.size(); ++i) {
                node = (DefaultMutableTreeNode)group.get(i);
                pNode.add(node);
            }
            if (this.keepSiblingsTogether) {
                this.adjustTimes(pNode, timeBounds[0], timeBounds[1]);
            }
            this.createSymSubAnnotationsSkipRoot(trans, pNode, tierMapping);
        } else if (linStereoType == 4) {
            DefaultMutableTreeNode pNode = new DefaultMutableTreeNode("p");
            for (int i = 0; i < group.size(); ++i) {
                node = (DefaultMutableTreeNode)group.get(i);
                pNode.add(node);
            }
            if (this.keepSiblingsTogether) {
                this.adjustTimes(pNode, timeBounds[0], timeBounds[1]);
            }
            this.createSymAssAnnotationsSkipRoot(trans, pNode, tierMapping);
        }
    }

    private void createTimeSubAnnotationsSkipRoot(Transcription trans, DefaultMutableTreeNode pNode, HashMap tierMapping) {
        long end;
        long begin;
        DefaultMutableTreeNode node;
        AnnotationDataRecord annData = null;
        String tierName = null;
        TierImpl tier = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        Annotation prevAnn = null;
        int linStereoType = -1;
        long[] timeBounds = new long[]{0L, 0L};
        Enumeration<TreeNode> en = pNode.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            if (!annData.isBeginTimeAligned()) continue;
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier copy does not exist: " + tierName);
                return;
            }
            begin = annData.getBeginTime();
            end = annData.getEndTime();
            Vector overlap = ((TierImpl)tier.getParentTier()).getOverlappingAnnotations(begin, end);
            if (overlap.size() > 0) {
                an = (Annotation)overlap.get(0);
                timeBounds[0] = an.getBeginTimeBoundary();
                timeBounds[1] = an.getEndTimeBoundary();
            }
            if (timeBounds[0] == 0L && timeBounds[1] == 0L) continue;
            if (begin < timeBounds[0]) {
                begin = timeBounds[0];
            }
            if (end > timeBounds[1]) {
                end = timeBounds[1];
            }
            if ((aa = (AlignableAnnotation)tier.createAnnotation(begin, end)) != null) {
                aa.setValue(annData.getValue());
                if (annData.getExtRef() != null) {
                    aa.setExtRef(annData.getExtRef());
                }
                if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                if (svgRec.getShape() != null) {
                    ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                }
                if (svgRec.getSvgElementId() == null) continue;
                ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                continue;
            }
            LOG.warning("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime() + " et: " + annData.getEndTime());
        }
        en = pNode.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            long mid;
            aa = null;
            an = null;
            ra = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            if (annData.isBeginTimeAligned()) continue;
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                if (!annData.isBeginTimeAligned()) {
                    if (!(prevAnn == null || prevAnn.getTier().getName().equals(tierName) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        begin = annData.getBeginTime();
                        an = tier.getAnnotationAtTime(begin);
                        if (an != null) {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                            prevAnn = aa;
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotation(begin, annData.getEndTime());
                            prevAnn = aa;
                        }
                    } else {
                        aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = aa;
                    }
                    if (aa != null) {
                        aa.setValue(annData.getValue());
                        if (annData.getExtRef() != null) {
                            aa.setExtRef(annData.getExtRef());
                        }
                        if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                        SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                        if (svgRec.getShape() != null) {
                            ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                        }
                        if (svgRec.getSvgElementId() == null) continue;
                        ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                        continue;
                    }
                    LOG.info("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                    continue;
                }
                prevAnn = null;
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (begin < timeBounds[0]) {
                    begin = timeBounds[0];
                }
                if (prevAnn != null && !prevAnn.getTier().getName().equals(tierName)) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() == null) continue;
                    ra.setExtRef(annData.getExtRef());
                    continue;
                }
                LOG.info("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            end = annData.getEndTime();
            if (begin < timeBounds[0]) {
                begin = timeBounds[0];
            }
            if (end > timeBounds[1]) {
                end = timeBounds[1];
            }
            if ((an = tier.getAnnotationAtTime(mid = (begin + end) / 2L)) == null) {
                ra = (RefAnnotation)tier.createAnnotation(mid, mid);
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() == null) continue;
                ra.setExtRef(annData.getExtRef());
                continue;
            }
            LOG.info("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
    }

    private void createSymSubAnnotationsSkipRoot(Transcription trans, DefaultMutableTreeNode pNode, HashMap tierMapping) {
        AnnotationDataRecord annData = null;
        String tierName = null;
        TierImpl tier = null;
        RefAnnotation ra = null;
        Annotation an = null;
        Annotation prevAnn = null;
        int linStereoType = -1;
        Enumeration<TreeNode> en = pNode.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            long begin;
            an = null;
            ra = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                LOG.warning("Tier should not be time alignable");
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (prevAnn != null && !prevAnn.getTier().getName().equals(tierName)) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() == null) continue;
                    ra.setExtRef(annData.getExtRef());
                    continue;
                }
                LOG.info("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            long mid = (begin + annData.getEndTime()) / 2L;
            an = tier.getAnnotationAtTime(mid);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(mid, mid);
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() == null) continue;
                ra.setExtRef(annData.getExtRef());
                continue;
            }
            LOG.info("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
    }

    private void createSymAssAnnotationsSkipRoot(Transcription trans, DefaultMutableTreeNode pNode, HashMap tierMapping) {
        AnnotationDataRecord annData = null;
        String tierName = null;
        TierImpl tier = null;
        RefAnnotation ra = null;
        Annotation an = null;
        Annotation prevAnn = null;
        int linStereoType = -1;
        Enumeration<TreeNode> en = pNode.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            long begin;
            an = null;
            ra = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tierName = (String)tierMapping.get(annData.getTierName());
            tier = (TierImpl)trans.getTierWithId(tierName);
            if (tier == null) {
                LOG.warning("Cannot recreate annotations: tier does not exist: " + tierName);
                continue;
            }
            if (tier.isTimeAlignable()) {
                LOG.warning("Tier should not be time alignable");
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 4) {
                begin = annData.getBeginTime();
                long mid = (begin + annData.getEndTime()) / 2L;
                an = tier.getAnnotationAtTime(mid);
                if (an == null) {
                    ra = (RefAnnotation)tier.createAnnotation(mid, mid);
                } else if (this.appendSubdivisionSiblings) {
                    an.setValue(an.getValue() + " " + annData.getValue());
                    continue;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() == null) continue;
                    ra.setExtRef(annData.getExtRef());
                    continue;
                }
                LOG.info("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            if (linStereoType != 3) continue;
            begin = annData.getBeginTime();
            if (prevAnn != null && !prevAnn.getTier().getName().equals(tierName)) {
                prevAnn = null;
            }
            if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                prevAnn = null;
            }
            if (prevAnn == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                prevAnn = ra;
            } else {
                ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                prevAnn = ra;
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() == null) continue;
                ra.setExtRef(annData.getExtRef());
                continue;
            }
            LOG.info("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
    }

    private void adjustTimes(DefaultMutableTreeNode node, long bt, long et) {
        if (node == null) {
            return;
        }
        int numChildren = node.getChildCount();
        if (numChildren == 0) {
            return;
        }
        int perAnn = (int)(et - bt) / numChildren;
        DefaultMutableTreeNode n = null;
        AnnotationDataRecord annData = null;
        for (int i = 0; i < numChildren; ++i) {
            n = (DefaultMutableTreeNode)node.getChildAt(i);
            annData = (AnnotationDataRecord)n.getUserObject();
            annData.setBeginTime(bt + (long)(i * perAnn));
            annData.setEndTime(bt + (long)((i + 1) * perAnn));
            this.adjustTimes(n, annData.getBeginTime(), annData.getEndTime());
        }
    }
}

