/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.csv;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.ContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.NonContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.config.SamplePosition;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.csv.CSVConfigPanel;
import mpi.eudico.client.annotator.timeseries.csv.CSVReader;
import mpi.eudico.client.annotator.timeseries.spi.TSConfigPanel;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.util.ClientLogger;

public class CSVServiceProvider
implements ClientLogger,
TSServiceProvider {
    private final String[] suffices = new String[]{"txt", "csv"};
    private HashMap sourceToReaderMap = new HashMap();

    @Override
    public boolean canHandle(String filePath) {
        LOG.info("Polling: " + filePath);
        if (filePath == null || filePath.length() < 5) {
            return false;
        }
        if (this.sourceToReaderMap.get(filePath) != null) {
            return true;
        }
        String lowerPath = filePath.toLowerCase();
        for (int i = 0; i < this.suffices.length; ++i) {
            if (!lowerPath.endsWith(this.suffices[i])) continue;
            try {
                CSVReader reader = new CSVReader(filePath);
                if (!reader.isValidFile()) continue;
                this.sourceToReaderMap.put(filePath, reader);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public TSConfigPanel getConfigPanel(TSSourceConfiguration config) {
        CSVConfigPanel configPanel = new CSVConfigPanel();
        configPanel.setSourceConfiguration(config);
        if (this.sourceToReaderMap.get(config.getSource()) != null) {
            configPanel.setReader((CSVReader)this.sourceToReaderMap.get(config.getSource()));
        } else {
            CSVReader reader = new CSVReader(config.getSource());
            this.sourceToReaderMap.put(config.getSource(), reader);
            configPanel.setReader(reader);
        }
        return configPanel;
    }

    @Override
    public void autoCreateTracks(TSSourceConfiguration config) {
    }

    @Override
    public void createTracksFromConfiguration(TSSourceConfiguration config) {
        int timeColumn;
        if (config == null) {
            LOG.warning("The configuration object is null.");
            return;
        }
        CSVReader reader = null;
        if (this.sourceToReaderMap.containsKey(config.getSource())) {
            reader = (CSVReader)this.sourceToReaderMap.get(config.getSource());
        } else {
            reader = new CSVReader(config.getSource());
            this.sourceToReaderMap.put(config.getSource(), reader);
        }
        boolean continRate = false;
        if (config.getSampleType() != null) {
            continRate = "Continuous Rate".equals(config.getSampleType());
        }
        if ((timeColumn = config.getTimeColumn()) < 0) {
            LOG.warning("Could not restore tracks: the time column has not been specified.");
            return;
        }
        Iterator trIt = config.objectKeySet().iterator();
        int offset = config.getTimeOrigin();
        while (trIt.hasNext()) {
            Object key = trIt.next();
            Object val = config.getObject(key);
            if (!(val instanceof TSTrackConfiguration)) continue;
            TSTrackConfiguration trconf = (TSTrackConfiguration)val;
            SamplePosition spos = trconf.getSamplePos();
            int dataCol = spos.getColumns()[0];
            int derLevel = this.parseInt(trconf.getProperty("derivative"));
            AbstractTSTrack track = null;
            try {
                if (continRate) {
                    track = new ContinuousRateTSTrack();
                    track.setData(reader.readTrack(timeColumn, dataCol, derLevel, continRate));
                    track.setSampleRate(reader.getSampleFrequency());
                    track.setType(1);
                } else {
                    track = new NonContinuousRateTSTrack();
                    track.setData(reader.readTrack(timeColumn, dataCol, derLevel, continRate));
                    track.setType(11);
                }
            }
            catch (IOException ioe) {
                LOG.severe("Could not read track: " + trconf.getTrackName() + " from: " + config.getSource());
                continue;
            }
            track.setName(trconf.getTrackName());
            track.setDerivativeLevel(derLevel);
            track.setTimeOffset(offset);
            track.setDescription(trconf.getProperty("description"));
            track.setUnitString(trconf.getProperty("units"));
            float min = 0.0f;
            float max = 100.0f;
            try {
                min = Float.parseFloat(trconf.getProperty("min"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                max = Float.parseFloat(trconf.getProperty("max"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            track.setRange(new float[]{min, max});
            Color c = this.parseColor(trconf.getProperty("color"));
            track.setColor(c);
            trconf.putObject(track.getName(), track);
            trconf.removeProperty("derivative");
            trconf.removeProperty("description");
            trconf.removeProperty("units");
            trconf.removeProperty("min");
            trconf.removeProperty("max");
            trconf.removeProperty("color");
        }
    }

    private Color parseColor(String rgb) {
        if (rgb == null) {
            return Color.GREEN;
        }
        int index = rgb.indexOf(44);
        int index2 = rgb.lastIndexOf(44);
        if (index > -1 && index2 > -1) {
            int r = this.parseInt(rgb.substring(0, index));
            int g = this.parseInt(rgb.substring(index + 1, index2));
            int b = this.parseInt(rgb.substring(index2 + 1));
            return new Color(r, g, b);
        }
        return Color.GREEN;
    }

    private int parseInt(String sint) {
        try {
            return Integer.parseInt(sint);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

