/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.praat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import mpi.eudico.client.annotator.timeseries.TimeValue;
import mpi.eudico.client.annotator.timeseries.TimeValueStart;

public class PitchTierFileReader {
    private boolean validFile;
    private String filePath;
    private File sourceFile;
    private FileReader fileRead;
    private BufferedReader bufRead;
    private float msPerSample = 0.0f;
    private int sampleFrequency = 0;
    private boolean shortNotation = false;
    private int size;
    private double minT;
    private double maxT;
    private float minVal = Float.MAX_VALUE;
    private float maxVal = Float.MIN_VALUE;
    private final String TIME = "time";
    private final String VAL = "value";
    private final char EQ = (char)61;
    private boolean isPitch = true;
    private boolean isIntensity = false;

    public PitchTierFileReader(String fileName) {
        this.filePath = fileName;
        if (this.filePath.startsWith("file:")) {
            this.filePath = this.filePath.substring(5);
        }
        this.sourceFile = new File(this.filePath);
        this.isValidPTFile();
    }

    public String getTrackName() {
        if (this.isIntensity) {
            return "IntensityTier";
        }
        return "PitchTier";
    }

    private void isValidPTFile() {
        if (this.sourceFile == null) {
            this.validFile = false;
            return;
        }
        try {
            this.fileRead = new FileReader(this.sourceFile);
            this.bufRead = new BufferedReader(this.fileRead);
            boolean textFile = false;
            boolean pitchFile = false;
            int rowIndex = 0;
            String li = null;
            long firstTimeStamp = -1L;
            double d = 0.0;
            ArrayList<Long> times = new ArrayList<Long>(11);
            while ((li = this.bufRead.readLine()) != null && rowIndex < 36) {
                block35: {
                    if (li.length() == 0) {
                        ++rowIndex;
                        continue;
                    }
                    if (li.contains("ooTextFile")) {
                        textFile = true;
                    } else if (li.contains("PitchTier")) {
                        pitchFile = true;
                        this.validFile = true;
                        this.isPitch = true;
                        this.isIntensity = false;
                    } else if (li.contains("IntensityTier")) {
                        pitchFile = true;
                        this.validFile = true;
                        this.isPitch = false;
                        this.isIntensity = true;
                    } else if (rowIndex == 3 || li.contains("xmin")) {
                        try {
                            if (li.contains("=")) {
                                this.minT = Double.parseDouble(li.substring(li.indexOf(61) + 1).trim()) * 1000.0;
                                break block35;
                            }
                            this.minT = Double.parseDouble(li.trim()) * 1000.0;
                            this.shortNotation = true;
                        }
                        catch (NumberFormatException nfe) {
                            this.minT = 0.0;
                        }
                    } else if (rowIndex == 4 || li.contains("xmax")) {
                        try {
                            if (li.contains("=")) {
                                this.maxT = Double.parseDouble(li.substring(li.indexOf(61) + 1).trim()) * 1000.0;
                                break block35;
                            }
                            this.maxT = Double.parseDouble(li.trim()) * 1000.0;
                            this.shortNotation = true;
                        }
                        catch (NumberFormatException nfe) {
                            this.maxT = 1000.0;
                        }
                    } else if (rowIndex == 5 || li.contains("size")) {
                        try {
                            if (li.contains("=")) {
                                this.size = Integer.parseInt(li.substring(li.indexOf(61) + 1).trim());
                                break block35;
                            }
                            this.size = Integer.parseInt(li.trim());
                        }
                        catch (NumberFormatException nfe) {
                            this.maxT = 1000.0;
                        }
                    } else if (rowIndex > 5 && pitchFile) {
                        try {
                            if (li.contains("=") && rowIndex % 3 == 1) {
                                d = Double.parseDouble(li.substring(li.indexOf(61) + 1).trim());
                                times.add((long)(d * 1000.0));
                                if (firstTimeStamp < 0L) {
                                    firstTimeStamp = (long)(d * 1000.0);
                                }
                                break block35;
                            }
                            if (!this.shortNotation || rowIndex % 2 != 0) break block35;
                            d = Double.parseDouble(li.trim());
                            times.add((long)(d * 1000.0));
                            if (firstTimeStamp >= 0L) break block35;
                            firstTimeStamp = (long)(d * 1000.0);
                        }
                        catch (NumberFormatException nfe) {
                            break;
                        }
                    }
                }
                ++rowIndex;
            }
            if (times.size() > 2) {
                long bt = (Long)times.get(0);
                long et = (Long)times.get(times.size() - 1);
                long dur = et - bt;
                this.msPerSample = (float)dur / (float)(times.size() - 1);
                this.sampleFrequency = Math.round(1000.0f / this.msPerSample);
            } else {
                this.validFile = false;
            }
            try {
                this.bufRead.close();
            }
            catch (IOException ie) {}
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean isValidFile() {
        return this.validFile;
    }

    public Object readTrack() throws IOException {
        if (!this.validFile) {
            return null;
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        ArrayList<TimeValue> values = new ArrayList<TimeValue>(this.size);
        int rowIndex = 0;
        long curTimeStamp = 0L;
        long prevTimeStamp = -1L;
        float nextSample = 0.0f;
        String li = null;
        int eqIndex = -1;
        while ((li = this.bufRead.readLine()) != null) {
            if (li.length() == 0 || rowIndex < 6) {
                ++rowIndex;
                continue;
            }
            if (this.shortNotation) {
                if (rowIndex % 2 == 0) {
                    try {
                        curTimeStamp = (long)(1000.0 * Double.parseDouble(li.trim()));
                    }
                    catch (NumberFormatException nfe) {
                        curTimeStamp += (long)this.msPerSample;
                    }
                } else {
                    try {
                        nextSample = Float.parseFloat(li.trim());
                        if (nextSample > this.maxVal) {
                            this.maxVal = nextSample;
                        }
                        if (nextSample < this.minVal) {
                            this.minVal = nextSample;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        nextSample = Float.NaN;
                    }
                    if (prevTimeStamp < 0L || (double)(curTimeStamp - prevTimeStamp) > 1.2 * (double)this.msPerSample) {
                        values.add(new TimeValueStart(curTimeStamp, nextSample));
                    } else {
                        values.add(new TimeValue(curTimeStamp, nextSample));
                    }
                    prevTimeStamp = curTimeStamp;
                }
            } else if (li.indexOf("time") > -1) {
                eqIndex = li.indexOf(61);
                if (eqIndex > 0) {
                    try {
                        curTimeStamp = (long)(1000.0 * Double.parseDouble(li.substring(eqIndex + 1).trim()));
                    }
                    catch (NumberFormatException nfe) {
                        curTimeStamp += (long)this.msPerSample;
                    }
                }
            } else if (li.indexOf("value") > -1 && (eqIndex = li.indexOf(61)) > 0) {
                try {
                    nextSample = Float.parseFloat(li.substring(eqIndex + 1).trim());
                    if (nextSample > this.maxVal) {
                        this.maxVal = nextSample;
                    }
                    if (nextSample < this.minVal) {
                        this.minVal = nextSample;
                    }
                }
                catch (NumberFormatException nfe) {
                    nextSample = Float.NaN;
                }
                if (prevTimeStamp < 0L || (double)(curTimeStamp - prevTimeStamp) > 1.2 * (double)this.msPerSample) {
                    values.add(new TimeValueStart(curTimeStamp, nextSample));
                } else {
                    values.add(new TimeValue(curTimeStamp, nextSample));
                }
                prevTimeStamp = curTimeStamp;
            }
            ++rowIndex;
        }
        return values;
    }

    public float getMsPerSample() {
        return this.msPerSample;
    }

    public int getSampleFrequency() {
        return this.sampleFrequency;
    }

    public float getMin() {
        return this.minVal;
    }

    public float getMax() {
        return this.maxVal;
    }
}

