/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.praat;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import mpi.eudico.client.annotator.timeseries.NonContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.praat.PitchTierFileReader;
import mpi.eudico.client.annotator.timeseries.spi.TSConfigPanel;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.util.ClientLogger;

public class PitchTierServiceProvider
implements TSServiceProvider {
    private HashMap<String, PitchTierFileReader> sourceToReaderMap;
    private int trackCount = 0;
    private final Color color = new Color(0, 160, 0);

    public PitchTierServiceProvider() {
        this.sourceToReaderMap = new HashMap();
    }

    @Override
    public void autoCreateTracks(TSSourceConfiguration config) {
        if (config == null) {
            return;
        }
        PitchTierFileReader ptfr = this.sourceToReaderMap.get(config.getSource());
        if (ptfr == null) {
            ptfr = new PitchTierFileReader(config.getSource());
            this.sourceToReaderMap.put(config.getSource(), ptfr);
        }
        Iterator trIt = config.objectKeySet().iterator();
        int offset = config.getTimeOrigin();
        while (trIt.hasNext()) {
            Object key = trIt.next();
            Object val = config.getObject(key);
            if (!(val instanceof TSTrackConfiguration)) continue;
            TSTrackConfiguration trconf = (TSTrackConfiguration)val;
            NonContinuousRateTSTrack track = new NonContinuousRateTSTrack();
            String trackName = trconf.getTrackName();
            track.setName(trackName);
            track.setTimeOffset(offset);
            try {
                track.setData(ptfr.readTrack());
                track.setSampleRate(ptfr.getSampleFrequency());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Could not read track: " + trconf.getTrackName() + " from: " + config.getSource());
            }
            track.setDescription(trconf.getProperty("description"));
            track.setUnitString(trconf.getProperty("units"));
            track.setType(11);
            float min = 0.0f;
            float max = 100.0f;
            try {
                min = Float.parseFloat(trconf.getProperty("min"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                max = Float.parseFloat(trconf.getProperty("max"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            track.setRange(new float[]{min, max});
            Color c = this.parseColor(trconf.getProperty("color"));
            track.setColor(c);
            trconf.putObject(track.getName(), track);
            trconf.removeProperty("derivative");
            trconf.removeProperty("description");
            trconf.removeProperty("units");
            trconf.removeProperty("min");
            trconf.removeProperty("max");
            trconf.removeProperty("color");
            int trackNo = this.parseInt(trackName.substring(trackName.lastIndexOf("-") + 1));
            if (trackNo >= this.trackCount) {
                this.trackCount = trackNo;
                ++this.trackCount;
            }
            return;
        }
        NonContinuousRateTSTrack track = new NonContinuousRateTSTrack();
        track.setColor(this.color);
        try {
            Object data = ptfr.readTrack();
            if (data != null) {
                try {
                    track.setData(data);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
            track.setName(ptfr.getTrackName() + "-" + this.trackCount++);
            track.setSampleRate(ptfr.getSampleFrequency());
            track.setRange(new float[]{ptfr.getMin(), ptfr.getMax()});
            track.setType(11);
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Could not read data from the timeseries file " + config.getSource());
        }
        TSTrackConfiguration trconf = new TSTrackConfiguration(track.getName(), track);
        config.putObject(track.getName(), trconf);
    }

    @Override
    public boolean canHandle(String filePath) {
        ClientLogger.LOG.info("Polling: " + filePath);
        if (filePath == null || filePath.length() < 5) {
            return false;
        }
        if (this.sourceToReaderMap.get(filePath) != null) {
            return true;
        }
        String lowerPath = filePath.toLowerCase();
        if (lowerPath.endsWith("pitchtier") || lowerPath.endsWith("intensitytier")) {
            try {
                PitchTierFileReader ptfr = new PitchTierFileReader(filePath);
                if (ptfr.isValidFile()) {
                    this.sourceToReaderMap.put(filePath, ptfr);
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void createTracksFromConfiguration(TSSourceConfiguration config) {
        if (config == null) {
            return;
        }
        PitchTierFileReader reader = null;
        if (this.sourceToReaderMap.containsKey(config.getSource())) {
            reader = this.sourceToReaderMap.get(config.getSource());
        } else {
            reader = new PitchTierFileReader(config.getSource());
            this.sourceToReaderMap.put(config.getSource(), reader);
        }
        Iterator trIt = config.objectKeySet().iterator();
        int offset = config.getTimeOrigin();
        while (trIt.hasNext()) {
            Object key = trIt.next();
            Object val = config.getObject(key);
            if (!(val instanceof TSTrackConfiguration)) continue;
            TSTrackConfiguration trconf = (TSTrackConfiguration)val;
            NonContinuousRateTSTrack track = new NonContinuousRateTSTrack();
            track.setName(trconf.getTrackName());
            track.setTimeOffset(offset);
            try {
                track.setData(reader.readTrack());
                track.setSampleRate(reader.getSampleFrequency());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Could not read track: " + trconf.getTrackName() + " from: " + config.getSource());
            }
            track.setDescription(trconf.getProperty("description"));
            track.setUnitString(trconf.getProperty("units"));
            track.setType(11);
            float min = 0.0f;
            float max = 100.0f;
            try {
                min = Float.parseFloat(trconf.getProperty("min"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                max = Float.parseFloat(trconf.getProperty("max"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            track.setRange(new float[]{min, max});
            Color c = this.parseColor(trconf.getProperty("color"));
            track.setColor(c);
            trconf.putObject(track.getName(), track);
            trconf.removeProperty("derivative");
            trconf.removeProperty("description");
            trconf.removeProperty("units");
            trconf.removeProperty("min");
            trconf.removeProperty("max");
            trconf.removeProperty("color");
            break;
        }
    }

    @Override
    public TSConfigPanel getConfigPanel(TSSourceConfiguration config) {
        return null;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    private Color parseColor(String rgb) {
        if (rgb == null) {
            return Color.GREEN;
        }
        int index = rgb.indexOf(44);
        int index2 = rgb.lastIndexOf(44);
        if (index > -1 && index2 > -1) {
            int r = this.parseInt(rgb.substring(0, index));
            int g = this.parseInt(rgb.substring(index + 1, index2));
            int b = this.parseInt(rgb.substring(index2 + 1));
            return new Color(r, g, b);
        }
        return Color.GREEN;
    }

    private int parseInt(String sint) {
        try {
            return Integer.parseInt(sint);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

