/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.xml;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import mpi.eudico.client.annotator.recognizer.io.XmlTimeSeriesReader;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TimeSeriesTrack;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.spi.TSConfigPanel;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.SAXException;

public class XmlTsServiceProvider
implements TSServiceProvider {
    @Override
    public void autoCreateTracks(TSSourceConfiguration config) {
        if (config != null) {
            String source = config.getSource();
            if (source.startsWith("file:")) {
                source = source.substring(5);
            }
            File sourceFile = new File(source);
            XmlTimeSeriesReader xmlReader = new XmlTimeSeriesReader(sourceFile);
            try {
                List<Object> tracks = xmlReader.parse();
                if (tracks != null) {
                    for (Object trObj : tracks) {
                        if (!(trObj instanceof TimeSeriesTrack)) continue;
                        AbstractTSTrack tst = (AbstractTSTrack)trObj;
                        tst.setTimeOffset(config.getTimeOrigin());
                        TSTrackConfiguration trconf = new TSTrackConfiguration(tst.getName(), tst);
                        config.putObject(tst.getName(), trconf);
                    }
                }
            }
            catch (IOException ioe) {
                ClientLogger.LOG.severe("Could not read data from the timeseries file " + config.getSource() + ": " + ioe.getMessage());
            }
            catch (SAXException sax) {
                ClientLogger.LOG.severe("Could not read data from the timeseries file " + config.getSource() + ": " + sax.getMessage());
            }
        }
    }

    @Override
    public boolean canHandle(String filePath) {
        ClientLogger.LOG.info("Polling: " + filePath);
        if (filePath == null || filePath.length() < 5) {
            return false;
        }
        String lowerPath = filePath.toLowerCase();
        if (lowerPath.endsWith(".xml")) {
            if (filePath.startsWith("file:")) {
                filePath = filePath.substring(5);
            }
            File f = new File(filePath);
            try {
                FileReader fileRead = new FileReader(f);
                BufferedReader bufRead = new BufferedReader(fileRead);
                String line = null;
                int numLine = 0;
                boolean canHandle = false;
                while ((line = bufRead.readLine()) != null) {
                    String trimmed;
                    if (line.length() == 0) continue;
                    if (numLine == 0 && !line.trim().startsWith("<?xml")) {
                        ClientLogger.LOG.info("Not an XML file.");
                        break;
                    }
                    if (numLine >= 1 && (trimmed = line.trim()).startsWith("<")) {
                        if (!trimmed.startsWith("<TIMESERIES")) break;
                        canHandle = true;
                        break;
                    }
                    ++numLine;
                }
                try {
                    bufRead.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return canHandle;
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Error reading file: " + ioe.getMessage());
            }
        }
        return false;
    }

    @Override
    public void createTracksFromConfiguration(TSSourceConfiguration config) {
        if (config == null) {
            return;
        }
        String source = config.getSource();
        if (source.startsWith("file:")) {
            source = source.substring(5);
        }
        File sourceFile = new File(source);
        XmlTimeSeriesReader xmlReader = new XmlTimeSeriesReader(sourceFile);
        try {
            List<Object> tracks = xmlReader.parse();
            if (tracks == null) {
                return;
            }
            block7: for (Object key : config.objectKeySet()) {
                Object val = config.getObject(key);
                if (!(val instanceof TSTrackConfiguration)) continue;
                TSTrackConfiguration trconf = (TSTrackConfiguration)val;
                for (Object trObj : tracks) {
                    Color c;
                    if (!(trObj instanceof TimeSeriesTrack)) continue;
                    AbstractTSTrack track = (AbstractTSTrack)trObj;
                    if (!trconf.getTrackName().equals(track.getName())) continue;
                    track.setTimeOffset(config.getTimeOrigin());
                    track.setDescription(trconf.getProperty("description"));
                    track.setUnitString(trconf.getProperty("units"));
                    float min = Float.NaN;
                    float max = Float.NaN;
                    try {
                        min = Float.parseFloat(trconf.getProperty("min"));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        max = Float.parseFloat(trconf.getProperty("max"));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    if (!Float.isNaN(min) && !Float.isNaN(max)) {
                        track.setRange(new float[]{min, max});
                    }
                    if ((c = this.parseColor(trconf.getProperty("color"))) != null) {
                        track.setColor(c);
                    }
                    trconf.putObject(track.getName(), track);
                    trconf.removeProperty("derivative");
                    trconf.removeProperty("description");
                    trconf.removeProperty("units");
                    trconf.removeProperty("min");
                    trconf.removeProperty("max");
                    trconf.removeProperty("color");
                    continue block7;
                }
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Could not read data from the timeseries file " + config.getSource() + ": " + ioe.getMessage());
        }
        catch (SAXException sax) {
            ClientLogger.LOG.severe("Could not read data from the timeseries file " + config.getSource() + ": " + sax.getMessage());
        }
    }

    private Color parseColor(String rgb) {
        if (rgb == null) {
            return null;
        }
        int index = rgb.indexOf(44);
        int index2 = rgb.lastIndexOf(44);
        if (index > -1 && index2 > -1) {
            try {
                int r = Integer.parseInt(rgb.substring(0, index));
                int g = Integer.parseInt(rgb.substring(index + 1, index2));
                int b = Integer.parseInt(rgb.substring(index2 + 1));
                return new Color(r, g, b);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        return null;
    }

    @Override
    public TSConfigPanel getConfigPanel(TSSourceConfiguration config) {
        return null;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }
}

