/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class PossibleTypesExtractor {
    private List<String> linkedTypes;
    private List<TierImpl> parentTierList;
    private HashMap<TierImpl, HashMap<String, Integer>> typeTierMap = new HashMap();
    private Transcription transcription;

    public PossibleTypesExtractor(Transcription transcription) {
        this.parentTierList = new ArrayList<TierImpl>();
        this.linkedTypes = new ArrayList<String>();
        this.transcription = transcription;
    }

    private HashMap<String, Integer> getTierTypeMap(TierImpl tier) {
        HashMap<String, Integer> tierTypeMap = new HashMap<String, Integer>();
        Vector childTiers = tier.getChildTiers();
        for (int x = 0; x < childTiers.size(); ++x) {
            TierImpl childTier = (TierImpl)childTiers.get(x);
            String typeName = null;
            if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
            Vector dependentTiers = childTier.getDependentTiers();
            for (int y = 0; y < dependentTiers.size(); ++y) {
                TierImpl dependantTier = (TierImpl)dependentTiers.get(y);
                typeName = dependantTier.getLinguisticType().getLinguisticTypeName();
                if (dependantTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
                if (tierTypeMap.containsKey(typeName)) {
                    tierTypeMap.put(typeName, tierTypeMap.get(typeName) + 1);
                } else {
                    tierTypeMap.put(typeName, 1);
                }
                if (this.linkedTypes.contains(dependantTier.getLinguisticType().getLinguisticTypeName())) continue;
                this.linkedTypes.add(dependantTier.getLinguisticType().getLinguisticTypeName());
            }
            typeName = childTier.getLinguisticType().getLinguisticTypeName();
            if (tierTypeMap.containsKey(typeName)) {
                tierTypeMap.put(typeName, tierTypeMap.get(typeName) + 1);
            } else {
                tierTypeMap.put(typeName, 1);
            }
            if (this.linkedTypes.contains(childTier.getLinguisticType().getLinguisticTypeName())) continue;
            this.linkedTypes.add(childTier.getLinguisticType().getLinguisticTypeName());
        }
        return tierTypeMap;
    }

    private void getLinkedTypes(String refType) {
        this.linkedTypes.clear();
        this.parentTierList.clear();
        Vector tierList = this.transcription.getTiersWithLinguisticType(refType);
        ArrayList parentTiers = new ArrayList();
        for (int i = 0; i < tierList.size(); ++i) {
            TierImpl parentTier;
            TierImpl tier = (TierImpl)tierList.get(i);
            if (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 4) {
                if (this.parentTierList.contains(tier)) continue;
                this.parentTierList.add(tier);
                this.typeTierMap.put(tier, this.getTierTypeMap(tier));
                continue;
            }
            for (parentTier = (TierImpl)tier.getParentTier(); parentTier != null && parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4; parentTier = (TierImpl)parentTier.getParentTier()) {
            }
            if (this.parentTierList.contains(parentTier)) continue;
            this.parentTierList.add(parentTier);
            this.typeTierMap.put(parentTier, this.getTierTypeMap(parentTier));
        }
    }

    public List<String> getPossibleTypesForColumn(int column, List<String> columnTypeList) {
        ArrayList<String> possibleTypes = new ArrayList<String>();
        if (column == 1) {
            Vector types = this.transcription.getLinguisticTypes();
            for (int i = 0; i < types.size(); ++i) {
                LinguisticType type = (LinguisticType)types.get(i);
                Vector tierList = this.transcription.getTiersWithLinguisticType(type.getLinguisticTypeName());
                if (tierList == null || tierList.size() <= 0) continue;
                possibleTypes.add(type.getLinguisticTypeName());
            }
            return possibleTypes;
        }
        if (columnTypeList == null) {
            return possibleTypes;
        }
        if (column == 2) {
            if (columnTypeList.size() > 0) {
                this.getLinkedTypes(columnTypeList.get(0));
            } else {
                return possibleTypes;
            }
        }
        for (int x = 0; x < this.parentTierList.size(); ++x) {
            HashMap<String, Integer> _map = this.typeTierMap.get(this.parentTierList.get(x));
            for (int i = 0; i < this.linkedTypes.size(); ++i) {
                String typeName = this.linkedTypes.get(i);
                if (!_map.containsKey(typeName)) continue;
                int noOfTiers = _map.get(typeName);
                if (noOfTiers > 0) {
                    for (int c = 0; c < columnTypeList.size() && c != column - 1; ++c) {
                        if (!typeName.equals(columnTypeList.get(c)) || --noOfTiers > 0) continue;
                        noOfTiers = 0;
                        break;
                    }
                }
                if (noOfTiers <= 0 || possibleTypes.contains(typeName)) continue;
                possibleTypes.add(typeName);
            }
        }
        return possibleTypes;
    }
}

