/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SelectionPanel;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;

public class TranscriptionModePlayerController
implements ChangeListener,
ActionListener {
    private static final Dimension BUTTON_SIZE = new Dimension(30, 20);
    private long userTimeBetweenLoops = 500L;
    private JPanel volRatePanel;
    private JLabel volNameLabel;
    private JLabel volValueLabel;
    private JLabel rateNameLabel;
    private JLabel rateValueLabel;
    private JSlider volSlider;
    private JSlider rateSlider;
    private ViewerManager2 vm;
    private TranscriptionViewer viewer;
    private Icon playIcon;
    private Icon pauseIcon;
    private JButton butPlay;
    private JPanel playButtonsPanel;
    private JCheckBox loopModeCB;
    private JPanel modePanel;
    private JButton butPlaySelection;
    private JButton butClearSelection;
    private JPanel selectionButtonsPanel;
    private boolean loopMode = false;
    private LoopThread loopThread;
    private SelectionPanel selectionPanel;

    public TranscriptionModePlayerController(ViewerManager2 theVM, TranscriptionViewer viewer) {
        this.vm = theVM;
        this.viewer = viewer;
    }

    public Dimension getButtonSize() {
        return BUTTON_SIZE;
    }

    public long getUserTimeBetweenLoops() {
        return this.userTimeBetweenLoops;
    }

    public void setUserTimeBetweenLoops(long loopTime) {
        this.userTimeBetweenLoops = loopTime;
    }

    public JPanel getVolumeRatePanel() {
        Insets insets;
        if (this.volRatePanel != null) {
            return this.volRatePanel;
        }
        this.volRatePanel = new JPanel(new GridBagLayout());
        this.volNameLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Volume"));
        int volume = (int)(this.vm.getMasterMediaPlayer().getVolume() * 100.0f);
        Float value = (Float)Preferences.get("MediaControlVolume", this.vm.getTranscription());
        if (value != null) {
            volume = (int)(value.floatValue() * 100.0f);
        }
        this.volValueLabel = new JLabel(String.valueOf(volume));
        this.volValueLabel.setFont(this.volValueLabel.getFont().deriveFont(0, 10.0f));
        this.volSlider = new JSlider(0, 100, volume);
        this.volSlider.addChangeListener(this);
        this.rateNameLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Rate"));
        int rate = (int)(this.vm.getMasterMediaPlayer().getRate() * 100.0f);
        value = (Float)Preferences.get("MediaControlRate", this.vm.getTranscription());
        if (value != null) {
            rate = (int)(value.floatValue() * 100.0f);
        }
        this.rateValueLabel = new JLabel(String.valueOf(rate));
        this.rateValueLabel.setFont(this.rateValueLabel.getFont().deriveFont(0, 10.0f));
        this.rateSlider = new JSlider(0, 200, rate);
        this.rateSlider.addChangeListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(1, 1, 1, 1);
        gbc.anchor = 16;
        this.volRatePanel.add((Component)this.volNameLabel, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.volRatePanel.add((Component)this.rateNameLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 6, 1, 1);
        gbc.weighty = 0.5;
        this.volRatePanel.add((Component)this.volValueLabel, gbc);
        gbc.gridy = 2;
        this.volRatePanel.add((Component)this.rateValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.volRatePanel.add((Component)this.volSlider, gbc);
        gbc.gridy = 3;
        this.volRatePanel.add((Component)this.rateSlider, gbc);
        this.volRatePanel.setBorder(new TitledBorder(""));
        return this.volRatePanel;
    }

    public JPanel getModePanel() {
        if (this.modePanel != null) {
            return this.modePanel;
        }
        this.modePanel = new JPanel(new FlowLayout(0, 0, 0));
        this.loopModeCB = new JCheckBox(ElanLocale.getString("CommandActions.LoopMode"));
        this.loopModeCB.setFont(Constants.SMALLFONT);
        this.loopModeCB.addActionListener(this);
        String ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.LoopMode", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.loopModeCB.setToolTipText(ElanLocale.getString("CommandActions.LoopModeToolTip") + " (" + ksDescription + ")");
        } else {
            this.loopModeCB.setToolTipText(ElanLocale.getString("CommandActions.LoopModeToolTip"));
        }
        this.modePanel.add(this.loopModeCB);
        return this.modePanel;
    }

    public void isClosing() {
        this.stopLoop();
        Preferences.set("MediaControlRate", new Float((float)this.rateSlider.getValue() / 100.0f), this.vm.getTranscription());
        Preferences.set("MediaControlVolume", new Float((float)this.volSlider.getValue() / 100.0f), this.vm.getTranscription());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.volSlider) {
            int volume = this.volSlider.getValue();
            this.volValueLabel.setText(String.valueOf(volume));
            this.vm.getMasterMediaPlayer().setVolume((float)volume / 100.0f);
        } else if (e.getSource() == this.rateSlider) {
            int rate = this.rateSlider.getValue();
            this.rateValueLabel.setText(String.valueOf(rate));
            this.vm.getMasterMediaPlayer().setRate((float)rate / 100.0f);
        }
        this.viewer.focusTable();
    }

    public JPanel getPlayButtonsPanel() {
        if (this.playButtonsPanel != null) {
            return this.playButtonsPanel;
        }
        this.playButtonsPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.playIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PlayButton.gif"));
        this.pauseIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PauseButton.gif"));
        this.butPlay = new JButton(this.playIcon);
        this.butPlay.setPreferredSize(BUTTON_SIZE);
        this.butPlay.setEnabled(false);
        this.butPlay.addActionListener(this);
        String ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.PlayPause", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.butPlay.setToolTipText(ElanLocale.getString("Menu.Play.PlayPauseToolTip") + " (" + ksDescription + ")");
        } else {
            this.butPlay.setToolTipText(ElanLocale.getString("Menu.Play.PlayPauseToolTip"));
        }
        this.playButtonsPanel.add(this.butPlay);
        return this.playButtonsPanel;
    }

    public void setPlayPauseButton(boolean play) {
        if (play) {
            this.butPlay.setIcon(this.playIcon);
        } else {
            this.butPlay.setIcon(this.pauseIcon);
        }
        this.viewer.focusTable();
    }

    public JPanel getSelectionButtonsPanel() {
        if (this.selectionButtonsPanel != null) {
            return this.selectionButtonsPanel;
        }
        this.selectionButtonsPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.butPlaySelection = new JButton(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PlaySelectionButton.gif")));
        this.butPlaySelection.setPreferredSize(BUTTON_SIZE);
        this.butPlaySelection.addActionListener(this);
        String ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.PlaySelection", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.butPlaySelection.setToolTipText(ElanLocale.getString("Menu.Play.PlaySelectionToolTip") + " (" + ksDescription + ")");
        } else {
            this.butPlaySelection.setToolTipText(ElanLocale.getString("Menu.Play.PlaySelectionToolTip"));
        }
        this.selectionButtonsPanel.add(this.butPlaySelection);
        this.butClearSelection = new JButton(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ClearSelectionButton.gif")));
        this.butClearSelection.setPreferredSize(BUTTON_SIZE);
        this.butClearSelection.addActionListener(this);
        ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.ClearSelection", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.butClearSelection.setToolTipText(ElanLocale.getString("Menu.Play.ClearSelectionToolTip") + " (" + ksDescription + ")");
        } else {
            this.butClearSelection.setToolTipText(ElanLocale.getString("Menu.Play.ClearSelectionToolTip"));
        }
        this.selectionButtonsPanel.add(this.butClearSelection);
        return this.selectionButtonsPanel;
    }

    public boolean getLoopMode() {
        return this.loopMode;
    }

    public void startLoop(long begin, long end) {
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
        this.loopThread = new LoopThread(begin, end);
        this.loopThread.start();
    }

    public void stopLoop() {
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
    }

    private boolean playerIsPlaying() {
        return this.vm.getMasterMediaPlayer().isPlaying();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butPlay) {
            this.viewer.playMedia();
        } else if (e.getSource() == this.loopModeCB) {
            this.changeLoopMode();
        } else if (e.getSource() == this.butClearSelection) {
            this.viewer.clearSelection();
        } else if (e.getSource() == this.butPlaySelection) {
            this.viewer.playSelection();
        }
        this.viewer.focusTable();
    }

    public void enableButtons(boolean b) {
        this.butPlay.setEnabled(b);
        this.butPlaySelection.setEnabled(b);
        this.butClearSelection.setEnabled(b);
        this.loopModeCB.setEnabled(b);
    }

    private void changeLoopMode() {
        this.loopMode = this.loopModeCB.isSelected();
        this.viewer.focusTable();
        Preferences.set("TranscriptionManager.LoopMode", this.loopModeCB.isSelected(), null);
    }

    public void toggleLoopMode() {
        this.loopModeCB.setSelected(!this.loopModeCB.isSelected());
    }

    public SelectionPanel getSelectionPanel() {
        if (this.selectionPanel != null) {
            return this.selectionPanel;
        }
        this.selectionPanel = new SelectionPanel(this.vm);
        this.selectionPanel.setNameLabel(ElanLocale.getString("TranscriptionManager.TimeInterval"));
        this.vm.getSelection().removeSelectionListener(this.selectionPanel);
        return this.selectionPanel;
    }

    public void updateLocale() {
        String ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.LoopMode", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.loopModeCB.setToolTipText(ElanLocale.getString("CommandActions.LoopModeToolTip") + " (" + ksDescription + ")");
        } else {
            this.loopModeCB.setToolTipText(ElanLocale.getString("CommandActions.LoopModeToolTip"));
        }
        ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.PlayPause", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.butPlay.setToolTipText(ElanLocale.getString("Menu.Play.PlayPauseToolTip") + " (" + ksDescription + ")");
        } else {
            this.butPlay.setToolTipText(ElanLocale.getString("Menu.Play.PlayPauseToolTip"));
        }
        ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.PlaySelection", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.butPlaySelection.setToolTipText(ElanLocale.getString("Menu.Play.PlaySelectionToolTip") + " (" + ksDescription + ")");
        } else {
            this.butPlaySelection.setToolTipText(ElanLocale.getString("Menu.Play.PlaySelectionToolTip"));
        }
        ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.ClearSelection", "Menu.Options.TranscriptionMode"));
        if (ksDescription != null && ksDescription.trim().length() > 0) {
            this.butClearSelection.setToolTipText(ElanLocale.getString("Menu.Play.ClearSelectionToolTip") + " (" + ksDescription + ")");
        } else {
            this.butClearSelection.setToolTipText(ElanLocale.getString("Menu.Play.ClearSelectionToolTip"));
        }
    }

    private class LoopThread
    extends Thread {
        private long beginTime;
        private long endTime;
        private boolean stopLoop = false;

        LoopThread(long begin, long end) {
            this.beginTime = begin;
            this.endTime = end;
            this.setName("Loop Thread");
        }

        public void stopLoop() {
            this.stopLoop = true;
        }

        @Override
        public void run() {
            while (!this.stopLoop && TranscriptionModePlayerController.this.loopMode) {
                if (!TranscriptionModePlayerController.this.playerIsPlaying()) {
                    TranscriptionModePlayerController.this.vm.getMasterMediaPlayer().playInterval(this.beginTime, this.endTime);
                    while (!TranscriptionModePlayerController.this.playerIsPlaying()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
                while (TranscriptionModePlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (!this.stopLoop) continue;
                    return;
                }
                try {
                    Thread.sleep(TranscriptionModePlayerController.this.getUserTimeBetweenLoops());
                }
                catch (Exception exception) {}
            }
        }
    }
}

