/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTable;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceGroup;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;

public class TranscriptionTableEditBox
extends JPanel
implements ActionListener,
MouseListener,
KeyListener,
ElanLocaleListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(TranscriptionTableEditBox.class.getName());
    private JTextArea textArea = new JTextArea();
    private JPopupMenu popupMenu;
    private String oldText;
    private Annotation annotation;
    private TranscriptionTable table = null;
    private TranscriptionViewer viewer;
    private boolean isUsingControlledVocabulary = false;
    private JMenuItem commitMI;
    private JMenuItem cancelMI;
    private JMenuItem mergeBeforeMI;
    private JMenuItem mergeNextMI;
    private JMenuItem deleteAnnotationMI;
    private JMenuItem editInAnnModeMI;
    private JMenuItem selectAllMI;
    private JMenuItem cutMI;
    private JMenuItem copyMI;
    private JMenuItem pasteMI;
    private JMenuItem changeColorMI;
    private JMenuItem nonEditableTierMI;
    private JMenuItem hideAllTiersMI;
    private JMenuItem showHideMoreMI;
    private CVEntryComponent cvEntryComp;
    private List<KeyStroke> keyStrokesList;
    private int caretPosition = -1;
    private int maxHtForOtherColumn = 0;
    private boolean heightComputed = false;
    private Graphics g;
    private FontMetrics fm;
    private int fontHeight;
    private int currentRow;
    private int minRowHeight;
    private int columnWidth;
    private JComponent editorComponent;
    private Font uniFont = Constants.DEFAULTFONT;
    private boolean isEditing = false;
    private boolean commitChanges = false;
    private final FocusListener intFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!TranscriptionTableEditBox.this.isUsingControlledVocabulary) {
                TranscriptionTableEditBox.this.textArea.requestFocus();
                TranscriptionTableEditBox.this.textArea.getCaret().setVisible(true);
            } else if (TranscriptionTableEditBox.this.cvEntryComp != null) {
                TranscriptionTableEditBox.this.cvEntryComp.grabFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!TranscriptionTableEditBox.this.isEditing) {
                TranscriptionTableEditBox.this.transferFocusUpCycle();
            }
        }
    };

    public TranscriptionTableEditBox(TranscriptionViewer viewer, TranscriptionTable table) {
        this.table = table;
        this.viewer = viewer;
        this.keyStrokesList = viewer.getKeyStrokeList();
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.textArea.addMouseListener(this);
        this.textArea.setLineWrap(true);
        this.textArea.setMargin(new Insets(0, 3, 0, 3));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setBorder(new CompoundBorder(new LineBorder(Color.black, 1), new LineBorder(Color.white, 2)));
        this.add((Component)this.textArea, "Center");
        this.textArea.getCaret().setVisible(true);
        this.textArea.addKeyListener(this);
        this.textArea.addFocusListener(this.intFocusListener);
        this.addFocusListener(this.intFocusListener);
        this.textArea.getDocument().addDocumentListener(this);
        AbstractAction doNothing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "doNothing");
    }

    public void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.commitMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
        this.commitMI.addActionListener(this);
        this.popupMenu.add(this.commitMI);
        this.cancelMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cancelMI.addActionListener(this);
        this.popupMenu.add(this.cancelMI);
        this.editInAnnModeMI = new JMenuItem(ElanLocale.getString("TranscriptionTableEditBox.EditInAnnotationMode"));
        this.editInAnnModeMI.addActionListener(this);
        this.popupMenu.add(this.editInAnnModeMI);
        this.mergeBeforeMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.MergeWithBefore"));
        this.mergeBeforeMI.addActionListener(this);
        this.popupMenu.add(this.mergeBeforeMI);
        this.mergeNextMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.MergeWithNext"));
        this.mergeNextMI.addActionListener(this);
        this.popupMenu.add(this.mergeNextMI);
        this.deleteAnnotationMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
        this.deleteAnnotationMI.addActionListener(this);
        this.popupMenu.add(this.deleteAnnotationMI);
        this.popupMenu.addSeparator();
        this.cutMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.cutMI.setActionCommand("cut");
        this.cutMI.addActionListener(this);
        this.popupMenu.add(this.cutMI);
        this.copyMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.copyMI.setActionCommand("copy");
        this.copyMI.addActionListener(this);
        this.popupMenu.add(this.copyMI);
        this.pasteMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        this.pasteMI.setActionCommand("paste");
        this.pasteMI.addActionListener(this);
        this.popupMenu.add(this.pasteMI);
        this.selectAllMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.SelectAll"));
        this.selectAllMI.setActionCommand("selectAll");
        this.selectAllMI.addActionListener(this);
        this.popupMenu.add(this.selectAllMI);
        this.popupMenu.addSeparator();
        this.changeColorMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.ChangeColorForThisTier"));
        this.changeColorMI.addActionListener(this);
        this.nonEditableTierMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.NonEditableTier"));
        this.nonEditableTierMI.addActionListener(this);
        this.hideAllTiersMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.HideLinkedTiers"));
        this.hideAllTiersMI.addActionListener(this);
        this.showHideMoreMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.ShoworHideTiers"));
        this.showHideMoreMI.addActionListener(this);
        this.popupMenu.add(this.changeColorMI);
        this.popupMenu.add(this.nonEditableTierMI);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.hideAllTiersMI);
        this.popupMenu.add(this.showHideMoreMI);
        this.updatePopMenuShortcuts();
    }

    public boolean isUsingControlledVocabulary() {
        return this.isUsingControlledVocabulary;
    }

    public String getEditingCellValue() {
        if (this.textArea != null) {
            return this.textArea.getText();
        }
        return null;
    }

    @Override
    public void setFont(Font font) {
        this.uniFont = font;
        if (this.textArea != null) {
            this.textArea.setFont(font);
            if (this.heightComputed) {
                this.heightComputed = false;
                this.recalculateRowHeight();
                this.textArea.repaint();
            }
        }
    }

    public void setAnnotation(Annotation ann, boolean forceOpenCV) {
        this.annotation = ann;
        this.oldText = ann.getValue();
        this.textArea.setText(this.oldText);
        try {
            this.isUsingControlledVocabulary = forceOpenCV ? false : ((TierImpl)this.annotation.getTier()).getLinguisticType().isUsingControlledVocabulary();
        }
        catch (Exception e) {
            this.isUsingControlledVocabulary = false;
        }
        if (!this.isUsingControlledVocabulary) {
            this.textArea.setEditable(true);
            if (this.caretPosition > 0 && this.caretPosition <= this.textArea.getText().length()) {
                this.textArea.setCaretPosition(this.caretPosition);
            } else {
                this.textArea.setCaretPosition(this.textArea.getText().length());
                this.caretPosition = -1;
            }
        } else {
            this.textArea.setEditable(false);
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(JScrollPane.class);
            }
            this.cvEntryComp.setAnnotation(this.annotation);
        }
    }

    public void setAnnotation(Annotation ann) {
        this.setAnnotation(ann, false);
    }

    public boolean annotationModified() {
        return !this.oldText.equals(this.textArea.getText());
    }

    public void cancelEdit() {
        this.viewer.stopPlayer();
        this.isEditing = false;
        this.heightComputed = false;
        this.setVisible(false);
        if (this.table != null) {
            this.table.editingCanceled(new ChangeEvent(this));
        }
    }

    public void commitChanges() {
        if (!this.isEditing || this.annotation == null) {
            return;
        }
        this.commitChanges = true;
        Object extRef = null;
        if (this.isUsingControlledVocabulary && this.cvEntryComp != null && this.cvEntryComp.getSelectedEntry() != null) {
            this.textArea.setText(this.cvEntryComp.getSelectedEntryValue());
            extRef = this.cvEntryComp.getSelectedEntry().getExternalRef();
            if (this.cvEntryComp.getSelectedEntry() instanceof ExternalCVEntry) {
                String entryId = ((ExternalCVEntry)this.cvEntryComp.getSelectedEntry()).getId();
                ExternalReferenceImpl extRefCv = new ExternalReferenceImpl(entryId, 5);
                ExternalReferenceGroup tmpExtRefGrp = new ExternalReferenceGroup();
                tmpExtRefGrp.addReference(extRefCv);
                if (extRef != null) {
                    try {
                        Object clone = ((ExternalReference)extRef).clone();
                        if (clone instanceof ExternalReference) {
                            tmpExtRefGrp.addReference((ExternalReference)clone);
                        }
                        extRef = tmpExtRefGrp;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    extRef = tmpExtRefGrp;
                }
            }
        }
        if (extRef == null && ((AbstractAnnotation)this.annotation).getExtRef() != null) {
            extRef = new ExternalReferenceImpl(null, 5);
        }
        String newText = this.textArea.getText();
        boolean modified = this.annotationModified();
        if (modified) {
            this.setVisible(false);
            Command c = ELANCommandFactory.createCommand((Transcription)this.annotation.getTier().getParent(), "Menu.Annotation.ModifyAnnotation");
            Object[] args = new Object[]{this.oldText, newText, extRef};
            c.execute(this.annotation, args);
        }
        this.isEditing = false;
        this.heightComputed = false;
        this.commitChanges = false;
        if (this.table != null) {
            if (this.getEditorComponent() instanceof JScrollPane || this.oldText.length() != newText.length()) {
                this.recalculateRowHeight();
            }
            this.table.editingStopped(new ChangeEvent(this));
        }
    }

    public boolean isCommitChanges() {
        return this.commitChanges;
    }

    private void doCut() {
        this.textArea.cut();
        this.recalculateRowHeight();
    }

    private void doCopy() {
        this.textArea.copy();
    }

    private void doPaste() {
        this.textArea.paste();
        this.recalculateRowHeight();
    }

    private void doSelectAll() {
        this.textArea.selectAll();
    }

    private void mergeWithAnnBefore() {
        Annotation ann = (Annotation)this.table.getValueAt(this.table.getCurrentRow() - 1, this.table.getCurrentColumn());
        this.caretPosition = ann.getValue().length() + this.textArea.getCaretPosition();
        this.commitChanges();
        if (((TierImpl)this.annotation.getTier()).hasParentTier()) {
            this.viewer.mergeBeforeAnn(this.annotation.getParentAnnotation());
        } else {
            this.viewer.mergeBeforeAnn(this.annotation);
        }
    }

    private void mergeWithNextAnn() {
        this.caretPosition = this.textArea.getCaretPosition();
        this.commitChanges();
        if (((TierImpl)this.annotation.getTier()).hasParentTier()) {
            this.viewer.mergeNextAnn(this.annotation.getParentAnnotation());
        } else {
            this.viewer.mergeNextAnn(this.annotation);
        }
    }

    private void commit() {
        this.commitChanges();
        this.table.goToNextEditableCell();
    }

    private void deleteAnnotation() {
        this.commitChanges();
        this.viewer.deleteAnnotation(this.annotation);
    }

    private void editInAnnotationMode() {
        this.commitChanges();
        if (this.annotation != null) {
            this.viewer.getViewerManager().getMasterMediaPlayer().stop();
            this.viewer.editInAnnotationMode();
        }
    }

    private void updatePopup() {
        if (this.textArea.getSelectedText() == null || this.textArea.getSelectedText().length() == 0) {
            this.cutMI.setEnabled(false);
            this.copyMI.setEnabled(false);
        } else {
            this.cutMI.setEnabled(true);
            this.copyMI.setEnabled(true);
        }
        if (this.isTextOnClipboard()) {
            this.pasteMI.setEnabled(true);
        } else {
            this.pasteMI.setEnabled(false);
        }
        if (this.textArea.getText() == null || this.textArea.getText().length() == 0) {
            this.selectAllMI.setEnabled(false);
        } else {
            this.selectAllMI.setEnabled(true);
        }
        if (this.annotation == null) {
            this.editInAnnModeMI.setEnabled(false);
        } else {
            this.editInAnnModeMI.setEnabled(true);
        }
        if (this.viewer.getMerge()) {
            Object obj;
            int leadColumn = this.table.getCurrentColumn();
            int leadRow = this.table.getCurrentRow();
            if (leadRow != 0) {
                obj = this.table.getValueAt(leadRow - 1, leadColumn);
                if (obj instanceof Annotation) {
                    if (this.annotation.getTier().equals(((Annotation)obj).getTier())) {
                        this.mergeBeforeMI.setEnabled(true);
                    } else {
                        this.mergeBeforeMI.setEnabled(false);
                    }
                } else {
                    this.mergeBeforeMI.setEnabled(false);
                }
            } else {
                this.mergeBeforeMI.setEnabled(false);
            }
            if (leadRow < this.table.getRowCount() - 1) {
                obj = this.table.getValueAt(leadRow + 1, leadColumn);
                if (obj instanceof Annotation) {
                    if (this.annotation.getTier().equals(((Annotation)obj).getTier())) {
                        this.mergeNextMI.setEnabled(true);
                    } else {
                        this.mergeNextMI.setEnabled(false);
                    }
                } else {
                    this.mergeNextMI.setEnabled(false);
                }
            } else {
                this.mergeNextMI.setEnabled(false);
            }
        } else {
            this.mergeBeforeMI.setEnabled(false);
            this.mergeNextMI.setEnabled(false);
        }
    }

    private boolean checkForMergeBefore() {
        if (this.viewer.getMerge()) {
            int leadColumn = this.table.getCurrentColumn();
            int leadRow = this.table.getCurrentRow();
            if (leadRow != 0) {
                Object obj = this.table.getValueAt(leadRow - 1, leadColumn);
                if (obj instanceof Annotation) {
                    return this.annotation.getTier().equals(((Annotation)obj).getTier());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean checkForMergeAfter() {
        if (this.viewer.getMerge()) {
            int leadColumn = this.table.getCurrentColumn();
            int leadRow = this.table.getCurrentRow();
            if (leadRow < this.table.getRowCount() - 1) {
                Object obj = this.table.getValueAt(leadRow + 1, leadColumn);
                if (obj instanceof Annotation) {
                    return this.annotation.getTier().equals(((Annotation)obj).getTier());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void showPopUp(Component obj, int x, int y) {
        if (this.popupMenu == null) {
            this.createPopupMenu();
        }
        this.updatePopup();
        this.popupMenu.show(obj, x, y);
        this.popupMenu.setVisible(true);
    }

    private boolean isTextOnClipboard() {
        DataFlavor[] flavors;
        DataFlavor best;
        Transferable contents = null;
        try {
            contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        }
        catch (IllegalStateException ise) {
            LOG.warning("Could not access the system clipboard.");
        }
        return contents != null && (best = DataFlavor.selectBestTextFlavor(flavors = contents.getTransferDataFlavors())) != null;
    }

    public JComponent getEditorComponent() {
        if (this.editorComponent == null) {
            return this;
        }
        return this.editorComponent;
    }

    public void configureEditor(Class preferredComponent, Font font, Dimension size) {
        if (preferredComponent == JTextArea.class) {
            if (font != null) {
                this.setFont(font);
            }
            if (size != null) {
                this.setSize(size);
            }
            this.editorComponent = this.textArea;
        } else if (preferredComponent == JScrollPane.class && this.isUsingControlledVocabulary) {
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(preferredComponent);
                this.cvEntryComp.setAnnotation(this.annotation);
            }
            if (font != null) {
                this.cvEntryComp.setFont(font);
            }
            if (size != null) {
                this.cvEntryComp.getEditorComponent().setSize(size);
            }
            this.editorComponent = this.cvEntryComp.getEditorComponent();
        }
    }

    public void startEdit() {
        if (this.isEditing) {
            return;
        }
        this.isEditing = true;
        if (this.editorComponent == this) {
            this.setVisible(true);
            this.requestFocus();
        } else if (this.isUsingControlledVocabulary) {
            this.cvEntryComp.grabFocus();
        } else {
            this.editorComponent.requestFocus();
        }
    }

    @Override
    public void grabFocus() {
        if (this.isUsingControlledVocabulary) {
            this.cvEntryComp.grabFocus();
        } else {
            this.editorComponent.requestFocus();
        }
    }

    private void updatePopMenuShortcuts() {
        if (this.popupMenu == null) {
            return;
        }
        ShortcutsUtil scu = ShortcutsUtil.getInstance();
        this.commitMI.setAccelerator(scu.getKeyStrokeForAction("TranscriptionMode.Actions.CommitChanges", "Menu.Options.TranscriptionMode"));
        this.cancelMI.setAccelerator(scu.getKeyStrokeForAction("TranscriptionMode.Actions.CancelChanges", "Menu.Options.TranscriptionMode"));
        this.editInAnnModeMI.setAccelerator(scu.getKeyStrokeForAction("TranscriptionTableEditBox.EditInAnnotationMode", "Menu.Options.TranscriptionMode"));
        this.mergeBeforeMI.setAccelerator(scu.getKeyStrokeForAction("Menu.Annotation.MergeWithBefore", "Menu.Options.TranscriptionMode"));
        this.mergeNextMI.setAccelerator(scu.getKeyStrokeForAction("Menu.Annotation.MergeWithNext", "Menu.Options.TranscriptionMode"));
        this.deleteAnnotationMI.setAccelerator(scu.getKeyStrokeForAction("Menu.Annotation.DeleteAnnotation", "Menu.Options.TranscriptionMode"));
        this.nonEditableTierMI.setAccelerator(scu.getKeyStrokeForAction("TranscriptionMode.Actions.FreezeTier", "Menu.Options.TranscriptionMode"));
        this.hideAllTiersMI.setAccelerator(scu.getKeyStrokeForAction("TranscriptionTable.Label.HideLinkedTiers", "Menu.Options.TranscriptionMode"));
    }

    public void updateShortCuts() {
        this.keyStrokesList = this.viewer.getKeyStrokeList();
        this.updatePopMenuShortcuts();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (e.getSource() == this.cancelMI) {
            this.cancelEdit();
        } else if (e.getSource() == this.commitMI) {
            this.commitChanges();
        } else if (e.getSource() == this.editInAnnModeMI) {
            this.editInAnnotationMode();
        } else if (command.equals("cut")) {
            this.doCut();
        } else if (command.equals("copy")) {
            this.doCopy();
        } else if (command.equals("paste")) {
            this.doPaste();
        } else if (command.equals("selectAll")) {
            this.doSelectAll();
        } else if (e.getSource() == this.mergeBeforeMI) {
            this.mergeWithAnnBefore();
        } else if (e.getSource() == this.mergeNextMI) {
            this.mergeWithNextAnn();
        } else if (e.getSource() == this.deleteAnnotationMI) {
            this.deleteAnnotation();
        } else if (e.getSource() == this.changeColorMI) {
            this.viewer.showChangeColorDialog(this.annotation.getTier().getName());
        } else if (e.getSource() == this.nonEditableTierMI) {
            this.commitChanges();
            this.viewer.editOrNoneditableTier(this.annotation.getTier().getName());
        } else if (e.getSource() == this.hideAllTiersMI) {
            this.commitChanges();
            this.viewer.hideTiersLinkedWith(this.annotation.getTier().getName());
        } else if (e.getSource() == this.showHideMoreMI) {
            this.commitChanges();
            this.viewer.showHideMoreTiers();
        }
    }

    public void cvChanged(ControlledVocabulary cv) {
        if (this.cvEntryComp != null) {
            this.cvEntryComp.cvChanged(cv);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            this.showPopUp(this.textArea, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        if (ks == null || !this.keyStrokesList.contains(ks)) {
            return;
        }
        if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.CancelChanges", "Menu.Options.TranscriptionMode")) {
            this.cancelEdit();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.MoveUp", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellUp();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.MoveDown", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellDown();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.MoveLeft", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellLeft();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.MoveRight", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.commitChanges();
            this.table.goToEditableCellRight();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.PlayFromStart", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.playIntervalFromBeginTime(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionTableEditBox.EditInAnnotationMode", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.editInAnnotationMode();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.PlayPause", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.playInterval(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.PlaySelection", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.playSelection();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.ClearSelection", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.clearSelection();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.PlayAroundSelection", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.playAroundSelection(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.1PixelLeft", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.goToOnepixelForwardOrBackward("Menu.Play.1PixelLeft", this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.1PixelRight", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.goToOnepixelForwardOrBackward("Menu.Play.1PixelRight", this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.Previous", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.goToPreviousOrNextFrame("Menu.Play.Previous", this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.Next", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.goToPreviousOrNextFrame("Menu.Play.Next", this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.1SecLeft", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.goToOneSecondForwardOrBackward("Menu.Play.1SecLeft", this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Play.1SecRight", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.goToOneSecondForwardOrBackward("Menu.Play.1SecRight", this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.DeleteAnnotation", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.deleteAnnotation();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.MergeWithBefore", "Menu.Options.TranscriptionMode")) {
            e.consume();
            if (this.checkForMergeBefore()) {
                this.mergeWithAnnBefore();
            }
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.MergeWithNext", "Menu.Options.TranscriptionMode")) {
            e.consume();
            if (this.checkForMergeAfter()) {
                this.mergeWithNextAnn();
            }
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.FreezeTier", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.commitChanges();
            this.viewer.editOrNoneditableTier(this.annotation.getTier().getName());
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionTable.Label.HideLinkedTiers", "Menu.Options.TranscriptionMode")) {
            this.commitChanges();
            this.viewer.hideTiersLinkedWith(this.annotation.getTier().getName());
        } else if (e.getKeyCode() == 67 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.doCopy();
        } else if (e.getKeyCode() == 86 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.doPaste();
        } else if (e.getKeyCode() == 88 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.doCut();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("TranscriptionMode.Actions.CommitChanges", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.commitChanges();
            this.table.goToNextEditableCell();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.LoopMode", "Menu.Options.TranscriptionMode")) {
            e.consume();
            this.viewer.toggleLoopMode();
        } else if (ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Edit.Undo", "Menu.Options.TranscriptionMode") || ks == ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Edit.Redo", "Menu.Options.TranscriptionMode")) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void updateLocale() {
        this.commitMI.setText(ElanLocale.getString("InlineEditBox.Commit"));
        this.cancelMI.setText(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cutMI.setText(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.copyMI.setText(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.pasteMI.setText(ElanLocale.getString("InlineEditBox.Edit.Paste"));
    }

    private void initializeHeightParameterSettings() {
        this.g = this.textArea.getGraphics();
        this.fm = this.textArea.getFontMetrics(this.uniFont);
        this.fontHeight = this.fm.getAscent() + this.fm.getDescent() + 3;
        this.currentRow = this.table.getEditingRow();
        this.minRowHeight = this.table.getDefaultRowHeight() + 10;
        this.maxHtForOtherColumn = 0;
        this.columnWidth = this.table.getCellRect((int)this.currentRow, (int)this.table.getEditingColumn(), (boolean)false).width - 6;
    }

    private void calculateMaxHieghtForOtherCells() {
        int longestTextInOtherColumn = 0;
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            int length;
            Annotation ann;
            String value;
            Object c;
            if (i == this.table.getCurrentColumn() || !((c = this.table.getValueAt(this.currentRow, i)) instanceof Annotation) || (value = (ann = (Annotation)c).getValue()) == null || (length = value.length()) <= longestTextInOtherColumn) continue;
            longestTextInOtherColumn = length;
            this.maxHtForOtherColumn = this.getHeightForthisCell(ann, i);
        }
    }

    private int getHeightForthisCell(Annotation ann, int column) {
        int fontHeight = 0;
        int rowHeightValue = 0;
        FontMetrics fm = null;
        Graphics g = this.getGraphics();
        String value = ann.getValue();
        Font f = this.table.getFontForTier(ann.getTier().getName());
        if (f != null) {
            f = new Font(f.getFontName(), f.getStyle(), this.table.getFontSize());
            fm = this.getFontMetrics(f);
        } else {
            f = new Font(this.table.getFont().getFontName(), this.table.getFont().getStyle(), this.table.getFontSize());
            fm = this.getFontMetrics(f);
        }
        int height = fm.getAscent() + fm.getDescent() + 3;
        if (height > fontHeight) {
            fontHeight = height;
        }
        double width = fm.getStringBounds(value, g).getWidth() + 10.0;
        int newRowHeight = 0;
        if (width > (double)this.columnWidth) {
            int y = (int)(width / (double)this.columnWidth);
            newRowHeight = (1 + y) * fontHeight;
        } else {
            newRowHeight = fontHeight;
        }
        if (newRowHeight > rowHeightValue) {
            rowHeightValue = newRowHeight;
        }
        if (rowHeightValue > this.minRowHeight) {
            return rowHeightValue + 10;
        }
        return this.minRowHeight;
    }

    private int calculateNewHeight() {
        double width = this.fm.getStringBounds(this.textArea.getText(), this.g).getWidth() + 10.0;
        int newRowHeight = 0;
        if (width > (double)this.columnWidth) {
            int y = (int)(width / (double)this.columnWidth);
            newRowHeight = (1 + y) * this.fontHeight;
        } else {
            newRowHeight = this.fontHeight;
        }
        return newRowHeight;
    }

    private void recalculateRowHeight() {
        if (this.table == null) {
            return;
        }
        if (this.table.isEditing()) {
            if (!this.heightComputed) {
                this.initializeHeightParameterSettings();
                this.calculateMaxHieghtForOtherCells();
                this.heightComputed = true;
            }
            int currentHeight = this.table.getRowHeight(this.currentRow);
            int height = this.calculateNewHeight();
            if (this.maxHtForOtherColumn > height) {
                if (currentHeight > this.maxHtForOtherColumn) {
                    this.table.setRowHeight(this.currentRow, this.maxHtForOtherColumn);
                }
            } else if (this.minRowHeight < height) {
                this.table.setRowHeight(this.currentRow, height + 10);
            } else if (height < this.minRowHeight && currentHeight > this.minRowHeight) {
                this.table.setRowHeight(this.currentRow, this.minRowHeight);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.recalculateRowHeight();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.recalculateRowHeight();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    class CVEntryComponent {
        private JList entryList;
        private DefaultListModel entryListModel;
        private JScrollPane scrollPane;
        private MouseListener popupListener;
        private MouseListener doubleClickListener;
        private JComponent delegate;
        private CVEntry[] entries;
        private Annotation annotation;

        public CVEntryComponent(Class componentClass) {
            this.initComponents(componentClass);
        }

        public JComponent getEditorComponent() {
            return this.delegate;
        }

        void setDelegate(Class compClass) {
            if (this.delegate.getClass() == compClass) {
                return;
            }
            if (this.entryList == null) {
                this.initComponents(compClass);
            }
            this.delegate = this.scrollPane;
            this.entryListModel.clear();
            this.fillModel(true);
        }

        public void ensureSelectionIsVisible() {
            if (this.delegate instanceof JScrollPane && this.entryList != null) {
                this.entryList.ensureIndexIsVisible(this.entryList.getSelectedIndex());
            }
        }

        public ControlledVocabulary cvChanged(ControlledVocabulary cv) {
            BasicControlledVocabulary currentCV = null;
            if (this.annotation != null) {
                TierImpl tier = (TierImpl)this.annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                currentCV = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            if (currentCV != null && currentCV.equals(cv)) {
                this.fillModel(true);
                TranscriptionTableEditBox.this.commitChanges();
                TranscriptionTableEditBox.this.table.startEdit(null);
            }
            return null;
        }

        private void initComponents(Class component) {
            if (this.entryList == null) {
                this.entryListModel = new DefaultListModel();
                this.entryList = new JList(this.entryListModel);
                this.entryList.setFont(TranscriptionTableEditBox.this.getFont());
                this.entryList.setSelectionMode(0);
                this.scrollPane = new JScrollPane(this.entryList);
                if (TranscriptionTableEditBox.this.popupMenu == null) {
                    TranscriptionTableEditBox.this.createPopupMenu();
                }
                this.popupListener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                            TranscriptionTableEditBox.this.showPopUp(CVEntryComponent.this.entryList, e.getX(), e.getY());
                        }
                    }
                };
                this.doubleClickListener = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            TranscriptionTableEditBox.this.commit();
                        }
                    }
                };
                this.entryList.addMouseListener(this.popupListener);
                this.entryList.addMouseListener(this.doubleClickListener);
                this.entryList.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (CVEntryComponent.this.entries != null) {
                            int code = e.getKeyCode();
                            for (CVEntry cve : CVEntryComponent.this.entries) {
                                if (cve.getShortcutKeyCode() != code) continue;
                                if (CVEntryComponent.this.delegate == CVEntryComponent.this.scrollPane) {
                                    CVEntryComponent.this.entryList.setSelectedValue(cve, false);
                                }
                                TranscriptionTableEditBox.this.commit();
                                e.consume();
                                break;
                            }
                        }
                        if (!e.isConsumed()) {
                            TranscriptionTableEditBox.this.keyPressed(e);
                        }
                    }
                });
                this.entryList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent lse) {
                        CVEntryComponent.this.ensureSelectionIsVisible();
                    }
                });
                this.delegate = this.scrollPane;
            }
        }

        public void setFont(Font f) {
            if (this.delegate == this.scrollPane) {
                this.entryList.setFont(f);
            }
        }

        public void setAnnotation(Annotation annotation) {
            ControlledVocabulary oldCV = null;
            if (this.annotation != null) {
                TierImpl tier = (TierImpl)this.annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                oldCV = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            this.annotation = annotation;
            BasicControlledVocabulary cv = null;
            if (annotation != null) {
                TierImpl tier = (TierImpl)annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                cv = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            if (cv != null) {
                if (cv != oldCV || !(cv instanceof ExternalCV)) {
                    this.entries = cv.getEntries();
                    if (this.entryListModel != null) {
                        this.entryListModel.clear();
                    }
                    this.fillModel(true);
                } else {
                    this.fillModel(false);
                }
            } else {
                this.entries = new CVEntry[0];
                if (this.entryListModel != null) {
                    this.entryListModel.clear();
                }
                this.fillModel(false);
            }
        }

        private void fillModel(boolean reload) {
            String value = null;
            if (this.annotation != null) {
                value = this.annotation.getValue();
            }
            if (this.delegate == this.scrollPane) {
                if (reload) {
                    for (int i = 0; i < this.entries.length; ++i) {
                        this.entryListModel.addElement(this.entries[i]);
                        if (value == null || !value.equals(this.entries[i].getValue())) continue;
                        this.entryList.setSelectedIndex(i);
                    }
                } else if (value != null) {
                    for (int i = 0; i < this.entryListModel.size(); ++i) {
                        CVEntry entry = (CVEntry)this.entryListModel.getElementAt(i);
                        if (!value.equals(entry.getValue())) continue;
                        this.entryList.setSelectedIndex(i);
                        break;
                    }
                }
                this.entryList.setSelectedIndex(-1);
            }
        }

        public void grabFocus() {
            if (this.delegate == this.scrollPane) {
                this.entryList.requestFocus();
                this.entryList.ensureIndexIsVisible(this.entryList.getSelectedIndex());
            }
        }

        public String getSelectedEntryValue() {
            String value = null;
            if (this.delegate == this.scrollPane && this.entryList.getSelectedValue() != null) {
                value = ((CVEntry)this.entryList.getSelectedValue()).getValue();
            }
            return value;
        }

        public CVEntry getSelectedEntry() {
            CVEntry value = null;
            if (this.delegate == this.scrollPane && this.entryList.getSelectedValue() != null) {
                value = (CVEntry)this.entryList.getSelectedValue();
            }
            return value;
        }
    }
}

