/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class AnnotationSlicer {
    public static ArrayList<Long> getTimeValues(List<TierImpl> tierList) {
        if (tierList == null) {
            return null;
        }
        ArrayList<Long> timeSlotList = new ArrayList<Long>();
        TierImpl tier = null;
        for (int i = 0; i < tierList.size(); ++i) {
            tier = tierList.get(i);
            Vector annotations = tier.getAnnotations();
            for (int a = 0; a < annotations.size(); ++a) {
                long time = ((Annotation)annotations.get(a)).getBeginTimeBoundary();
                if (!timeSlotList.contains(time)) {
                    timeSlotList.add(time);
                }
                if (timeSlotList.contains(time = ((Annotation)annotations.get(a)).getEndTimeBoundary())) continue;
                timeSlotList.add(time);
            }
        }
        Collections.sort(timeSlotList);
        return timeSlotList;
    }

    public static HashMap<Long, ArrayList<Annotation>> getAnnotationMap(ArrayList<Long> timeValuesList, ArrayList<TierImpl> tierList) {
        HashMap<Long, ArrayList<Annotation>> map = new HashMap<Long, ArrayList<Annotation>>();
        for (int i = 0; i < timeValuesList.size(); ++i) {
            long currentTimeValue = timeValuesList.get(i);
            ArrayList<Annotation> annList = new ArrayList<Annotation>();
            for (int t = 0; t < tierList.size(); ++t) {
                Annotation ann = tierList.get(t).getAnnotationAtTime(currentTimeValue);
                if (ann == null) continue;
                annList.add(ann);
            }
            map.put(currentTimeValue, annList);
        }
        return map;
    }
}

