/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mpi.eudico.client.annotator.lexicon.api.LexSrvcAvailabilityDetector;
import mpi.eudico.client.annotator.recognizer.api.RecogAvailabilityDetector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.ExtClassLoader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class AvailabilityDetector {
    private static final int LEXICON_CMDI = 0;
    private static final int RECOGNIZER_CMDI = 1;
    private static CMDIParser parser;
    private static boolean initialized;

    protected AvailabilityDetector() {
    }

    public static void loadFilesFromExtensionsFolder() {
        File[] files;
        if (initialized) {
            return;
        }
        File extFile = new File(ExtClassLoader.EXTENSIONS_DIR);
        if (!extFile.exists()) {
            ClientLogger.LOG.warning("The extension folder could not be found (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        if (!extFile.isDirectory()) {
            ClientLogger.LOG.warning("The extension 'folder' is not a folder (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        if (!extFile.canRead()) {
            ClientLogger.LOG.warning("The extension folder is not accessible (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        for (File f : files = extFile.listFiles()) {
            if (f.isDirectory()) {
                AvailabilityDetector.detectFromFolder(f);
                continue;
            }
            String name = f.getName().toLowerCase();
            if (name.endsWith("jar")) {
                AvailabilityDetector.detectFromJar(f);
                continue;
            }
            if (!name.endsWith("zip")) continue;
            AvailabilityDetector.detectFromZip(f);
        }
        initialized = true;
    }

    private static void detectFromFolder(File folder) {
        File[] files = folder.listFiles();
        ArrayList<URL> libs = null;
        ArrayList<URL> natLibs = null;
        boolean cmdiFound = false;
        boolean libsAdded = false;
        for (File f : files) {
            if (!f.getName().toLowerCase().endsWith(".cmdi") || f.getName().startsWith(".")) continue;
            try {
                int type = AvailabilityDetector.getCMDIType(new FileInputStream(f));
                if (type <= -1) continue;
                if (!libsAdded) {
                    libs = new ArrayList<URL>();
                    natLibs = new ArrayList<URL>();
                    AvailabilityDetector.addLibs(folder, libs, natLibs);
                    libsAdded = true;
                }
                boolean bool = AvailabilityDetector.createBundle(type, new FileInputStream(f), libs, natLibs, folder);
                if (cmdiFound) continue;
                cmdiFound = bool;
            }
            catch (FileNotFoundException fnfe) {
                ClientLogger.LOG.severe("File not found:" + fnfe.getMessage());
            }
        }
        if (!cmdiFound) {
            ClientLogger.LOG.severe("No cmdi metadata file found in: " + folder.getName());
        }
    }

    private static void detectFromJar(File file) {
        try {
            JarFile jFile = new JarFile(file);
            ArrayList<URL> libs = null;
            ArrayList<URL> natLibs = null;
            boolean cmdiFound = false;
            boolean libsAdded = false;
            Enumeration<JarEntry> entries = jFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (!je.getName().toLowerCase().endsWith(".cmdi") || je.getName().startsWith(".")) continue;
                try {
                    int type = AvailabilityDetector.getCMDIType(jFile.getInputStream(je));
                    if (type <= -1) continue;
                    if (!libsAdded) {
                        libs = new ArrayList<URL>();
                        natLibs = new ArrayList<URL>();
                        AvailabilityDetector.addLibs(file, libs, natLibs);
                        libsAdded = true;
                    }
                    boolean bool = AvailabilityDetector.createBundle(type, jFile.getInputStream(je), libs, natLibs, file.getParentFile());
                    if (cmdiFound) continue;
                    cmdiFound = bool;
                }
                catch (MalformedURLException mue) {
                    ClientLogger.LOG.severe("Cannot create URL for file: " + file.getName());
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Cannot read the cmdi file from the jar file: " + file.getName());
                }
            }
            if (!cmdiFound) {
                ClientLogger.LOG.warning("No plug-in cmdi metadata file found in " + file.getName());
                return;
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot read the jar file: " + file.getName());
        }
    }

    private static void detectFromZip(File file) {
        try {
            ZipFile zFile = new ZipFile(file);
            ArrayList<URL> libs = null;
            ArrayList<URL> natLibs = null;
            boolean cmdiFound = false;
            boolean libsAdded = false;
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (!ze.getName().toLowerCase().endsWith(".cmdi") || ze.getName().startsWith(".")) continue;
                try {
                    int type = AvailabilityDetector.getCMDIType(zFile.getInputStream(ze));
                    if (type <= -1) continue;
                    if (!libsAdded) {
                        libs = new ArrayList<URL>();
                        natLibs = new ArrayList<URL>();
                        AvailabilityDetector.addLibs(file, libs, natLibs);
                        libsAdded = true;
                    }
                    boolean bool = AvailabilityDetector.createBundle(type, zFile.getInputStream(ze), libs, natLibs, file.getParentFile());
                    if (cmdiFound) continue;
                    cmdiFound = bool;
                }
                catch (MalformedURLException mue) {
                    ClientLogger.LOG.severe("Cannot create URL for file: " + file.getName());
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Cannot read the cmdi file from the zip file: " + file.getName());
                }
            }
            if (!cmdiFound) {
                ClientLogger.LOG.warning("No plug-in cmdi metadata file found in " + file.getName());
                return;
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot read the zip file: " + file.getName());
        }
    }

    private static int getCMDIType(InputStream stream) {
        parser = new CMDIParser(stream);
        try {
            parser.parse();
            stream.close();
            return parser.getCMDIType();
        }
        catch (SAXException se) {
            ClientLogger.LOG.severe("Cannot parse metadata file: " + stream.toString() + " :" + se.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe(ioe.getMessage());
        }
        return -1;
    }

    private static boolean createBundle(int type, InputStream stream, List<URL> libs, List<URL> natLibs, File basedir) {
        if (type > -1) {
            URL[] libUrls = null;
            if (libs.size() > 0) {
                libUrls = libs.toArray(new URL[0]);
            }
            URL[] natLibUrls = null;
            if (natLibs.size() > 0) {
                natLibUrls = natLibs.toArray(new URL[0]);
            }
            switch (type) {
                case 0: {
                    LexSrvcAvailabilityDetector.createBundle(stream, libUrls, natLibUrls, basedir);
                    break;
                }
                case 1: {
                    RecogAvailabilityDetector.createBundle(stream, libUrls, natLibUrls, basedir);
                }
            }
            return true;
        }
        return false;
    }

    private static void addLibs(File file, List<URL> libs, List<URL> natLibs) {
        String name = file.getName().toLowerCase();
        if (name.endsWith("jar") || name.endsWith("zip")) {
            try {
                libs.add(file.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                ClientLogger.LOG.severe("Cannot create URL for file: " + file.getName());
            }
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                try {
                    if (f.isDirectory()) {
                        AvailabilityDetector.addLibs(f, libs, natLibs);
                        continue;
                    }
                    name = f.getName().toLowerCase();
                    if (name.endsWith("jar") || name.endsWith("zip")) {
                        try {
                            libs.add(f.toURI().toURL());
                        }
                        catch (MalformedURLException mue) {
                            ClientLogger.LOG.severe("Cannot create URL for file: " + f.getName());
                        }
                        continue;
                    }
                    if (!name.endsWith("dll") && !name.endsWith("so") && !name.endsWith("jnilib")) continue;
                    try {
                        natLibs.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        ClientLogger.LOG.severe("Cannot create URL for file: " + f.getName());
                    }
                }
                catch (SecurityException se) {
                    ClientLogger.LOG.warning("Cannot read file: " + f.getName());
                }
            }
        }
    }

    static {
        initialized = false;
    }

    private static class CMDIParser
    implements ContentHandler {
        private InputStream inputStream;
        private int cmdi_type = -1;

        public CMDIParser(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void parse() throws SAXException {
            if (this.inputStream != null) {
                try {
                    XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                    reader.setContentHandler(this);
                    reader.parse(new InputSource(this.inputStream));
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
            } else {
                throw new SAXException("No input stream specified");
            }
        }

        public int getCMDIType() {
            return this.cmdi_type;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            if (name.equals("RECOGNIZER")) {
                if (this.cmdi_type == -1) {
                    this.cmdi_type = 1;
                }
            } else if (name.equals("lexiconserviceclient") && this.cmdi_type == -1) {
                this.cmdi_type = 0;
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

