/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MonitoringLogger {
    public static final String CHANGE_ANNOTATION_TIME = ElanLocale.getString("MonitorLoggingEvent.Change_Ann_Time");
    public static final String CHANGE_ANNOTATION_VALUE = ElanLocale.getString("MonitorLoggingEvent.Change_Ann_Val");
    public static final String CLOSE_FILE = ElanLocale.getString("MonitorLoggingEvent.Close_File");
    public static final String CREATE_DEPENDING_ANNOTATIONS = ElanLocale.getString("MonitorLoggingEvent.Create_Depending_Annotations");
    public static final String DELETE_ANNOTATION = ElanLocale.getString("MonitorLoggingEvent.Delete_Annotation");
    public static final String DELETE_MULTIPLE_ANNOTATION = ElanLocale.getString("MonitorLoggingEvent.Delete_Multiple_Annotation");
    public static final String EXIT_ELAN = ElanLocale.getString("MonitorLoggingEvent.Exit_Elan");
    public static final String MERGE_ANNOTATION = ElanLocale.getString("MonitorLoggingEvent.Merge_Annotation");
    public static final String MONITORING_PAUSED = ElanLocale.getString("MonitorLoggingEvent.Monitoring_Paused");
    public static final String MONITORING_STARTED = ElanLocale.getString("MonitorLoggingEvent.Monitoring_Started");
    public static final String MONITORING_STOPPED = ElanLocale.getString("MonitorLoggingEvent.Monitoring_Stopped");
    public static final String NEW_ANNOTATION = ElanLocale.getString("MonitorLoggingEvent.New_Annotation");
    public static final String NEW_FILE = ElanLocale.getString("MonitorLoggingEvent.New_File");
    public static final String OPEN_FILE = ElanLocale.getString("MonitorLoggingEvent.Open_File");
    public static final String SAVE_FILE = ElanLocale.getString("MonitorLoggingEvent.Save_File");
    public static final String SPLIT_ANNOTATION = ElanLocale.getString("MonitorLoggingEvent.Split_Annotation");
    public static final String RECOGNIZER_STARTED = ElanLocale.getString("MonitorLoggingEvent.Recognizer_Started");
    public static final String RECURSIVE_ANNOTATIONS = ElanLocale.getString("MonitorLoggingEvent.Recursive_Annotations");
    public static final String REDO = ElanLocale.getString("MonitorLoggingEvent.Redo");
    public static final String UNDO = ElanLocale.getString("MonitorLoggingEvent.Undo");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS");
    private static final DateFormat dateFormat1 = new SimpleDateFormat("mm:ss.SSS");
    private static final DateFormat dateFormat2 = new SimpleDateFormat("ss.SSS");
    private static final DateFormat dateFormat3 = new SimpleDateFormat("SSS");
    private static HashMap<Transcription, MonitoringLogger> loggerMap;
    private static boolean appendDataToFile;
    private static boolean newFilesPerSession;
    private static boolean monitoringStarted;
    private static boolean monitoringInitiated;
    private static Calendar cal;
    private static String path;
    private static MonitoringLogger globalLogger;
    private StringBuilder buffer = new StringBuilder();
    private HashMap<Integer, StringBuilder> bufferMap;
    private int noOfSessions = 0;
    private int fileIndex = -1;
    private Transcription transcription;
    private boolean useDefaultPath = true;

    private MonitoringLogger(boolean global) {
    }

    public static MonitoringLogger getLogger(Transcription trans) {
        if (monitoringInitiated) {
            if (trans == null) {
                if (globalLogger == null) {
                    globalLogger = new MonitoringLogger(true);
                    MonitoringLogger.globalLogger.transcription = trans;
                }
                return globalLogger;
            }
            if (loggerMap == null) {
                loggerMap = new HashMap();
            }
            if (loggerMap.get(trans) != null) {
                return loggerMap.get(trans);
            }
            MonitoringLogger logger = new MonitoringLogger(false);
            logger.transcription = trans;
            loggerMap.put(trans, logger);
            return logger;
        }
        return null;
    }

    public static boolean isInitiated() {
        return monitoringInitiated;
    }

    public static void startMonitoring(boolean start) {
        monitoringStarted = start;
        monitoringInitiated = true;
        MonitoringLogger.readPreferrences();
    }

    private static void readPreferrences() {
        Object val = Preferences.get("ActivityMonitoring.AppendToFile", null);
        if (val instanceof Boolean) {
            appendDataToFile = (Boolean)val;
        }
        if ((val = Preferences.get("ActivityMonitoring.FilesPerSession", null)) instanceof Boolean) {
            newFilesPerSession = (Boolean)val;
        }
    }

    public static void setDirectory(String path) {
        if (MonitoringLogger.path == null || !MonitoringLogger.path.equals(path)) {
            MonitoringLogger.path = path;
            if (loggerMap != null) {
                MonitoringLogger logger = null;
                Iterator<Transcription> keyIt = loggerMap.keySet().iterator();
                while (keyIt.hasNext()) {
                    logger = loggerMap.get(keyIt.next());
                    logger.fileIndex = -1;
                }
            }
        }
    }

    public static void setAppendFileFlag(boolean append) {
        appendDataToFile = append;
    }

    public static void createNewFilesPerSession(boolean create) {
        newFilesPerSession = create;
    }

    public void log(String event, String ... args) {
        if (!monitoringStarted) {
            return;
        }
        cal = Calendar.getInstance();
        this.buffer.append(System.currentTimeMillis());
        this.buffer.append('\t');
        this.buffer.append(dateFormat.format(cal.getTime()));
        this.buffer.append('\t');
        this.buffer.append(dateFormat1.format(cal.getTime()));
        this.buffer.append('\t');
        this.buffer.append(dateFormat2.format(cal.getTime()));
        this.buffer.append('\t');
        this.buffer.append(dateFormat3.format(cal.getTime()));
        this.buffer.append('\t');
        this.buffer.append(event);
        for (String i : args) {
            this.buffer.append('\t');
            i.replaceAll("\\n", " ");
            this.buffer.append(i);
        }
        this.buffer.append('\n');
        if (CLOSE_FILE.equals(event)) {
            this.writeFile();
            if (this.transcription != null) {
                loggerMap.remove(this.transcription);
            }
            this.transcription = null;
            this.buffer = null;
        }
        if (newFilesPerSession && MONITORING_STOPPED.equals(event)) {
            this.createNewSessionFile();
        }
    }

    private void createNewSessionFile() {
        if (this == globalLogger) {
            return;
        }
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
        }
        this.bufferMap.put(++this.noOfSessions, this.buffer);
        this.buffer = new StringBuilder();
    }

    public static void logInAllLoggers(String event, String ... args) {
        if (!monitoringStarted) {
            return;
        }
        if (globalLogger != null) {
            globalLogger.log(event, args);
        }
        if (loggerMap == null) {
            return;
        }
        MonitoringLogger logger = null;
        Iterator<Transcription> keyIt = loggerMap.keySet().iterator();
        while (keyIt.hasNext()) {
            logger = loggerMap.get(keyIt.next());
            if (logger == null) continue;
            logger.log(event, args);
        }
    }

    public static void exitElan() {
        if (globalLogger != null) {
            globalLogger.log(EXIT_ELAN, new String[0]);
        }
        if (loggerMap == null) {
            return;
        }
        MonitoringLogger logger = null;
        Iterator<Transcription> keyIt = loggerMap.keySet().iterator();
        while (keyIt.hasNext()) {
            logger = loggerMap.get(keyIt.next());
            if (logger == null) continue;
            logger.log(EXIT_ELAN, new String[0]);
        }
    }

    private void writeFile() {
        if (this == globalLogger) {
            return;
        }
        String transName = ((TranscriptionImpl)this.transcription).getName();
        if (!transName.endsWith(".eaf")) {
            return;
        }
        String fileName = transName.substring(0, transName.length() - 4);
        if (path != null) {
            File logFile = new File(path);
            this.useDefaultPath = !logFile.isDirectory() || !logFile.exists();
        }
        String filePath = null;
        if (this.useDefaultPath) {
            filePath = ((TranscriptionImpl)this.transcription).getPathName();
            filePath = filePath.substring(0, filePath.length() - transName.length() - 1);
        } else {
            filePath = path;
        }
        String filePrefix = null;
        String file = null;
        if (this.noOfSessions > 0) {
            filePrefix = fileName + "-";
            while (this.noOfSessions > 0) {
                if (this.fileIndex < 0) {
                    this.computeFileIndex(filePath, filePrefix);
                }
                ++this.fileIndex;
                file = filePath.trim() + "/" + filePrefix + this.fileIndex + ".txt";
                this.write(file, this.bufferMap.get(this.noOfSessions));
                --this.noOfSessions;
            }
        }
        if (newFilesPerSession) {
            if (filePrefix == null) {
                filePrefix = fileName + "-";
            }
            if (this.fileIndex < 0) {
                this.computeFileIndex(filePath, filePrefix);
            }
            ++this.fileIndex;
            file = filePath.trim() + "/" + filePrefix + this.fileIndex + ".txt";
        } else {
            file = filePath.trim() + "/" + fileName + ".txt";
        }
        this.write(file, this.buffer);
    }

    private void write(String file, StringBuilder buffer) {
        FileWriter fstream = null;
        File logFile = new File(file);
        try {
            fstream = logFile.exists() ? new FileWriter(file, appendDataToFile) : new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(buffer.toString());
            out.close();
            buffer.delete(0, buffer.length() - 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void computeFileIndex(String folder, final String filePreffix) {
        File dir = new File(folder);
        Object[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(filePreffix) && name.endsWith(".txt");
            }
        });
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (files != null) {
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                Object name = files[i];
                if (((String)(name = ((String)name).substring(filePreffix.length(), ((String)name).length() - 4))).length() <= 0) continue;
                try {
                    int n = Integer.parseInt((String)name);
                    indexes.add(n);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (indexes.size() > 0) {
            Collections.sort(indexes);
            this.fileIndex = (Integer)indexes.get(indexes.size() - 1);
        } else {
            this.fileIndex = -1;
        }
    }

    static {
        appendDataToFile = true;
        newFilesPerSession = false;
        monitoringStarted = false;
        monitoringInitiated = false;
    }
}

