/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.File;
import java.util.Map;
import mpi.eudico.client.annotator.util.ClientLogger;

public class SystemReporting {
    public static final String OS_NAME;
    public static final String USER_HOME;
    public static boolean antiAliasedText;
    private static boolean isMacOS;
    private static boolean isWindows;
    private static boolean isVista;
    private static boolean isWin7;
    private static boolean isLinux;

    public static boolean isMacOS() {
        return isMacOS;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isWindowsVista() {
        return isVista;
    }

    public static boolean isWindows7OrHigher() {
        return isWin7;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void printProperty(String prop) {
        System.out.println(prop + " = " + System.getProperty(prop));
    }

    public static File getLibExtDir() {
        if (OS_NAME.startsWith("Mac OS X")) {
            String useBI = System.getProperty("useBufferedImage");
            if (useBI == null) {
                System.setProperty("useBufferedImage", "true");
            }
            return SystemReporting.verifyMacUserLibExt();
        }
        return new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext");
    }

    public static File[] getLibExt() {
        File ext = SystemReporting.getLibExtDir();
        if (ext != null && ext.exists()) {
            return SystemReporting.getLibExtDir().listFiles();
        }
        return null;
    }

    private static File verifyMacUserLibExt() {
        String userLibJavaExt = USER_HOME + "/Library/Java/Extensions";
        File userLibExt = new File(userLibJavaExt);
        if (!userLibExt.exists()) {
            try {
                boolean success = userLibExt.mkdirs();
                if (!success) {
                    ClientLogger.LOG.warning("Unable to create folder: " + userLibExt);
                    return null;
                }
            }
            catch (SecurityException se) {
                ClientLogger.LOG.warning("Unable to create folder: " + userLibExt);
                ClientLogger.LOG.warning("Cause: " + se.getMessage());
                return null;
            }
        }
        return userLibExt;
    }

    public static void printLibExt() {
        File[] potext = SystemReporting.getLibExt();
        int NOFfiles = potext == null ? 0 : potext.length;
        System.out.println("Found " + NOFfiles + " potential extension(s)");
        for (int i = 0; i < NOFfiles; ++i) {
            System.out.println("\t" + potext[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        SystemReporting.printProperty("java.home");
        SystemReporting.printLibExt();
    }

    static {
        String awtRH;
        Object aaHint;
        Map map;
        antiAliasedText = false;
        isVista = false;
        isWin7 = false;
        OS_NAME = System.getProperty("os.name");
        USER_HOME = System.getProperty("user.home");
        String lowerOS = OS_NAME.toLowerCase();
        if (lowerOS.indexOf("win") > -1) {
            isWindows = true;
        } else if (lowerOS.indexOf("mac") > -1) {
            isMacOS = true;
        } else if (lowerOS.indexOf("lin") > -1) {
            isLinux = true;
        }
        String version = System.getProperty("os.version");
        try {
            if (version.indexOf(46) > -1) {
                String[] verTokens = version.split("\\.");
                int major = Integer.parseInt(verTokens[0]);
                if (verTokens.length > 1) {
                    int minor = Integer.parseInt(verTokens[1]);
                    if (major > 6) {
                        isWin7 = true;
                    } else if (major == 6) {
                        if (minor > 0) {
                            isWin7 = true;
                        } else {
                            isVista = true;
                        }
                    }
                }
            } else {
                int major = Integer.parseInt(version);
                if (major > 6) {
                    isWin7 = true;
                } else if (major == 6) {
                    isVista = true;
                }
            }
        }
        catch (NumberFormatException nfe) {
            ClientLogger.LOG.warning("Unable to parse the Windows version.");
        }
        String atp = System.getProperty("swing.aatext");
        if ("true".equals(atp)) {
            antiAliasedText = true;
        }
        if ((map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) != null && RenderingHints.VALUE_TEXT_ANTIALIAS_OFF != (aaHint = map.get(RenderingHints.KEY_TEXT_ANTIALIASING))) {
            antiAliasedText = true;
        }
        if ("on".equals(awtRH = System.getProperty("awt.useSystemAAFontSettings"))) {
            antiAliasedText = true;
        } else if (map != null && ("off".equals(awtRH) || "false".equals(awtRH) || "default".equals(awtRH))) {
            antiAliasedText = false;
        }
    }
}

