/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.ArrayList;
import java.util.Iterator;
import mpi.eudico.client.annotator.util.Tag2D;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class Tier2D {
    private TierImpl tier;
    private ArrayList tags;
    private String name;
    private boolean isActiveTier;

    public Tier2D(TierImpl tier) {
        this.tier = tier;
        this.name = tier.getName();
        this.isActiveTier = false;
        this.tags = new ArrayList(20);
    }

    public TierImpl getTier() {
        return this.tier;
    }

    public void addTag(Tag2D tag) {
        this.tags.add(tag);
        tag.setTier2D(this);
    }

    public void insertTag(Tag2D tag) {
        tag.setTier2D(this);
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag2D t1 = (Tag2D)this.tags.get(i);
            if ((i == 0 || i == this.tags.size() - 1) && tag.getX() < t1.getX()) {
                this.tags.add(i, tag);
                return;
            }
            if (i >= this.tags.size() - 1) continue;
            Tag2D t2 = (Tag2D)this.tags.get(i + 1);
            if (tag.getX() <= t1.getX() || tag.getX() >= t2.getX()) continue;
            this.tags.add(i + 1, tag);
            return;
        }
        this.tags.add(tag);
    }

    public void removeTag(Tag2D tag) {
        this.tags.remove(tag);
    }

    public Iterator getTags() {
        return this.tags.iterator();
    }

    public ArrayList getTagsList() {
        return this.tags;
    }

    public String getName() {
        return this.name;
    }

    public void updateName() {
        String old = this.name;
        if (!old.equals(this.tier.getName())) {
            this.name = this.tier.getName();
        }
    }

    public void setActive(boolean active) {
        this.isActiveTier = active;
    }

    public boolean isActive() {
        return this.isActiveTier;
    }
}

