/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import com.apple.eawt.event.GestureAdapter;
import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GesturePhaseEvent;
import com.apple.eawt.event.GestureUtilities;
import com.apple.eawt.event.MagnificationEvent;
import com.apple.eawt.event.SwipeEvent;
import javax.swing.JComponent;
import mpi.eudico.client.annotator.viewer.GestureDispatcher;
import mpi.eudico.client.annotator.viewer.GesturesListener;

public class GestureMacDispatcher
extends GestureAdapter
implements GestureDispatcher {
    private GesturesListener listener;
    private JComponent component;
    private Swiper curThread = null;

    public GestureMacDispatcher(JComponent component, GesturesListener listener) {
        this.component = component;
        this.listener = listener;
    }

    @Override
    public void connect() {
        if (this.component != null) {
            GestureUtilities.addGestureListenerTo((JComponent)this.component, (GestureListener)this);
        }
    }

    @Override
    public void disconnect() {
        this.listener = null;
        if (this.component != null) {
            GestureUtilities.removeGestureListenerFrom((JComponent)this.component, (GestureListener)this);
        }
        this.component = null;
    }

    public void magnify(MagnificationEvent event) {
        if (this.listener != null) {
            this.listener.magnify(event.getMagnification());
        }
    }

    public void swipedDown(SwipeEvent event) {
        if (this.listener != null) {
            if (this.curThread != null && this.curThread.isAlive()) {
                try {
                    this.curThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.curThread = new Swiper(SWIPE_DIRECTION.DOWN);
            this.curThread.start();
        }
    }

    public void swipedLeft(SwipeEvent event) {
        if (this.listener != null) {
            if (this.curThread != null && this.curThread.isAlive()) {
                if (this.curThread.getDirection() == SWIPE_DIRECTION.LEFT) {
                    this.curThread.amplifyGesture();
                    return;
                }
                try {
                    this.curThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.curThread = new Swiper(SWIPE_DIRECTION.LEFT);
            this.curThread.start();
        }
    }

    public void swipedRight(SwipeEvent event) {
        if (this.listener != null) {
            if (this.curThread != null && this.curThread.isAlive()) {
                if (this.curThread.getDirection() == SWIPE_DIRECTION.RIGHT) {
                    this.curThread.amplifyGesture();
                    return;
                }
                try {
                    this.curThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.curThread = new Swiper(SWIPE_DIRECTION.RIGHT);
            this.curThread.start();
        }
    }

    public void swipedUp(SwipeEvent event) {
        if (this.listener != null) {
            if (this.curThread != null && this.curThread.isAlive()) {
                try {
                    this.curThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.curThread = new Swiper(SWIPE_DIRECTION.UP);
            this.curThread.start();
        }
    }

    public void gestureBegan(GesturePhaseEvent event) {
    }

    public void gestureEnded(GesturePhaseEvent event) {
    }

    private class Swiper
    extends Thread {
        private SWIPE_DIRECTION direction;
        private final int[] HOR_AMOUNTS = new int[]{200, 170, 140, 110, 90, 75, 55, 38, 28, 19, 10, 8, 7, 6, 5, 4, 3, 2, 1};
        private final int[] VER_AMOUNTS = new int[]{56, 40, 28, 18, 10, 8, 7, 6, 5, 4, 3, 2, 1};
        private volatile int numIncreases = 0;

        public Swiper(SWIPE_DIRECTION direction) {
            this.direction = direction;
        }

        public void amplifyGesture() {
            ++this.numIncreases;
        }

        public SWIPE_DIRECTION getDirection() {
            return this.direction;
        }

        @Override
        public void run() {
            int maxCount = 0;
            maxCount = this.direction == SWIPE_DIRECTION.LEFT || this.direction == SWIPE_DIRECTION.RIGHT ? this.HOR_AMOUNTS.length : this.VER_AMOUNTS.length;
            int count = 0;
            while (count < maxCount && !this.isInterrupted()) {
                if (this.direction == SWIPE_DIRECTION.LEFT) {
                    if (GestureMacDispatcher.this.listener != null) {
                        GestureMacDispatcher.this.listener.swipe(this.HOR_AMOUNTS[count], 0);
                    }
                } else if (this.direction == SWIPE_DIRECTION.RIGHT) {
                    if (GestureMacDispatcher.this.listener != null) {
                        GestureMacDispatcher.this.listener.swipe(-this.HOR_AMOUNTS[count], 0);
                    }
                } else if (this.direction == SWIPE_DIRECTION.UP) {
                    if (GestureMacDispatcher.this.listener != null) {
                        GestureMacDispatcher.this.listener.swipe(0, -this.VER_AMOUNTS[count]);
                    }
                } else if (this.direction == SWIPE_DIRECTION.DOWN && GestureMacDispatcher.this.listener != null) {
                    GestureMacDispatcher.this.listener.swipe(0, this.VER_AMOUNTS[count]);
                }
                ++count;
                try {
                    Thread.sleep(15 + 2 * count);
                }
                catch (InterruptedException ie) {
                    break;
                }
                if (this.numIncreases <= 0) continue;
                count = 0;
                --this.numIncreases;
            }
        }
    }

    private static enum SWIPE_DIRECTION {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

