/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.prefs.PreferencesReader;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;

public class PraatConnection {
    private static final String PRAAT_SCRIPT = "openpraat-v3.praat";
    public static final String PRAAT_CLIP_SCRIPT = "createsoundclip-v3.praat";
    private static String scriptFileName;
    private static final String PRAAT_APP = "Praat app";
    private static final String SENDPRAAT_APP = "Sendpraat app";
    private static final String PRAAT_PREFS_FILE;
    private static final String PRAAT_PREFS_XML_FILE;
    static boolean isPraatRunning;
    private static final Logger LOG;
    private static Map preferences;

    private PraatConnection() {
    }

    public static void openInPraat(final String fileName, final long begintime, final long endtime) {
        new Thread(){

            @Override
            public void run() {
                if (!PraatConnection.checkScript()) {
                    JOptionPane.showMessageDialog(new JFrame(), ElanLocale.getString("PraatConnection.Message.NoScript"), ElanLocale.getString("Message.Warning"), 2);
                    LOG.warning("Praat script could not be created");
                    return;
                }
                if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                    PraatConnection.openWindowsPraat(fileName, begintime, endtime);
                } else {
                    PraatConnection.openOtherPraat(fileName, begintime, endtime);
                }
            }
        }.start();
    }

    public static void clipWithPraat(final String fileName, final long begintime, final long endtime) {
        new Thread(){

            @Override
            public void run() {
                if (!PraatConnection.checkClipScript()) {
                    JOptionPane.showMessageDialog(new JFrame(), ElanLocale.getString("PraatConnection.Message.NoScript"), ElanLocale.getString("Message.Warning"), 2);
                    LOG.warning("Praat script could not be created");
                    return;
                }
                if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                    PraatConnection.openWindowsPraat(fileName, begintime, endtime);
                } else {
                    PraatConnection.openOtherPraat(fileName, begintime, endtime);
                }
            }
        }.start();
    }

    private static void openWindowsPraat(String fileName, long begintime, long endtime) {
        if (fileName != null) {
            if (fileName.startsWith("///")) {
                fileName = fileName.substring(3);
            }
            if ((fileName = fileName.replace('/', '\\')).indexOf(32) > 0) {
                fileName = PraatConnection.spacelessWindowsPath(fileName);
            }
        } else {
            LOG.warning("Praat: media file is null");
            return;
        }
        String praatExe = PraatConnection.getPreference(PRAAT_APP);
        if (praatExe == null || praatExe.length() == 0) {
            praatExe = "Praat.exe";
        }
        String[] praatCom = new String[]{praatExe};
        try {
            Runtime.getRuntime().exec(praatCom);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                LOG.info("Thread interrupted in sleep: " + ie.getMessage());
            }
        }
        catch (SecurityException se) {
            JOptionPane.showMessageDialog(new JFrame(), ElanLocale.getString("PraatConnection.Message.Security"), ElanLocale.getString("Message.Warning"), 2);
            LOG.warning("Cannot execute Praat (security): " + se.getMessage());
            return;
        }
        catch (IOException ioe) {
            LOG.warning("Cannot execute Praat (io): " + ioe.getMessage());
            String path = PraatConnection.locatePraat();
            if (path == null) {
                return;
            }
            PraatConnection.openWindowsPraat(fileName, begintime, endtime);
            return;
        }
        String sendpraatExe = PraatConnection.getPreference(SENDPRAAT_APP);
        if (sendpraatExe == null || sendpraatExe.length() == 0) {
            sendpraatExe = "sendpraat.exe";
        }
        String executeCom = "execute " + scriptFileName + " \"" + fileName + "\" " + String.valueOf(begintime) + " " + String.valueOf(endtime);
        String[] sendpraatCom = new String[]{sendpraatExe, "Praat", executeCom};
        try {
            Runtime.getRuntime().exec(sendpraatCom);
        }
        catch (SecurityException se) {
            JOptionPane.showMessageDialog(new JFrame(), ElanLocale.getString("PraatConnection.Message.Security"), ElanLocale.getString("Message.Warning"), 2);
            LOG.warning("Cannot execute Praat (security):" + se.getMessage());
            return;
        }
        catch (IOException ioe) {
            LOG.warning("Cannot execute Praat (io):" + ioe.getMessage());
            String path = PraatConnection.locateSendpraat();
            if (path == null) {
                return;
            }
            PraatConnection.openWindowsPraat(fileName, begintime, endtime);
        }
    }

    private static void openOtherPraat(String fileName, long begintime, long endtime) {
        String sendpraatExe;
        if (fileName != null) {
            if (fileName.startsWith("///")) {
                fileName = fileName.substring(2);
            }
        } else {
            LOG.warning("Praat: media file is null");
            return;
        }
        String praatExe = PraatConnection.getPreference(PRAAT_APP);
        if (praatExe == null) {
            praatExe = PraatConnection.locatePraat();
            if (praatExe.length() == 0) {
                praatExe = "praat";
            }
        } else if (praatExe.length() == 0) {
            praatExe = "praat";
        }
        isPraatRunning = false;
        PraatConnection.checkUnixPraatProcess();
        try {
            Thread.sleep(700L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (!isPraatRunning) {
            String[] praatCom = new String[]{praatExe};
            try {
                Runtime.getRuntime().exec(praatCom);
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException ie) {
                    LOG.info("Interrupted in sleep: " + ie.getMessage());
                }
            }
            catch (SecurityException se) {
                JOptionPane.showMessageDialog(new JFrame(), ElanLocale.getString("PraatConnection.Message.Security"), ElanLocale.getString("Message.Warning"), 2);
                LOG.warning("Cannot execute Praat (security): " + se.getMessage());
                return;
            }
            catch (IOException ioe) {
                LOG.warning("Cannot execute Praat (io): " + ioe.getMessage());
                String path = PraatConnection.locatePraat();
                if (path == null) {
                    return;
                }
                PraatConnection.openOtherPraat(fileName, begintime, endtime);
                return;
            }
        }
        if ((sendpraatExe = PraatConnection.getPreference(SENDPRAAT_APP)) == null) {
            sendpraatExe = PraatConnection.locateSendpraat();
            if (sendpraatExe.length() == 0) {
                sendpraatExe = "sendpraat";
            }
        } else if (sendpraatExe.length() == 0) {
            sendpraatExe = "sendpraat";
        }
        String executeCom = "execute " + scriptFileName + " \"" + fileName + "\" " + String.valueOf(begintime) + " " + String.valueOf(endtime);
        String[] sendpraatCom = new String[]{sendpraatExe, "praat", executeCom};
        try {
            Runtime.getRuntime().exec(sendpraatCom);
        }
        catch (SecurityException se) {
            JOptionPane.showMessageDialog(new JFrame(), ElanLocale.getString("PraatConnection.Message.Security"), ElanLocale.getString("Message.Warning"), 2);
            LOG.warning("Cannot execute sendpraat (security): " + se.getMessage());
            return;
        }
        catch (IOException ioe) {
            LOG.warning("Cannot execute sendraat (io): " + ioe.getMessage());
            String path = PraatConnection.locateSendpraat();
            if (path == null) {
                return;
            }
            PraatConnection.openOtherPraat(fileName, begintime, endtime);
        }
    }

    private static boolean checkScript() {
        File file;
        String dir;
        if (!PraatConnection.checkHome()) {
            return false;
        }
        scriptFileName = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + PRAAT_SCRIPT;
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 && scriptFileName.indexOf(32) > -1 && (dir = System.getProperty("java.io.tmpdir")) != null) {
            scriptFileName = dir + Constants.FILESEPARATOR + PRAAT_SCRIPT;
        }
        if ((file = new File(scriptFileName)).exists()) {
            return true;
        }
        if (PraatConnection.copyScriptFromJar(file, "/mpi/eudico/client/annotator/resources/openpraat-v3.praat")) {
            return true;
        }
        return PraatConnection.createScriptFile(file);
    }

    private static boolean checkClipScript() {
        File file;
        String dir;
        if (!PraatConnection.checkHome()) {
            return false;
        }
        scriptFileName = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + PRAAT_CLIP_SCRIPT;
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1 && scriptFileName.indexOf(32) > -1 && (dir = System.getProperty("java.io.tmpdir")) != null) {
            scriptFileName = dir + Constants.FILESEPARATOR + PRAAT_CLIP_SCRIPT;
        }
        if ((file = new File(scriptFileName)).exists()) {
            return true;
        }
        return PraatConnection.copyScriptFromJar(file, "/mpi/eudico/client/annotator/resources/createsoundclip-v3.praat");
    }

    private static boolean checkHome() {
        File dataDir = new File(Constants.ELAN_DATA_DIR);
        if (!dataDir.exists()) {
            try {
                dataDir.mkdir();
            }
            catch (Exception e) {
                LOG.warning("Unable to create the Data directory: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private static boolean copyScriptFromJar(File copyFile, String resource) {
        try {
            int n;
            copyFile.createNewFile();
            URL scriptSrc = PraatConnection.class.getResource(resource);
            if (scriptSrc == null) {
                LOG.warning("No script source file found");
                return false;
            }
            BufferedInputStream inStream = new BufferedInputStream(scriptSrc.openStream());
            byte[] buf = new byte[512];
            FileOutputStream out = new FileOutputStream(copyFile);
            while ((n = inStream.read(buf)) > -1) {
                out.write(buf, 0, n);
            }
            out.flush();
            out.close();
            inStream.close();
            return true;
        }
        catch (IOException ioe) {
            LOG.warning("Unable to write the Praat script file: " + ioe.getMessage());
            return false;
        }
    }

    private static boolean createScriptFile(File scriptFile) {
        try {
            if (!scriptFile.exists()) {
                scriptFile.createNewFile();
            }
            String contents = PraatConnection.createScriptContents();
            FileWriter writer = new FileWriter(scriptFile);
            writer.write(contents);
            writer.close();
        }
        catch (IOException ioe) {
            LOG.warning("Unable to write the Praat script file: " + ioe.getMessage());
            return false;
        }
        return true;
    }

    private static String createScriptContents() {
        StringBuffer scriptBuffer = new StringBuffer();
        scriptBuffer.append("form Segment info\n");
        scriptBuffer.append("\ttext Filepath \"\"\n");
        scriptBuffer.append("\ttext Filename \"\"\n");
        scriptBuffer.append("\tpositive Start 0\n");
        scriptBuffer.append("\tpositive End 10\n");
        scriptBuffer.append("endform\n");
        scriptBuffer.append("Open long sound file... 'filepath$'\n");
        scriptBuffer.append("s = start / 1000\n");
        scriptBuffer.append("en = end / 1000\n");
        scriptBuffer.append("View\n");
        scriptBuffer.append("editor LongSound 'filename$'\n");
        scriptBuffer.append("\tSelect... 's' 'en'\n");
        scriptBuffer.append("\tZoom to selection\n");
        scriptBuffer.append("endeditor");
        return scriptBuffer.toString();
    }

    private static String locatePraat() {
        String praatPath = null;
        FileChooser chooser = new FileChooser(new JFrame());
        chooser.createAndShowFileDialog(ElanLocale.getString("PraatConnection.LocateDialog.Title1"), 0, ElanLocale.getString("PraatConnection.LocateDialog.Select"), null, null, true, "PraatLocation.Dir", 0, null);
        File path = chooser.getSelectedFile();
        if (path == null) {
            PraatConnection.setPreference(PRAAT_APP, "");
        } else {
            praatPath = path.getAbsolutePath();
            if (path.isDirectory() && praatPath.endsWith(".app")) {
                praatPath = praatPath + "/Contents/MacOS/Praat";
            }
            PraatConnection.setPreference(PRAAT_APP, praatPath);
        }
        return praatPath;
    }

    private static String locateSendpraat() {
        FileChooser chooser = new FileChooser(new JFrame());
        chooser.createAndShowFileDialog(ElanLocale.getString("PraatConnection.LocateDialog.Title2"), 0, ElanLocale.getString("PraatConnection.LocateDialog.Select"), null, null, true, "PraatLocation.Dir", 0, null);
        File path = chooser.getSelectedFile();
        if (path == null) {
            PraatConnection.setPreference(SENDPRAAT_APP, "");
            return null;
        }
        PraatConnection.setPreference(SENDPRAAT_APP, path.getAbsolutePath());
        return path.getAbsolutePath();
    }

    private static String getPreference(String key) {
        if (key == null) {
            return null;
        }
        if (preferences == null && (preferences = PraatConnection.loadPreferences()) instanceof Hashtable) {
            PraatConnection.savePreferences();
        }
        return (String)preferences.get(key);
    }

    private static Map loadPreferences() {
        PreferencesReader reader = new PreferencesReader();
        HashMap prefMap = (HashMap)reader.parse(PRAAT_PREFS_XML_FILE);
        if (prefMap.size() > 0) {
            return prefMap;
        }
        Hashtable hashtable = new Hashtable();
        File inFile = new File(PRAAT_PREFS_FILE);
        try {
            FileInputStream inStream = new FileInputStream(inFile);
            ObjectInputStream objectIn = new ObjectInputStream(inStream);
            hashtable = (Hashtable)objectIn.readObject();
            objectIn.close();
            inStream.close();
        }
        catch (FileNotFoundException fnfe) {
            LOG.warning("Could not load Praat preferences: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            LOG.warning("Could not load Praat preferences: " + ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warning("Could not load Praat preferences: " + cnfe.getMessage());
        }
        return hashtable;
    }

    private static void setPreference(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (preferences == null) {
            preferences = new HashMap();
        }
        preferences.put(key, value);
        PraatConnection.savePreferences();
    }

    private static void savePreferences() {
        if (preferences == null) {
            return;
        }
        PreferencesWriter writer = new PreferencesWriter();
        writer.encodeAndSave(preferences, PRAAT_PREFS_XML_FILE);
    }

    private static void checkUnixPraatProcess() {
        try {
            final Process p = Runtime.getRuntime().exec(new String[]{"top", "-l1"});
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        InputStreamReader isr = new InputStreamReader(p.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            if (line.indexOf(" Praat ") <= 0) continue;
                            br.close();
                            isPraatRunning = true;
                            break;
                        }
                    }
                    catch (IOException ioe) {
                        LOG.warning("Cannot determine the running state of Praat: " + ioe.getMessage());
                    }
                }
            }).start();
        }
        catch (SecurityException sex) {
            LOG.warning("Cannot run the \"top\" utility: " + sex.getMessage());
        }
        catch (IOException ioe) {
            LOG.warning("Cannot run the \"top\" utility: " + ioe.getMessage());
        }
    }

    private static String spacelessWindowsPath(String fileName) {
        if (fileName == null) {
            return null;
        }
        int firstSpace = fileName.indexOf(32);
        if (firstSpace < 0) {
            return fileName;
        }
        int prevSep = fileName.lastIndexOf(File.separator, firstSpace);
        int nextSep = fileName.indexOf(File.separator, firstSpace);
        String fileOrDirName = null;
        if (nextSep <= 0) {
            return fileName;
        }
        fileOrDirName = fileName.substring(prevSep + 1, nextSep);
        try {
            StringBuffer pathBuf;
            File dir = new File(fileName.substring(0, prevSep + 1));
            if (!dir.isDirectory()) {
                return fileName;
            }
            String start = fileOrDirName.substring(0, fileOrDirName.indexOf(32));
            String[] fNames = dir.list();
            int sufNum = 0;
            for (int i = 0; i < fNames.length; ++i) {
                if (!fNames[i].startsWith(fileOrDirName)) continue;
                ++sufNum;
                if (fNames[i].equals(fileOrDirName)) break;
            }
            if ((pathBuf = new StringBuffer(dir.getPath())).charAt(pathBuf.length() - 1) != File.separatorChar) {
                pathBuf.append(File.separator);
            }
            if (start.length() <= 6) {
                String tmp = fileOrDirName.replaceAll(" ", "");
                if (tmp.length() <= 6) {
                    pathBuf.append(tmp.toUpperCase()).append("~").append(sufNum);
                } else {
                    pathBuf.append(tmp.substring(0, 6).toUpperCase()).append("~").append(sufNum);
                }
            } else {
                pathBuf.append(start.substring(0, 6).toUpperCase()).append("~").append(sufNum);
            }
            if (nextSep > 0) {
                pathBuf.append(fileName.substring(nextSep));
            }
            if (pathBuf.indexOf(" ") < 0) {
                return pathBuf.toString();
            }
            return PraatConnection.spacelessWindowsPath(pathBuf.toString());
        }
        catch (Exception ex) {
            LOG.warning("Invalid directory: " + ex.getMessage());
            return fileName;
        }
    }

    private static String praatFriendlyFileName(String filePath) {
        String pffn = filePath.replace('\\', '/');
        int b = pffn.lastIndexOf(47);
        int e = pffn.lastIndexOf(46);
        if (b > -1) {
            pffn = e > b + 1 ? pffn.substring(b + 1, e) : pffn.substring(b + 1);
        } else if (e > -1) {
            pffn = pffn.substring(0, e);
        }
        pffn = pffn.replace(' ', '_');
        pffn = pffn.replace('.', '_');
        return pffn;
    }

    static {
        PRAAT_PREFS_FILE = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "praat.pfs";
        PRAAT_PREFS_XML_FILE = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "praat.pfsx";
        isPraatRunning = false;
        LOG = Logger.getLogger(PraatConnection.class.getName());
    }
}

