/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.DetachedViewerFrame;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.ContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.ExportTrack;
import mpi.eudico.client.annotator.timeseries.ExtractDataMultiStep;
import mpi.eudico.client.annotator.timeseries.TSRulerImpl;
import mpi.eudico.client.annotator.timeseries.TSTrackManager;
import mpi.eudico.client.annotator.timeseries.TSTrackPanelImpl;
import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeEvent;
import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeListener;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.glove.DataGloveFileReader;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.DefaultTimeScaleBasedViewer;
import mpi.eudico.client.annotator.viewer.GesturesListener;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TimeSeriesViewer
extends DefaultTimeScaleBasedViewer
implements AdjustmentListener,
TimeSeriesChangeListener,
MouseListener,
GesturesListener {
    private TranscriptionImpl transcription;
    private TSTrackManager trackManager;
    private final String ADD_PR = "add-";
    private final String REM_PR = "rem-";
    private final String RANGE = "ran-";
    private final String EXP_PR = "exp-";
    private final int DEF_PANEL_HEIGHT = 300;
    private BufferedImage ri;
    private Graphics2D rug2d;
    private int vertRulerWidth;
    private int verticalScrollOffset;
    private JScrollBar scrollBar;
    private int defBarWidth;
    private List trackPanels;
    private int trackPanelHeight;
    private Insets panelMargins;
    private TSTrackPanelImpl selTrackPanel;
    private boolean autoFitVertical = true;
    private JCheckBoxMenuItem fitVerticalMI;
    private JCheckBoxMenuItem showTrackValueMenu;
    private JMenu trPanelMenu;
    private JMenuItem addPanelMI;
    private JMenuItem removePanelMI;
    private JMenu setRangeMenu;
    private JMenu addTrackMenu;
    private JMenu removeTrackMenu;
    private JMenuItem extractDataMI;
    private JMenuItem configureTrMI;
    private JMenuItem removeAllPanelsMI;
    private JMenuItem addPanelForEachTrackMI;
    private JMenuItem detachItem;
    private JMenuItem combinedRangeMI;
    private JMenu exportTrackMenu;
    private boolean showTrackValues;
    private boolean isPlaying;
    private JMenuItem addAllTrackMI;
    private JMenuItem removeAllTrackMI;
    private boolean syncModeViewer = false;
    private boolean syncConnected = false;

    public TimeSeriesViewer() {
        this.initViewer();
        this.defBarWidth = this.getDefaultBarWidth();
        this.paintBuffer();
        this.addMouseWheelListener(this);
        this.addEmptyTrackPanel();
    }

    public TimeSeriesViewer(Transcription transcription) {
        this();
        this.transcription = (TranscriptionImpl)transcription;
    }

    public TimeSeriesViewer(Transcription transcription, TSTrackManager trackManager) {
        this();
        this.transcription = (TranscriptionImpl)transcription;
        this.trackManager = trackManager;
        if (trackManager != null) {
            trackManager.addTimeSeriesChangeListener(this);
        }
    }

    public boolean isSyncModeViewer() {
        return this.syncModeViewer;
    }

    public void setSyncModeViewer(boolean syncModeViewer) {
        this.syncModeViewer = syncModeViewer;
    }

    public void setSyncConnected(boolean syncConnected) {
        this.syncConnected = syncConnected;
    }

    @Override
    public void setPlayer(ElanMediaPlayer player) {
        super.setPlayer(player);
        this.controllerUpdate(new TimeEvent(player));
        System.out.println("Player: " + player);
    }

    public TSTrackManager getTrackManager() {
        return this.trackManager;
    }

    public void setTrackManager(TSTrackManager manager) {
        this.trackManager = manager;
        if (this.trackManager != null) {
            this.trackManager.addTimeSeriesChangeListener(this);
        }
    }

    @Override
    protected void initViewer() {
        super.initViewer();
        this.trackPanels = new ArrayList(4);
        this.vertRulerWidth = 43;
        this.trackPanelHeight = 300;
        this.panelMargins = new Insets(3, 3, 3, 0);
        this.showTrackValues = true;
        this.isPlaying = false;
        this.verticalScrollOffset = 0;
        this.scrollBar = new JScrollBar(1, 0, 50, 0, 200);
        this.scrollBar.setBlockIncrement(this.trackPanelHeight);
        this.scrollBar.addAdjustmentListener(this);
        this.add(this.scrollBar);
    }

    private int getDefaultBarWidth() {
        int width = 20;
        if (UIManager.getDefaults().get("ScrollBar.width") != null) {
            width = (Integer)UIManager.getDefaults().get("ScrollBar.width");
        }
        return width;
    }

    @Override
    public void paintComponent(Graphics g) {
        int h;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if ((h = this.getHeight()) > this.imageHeight) {
            g2d.setColor(Color.WHITE);
            g2d.fillRect(0, 0, this.imageWidth, h);
            if (this.bi != null) {
                g2d.drawImage((Image)this.bi, 0, h - this.imageHeight - this.verticalScrollOffset, null);
            }
        } else if (this.bi != null) {
            g2d.drawImage((Image)this.bi, 0, -this.verticalScrollOffset, null);
        }
        if (this.ri != null) {
            g2d.drawImage((Image)this.ri, this.vertRulerWidth, h - this.rulerHeight, null);
        }
        if (this.selectionBeginPos != this.selectionEndPos && this.selectionEndPos > this.vertRulerWidth) {
            g2d.setColor(Constants.SELECTIONCOLOR);
            g2d.setComposite(this.alpha05);
            if (this.selectionBeginPos < this.vertRulerWidth) {
                this.selectionBeginPos = this.vertRulerWidth;
            }
            g2d.fillRect(this.selectionBeginPos, h - this.rulerHeight, this.selectionEndPos - this.selectionBeginPos, this.rulerHeight);
            g2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, h - this.rulerHeight);
            g2d.setComposite(AlphaComposite.Src);
        }
        if (this.crossHairPos >= this.vertRulerWidth && this.crossHairPos <= this.imageWidth) {
            g2d.setColor(Constants.CROSSHAIRCOLOR);
            g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
            if (this.showTrackValues && !this.isPlaying) {
                long endTime;
                long beginTime = this.timeAt(this.crossHairPos);
                if (beginTime >= (endTime = this.timeAt(this.crossHairPos + 1))) {
                    return;
                }
                int labelHeight = g2d.getFontMetrics(g2d.getFont()).getHeight() + 1;
                for (int i = 1; i <= this.trackPanels.size(); ++i) {
                    TSTrackPanelImpl panel = this.getPanelAtY(h - this.rulerHeight - i * this.trackPanelHeight + 2);
                    if (panel == null) continue;
                    List tracks = panel.getTracks();
                    for (int j = 0; j < tracks.size(); ++j) {
                        Color trackColor = ((AbstractTSTrack)tracks.get(j)).getColor();
                        float average = ((AbstractTSTrack)tracks.get(j)).getAverage(beginTime, endTime);
                        if (Float.isNaN(average)) continue;
                        String label = Float.toString(average);
                        g2d.setColor(trackColor);
                        g2d.drawString(label, this.crossHairPos + 4, h - this.rulerHeight - i * this.trackPanelHeight + (j + 1) * labelHeight);
                    }
                }
            }
        }
    }

    private void paintBuffer() {
        int h;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.imageWidth != this.getWidth() - this.defBarWidth) {
            this.imageWidth = Math.max(this.getWidth() - this.defBarWidth, 1);
        }
        if (this.imageHeight != (h = this.trackPanels.size() * this.trackPanelHeight + this.rulerHeight)) {
            int n = this.imageHeight = this.getHeight() > h ? this.getHeight() : h;
            if (this.imageHeight <= 0) {
                return;
            }
        }
        this.imageHeight = Math.max(this.imageHeight, 1);
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.intervalWidth * this.msPerPixel));
        if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
            this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            this.big2d = this.bi.createGraphics();
        }
        if (SystemReporting.antiAliasedText) {
            this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.big2d.setColor(Color.WHITE);
        this.big2d.fillRect(0, 0, this.imageWidth, this.bi.getHeight());
        int y = this.imageHeight - this.rulerHeight;
        for (int i = 0; i < this.trackPanels.size(); ++i) {
            TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(i);
            this.big2d.translate(0, y -= panel.getHeight());
            panel.paint(this.big2d, this.intervalBeginTime);
            this.big2d.translate(0, -y);
        }
        this.big2d.setTransform(this.identity);
        if (this.timeRulerVisible) {
            if (this.ri == null || this.ri.getWidth() < this.imageWidth - this.vertRulerWidth || this.ri.getHeight() != this.rulerHeight) {
                this.ri = new BufferedImage(this.imageWidth - this.vertRulerWidth, this.rulerHeight, 1);
                this.rug2d = this.ri.createGraphics();
            }
            this.rug2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            this.rug2d.fillRect(0, 0, this.imageWidth, this.rulerHeight);
            this.rug2d.setColor(Color.DARK_GRAY);
            this.rug2d.drawLine(0, 0, this.imageWidth, 0);
            this.rug2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            this.rug2d.translate(-((float)this.intervalBeginTime / this.msPerPixel), 0.0);
            this.ruler.paint(this.rug2d, this.intervalBeginTime, this.imageWidth, this.msPerPixel, 1);
            this.rug2d.setTransform(this.identity);
        }
        this.repaint();
    }

    public void addTSTrackPanel(TSTrackPanelImpl trackPanel) {
        trackPanel.setHeight(this.trackPanelHeight);
        trackPanel.setWidth(this.getWidth() - this.defBarWidth);
        trackPanel.setMargin(this.panelMargins);
        trackPanel.setRulerWidth(this.vertRulerWidth - this.panelMargins.left);
        trackPanel.setMsPerPixel(this.msPerPixel);
        this.trackPanels.add(trackPanel);
        this.adjustPanelHeight();
        this.paintBuffer();
        this.updateScrollBar();
    }

    public void addEmptyTrackPanel() {
        TSTrackPanelImpl tsp = new TSTrackPanelImpl();
        TSRulerImpl ruler = new TSRulerImpl();
        ruler.setFont(Constants.SMALLFONT);
        tsp.setRuler(ruler);
        this.addTSTrackPanel(tsp);
    }

    public void removeTSTrackPanel(TSTrackPanelImpl trackPanel) {
        this.trackPanels.remove(trackPanel);
        this.adjustPanelHeight();
        this.paintBuffer();
        this.updateScrollBar();
    }

    public int getVerticalRulerWidth() {
        return this.vertRulerWidth;
    }

    public void setVerticalRulerWidth(int rulerWidth) {
        this.vertRulerWidth = rulerWidth;
        for (int i = 0; i < this.trackPanels.size(); ++i) {
            TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(i);
            panel.setRulerWidth(this.vertRulerWidth - this.panelMargins.left);
        }
        this.paintBuffer();
    }

    public int getVerticalScrollOffset() {
        return this.verticalScrollOffset;
    }

    public void setVerticalScrollOffset(int offset) {
        this.verticalScrollOffset = offset;
        this.repaint();
    }

    public int getNumberOfTrackPanels() {
        return this.trackPanels.size();
    }

    public void setNumberOfTrackPanels(int num) {
        int curSize = this.trackPanels.size();
        for (int i = 0; i < num - curSize; ++i) {
            this.addEmptyTrackPanel();
        }
    }

    public List getTracksForPanel(int panelIndex) {
        if (panelIndex < 0 || panelIndex >= this.trackPanels.size()) {
            return null;
        }
        TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(panelIndex);
        List tracks = panel.getTracks();
        ArrayList<String> names = new ArrayList<String>(tracks.size());
        for (int i = 0; i < tracks.size(); ++i) {
            AbstractTSTrack tr = (AbstractTSTrack)tracks.get(i);
            names.add(tr.getName());
        }
        return names;
    }

    public void setTracksForPanel(int panelIndex, List trackNames) {
        if (panelIndex < 0 || panelIndex >= this.trackPanels.size() || trackNames == null) {
            return;
        }
        TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(panelIndex);
        for (int i = 0; i < trackNames.size(); ++i) {
            AbstractTSTrack tr;
            String name = (String)trackNames.get(i);
            if (name == null || panel.getTrack(name) != null || (tr = this.trackManager.getTrack(name)) == null) continue;
            panel.addTrack(tr);
            panel.getRuler().setRange(tr.getRange());
            panel.getRuler().setUnitString(tr.getUnitString());
        }
        this.paintBuffer();
    }

    private void updateScrollBar() {
        int value = this.scrollBar.getValue();
        int max = this.imageHeight > this.getHeight() ? this.imageHeight : this.getHeight();
        this.scrollBar.setValue(0);
        this.scrollBar.setMaximum(max);
        this.scrollBar.setVisibleAmount(this.getHeight());
        if (value + this.getHeight() > max) {
            value = max - this.getHeight();
        }
        this.scrollBar.setValue(value);
        this.scrollBar.revalidate();
    }

    @Override
    public int getLeftMargin() {
        return this.vertRulerWidth;
    }

    @Override
    public int getRightMargin() {
        return this.defBarWidth;
    }

    public void setRightMargin(int width) {
        this.defBarWidth = width;
    }

    @Override
    protected void createPopupMenu() {
        super.createPopupMenu();
        if (!this.attached) {
            this.timeScaleConMI.setSelected(false);
            this.timeScaleConMI.setEnabled(false);
        } else {
            this.timeScaleConMI.setEnabled(true);
        }
        this.fitVerticalMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeSeriesViewer.TrackPanel.FitVertically"));
        this.fitVerticalMI.setSelected(this.autoFitVertical);
        this.fitVerticalMI.addActionListener(this);
        this.popup.add(this.fitVerticalMI);
        this.showTrackValueMenu = new JCheckBoxMenuItem(ElanLocale.getString("TimeSeriesViewer.Track.ShowValues"));
        this.showTrackValueMenu.addActionListener(this);
        this.showTrackValueMenu.setSelected(this.showTrackValues);
        this.popup.add(this.showTrackValueMenu);
        this.detachItem = new JMenuItem();
        if (this.isAttached()) {
            this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
        } else {
            this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
        }
        this.detachItem.addActionListener(this);
        this.popup.add(this.detachItem);
        this.popup.addSeparator();
        this.addPanelMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.TrackPanel.AddPanel"));
        this.addPanelMI.addActionListener(this);
        this.popup.add(this.addPanelMI);
        this.removePanelMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.TrackPanel.RemovePanel"));
        this.removePanelMI.addActionListener(this);
        this.popup.add(this.removePanelMI);
        this.addPanelForEachTrackMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.TrackPanel.AddPanelForEachTrack"));
        this.addPanelForEachTrackMI.addActionListener(this);
        this.popup.add(this.addPanelForEachTrackMI);
        this.removeAllPanelsMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.TrackPanel.RemoveAllPanels"));
        this.removeAllPanelsMI.addActionListener(this);
        this.popup.add(this.removeAllPanelsMI);
        this.popup.addSeparator();
        this.trPanelMenu = new JMenu(ElanLocale.getString("TimeSeriesViewer.TrackPanel"));
        this.popup.add(this.trPanelMenu);
        this.setRangeMenu = new JMenu(ElanLocale.getString("TimeSeriesViewer.TrackPanel.SetRange"));
        this.trPanelMenu.add(this.setRangeMenu);
        this.addTrackMenu = new JMenu(ElanLocale.getString("TimeSeriesViewer.Track.Add"));
        this.trPanelMenu.add(this.addTrackMenu);
        this.removeTrackMenu = new JMenu(ElanLocale.getString("TimeSeriesViewer.Track.Remove"));
        this.trPanelMenu.add(this.removeTrackMenu);
        this.popup.addSeparator();
        this.trPanelMenu.addSeparator();
        this.addAllTrackMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.Track.Addall"));
        this.addAllTrackMI.addActionListener(this);
        this.trPanelMenu.add(this.addAllTrackMI);
        this.removeAllTrackMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.Track.Removeall"));
        this.removeAllTrackMI.addActionListener(this);
        this.trPanelMenu.add(this.removeAllTrackMI);
        this.extractDataMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.Extract"));
        this.extractDataMI.addActionListener(this);
        this.popup.add(this.extractDataMI);
        this.configureTrMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.Tracks.Configure"));
        this.configureTrMI.addActionListener(this);
        this.popup.add(this.configureTrMI);
        this.popup.addSeparator();
        this.exportTrackMenu = new JMenu(ElanLocale.getString("TimeSeriesViewer.ExportTrack"));
        this.popup.add(this.exportTrackMenu);
        this.combinedRangeMI = new JMenuItem(ElanLocale.getString("TimeSeriesViewer.TrackPanel.SetRangeCombined"));
        this.combinedRangeMI.setActionCommand("ran-ALL");
        this.combinedRangeMI.addActionListener(this);
    }

    @Override
    protected void updatePopup(Point p) {
        this.selTrackPanel = null;
        this.removePanelMI.setEnabled(false);
        this.trPanelMenu.setEnabled(false);
        if (!this.pointInHorizontalRuler(p.y)) {
            Point inverse = new Point(p);
            inverse.y += this.verticalScrollOffset;
            this.selTrackPanel = this.getPanelAtY(inverse.y);
            if (this.selTrackPanel != null) {
                this.removePanelMI.setEnabled(true);
                this.trPanelMenu.setEnabled(true);
            }
        }
        this.addTrackMenu.removeAll();
        this.removeTrackMenu.removeAll();
        this.setRangeMenu.removeAll();
        this.exportTrackMenu.removeAll();
        this.removeAllPanelsMI.setEnabled(this.trackPanels.size() > 0);
        if (this.selTrackPanel == null) {
            return;
        }
        if (this.trackManager != null) {
            AbstractTSTrack tra;
            ArrayList trs = this.trackManager.getRegisteredTracks();
            if (trs.size() == 0 || this.transcription.getTiers().size() == 0) {
                this.extractDataMI.setEnabled(false);
                this.exportTrackMenu.setEnabled(false);
            } else {
                this.extractDataMI.setEnabled(true);
                this.exportTrackMenu.setEnabled(true);
            }
            Collections.sort(trs);
            for (int i = 0; i < trs.size(); ++i) {
                JMenuItem it;
                tra = (AbstractTSTrack)trs.get(i);
                if (tra != null && !this.selTrackPanel.getTracks().contains(tra)) {
                    it = new JMenuItem(tra.getName());
                    it.setActionCommand("add-" + tra.getName());
                    it.addActionListener(this);
                    this.addTrackMenu.add(it);
                }
                if (tra == null) continue;
                it = new JMenuItem(tra.getName());
                it.setActionCommand("exp-" + tra.getName());
                it.addActionListener(this);
                this.exportTrackMenu.add(it);
            }
            List curTracks = this.selTrackPanel.getTracks();
            if (curTracks.size() > 1) {
                this.setRangeMenu.add(this.combinedRangeMI);
                this.setRangeMenu.addSeparator();
            }
            for (int i = 0; i < curTracks.size(); ++i) {
                tra = (AbstractTSTrack)curTracks.get(i);
                if (tra == null) continue;
                JMenuItem it = new JMenuItem(tra.getName());
                it.setActionCommand("rem-" + tra.getName());
                it.addActionListener(this);
                this.removeTrackMenu.add(it);
                JMenuItem is = new JMenuItem(tra.getName());
                is.setActionCommand("ran-" + tra.getName());
                is.addActionListener(this);
                this.setRangeMenu.add(is);
            }
            this.removeAllTrackMI.setEnabled(curTracks.size() > 0);
        }
    }

    @Override
    protected void zoomToSelection() {
        int sw;
        float nextMsPP;
        long selInterval = this.getSelectionEndTime() - this.getSelectionBeginTime();
        if (selInterval < 150L) {
            selInterval = 150L;
        }
        if ((nextMsPP = (float)selInterval / (float)(sw = this.imageWidth != 0 ? this.imageWidth - 32 - this.vertRulerWidth : this.getWidth() - this.defBarWidth - 32)) > 200.0f) {
            nextMsPP = 200.0f;
        }
        this.setMsPerPixel(nextMsPP);
        if (!this.playerIsPlaying()) {
            long ibt = this.getSelectionBeginTime() - (long)(16.0f * this.msPerPixel);
            if (ibt < 0L) {
                ibt = 0L;
            }
            this.setIntervalBeginTime(ibt);
        }
    }

    @Override
    public long timeAt(int x) {
        return this.intervalBeginTime + (long)((int)((float)(x - this.vertRulerWidth) * this.msPerPixel));
    }

    @Override
    public int xAt(long t) {
        return super.xAt(t) + this.vertRulerWidth;
    }

    @Override
    protected void setLocalTimeScaleIntervalBeginTime(long begin) {
        if (begin == this.intervalBeginTime) {
            return;
        }
        this.intervalBeginTime = begin;
        this.intervalEndTime = this.intervalBeginTime + (long)((float)this.intervalWidth * this.msPerPixel);
        this.crossHairPos = this.xAt(this.crossHairTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.paintBuffer();
    }

    @Override
    protected void setLocalTimeScaleMsPerPixel(float step) {
        int zoom;
        if (this.msPerPixel == step) {
            return;
        }
        this.msPerPixel = step >= 0.025f ? step : 0.025f;
        boolean playing = this.playerIsPlaying();
        if (playing) {
            this.stopPlayer();
        }
        long mediaTime = this.getMediaTime();
        int oldScreenPos = this.crossHairPos;
        long newMediaX = (long)((float)mediaTime / this.msPerPixel);
        int numScreens = this.intervalWidth > 0 ? (int)((float)mediaTime / ((float)this.intervalWidth * this.msPerPixel)) : 0;
        int newScreenPos = (int)newMediaX - numScreens * this.intervalWidth + this.vertRulerWidth;
        int diff = oldScreenPos - newScreenPos;
        this.intervalBeginTime = (long)((float)(numScreens * this.intervalWidth - diff) * this.msPerPixel);
        if (this.intervalBeginTime < 0L) {
            this.intervalBeginTime = 0L;
        }
        this.intervalEndTime = this.intervalBeginTime + (long)((float)this.intervalWidth * this.msPerPixel);
        this.crossHairPos = this.xAt(mediaTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        for (int i = 0; i < this.trackPanels.size(); ++i) {
            TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(i);
            panel.setMsPerPixel(this.msPerPixel);
        }
        this.paintBuffer();
        if (playing) {
            this.startPlayer();
        }
        if ((zoom = (int)(100.0f * (10.0f / this.msPerPixel))) <= 0) {
            zoom = 100;
        }
        this.updateZoomPopup(zoom);
    }

    private void clearPanel() {
        this.trackPanels.clear();
        this.adjustPanelHeight();
        this.paintBuffer();
        this.updateScrollBar();
    }

    @Override
    public void setMediaTimeOffset(long offset) {
        if (offset != this.mediaTimeOffset) {
            super.setMediaTimeOffset(offset);
            for (int i = 0; i < this.trackPanels.size(); ++i) {
                TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(i);
                List tracks = panel.getTracks();
                for (int j = 0; j < tracks.size(); ++j) {
                    AbstractTSTrack track = (AbstractTSTrack)tracks.get(j);
                    if (track == null) continue;
                    track.setTimeOffset((int)this.mediaTimeOffset);
                }
            }
        }
    }

    @Override
    protected boolean pointInHorizontalRuler(int yPos) {
        int h = this.getHeight();
        return yPos <= h && yPos >= h - this.rulerHeight;
    }

    private TSTrackPanelImpl getPanelAtY(int y) {
        int h;
        TSTrackPanelImpl panel = null;
        int ymin = h = Math.max(this.getHeight(), this.imageHeight);
        int ymax = h - this.rulerHeight;
        for (int i = 0; i < this.trackPanels.size(); ++i) {
            panel = (TSTrackPanelImpl)this.trackPanels.get(i);
            ymin = ymax - panel.getHeight();
            if (ymax >= y && ymin <= y) {
                return panel;
            }
            ymax -= panel.getHeight();
        }
        return null;
    }

    private void adjustPanelHeight() {
        int numPan = this.trackPanels.size();
        if (numPan > 0) {
            this.trackPanelHeight = this.autoFitVertical ? (this.getHeight() - this.rulerHeight) / numPan : 300;
            for (int i = 0; i < this.trackPanels.size(); ++i) {
                TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(i);
                panel.setHeight(this.trackPanelHeight);
            }
        } else if (this.autoFitVertical) {
            this.trackPanelHeight = this.getHeight();
        }
    }

    private void extractTrackData() {
        new ExtractDataMultiStep(this.transcription, this.trackManager);
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StartEvent) {
            if (this.showTrackValues) {
                this.isPlaying = true;
                this.repaint();
            }
        } else if (event instanceof StopEvent && this.showTrackValues) {
            this.isPlaying = false;
            this.repaint();
        }
        super.controllerUpdate(event);
    }

    @Override
    public void updateSelection() {
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        if (this.selectionBeginPos < this.vertRulerWidth) {
            this.selectionBeginPos = this.vertRulerWidth;
        }
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        if (this.selectionEndPos < this.selectionBeginPos) {
            this.selectionEndPos = this.selectionBeginPos;
        }
        this.repaint();
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        if (this.popup != null) {
            this.fitVerticalMI.setText(ElanLocale.getString("TimeSeriesViewer.TrackPanel.FitVertically"));
            this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            this.addPanelMI.setText(ElanLocale.getString("TimeSeriesViewer.TrackPanel.AddPanel"));
            this.removePanelMI.setText(ElanLocale.getString("TimeSeriesViewer.TrackPanel.RemovePanel"));
            this.trPanelMenu.setText(ElanLocale.getString("TimeSeriesViewer.TrackPanel"));
            this.setRangeMenu.setText(ElanLocale.getString("TimeSeriesViewer.TrackPanel.SetRange"));
            this.addTrackMenu.setText(ElanLocale.getString("TimeSeriesViewer.Track.Add"));
            this.removeTrackMenu.setText(ElanLocale.getString("TimeSeriesViewer.Track.Remove"));
            this.extractDataMI.setText(ElanLocale.getString("TimeSeriesViewer.Extract"));
            this.configureTrMI.setText(ElanLocale.getString("TimeSeriesViewer.Tracks.Configure"));
            this.showTrackValueMenu.setText(ElanLocale.getString("TimeSeriesViewer.Track.ShowValues"));
            this.addAllTrackMI.setText(ElanLocale.getString("TimeSeriesViewer.Track.Addall"));
            this.removeAllTrackMI.setText(ElanLocale.getString("TimeSeriesViewer.Track.Removeall"));
            this.combinedRangeMI.setText(ElanLocale.getString("TimeSeriesViewer.TrackPanel.SetRangeCombined"));
            this.exportTrackMenu.setText(ElanLocale.getString("TimeSeriesViewer.ExportTrack"));
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.intervalWidth = this.getWidth() - this.vertRulerWidth - this.defBarWidth;
        for (int i = 0; i < this.trackPanels.size(); ++i) {
            TSTrackPanelImpl panel = (TSTrackPanelImpl)this.trackPanels.get(i);
            panel.setWidth(this.getWidth() - this.defBarWidth);
        }
        this.adjustPanelHeight();
        this.paintBuffer();
        this.scrollBar.setBounds(this.getWidth() - this.defBarWidth, 0, this.defBarWidth, this.getHeight());
        this.scrollBar.revalidate();
        this.updateScrollBar();
        this.storeLocation();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.paintBuffer();
        this.scrollBar.setBounds(this.getWidth() - this.defBarWidth, 0, this.defBarWidth, this.getHeight());
        this.scrollBar.revalidate();
        this.updateScrollBar();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = e.getValue();
        this.setVerticalScrollOffset(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.detachItem) {
            if (this.isAttached()) {
                this.setPreference("TimeSeriesViewer.Detached", Boolean.TRUE, this.transcription);
                ELANCommandFactory.getLayoutManager(this.transcription).detach(this);
                this.setAttached(false);
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.setVerticalRulerWidth(43);
                this.paintBuffer();
            } else {
                this.setPreference("TimeSeriesViewer.Detached", Boolean.FALSE, this.transcription);
                ELANCommandFactory.getLayoutManager(this.transcription).attach(this);
                this.setAttached(true);
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
            return;
        }
        if (e.getSource() == this.fitVerticalMI) {
            this.autoFitVertical = this.fitVerticalMI.isSelected();
            this.adjustPanelHeight();
            this.paintBuffer();
            this.updateScrollBar();
            this.setPreference("TimeSeriesViewer.FitVertically", new Boolean(this.autoFitVertical), this.transcription);
            return;
        }
        if (e.getSource() == this.showTrackValueMenu) {
            this.showTrackValues = !this.showTrackValues;
            this.showTrackValueMenu.setSelected(this.showTrackValues);
            this.paintBuffer();
            this.setPreference("TimeSeriesViewer.ShowTrackValues", new Boolean(this.showTrackValues), this.transcription);
            return;
        }
        if (e.getSource() == this.timeRulerVisMI) {
            this.timeRulerVisible = this.timeRulerVisMI.isSelected();
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
            this.adjustPanelHeight();
            this.paintBuffer();
            this.setPreference("TimeSeriesViewer.TimeRulerVisible", new Boolean(this.timeRulerVisible), this.transcription);
            return;
        }
        if (e.getSource() == this.addPanelMI) {
            this.addEmptyTrackPanel();
            this.storePanelSetup();
            return;
        }
        if (e.getSource() == this.removePanelMI) {
            if (this.selTrackPanel != null) {
                this.removeTSTrackPanel(this.selTrackPanel);
                this.storePanelSetup();
            }
            return;
        }
        if (e.getSource() == this.configureTrMI) {
            if (this.trackManager != null) {
                this.trackManager.configureTracks(this);
            }
            return;
        }
        if (e.getSource() == this.extractDataMI) {
            this.extractTrackData();
            return;
        }
        if (e.getSource() == this.addAllTrackMI) {
            if (this.selTrackPanel != null) {
                ArrayList tracks = this.trackManager.getRegisteredTracks();
                for (int i = 0; i < tracks.size(); ++i) {
                    AbstractTSTrack tr = (AbstractTSTrack)tracks.get(i);
                    if (this.selTrackPanel.getTrack(tr.getName()) != null) continue;
                    this.selTrackPanel.addTrack(tr);
                    this.selTrackPanel.getRuler().setRange(tr.getRange());
                    this.selTrackPanel.getRuler().setUnitString(tr.getUnitString());
                }
                this.paintBuffer();
                this.storePanelSetup();
            }
            return;
        }
        if (e.getSource() == this.removeAllTrackMI) {
            if (this.selTrackPanel != null) {
                List tracks = this.selTrackPanel.getTracks();
                for (int i = tracks.size() - 1; i >= 0; --i) {
                    this.selTrackPanel.removeTrack((AbstractTSTrack)tracks.get(i));
                }
                this.paintBuffer();
                this.storePanelSetup();
            }
            return;
        }
        if (e.getSource() == this.addPanelForEachTrackMI) {
            this.clearPanel();
            ArrayList trs = this.trackManager.getRegisteredTracks();
            int totPanels = 0;
            if (this.trackPanels.isEmpty()) {
                totPanels = trs.size();
            }
            for (int i = 0; i < totPanels; ++i) {
                this.addEmptyTrackPanel();
                AbstractTSTrack tra = (AbstractTSTrack)trs.get(i);
                TSTrackPanelImpl tsp = (TSTrackPanelImpl)this.trackPanels.get(i);
                if (tra == null || tsp.getTracks().contains(tra)) continue;
                tsp.addTrack(tra);
                tsp.getRuler().setRange(tra.getRange());
                tsp.getRuler().setUnitString(tra.getUnitString());
                this.selTrackPanel = tsp;
                this.paintBuffer();
            }
            this.storePanelSetup();
            return;
        }
        if (e.getSource() == this.removeAllPanelsMI) {
            this.clearPanel();
            this.storePanelSetup();
            return;
        }
        String command = e.getActionCommand();
        if (command != null && command.indexOf("add-") > -1) {
            String trackName = command.substring(4);
            if (this.trackManager != null && this.selTrackPanel != null) {
                AbstractTSTrack tr = this.trackManager.getTrack(trackName);
                if (tr != null) {
                    this.selTrackPanel.addTrack(tr);
                    this.selTrackPanel.getRuler().setRange(tr.getRange());
                    this.selTrackPanel.getRuler().setUnitString(tr.getUnitString());
                    this.paintBuffer();
                }
                this.storePanelSetup();
            }
            return;
        }
        if (command != null && command.indexOf("rem-") > -1) {
            String trackName = command.substring(4);
            if (this.selTrackPanel != null) {
                List tracks = this.selTrackPanel.getTracks();
                for (int i = 0; i < tracks.size(); ++i) {
                    AbstractTSTrack tr = (AbstractTSTrack)tracks.get(i);
                    if (!trackName.equals(tr.getName())) continue;
                    this.selTrackPanel.removeTrack(tr);
                    this.paintBuffer();
                }
                this.storePanelSetup();
            }
            return;
        }
        if (command != null && command.indexOf("ran-") > -1) {
            String trackName = command.substring(4);
            if (this.selTrackPanel != null) {
                List tracks = this.selTrackPanel.getTracks();
                boolean combined = trackName.equals("ALL");
                float[] allr = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
                for (int i = 0; i < tracks.size(); ++i) {
                    AbstractTSTrack tr = (AbstractTSTrack)tracks.get(i);
                    if (combined) {
                        if (tr.getRange()[0] < allr[0]) {
                            allr[0] = tr.getRange()[0];
                        }
                        if (!(tr.getRange()[1] > allr[1])) continue;
                        allr[1] = tr.getRange()[1];
                        continue;
                    }
                    if (!trackName.equals(tr.getName())) continue;
                    this.selTrackPanel.getRuler().setRange(tr.getRange());
                    this.selTrackPanel.getRuler().setUnitString(tr.getUnitString());
                    this.paintBuffer();
                    break;
                }
                if (combined) {
                    this.selTrackPanel.getRuler().setRange(allr);
                    this.selTrackPanel.getRuler().setUnitString("");
                    this.paintBuffer();
                }
            }
            return;
        }
        if (command != null && command.indexOf("exp-") > -1) {
            String trackName = command.substring("exp-".length());
            ArrayList trs = this.trackManager.getRegisteredTracks();
            for (int i = 0; i < trs.size(); ++i) {
                AbstractTSTrack tr = (AbstractTSTrack)trs.get(i);
                if (!tr.getName().equals(trackName)) continue;
                new ExportTrack().exportTrack(this, tr);
                break;
            }
            return;
        }
        float oldMsPP = this.msPerPixel;
        super.actionPerformed(e);
        if (this.msPerPixel != oldMsPP) {
            this.setPreference("TimeSeriesViewer.ZoomLevel", new Float(100.0f * (10.0f / this.msPerPixel)), this.transcription);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            super.mouseWheelMoved(e);
        } else if (e.isShiftDown()) {
            super.mouseWheelMoved(e);
        } else if (e.getUnitsToScroll() > 0) {
            this.scrollBar.setValue(this.scrollBar.getValue() + 25);
        } else {
            this.scrollBar.setValue(this.scrollBar.getValue() - 25);
        }
    }

    @Override
    public void magnify(double zoom) {
        if (zoom > 0.0) {
            this.zoomIn();
        } else if (zoom < 0.0) {
            this.zoomOut();
        }
    }

    @Override
    public void swipe(int x, int y) {
        long newTime;
        if (x != 0 && (newTime = this.intervalBeginTime + this.pixelToTime(x)) != this.intervalBeginTime && (newTime >= 0L || newTime >= this.intervalBeginTime)) {
            this.setIntervalBeginTime(newTime);
        }
    }

    @Override
    public void preferencesChanged() {
        Boolean showTV;
        Boolean rulerVis;
        Boolean fitVert;
        Object zoomLevel;
        Rectangle dialogBounds;
        Integer numPanels = (Integer)this.getPreference("TimeSeriesViewer.NumberOfPanels", this.transcription);
        if (numPanels != null) {
            int np = numPanels;
            this.setNumberOfTrackPanels(np);
            List trackNames = null;
            for (int i = 1; i <= np; ++i) {
                trackNames = (List)this.getPreference("TimeSeriesViewer.Panel-" + i, this.transcription);
                this.setTracksForPanel(i - 1, trackNames);
            }
        }
        if ((dialogBounds = (Rectangle)Preferences.get("TimeSeriesViewer.Detached.Bounds", this.transcription)) != null && SwingUtilities.windowForComponent(this) instanceof DetachedViewerFrame) {
            SwingUtilities.windowForComponent(this).setBounds(dialogBounds);
        }
        if ((zoomLevel = this.getPreference("TimeSeriesViewer.ZoomLevel", this.transcription)) instanceof Float) {
            float zl = ((Float)zoomLevel).floatValue();
            float newMsPerPixel = 100.0f / zl * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
            this.updateZoomPopup((int)zl);
        }
        if ((fitVert = (Boolean)this.getPreference("TimeSeriesViewer.FitVertically", this.transcription)) != null) {
            if (this.fitVerticalMI != null) {
                this.fitVerticalMI.setSelected(fitVert);
            }
            if (this.autoFitVertical != fitVert) {
                this.autoFitVertical = fitVert;
                this.adjustPanelHeight();
                this.paintBuffer();
                this.updateScrollBar();
            }
        }
        if ((rulerVis = (Boolean)this.getPreference("TimeSeriesViewer.TimeRulerVisible", this.transcription)) != null) {
            this.timeRulerVisible = rulerVis;
            if (this.timeRulerVisMI != null) {
                this.timeRulerVisMI.setSelected(this.timeRulerVisible);
            }
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
        }
        if ((showTV = (Boolean)this.getPreference("TimeSeriesViewer.ShowTrackValues", this.transcription)) != null) {
            this.showTrackValues = showTV;
            if (this.showTrackValueMenu != null) {
                this.showTrackValueMenu.setSelected(this.showTrackValues);
            }
        }
        super.preferencesChanged();
        this.paintBuffer();
    }

    private void storePanelSetup() {
        int np = this.getNumberOfTrackPanels();
        if (np > 0) {
            this.setPreference("TimeSeriesViewer.NumberOfPanels", new Integer(np), this.transcription);
            List names = null;
            for (int i = 0; i < np; ++i) {
                names = this.getTracksForPanel(i);
                if (names == null) continue;
                this.setPreference("TimeSeriesViewer.Panel-" + (i + 1), names, this.transcription);
            }
        }
    }

    private void storeLocation() {
        if (SwingUtilities.windowForComponent(this) instanceof DetachedViewerFrame) {
            this.setPreference("TimeSeriesViewer.Detached.Bounds", SwingUtilities.windowForComponent(this).getBounds(), this.transcription);
        }
    }

    private void testTrack() {
        String fileName = System.getProperty("user.dir") + File.separator + "glove.log";
        DataGloveFileReader reader = new DataGloveFileReader(fileName);
        try {
            int sampleRate = reader.detectSampleFrequency();
            float[] data = (float[])reader.readTrack(10, 5);
            ContinuousRateTSTrack track = new ContinuousRateTSTrack();
            track.setType(1);
            track.setRange(new float[]{-180.0f, 180.0f});
            track.setColor(new Color(128, 0, 128));
            track.setSampleRate(sampleRate);
            track.setData(data);
            float[] data2 = (float[])reader.readTrack(14, 5);
            ContinuousRateTSTrack track2 = new ContinuousRateTSTrack();
            track2.setType(1);
            track2.setRange(new float[]{-180.0f, 180.0f});
            track2.setColor(new Color(0, 128, 0));
            track2.setSampleRate(sampleRate);
            track2.setData(data2);
            if (this.trackPanels.size() > 0) {
                TSTrackPanelImpl tsp = (TSTrackPanelImpl)this.trackPanels.get(0);
                tsp.getRuler().setRange(track.getRange());
                tsp.addTrack(track);
                tsp.addTrack(track2);
            }
        }
        catch (IOException ioe) {
            System.out.println("Read error: " + ioe.getMessage());
        }
    }

    @Override
    public void timeSeriesChanged(TimeSeriesChangeEvent event) {
        if (event.getEditSourceType() == 102) {
            if (event.getEditType() == 0) {
                AbstractTSTrack tr = (AbstractTSTrack)event.getSource();
                if (this.trackPanels.size() == 1 && ((TSTrackPanelImpl)this.trackPanels.get(0)).getTracks().size() == 0) {
                    TSTrackPanelImpl trsp = (TSTrackPanelImpl)this.trackPanels.get(0);
                    trsp.addTrack(tr);
                    trsp.getRuler().setRange(tr.getRange());
                    trsp.getRuler().setUnitString(tr.getUnitString());
                    this.paintBuffer();
                    this.storePanelSetup();
                    return;
                }
                TSTrackPanelImpl tsp = new TSTrackPanelImpl();
                TSRulerImpl ruler = new TSRulerImpl();
                ruler.setFont(Constants.SMALLFONT);
                tsp.setRuler(ruler);
                tsp.addTrack(tr);
                tsp.getRuler().setRange(tr.getRange());
                tsp.getRuler().setUnitString(tr.getUnitString());
                this.addTSTrackPanel(tsp);
            }
        } else if (event.getEditSourceType() == 101) {
            if (event.getSource() instanceof TSTrackConfiguration || event.getSource() instanceof AbstractTSTrack) {
                AbstractTSTrack tr = null;
                if (event.getSource() instanceof TSTrackConfiguration) {
                    TSTrackConfiguration trc = (TSTrackConfiguration)event.getSource();
                    tr = (AbstractTSTrack)trc.getObject(trc.getTrackName());
                } else {
                    tr = (AbstractTSTrack)event.getSource();
                }
                if (event.getEditType() == 0 && this.trackPanels.size() == 1 && ((TSTrackPanelImpl)this.trackPanels.get(0)).getTracks().size() == 0) {
                    TSTrackPanelImpl trsp = (TSTrackPanelImpl)this.trackPanels.get(0);
                    trsp.addTrack(tr);
                    trsp.getRuler().setRange(tr.getRange());
                    trsp.getRuler().setUnitString(tr.getUnitString());
                    this.paintBuffer();
                    this.storePanelSetup();
                    return;
                }
                block0: for (int i = 0; i < this.trackPanels.size(); ++i) {
                    TSTrackPanelImpl pan = (TSTrackPanelImpl)this.trackPanels.get(i);
                    List tracks = pan.getTracks();
                    for (int j = 0; j < tracks.size(); ++j) {
                        AbstractTSTrack tr2 = (AbstractTSTrack)tracks.get(j);
                        if (tr2 != tr) continue;
                        if (event.getEditType() == 1) {
                            pan.getRuler().setUnitString(tr.getUnitString());
                            pan.getRuler().setRange(tr2.getRange());
                            this.paintBuffer();
                            continue block0;
                        }
                        if (event.getEditType() != 2) continue;
                        boolean active = false;
                        if (pan.getRuler().getRange()[0] == tr.getRange()[0] && pan.getRuler().getRange()[1] == tr.getRange()[1] && pan.getRuler().getUnitString() != null && pan.getRuler().getUnitString().equals(tr.getUnitString())) {
                            active = true;
                        }
                        pan.removeTrack(tr2);
                        if (active && pan.getTracks().size() > 0) {
                            pan.getRuler().setRange(((AbstractTSTrack)tracks.get(0)).getRange());
                            pan.getRuler().setUnitString(((AbstractTSTrack)tracks.get(0)).getUnitString());
                        }
                        this.paintBuffer();
                        continue block0;
                    }
                }
            }
        } else if (event.getEditSourceType() == 100 && event.getSource() instanceof TSSourceConfiguration) {
            Object val;
            Set keySet;
            TSSourceConfiguration configuration = (TSSourceConfiguration)event.getSource();
            if (event.getEditType() == 0 && (keySet = configuration.objectKeySet()).size() == 1 && (val = configuration.getObject(keySet.iterator().next())) instanceof TSTrackConfiguration) {
                TSTrackConfiguration trc = (TSTrackConfiguration)val;
                AbstractTSTrack tr = (AbstractTSTrack)trc.getObject(trc.getTrackName());
                if (this.trackPanels.size() == 1 && ((TSTrackPanelImpl)this.trackPanels.get(0)).getTracks().size() == 0) {
                    TSTrackPanelImpl trsp = (TSTrackPanelImpl)this.trackPanels.get(0);
                    trsp.addTrack(tr);
                    trsp.getRuler().setRange(tr.getRange());
                    trsp.getRuler().setUnitString(tr.getUnitString());
                    this.paintBuffer();
                    this.storePanelSetup();
                }
            }
        }
    }
}

