/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.util.WAVCuePoint;
import mpi.eudico.client.util.WAVCueSection;

public class WAVHeader {
    public static final short WAVE_FORMAT_UNCOMPRESSED = 0;
    public static final short WAVE_FORMAT_PCM = 1;
    public static final short WAVE_FORMAT_IEEE_FLOAT = 3;
    public static final short WAVE_FORMAT_ALAW = 6;
    public static final short WAVE_FORMAT_MULAW = 7;
    public static final String[] formatDescriptions = new String[]{"Unknown", "PCM (uncompressed)", "MS ADPCM", "IEEE float", "", "IBM CVSD", "8-bit ITU-T G.711 A-law", "8-bit ITU-T G.711 \u00b5-law"};
    private HashMap infos = new HashMap();
    private WAVCuePoint[] cuePoints = new WAVCuePoint[0];
    private WAVCueSection[] cueSections = new WAVCueSection[0];
    private char[] dID = new char[4];
    private char[] fID = new char[4];
    private short[] formatSpecific;
    private char[] riff = new char[4];
    private char[] wID = new char[4];
    private int dLen;
    private int fLen;
    private int headerSize;
    private int nAvgBytesPerSec;
    private int nSamplesPerSec;
    private int rLen;
    private long fileSize;
    private short nBlockAlign;
    private short nChannels;
    private short wFormatTag;
    private short wBitsPerSample;
    private short cbSize;
    private char[] factID;
    private int factLen;
    private int dwSampleLength;

    public WAVHeader(String fileName) {
        try {
            this.read(new RandomAccessFile(fileName, "r"));
        }
        catch (FileNotFoundException fne) {
            System.out.println("File " + fileName + " not found.");
            return;
        }
    }

    public WAVHeader(RandomAccessFile soundFile) {
        this.read(soundFile);
    }

    public short getCompressionCode() {
        return this.wFormatTag;
    }

    public WAVCuePoint[] getCuePoints() {
        return this.cuePoints;
    }

    public WAVCueSection[] getCueSections() {
        return this.cueSections;
    }

    public int getDataLength() {
        return this.dLen;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getFrequency() {
        return this.nSamplesPerSec;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public String getInfo() {
        StringBuffer info = new StringBuffer();
        for (Object key : this.infos.keySet()) {
            info.append("\n" + key + " : " + this.infos.get(key));
        }
        return info.toString();
    }

    public short getNumberOfChannels() {
        return this.nChannels;
    }

    public short getSampleSize() {
        return this.nBlockAlign;
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                WAVHeader wavHeader = new WAVHeader(args[0]);
                System.out.println(wavHeader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(RandomAccessFile soundFile) {
        try {
            int chunkDataSize;
            String chunkID;
            int i;
            this.fileSize = soundFile.length();
            byte[] b = new byte[12];
            soundFile.read(b);
            for (i = 0; i < 4; ++i) {
                this.riff[i] = (char)b[i];
            }
            this.rLen = WAVHeader.getInt(b[4], b[5], b[6], b[7]);
            for (i = 0; i < 4; ++i) {
                this.wID[i] = (char)b[8 + i];
            }
            this.headerSize = 12;
            while (true) {
                b = new byte[8];
                soundFile.read(b);
                this.headerSize += 8;
                chunkID = WAVHeader.getString(b, 4);
                chunkDataSize = WAVHeader.getInt(b[4], b[5], b[6], b[7]);
                if ("data".equalsIgnoreCase(chunkID)) break;
                b = new byte[chunkDataSize];
                soundFile.read(b);
                if ("fmt ".equals(chunkID)) {
                    this.fID = chunkID.toCharArray();
                    this.fLen = chunkDataSize;
                    this.wFormatTag = WAVHeader.getShort(b[0], b[1]);
                    this.nChannels = WAVHeader.getShort(b[2], b[3]);
                    this.nSamplesPerSec = WAVHeader.getInt(b[4], b[5], b[6], b[7]);
                    this.nAvgBytesPerSec = WAVHeader.getInt(b[8], b[9], b[10], b[11]);
                    this.nBlockAlign = WAVHeader.getShort(b[12], b[13]);
                    int index = 14;
                    int fslength = this.fLen - index;
                    if (fslength >= 2) {
                        this.wBitsPerSample = WAVHeader.getShort(b[14], b[15]);
                        fslength -= 2;
                        index += 2;
                    }
                    this.formatSpecific = new short[fslength / 2];
                    for (int i2 = 0; i2 < fslength; i2 += 2) {
                        this.formatSpecific[i2 / 2] = WAVHeader.getShort(b[index + i2], b[index + 1 + i2]);
                    }
                } else if ("fact".equals(chunkID)) {
                    this.factID = chunkID.toCharArray();
                    this.factLen = chunkDataSize;
                    this.dwSampleLength = WAVHeader.getInt(b[0], b[1], b[2], b[3]);
                } else {
                    System.out.println(chunkID + " header found - ignoring contents...");
                }
                this.headerSize += chunkDataSize;
            }
            this.dID = chunkID.toCharArray();
            this.dLen = chunkDataSize;
            if (this.fileSize > (long)(28 + this.fLen + this.dLen)) {
                this.readCues(soundFile);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer("File size: " + this.fileSize + " Bytes");
        output.append("\nHeader Size: " + this.headerSize);
        try {
            int i;
            output.append("\n00-03 Letters                 : ").append(this.riff);
            output.append("\n04-07 Length of rdata chunk   : ").append(this.rLen);
            output.append("\n================ rdata chunk ===================");
            output.append("\n08-11 Letters                 : ").append(this.wID);
            output.append("\n=============== format chunk ================");
            output.append("\n12-15 Letters                 : ").append(this.fID);
            output.append("\n16-19 Length of rest of chunk : ").append(this.fLen);
            output.append("\n20-21 WAV Format Tag          : ").append(this.wFormatTag);
            output.append("\n22-23 Number of channels      : ").append(this.nChannels);
            output.append("\n24-27 Sample frequency        : ").append(this.nSamplesPerSec);
            output.append("\n28-31 nAvgBytesPerSec         : ").append(this.nAvgBytesPerSec);
            output.append("\n32-33 nBlockAlign             : ").append(this.nBlockAlign);
            output.append("\n34-35 wBitsPerSample          : ").append(this.wBitsPerSample);
            for (i = 0; i < this.formatSpecific.length; ++i) {
                output.append("\n").append(36 + i * 2 + "-" + (37 + i * 2));
                output.append(" Format specific data    : ").append(this.formatSpecific[i]);
            }
            if (this.factID != null) {
                output.append("\n================ fact chunk =================");
                output.append("\n" + (20 + this.fLen) + "-" + (23 + this.fLen) + " Letters                 : ").append(this.factID);
                output.append("\n" + (24 + this.fLen) + "-" + (27 + this.fLen) + " Length of rest of chunk : ").append(this.factLen);
                output.append("\n" + (28 + this.fLen) + "-" + (31 + this.fLen) + " dwSampleLength          : ").append(this.dwSampleLength);
            }
            output.append("\n================ data chunk =================");
            output.append("\n" + (20 + this.fLen + this.factLen) + "-" + (23 + this.fLen + this.factLen)).append(" Letters                 : ");
            output.append(this.dID).append("\n" + (24 + this.fLen + this.factLen) + "-" + (27 + this.fLen + this.factLen));
            output.append(" Length of following data: ").append(this.dLen + "\n" + (28 + this.fLen + this.factLen) + "-" + (28 + this.fLen + this.factLen + this.dLen)).append(" (data)");
            if (this.cuePoints.length > 0) {
                output.append("\n================= cue Chunk =================");
                for (i = 0; i < this.cuePoints.length; ++i) {
                    output.append("\nCue point " + i + ":\n" + this.cuePoints[i]);
                }
            }
            if (this.cueSections.length > 0) {
                output.append("\n==================list chunk ================");
                output.append("\n============ labeled text chunk ===========");
                for (i = 0; i < this.cueSections.length; ++i) {
                    output.append("\nCue section " + i + ":\n" + this.cueSections[i]);
                }
            }
            output.append(this.getInfo());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return "";
        }
        return output.toString();
    }

    private static WAVCuePoint[] getCuePoints(RandomAccessFile soundFile) throws IOException {
        byte[] b = new byte[4];
        soundFile.read(b);
        soundFile.read(b);
        int numCuePoints = WAVHeader.getInt(b);
        WAVCuePoint[] cuePoints = new WAVCuePoint[numCuePoints];
        for (int i = 0; i < cuePoints.length; ++i) {
            soundFile.read(b);
            int ID = WAVHeader.getInt(b);
            soundFile.read(b);
            int position = WAVHeader.getInt(b);
            soundFile.read(b);
            String dataChunkID = WAVHeader.getString(b);
            soundFile.read(b);
            int chunkStart = WAVHeader.getInt(b);
            soundFile.read(b);
            int blockStart = WAVHeader.getInt(b);
            soundFile.read(b);
            int sampleOffset = WAVHeader.getInt(b);
            if (!"data".equals(dataChunkID)) {
                System.out.println("Warning: Reading of cue points failed!");
                System.out.println("Cannot handle Cue Point with Data Chunk ID '" + dataChunkID + "'");
                return new WAVCuePoint[0];
            }
            cuePoints[i] = new WAVCuePoint(ID, position, chunkStart, blockStart, sampleOffset);
        }
        return cuePoints;
    }

    private static WAVCueSection getCueSection(RandomAccessFile soundFile, WAVCuePoint[] cuePoints) throws IOException {
        String label;
        byte[] b = new byte[4];
        byte[] s = new byte[2];
        WAVCueSection cueSection = null;
        long seek = soundFile.getFilePointer();
        soundFile.read(b);
        int chunkDataSize = WAVHeader.getInt(b);
        soundFile.read(b);
        int cuePointID = WAVHeader.getInt(b);
        soundFile.read(b);
        int sampleLength = WAVHeader.getInt(b);
        soundFile.read(b);
        String purposeID = WAVHeader.getString(b);
        soundFile.read(s);
        short country = WAVHeader.getShort(s);
        soundFile.read(s);
        short language = WAVHeader.getShort(s);
        soundFile.read(s);
        short dialect = WAVHeader.getShort(s);
        soundFile.read(s);
        short codePage = WAVHeader.getShort(s);
        if (chunkDataSize - 20 - 1 >= 0) {
            byte[] t = new byte[chunkDataSize - 20 - 1];
            soundFile.read(t);
            label = WAVHeader.getString(t);
        } else {
            label = "";
        }
        for (int i = 0; i < cuePoints.length; ++i) {
            if (cuePoints[i].getID() != cuePointID) continue;
            cueSection = new WAVCueSection(cuePoints[i], sampleLength, purposeID, country, language, dialect, codePage, label);
            break;
        }
        seek += (long)(chunkDataSize + 4);
        seek += seek % 2L;
        soundFile.seek(seek);
        return cueSection;
    }

    private static String getInfo(RandomAccessFile soundFile) throws IOException {
        String info = "";
        byte[] b = new byte[4];
        soundFile.read(b);
        int chunkDataSize = WAVHeader.getInt(b);
        if (chunkDataSize > 0) {
            byte[] t = new byte[chunkDataSize];
            soundFile.read(t);
            info = WAVHeader.getString(t);
        }
        soundFile.seek(soundFile.getFilePointer() + soundFile.getFilePointer() % 2L);
        return info;
    }

    private static int getInt(byte[] bytes) {
        return WAVHeader.getInt(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    private static int getInt(byte b1, byte b2, byte b3, byte b4) {
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    private static short getShort(byte[] s) {
        return WAVHeader.getShort(s[0], s[1]);
    }

    private static short getShort(byte b1, byte b2) {
        return (short)(b1 & 0xFF | (b2 & 0xFF) << 8);
    }

    private static String getString(byte[] bytes) {
        return WAVHeader.getString(bytes, bytes.length);
    }

    private static String getString(byte[] bytes, int nrOfBytes) {
        char[] asChar = new char[nrOfBytes];
        for (int i = 0; i < nrOfBytes; ++i) {
            asChar[i] = bytes[i] > 32 ? (int)bytes[i] : 32;
        }
        return new String(asChar);
    }

    private void readAssociatedDataList(RandomAccessFile soundFile) {
        ArrayList<WAVCueSection> cueSectionList = new ArrayList<WAVCueSection>();
        byte[] b = new byte[4];
        try {
            while (soundFile.getFilePointer() < soundFile.length()) {
                soundFile.read(b);
                if ("ltxt".equals(WAVHeader.getString(b))) {
                    WAVCueSection cueSection = WAVHeader.getCueSection(soundFile, this.cuePoints);
                    if (cueSection == null) continue;
                    cueSectionList.add(cueSection);
                    continue;
                }
                if ("labl".equals(WAVHeader.getString(b))) {
                    WAVHeader.readCuePointLabels(soundFile, this.cuePoints);
                    continue;
                }
                if (!"note".equals(WAVHeader.getString(b))) break;
                WAVHeader.readCuePointNotes(soundFile, this.cuePoints);
            }
            this.cueSections = cueSectionList.toArray(new WAVCueSection[0]);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private static void readCuePointLabels(RandomAccessFile soundFile, WAVCuePoint[] cuePoints) throws IOException {
        byte[] b = new byte[4];
        long seek = soundFile.getFilePointer();
        soundFile.read(b);
        int chunkDataSize = WAVHeader.getInt(b);
        soundFile.read(b);
        int cuePointID = WAVHeader.getInt(b);
        if (chunkDataSize - 4 - 1 >= 0) {
            byte[] t = new byte[chunkDataSize - 4 - 1];
            soundFile.read(t);
            String label = WAVHeader.getString(t);
            for (int i = 0; i < cuePoints.length; ++i) {
                if (cuePoints[i].getID() != cuePointID) continue;
                cuePoints[i].setLabel(label);
                break;
            }
        }
        seek += (long)(chunkDataSize + 4);
        seek += seek % 2L;
        soundFile.seek(seek);
    }

    private static void readCuePointNotes(RandomAccessFile soundFile, WAVCuePoint[] cuePoints) throws IOException {
        byte[] b = new byte[4];
        long seek = soundFile.getFilePointer();
        soundFile.read(b);
        int chunkDataSize = WAVHeader.getInt(b);
        soundFile.read(b);
        int cuePointID = WAVHeader.getInt(b);
        if (chunkDataSize - 4 - 1 >= 0) {
            byte[] t = new byte[chunkDataSize - 4 - 1];
            soundFile.read(t);
            String label = WAVHeader.getString(t);
            for (int i = 0; i < cuePoints.length; ++i) {
                if (cuePoints[i].getID() != cuePointID) continue;
                cuePoints[i].setNote(label);
                break;
            }
        }
        seek += (long)(chunkDataSize + 4);
        seek += seek % 2L;
        soundFile.seek(seek);
    }

    private void readCues(RandomAccessFile soundFile) {
        byte[] b = new byte[4];
        try {
            soundFile.seek(28 + this.fLen + this.dLen);
            int listChunkSize = 0;
            while (soundFile.getFilePointer() < soundFile.length()) {
                soundFile.read(b);
                if ("list".equals(WAVHeader.getString(b).toLowerCase())) {
                    soundFile.read(b);
                    listChunkSize = WAVHeader.getInt(b);
                }
                if ("cue ".equals(WAVHeader.getString(b))) {
                    this.cuePoints = WAVHeader.getCuePoints(soundFile);
                    continue;
                }
                if ("adtl".equals(WAVHeader.getString(b))) {
                    this.readAssociatedDataList(soundFile);
                    continue;
                }
                if (!"info".equals(WAVHeader.getString(b).toLowerCase())) continue;
                long endOfChunk = soundFile.getFilePointer() + (long)listChunkSize - 4L;
                while (soundFile.getFilePointer() < endOfChunk && soundFile.getFilePointer() < soundFile.length()) {
                    soundFile.read(b);
                    this.infos.put(WAVHeader.getString(b), WAVHeader.getInfo(soundFile));
                }
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

