/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.p2p;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.p2p.ElanP2P;

public class CollaborationPanel
extends JComponent
implements ActionListener,
TableModelListener,
ElanLocaleListener {
    private JLabel sessionNameLabel;
    private JLabel chairNameLabel;
    private JLabel docNameLabel;
    private JLabel sessionValueLabel;
    private JLabel chairValueLabel;
    private JLabel docValueLabel;
    private JTable sessionTable;
    private DefaultTableModel sessionTableModel;
    private JButton requestControlButton;
    private JButton byeButton;
    private String controllingParticipantMail;
    private String localParticipantName;
    private String localParticipantMail;
    private ElanP2P elanP2P;
    private static Logger logger = Logger.getLogger(CollaborationPanel.class.getName());

    public CollaborationPanel() {
        this.initPanel();
        CollaborationPanel.populate(this);
    }

    public CollaborationPanel(ElanP2P elanP2P) {
        this.elanP2P = elanP2P;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(3, 5, 3, 5);
        this.sessionNameLabel = new JLabel();
        this.chairNameLabel = new JLabel();
        this.docNameLabel = new JLabel();
        this.sessionValueLabel = new JLabel();
        this.chairValueLabel = new JLabel();
        this.docValueLabel = new JLabel();
        this.sessionTableModel = new CollaborativeTableModel();
        this.sessionTable = new JTable(this.sessionTableModel);
        JScrollPane tableScrollPane = new JScrollPane(this.sessionTable);
        this.requestControlButton = new JButton();
        this.requestControlButton.setActionCommand("control");
        this.requestControlButton.addActionListener(this);
        this.byeButton = new JButton();
        this.byeButton.addActionListener(this);
        this.byeButton.setActionCommand("bye");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        this.add((Component)this.sessionNameLabel, gbc);
        gbc.gridx = 1;
        this.add((Component)this.sessionValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.chairNameLabel, gbc);
        gbc.gridx = 1;
        this.add((Component)this.chairValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.add((Component)this.docNameLabel, gbc);
        gbc.gridx = 1;
        this.add((Component)this.docValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)tableScrollPane, gbc);
        gbc.gridy = 4;
        gbc.fill = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.requestControlButton, gbc);
        gbc.gridy = 5;
        gbc.anchor = 12;
        this.add((Component)this.byeButton, gbc);
        this.updateLocale();
        this.sessionTable.getColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Control")).setMaxWidth(60);
        this.sessionTable.getColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Control")).setCellRenderer(new RadioButtonTableCellRenderer());
    }

    private void logOff() {
        logger.info("Signing off...");
        this.elanP2P.leaveSession();
        for (int i = this.sessionTableModel.getRowCount() - 1; i >= 0; --i) {
            this.sessionTableModel.removeRow(i);
        }
        String empty = "";
        this.setSessionName("");
        this.setChairName("");
        this.setSharedDocumentName("");
    }

    private void requestControl() {
        if (this.localParticipantMail == null) {
            return;
        }
        if (this.localParticipantMail.equals(this.controllingParticipantMail)) {
            return;
        }
        this.elanP2P.requestControl();
        this.setControllingParticipant(this.localParticipantMail);
        logger.info("Setting controlling participant to: " + this.localParticipantMail);
    }

    public String getLocalParticipantMail() {
        return this.localParticipantMail;
    }

    public String getLocalParticipantName() {
        return this.localParticipantName;
    }

    public void setLocalParticipantMail(String localParticipantMail) {
        this.localParticipantMail = localParticipantMail;
    }

    public void setLocalParticipantName(String localParticipantName) {
        this.localParticipantName = localParticipantName;
    }

    public void setSessionName(String name) {
        if (name != null) {
            this.sessionValueLabel.setText(name);
        }
    }

    public String getSessionName() {
        return this.sessionValueLabel.getText();
    }

    public void setChairName(String name) {
        if (name != null) {
            this.chairValueLabel.setText(name);
        }
    }

    public String getChairName() {
        return this.chairValueLabel.getText();
    }

    public void setSharedDocumentName(String name) {
        if (name != null) {
            this.docValueLabel.setText(name);
        }
    }

    public String getSharedDocumentName() {
        return this.docValueLabel.getText();
    }

    public void addParticipant(String name, String email) {
        if (name == null) {
            logger.warning("Illegal Argument: A participant without a name is not allowed");
            throw new IllegalArgumentException("A participant without a name is not allowed");
        }
        if (email == null) {
            logger.warning("Illegal Argument: A participant without a valid email address is not allowed");
            throw new IllegalArgumentException("A participant without a valid email address is not allowed");
        }
        int nameColumn = this.sessionTableModel.findColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Participant"));
        int emailColumn = this.sessionTableModel.findColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Mail"));
        for (int i = 0; i < this.sessionTableModel.getRowCount(); ++i) {
            String nm = (String)this.sessionTableModel.getValueAt(i, nameColumn);
            if (name.equals(nm)) {
                logger.warning("Illegal Argument: A participant with this name already exists");
                throw new IllegalArgumentException("A participant with this name already exists");
            }
            String mail = (String)this.sessionTableModel.getValueAt(i, emailColumn);
            if (!email.equals(mail)) continue;
            logger.warning("Illegal Argument: A participant with this email address already exists");
            throw new IllegalArgumentException("A participant with this email address already exists");
        }
        this.sessionTableModel.addRow(new String[]{"false", name, email});
    }

    public void removeParticipant(String email) {
        int column = this.sessionTableModel.findColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Mail"));
        for (int i = 0; i < this.sessionTableModel.getRowCount(); ++i) {
            String n = (String)this.sessionTableModel.getValueAt(i, column);
            if (!email.equals(n)) continue;
            this.sessionTableModel.removeRow(i);
            if (this.controllingParticipantMail.equals(email)) {
                this.controllingParticipantMail = null;
            }
            return;
        }
    }

    public void setControllingParticipant(String mail) {
        int mailColumn = this.sessionTableModel.findColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Mail"));
        int controlColumn = this.sessionTableModel.findColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Control"));
        for (int i = 0; i < this.sessionTableModel.getRowCount(); ++i) {
            String n = (String)this.sessionTableModel.getValueAt(i, mailColumn);
            if (mail.equals(n)) {
                this.sessionTableModel.setValueAt("true", i, controlColumn);
                this.controllingParticipantMail = mail;
                continue;
            }
            this.sessionTableModel.setValueAt("false", i, controlColumn);
        }
    }

    public String getControllingParticipant() {
        return this.controllingParticipantMail;
    }

    @Override
    public void updateLocale() {
        this.sessionNameLabel.setText(ElanLocale.getString("P2P.CollaborationPanel.Label.Session"));
        this.chairNameLabel.setText(ElanLocale.getString("P2P.CollaborationPanel.Label.Chair"));
        this.docNameLabel.setText(ElanLocale.getString("P2P.CollaborationPanel.Label.Document"));
        this.sessionValueLabel.setText("");
        this.chairValueLabel.setText("");
        this.docValueLabel.setText("");
        this.sessionTableModel.setColumnIdentifiers(new String[]{ElanLocale.getString("P2P.CollaborationPanel.Header.Control"), ElanLocale.getString("P2P.CollaborationPanel.Header.Participant"), ElanLocale.getString("P2P.CollaborationPanel.Header.Mail")});
        this.byeButton.setText(ElanLocale.getString("P2P.CollaborationPanel.Button.Bye"));
        this.requestControlButton.setText(ElanLocale.getString("P2P.CollaborationPanel.Button.Control"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("bye")) {
            this.logOff();
        } else if (event.getActionCommand().equals("control")) {
            this.requestControl();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        if (tme.getType() == 0) {
            String oldControllingPartMail = this.controllingParticipantMail;
            this.sessionTableModel.removeTableModelListener(this);
            int row = tme.getFirstRow();
            int column = tme.getColumn();
            TableModel tm = (TableModel)tme.getSource();
            for (int i = 0; i < tm.getRowCount(); ++i) {
                if (i != row) {
                    tm.setValueAt("false", i, column);
                    continue;
                }
                int mailColumn = this.sessionTableModel.findColumn(ElanLocale.getString("P2P.CollaborationPanel.Header.Mail"));
                this.controllingParticipantMail = (String)tm.getValueAt(i, mailColumn);
                if (this.controllingParticipantMail.equals(oldControllingPartMail)) continue;
                logger.info("Setting controlling participant to: " + this.controllingParticipantMail);
            }
            this.sessionTableModel.addTableModelListener(this);
        }
    }

    public static void main(String[] args) {
        CollaborationPanel cp = new CollaborationPanel();
        CollaborationPanel.showFrame(cp);
        CollaborationPanel.populate(cp);
    }

    private static void showFrame(CollaborationPanel cp) {
        JFrame frame = new JFrame("Collaboration");
        frame.getContentPane().add(cp);
        frame.setSize(400, 300);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    private static void populate(final CollaborationPanel cp) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                cp.setSessionName("Test session");
                cp.setChairName("Kofi Annan");
                cp.setSharedDocumentName("test document");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    class RadioButtonTableCellRenderer
    extends JRadioButton
    implements TableCellRenderer,
    Serializable {
        RadioButtonTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setBackground(table.getBackground());
            }
            this.setValue(value);
            this.setHorizontalAlignment(0);
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        protected void setValue(Object value) {
            boolean selected = false;
            if (value instanceof Boolean) {
                selected = (Boolean)value;
            } else if (value instanceof String) {
                selected = ((String)value).equalsIgnoreCase("true");
            }
            super.setSelected(selected);
        }
    }

    class RadioButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    Serializable {
        private JRadioButton radioButton = new JRadioButton();

        RadioButtonCellEditor() {
            this.radioButton.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setValue(value);
            if (isSelected) {
                this.radioButton.setBackground(table.getSelectionBackground());
            } else {
                this.radioButton.setBackground(table.getBackground());
            }
            this.radioButton.setHorizontalAlignment(0);
            return this.radioButton;
        }

        private void setValue(Object value) {
            boolean selected = false;
            if (value instanceof Boolean) {
                selected = (Boolean)value;
            } else if (value instanceof String) {
                selected = ((String)value).equalsIgnoreCase("true");
            }
            this.radioButton.setSelected(selected);
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return new Boolean(this.radioButton.isSelected());
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.radioButton.isSelected()) {
                this.radioButton.setSelected(true);
            }
            this.stopCellEditing();
        }
    }

    class CollaborativeTableModel
    extends DefaultTableModel {
        CollaborativeTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

