/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.p2p;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;

public class PublishAndDiscoverPanel
extends JPanel {
    private String name;
    private String email;
    private String documentName;
    private JTextField docNameField;
    private JTextField partNameField;
    private JTextField partEmailField;
    private int mode = 1;
    public static final int PUBLISH_MODE = 0;
    public static final int DISCOVER_MODE = 1;

    public PublishAndDiscoverPanel() {
        this.initPanel();
    }

    public PublishAndDiscoverPanel(int mode) {
        this.mode = mode;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        JLabel docNameLabel = new JLabel(ElanLocale.getString("P2P.PublishAndDiscoverPanel.Label.DocumentName"));
        JLabel nameLabel = new JLabel(ElanLocale.getString("P2P.PublishAndDiscoverPanel.Label.ParticipantName"));
        JLabel mailLabel = new JLabel(ElanLocale.getString("P2P.PublishAndDiscoverPanel.Label.ParticipantMail"));
        this.docNameField = new JTextField(24);
        if (this.mode == 0) {
            this.docNameField.setEditable(false);
        }
        this.partNameField = new JTextField(24);
        this.partEmailField = new JTextField(24);
        Insets insets = new Insets(2, 2, 2, 8);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        this.add((Component)docNameLabel, gbc);
        gbc.gridy = 1;
        this.add((Component)nameLabel, gbc);
        gbc.gridy = 2;
        this.add((Component)mailLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.docNameField, gbc);
        gbc.gridy = 1;
        this.add((Component)this.partNameField, gbc);
        gbc.gridy = 2;
        this.add((Component)this.partEmailField, gbc);
    }

    public String getDocumentName() {
        if (this.docNameField.getText() != null) {
            this.documentName = this.docNameField.getText().trim();
        }
        return this.documentName;
    }

    public String getEmail() {
        if (this.partEmailField.getText() != null) {
            this.email = this.partEmailField.getText().trim();
        }
        return this.email;
    }

    @Override
    public String getName() {
        if (this.partNameField.getText() != null) {
            this.name = this.partNameField.getText().trim();
        }
        return this.name;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
        this.docNameField.setText(documentName);
    }

    public void setEmail(String email) {
        this.email = email;
        this.partEmailField.setText(email);
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.partNameField.setText(name);
    }
}

