/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.TreeSet;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeOrderImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class AlignableAnnotation
extends AbstractAnnotation {
    TimeSlot beginTime;
    TimeSlot endTime;

    public AlignableAnnotation(TimeSlot bts, TimeSlot ets, Tier theTier) {
        this.beginTime = bts;
        this.endTime = ets;
        this.setTier(theTier);
        this.registerWithParent();
    }

    public void registerWithParent() {
        Annotation p;
        if (this.hasParentAnnotation() && (p = this.getParentAnnotation()) != null) {
            p.addParentAnnotationListener(this);
        }
    }

    public TimeSlot getBegin() {
        return this.beginTime;
    }

    public void setBegin(TimeSlot theBegin) {
        this.beginTime = theBegin;
    }

    public TimeSlot getEnd() {
        return this.endTime;
    }

    public void setEnd(TimeSlot theEnd) {
        this.endTime = theEnd;
    }

    public void updateTimeInterval(long beginTime, long endTime) {
        long oldBegin = this.getBegin().getTime();
        long oldEnd = this.getEnd().getTime();
        AlignableAnnotation parent = null;
        if (this.hasParentAnnotation()) {
            parent = (AlignableAnnotation)this.getParentAnnotation();
            if (beginTime >= parent.getEnd().getTime() || endTime <= parent.getBegin().getTime()) {
                return;
            }
            if (!parent.getBegin().isTimeAligned() || !parent.getEnd().isTimeAligned()) {
                return;
            }
            if (this.getBegin() == parent.getBegin() && this.getEnd() == parent.getEnd()) {
                return;
            }
            if (endTime >= parent.getEnd().getTime()) {
                endTime = parent.getEnd().getTime();
            }
            if (beginTime <= parent.getBegin().getTime()) {
                beginTime = parent.getBegin().getTime();
                this.setBegin(parent.getBegin());
            }
        }
        TreeSet connectedAnnots = new TreeSet();
        TreeSet connectedTimeSlots = new TreeSet();
        ((TranscriptionImpl)((TierImpl)this.getTier()).getParent()).getConnectedAnnots(connectedAnnots, connectedTimeSlots, this.getBegin());
        Vector connectedAnnotVector = new Vector(connectedAnnots);
        TimeSlot[] graphEndpoints = ((TierImpl)this.getTier()).getGraphEndpoints(connectedAnnotVector);
        if (!(this.getBegin() == graphEndpoints[0] && this.hasParentAnnotation() || parent != null && this.getBegin() == parent.getBegin())) {
            this.getBegin().setTime(beginTime);
        }
        if (!(this.getEnd() == graphEndpoints[1] && this.hasParentAnnotation() || parent != null && this.getEnd() == parent.getEnd())) {
            this.getEnd().setTime(endTime);
        }
        if (((TranscriptionImpl)((TierImpl)this.getTier()).getParent()).getTimeChangePropagationMode() == 1 && !this.hasParentAnnotation()) {
            ((TierImpl)this.getTier()).correctOverlapsByPushing(this, oldBegin, oldEnd);
        } else if (((TranscriptionImpl)((TierImpl)this.getTier()).getParent()).getTimeChangePropagationMode() == 2 && !this.hasParentAnnotation()) {
            Vector fixedSlots = new Vector(connectedTimeSlots);
            ((TranscriptionImpl)((TierImpl)this.getTier()).getParent()).correctOverlapsByShifting(this, fixedSlots, oldBegin, oldEnd);
            ((TierImpl)this.getTier()).correctTimeOverlaps(this);
        } else {
            ((TierImpl)this.getTier()).correctTimeOverlaps(this);
        }
        this.notifyParentListeners();
        this.cleanUpUnalignedChildAnnotations();
        ((TranscriptionImpl)((TierImpl)this.getTier()).getParent()).pruneAnnotations(this.getTier());
        boolean consistent = this.checkAnnotationOrderConsistency((TierImpl)this.getTier());
        if (!consistent) {
            this.resortAnnotationsAndSlots(connectedTimeSlots);
        }
        this.modified(7, this);
    }

    @Override
    public long getBeginTimeBoundary() {
        long beginBoundary = 0L;
        beginBoundary = this.beginTime.isTimeAligned() ? this.beginTime.getTime() : (((TimeSlotImpl)this.beginTime).getProposedTime() >= 0L ? ((TimeSlotImpl)this.beginTime).getProposedTime() : ((TierImpl)this.getTier()).proposeTimeFor(this.beginTime));
        return beginBoundary;
    }

    @Override
    public long getEndTimeBoundary() {
        long endBoundary = this.getBeginTimeBoundary();
        endBoundary = this.endTime.isTimeAligned() ? this.endTime.getTime() : (((TimeSlotImpl)this.endTime).getProposedTime() >= 0L ? ((TimeSlotImpl)this.endTime).getProposedTime() : ((TierImpl)this.getTier()).proposeTimeFor(this.endTime));
        return endBoundary;
    }

    public long calculateBeginTime() {
        if (this.beginTime.isTimeAligned()) {
            return this.beginTime.getTime();
        }
        return ((TierImpl)this.getTier()).proposeTimeFor(this.beginTime);
    }

    public long calculateEndTime() {
        if (this.endTime.isTimeAligned()) {
            return this.endTime.getTime();
        }
        return ((TierImpl)this.getTier()).proposeTimeFor(this.endTime);
    }

    @Override
    public void parentAnnotationChanged(EventObject e) {
        if (e.getSource() instanceof AlignableAnnotation) {
            if (((Annotation)e.getSource()).isMarkedDeleted()) {
                ((AlignableAnnotation)e.getSource()).removeParentAnnotationListener(this);
                this.markDeleted(true);
            } else {
                long parentBegin = ((AlignableAnnotation)e.getSource()).getBegin().getTime();
                long parentEnd = ((AlignableAnnotation)e.getSource()).getEnd().getTime();
                if (this.beginTime.isTimeAligned()) {
                    if (this.beginTime.getTime() < parentBegin) {
                        this.beginTime.setTime(parentBegin);
                    }
                    if (this.beginTime.getTime() > parentEnd) {
                        this.beginTime.setTime(parentEnd);
                    }
                }
                if (this.endTime.isTimeAligned()) {
                    if (this.endTime.getTime() > parentEnd) {
                        this.endTime.setTime(parentEnd);
                    }
                    if (this.endTime.getTime() < parentBegin) {
                        this.endTime.setTime(parentBegin);
                    }
                }
                if (this.beginTime.isTimeAligned() && this.endTime.isTimeAligned() && this.beginTime.getTime() >= this.endTime.getTime()) {
                    ((AlignableAnnotation)e.getSource()).removeParentAnnotationListener(this);
                    this.markDeleted(true);
                }
            }
        }
    }

    @Override
    public boolean hasParentAnnotation() {
        Constraint c;
        boolean hasParent = false;
        LinguisticType lt = ((TierImpl)this.getTier()).getLinguisticType();
        if (lt != null && (c = lt.getConstraints()) != null && (c.getStereoType() == 0 || c.getStereoType() == 1)) {
            hasParent = true;
        }
        return hasParent;
    }

    @Override
    public Annotation getParentAnnotation() {
        AlignableAnnotation parent = null;
        TierImpl parentTier = (TierImpl)((TierImpl)this.getTier()).getParentTier();
        if (parentTier != null) {
            if (((TierImpl)this.getTier()).getLinguisticType().getConstraints().getStereoType() == 0) {
                TimeSlot chainBegin = ((TierImpl)this.getTier()).getBeginSlotOfChain(this.getBegin(), false);
                Vector candidates = parentTier.getAnnotationsUsingTimeSlot(chainBegin);
                for (int i = 0; i < candidates.size(); ++i) {
                    AlignableAnnotation a = (AlignableAnnotation)candidates.elementAt(i);
                    if (a.getBegin() != chainBegin) continue;
                    parent = a;
                    break;
                }
            } else if (((TierImpl)this.getTier()).getLinguisticType().getConstraints().getStereoType() == 1) {
                parent = (AlignableAnnotation)parentTier.getAnnotationAtTime(this.getBegin().getTime());
            }
        }
        return parent;
    }

    public boolean isAncestorOf(AlignableAnnotation aa) {
        if (aa == null) {
            return false;
        }
        if (this.getParentListeners().contains(aa)) {
            return true;
        }
        ArrayList pl = this.getParentListeners();
        for (int i = 0; i < pl.size(); ++i) {
            AlignableAnnotation chan;
            if (!(pl.get(i) instanceof AlignableAnnotation) || !(chan = (AlignableAnnotation)pl.get(i)).isAncestorOf(aa)) continue;
            return true;
        }
        return false;
    }

    private void cleanUpUnalignedChildAnnotations() {
        ArrayList l = this.getParentListeners();
        ArrayList<AlignableAnnotation> yetToBeDeleted = new ArrayList<AlignableAnnotation>();
        for (int i = 0; i < l.size(); ++i) {
            AlignableAnnotation aa;
            Annotation a = (Annotation)l.get(i);
            if (!(a instanceof AlignableAnnotation) || (aa = (AlignableAnnotation)a).getBegin().isTimeAligned() && aa.getEnd().isTimeAligned() || aa.calculateBeginTime() != aa.calculateEndTime()) continue;
            yetToBeDeleted.add(aa);
        }
        for (int j = 0; j < yetToBeDeleted.size(); ++j) {
            ((AlignableAnnotation)yetToBeDeleted.get(j)).markDeleted(true);
        }
    }

    private void resortAnnotationsAndSlots(TreeSet oldConnectedTimeSlots) {
        int i;
        ((TierImpl)this.getTier()).resortAnnotations();
        TimeOrderImpl timeOrder = (TimeOrderImpl)((TranscriptionImpl)((TierImpl)this.getTier()).getParent()).getTimeOrder();
        Vector<TimeSlot> slots = new Vector<TimeSlot>(oldConnectedTimeSlots);
        for (i = slots.size() - 1; i >= 0; --i) {
            TimeSlot sl = (TimeSlot)slots.get(i);
            Enumeration elements = timeOrder.elements();
            boolean stillPresent = false;
            while (elements.hasMoreElements()) {
                if (elements.nextElement() != sl) continue;
                stillPresent = true;
                break;
            }
            if (stillPresent) continue;
            slots.remove(i);
        }
        if (!slots.contains(this.getBegin())) {
            slots.add(0, this.getBegin());
        }
        if (!slots.contains(this.getEnd())) {
            slots.add(this.getEnd());
        }
        for (i = 0; i < slots.size() - 2; ++i) {
            TimeSlot t1 = (TimeSlot)slots.get(i);
            TimeSlot t2 = (TimeSlot)slots.get(i + 1);
            TimeSlot t3 = (TimeSlot)slots.get(i + 2);
            if (t2.isTimeAligned()) continue;
            int index1 = t1.getIndex();
            int index2 = t2.getIndex();
            int index3 = t3.getIndex();
            if (index2 < index1) {
                timeOrder.removeTimeSlot(t2);
                if (index2 > index3) {
                    timeOrder.insertTimeSlot(t2, t1, null);
                    continue;
                }
                timeOrder.insertTimeSlot(t2, t1, t3);
                continue;
            }
            if (index2 > index1) {
                timeOrder.removeTimeSlot(t2);
                timeOrder.insertTimeSlot(t2, t1, null);
                continue;
            }
            if (index2 <= index3) continue;
            timeOrder.removeTimeSlot(t2);
            if (index2 > index1) {
                timeOrder.insertTimeSlot(t2, t1, null);
                continue;
            }
            timeOrder.insertTimeSlot(t2, t1, t3);
        }
        Vector depTiers = ((TierImpl)this.getTier()).getDependentTiers();
        for (int i2 = 0; i2 < depTiers.size(); ++i2) {
            ((TierImpl)depTiers.get(i2)).resortAnnotations();
        }
    }

    private boolean checkAnnotationOrderConsistency(TierImpl fromTier) {
        boolean consistent = fromTier.checkAnnotationOrderConsistency();
        if (!consistent) {
            return consistent;
        }
        Vector depTiers = fromTier.getDependentTiers();
        for (int i = 0; i < depTiers.size(); ++i) {
            consistent = ((TierImpl)depTiers.get(i)).checkAnnotationOrderConsistency();
            if (consistent) continue;
            return consistent;
        }
        return consistent;
    }
}

