/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.io.Serializable;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Tag;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.util.ACMEditableObject;

public abstract class TagImpl
implements Tag,
Serializable {
    protected long beginTime;
    protected long endTime;
    protected Vector valueList;
    private Tier tier;
    protected int index;

    @Override
    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    @Override
    public void handleModification(ACMEditableObject source, int operation, Object modification) {
        if (this.tier != null) {
            this.tier.handleModification(source, operation, modification);
        }
    }

    public TagImpl(long theBeginTime, long theEndTime, Tier theTier) {
        this.beginTime = theBeginTime;
        this.endTime = theEndTime;
        this.tier = theTier;
        this.valueList = new Vector();
    }

    @Override
    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    public void addValue(String theValue) {
        int lastIndex = theValue.lastIndexOf(10);
        while (lastIndex > 0) {
            theValue = theValue.substring(0, lastIndex - 1) + "\n" + theValue.substring(lastIndex + 1);
            lastIndex = theValue.lastIndexOf(10);
        }
        lastIndex = theValue.lastIndexOf(9);
        while (lastIndex > 0) {
            theValue = theValue.substring(0, lastIndex) + "\\t" + theValue.substring(lastIndex + 1);
            lastIndex = theValue.lastIndexOf(9);
        }
        this.valueList.add(theValue.trim());
    }

    public void addValue(Object value) {
        this.valueList.add(value);
    }

    @Override
    public Vector getValues() {
        return this.valueList;
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int theIndex) {
        this.index = theIndex;
    }

    @Override
    public boolean isTimeAligned() {
        return this.beginTime != 0L || this.endTime != 0L;
    }

    @Override
    public abstract boolean isAfter(Tag var1);

    public int compareTo(Object obj) {
        int ret = 1;
        ret = this.getIndex() > ((Tag)obj).getIndex() ? 1 : -1;
        return ret;
    }

    public boolean equals(Object o) {
        return o instanceof Tag && ((Tag)o).getIndex() == this.index;
    }

    public int hashCode() {
        return this.index;
    }
}

