/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DataTreeNode;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TierSharedInfo;
import mpi.eudico.server.corpora.clom.TierUnsharedInfo;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierSharedInfoImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeProposer2;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.IllegalEditException;
import mpi.eudico.server.corpora.util.ACMEditableObject;

public class TierImpl
implements Tier {
    protected TierSharedInfo sharedInfo;
    protected TierUnsharedInfo unsharedInfo;
    protected DataTreeNode parent;
    protected TreeSet annotations;
    protected Hashtable tierMetadata;
    protected Tier parentTier;
    private LinguisticType linguisticType;

    @Override
    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    @Override
    public void handleModification(ACMEditableObject source, int operation, Object modification) {
        if (this.parent != null) {
            ((Transcription)this.parent).handleModification(source, operation, modification);
        }
    }

    public TierImpl(String name, String participant, Transcription parent, LinguisticType theType) {
        this(null, parent);
        this.sharedInfo = new TierSharedInfoImpl(name, null, this);
        if (participant == null) {
            this.setMetadata("PARTICIPANT", "");
        } else {
            this.setMetadata("PARTICIPANT", participant);
        }
        this.setMetadata("DEFAULT_LOCALE", "");
        this.setLinguisticType(theType);
    }

    public TierImpl(Tier parenttier, String name, String participant, Transcription parent, LinguisticType theType) {
        this(name, participant, parent, theType);
        this.setParentTier(parenttier);
    }

    public TierImpl(String theName, DataTreeNode theParent) {
        this.parent = theParent;
        this.annotations = new TreeSet();
        this.tierMetadata = new Hashtable();
    }

    public Annotation createAnnotation(long beginTime, long endTime) {
        AbstractAnnotation annotation = null;
        TimeOrder timeOrder = ((TranscriptionImpl)this.parent).getTimeOrder();
        if (!this.isTimeAlignable() && beginTime == endTime) {
            Annotation referedAnnot = ((TierImpl)this.getParentTier()).getAnnotationAtTime(beginTime);
            if (referedAnnot != null && this.getAnnotationAtTime(beginTime) == null) {
                annotation = new RefAnnotation(referedAnnot, this);
            }
        } else if (endTime > beginTime) {
            Constraint c = this.getLinguisticType().getConstraints();
            if (c != null) {
                Vector slots = c.getTimeSlotsForNewAnnotation(beginTime, endTime, this);
                if (slots.size() == 2) {
                    annotation = this.getLinguisticType().hasGraphicReferences() ? new SVGAlignableAnnotation((TimeSlot)slots.elementAt(0), (TimeSlot)slots.elementAt(1), this) : new AlignableAnnotation((TimeSlot)slots.elementAt(0), (TimeSlot)slots.elementAt(1), this);
                }
            } else {
                TimeSlotImpl bts = new TimeSlotImpl(beginTime, timeOrder);
                timeOrder.insertTimeSlot(bts);
                TimeSlotImpl ets = new TimeSlotImpl(endTime, timeOrder);
                timeOrder.insertTimeSlot(ets);
                AbstractAnnotation abstractAnnotation = annotation = this.getLinguisticType().hasGraphicReferences() ? new SVGAlignableAnnotation(bts, ets, this) : new AlignableAnnotation(bts, ets, this);
            }
        }
        if (annotation != null) {
            this.addAnnotation(annotation);
            this.modified(3, annotation);
        }
        return annotation;
    }

    @Override
    public String getName() {
        return this.sharedInfo.getTierName();
    }

    @Override
    public TierSharedInfo getTierSharedInfo() {
        return this.sharedInfo;
    }

    @Override
    public TierUnsharedInfo getTierUnsharedInfo() {
        return this.unsharedInfo;
    }

    @Override
    public double getTimeScale() {
        return 1.0;
    }

    @Override
    public DataTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void removeChild(DataTreeNode theChild) {
    }

    public void unreferenced() {
        this.getParent().removeChild(this);
    }

    public void setName(String theName) {
        this.sharedInfo.setTierName(theName);
        this.modified(2, null);
    }

    public void addAnnotation(Annotation theAnnotation) {
        this.annotations.add(theAnnotation);
        if (theAnnotation instanceof AlignableAnnotation) {
            AlignableAnnotation a = (AlignableAnnotation)theAnnotation;
            if (((TranscriptionImpl)this.parent).getTimeChangePropagationMode() == 1 && this.getParentTier() == null) {
                this.correctOverlapsByPushing(a, a.getBegin().getTime(), a.getBegin().getTime());
            } else if (((TranscriptionImpl)this.parent).getTimeChangePropagationMode() == 2 && this.getParentTier() == null) {
                Vector<TimeSlot> fixedSlots = new Vector<TimeSlot>();
                fixedSlots.add(a.getBegin());
                ((TranscriptionImpl)this.parent).correctOverlapsByShifting(a, fixedSlots, a.getBegin().getTime(), a.getBegin().getTime());
                this.correctTimeOverlaps(a);
            } else if (this.linguisticType.getConstraints() != null && this.linguisticType.getConstraints().getStereoType() == 0) {
                Vector overLaps;
                if (a.getBegin().isTimeAligned() && a.getEnd().isTimeAligned() && (overLaps = this.getOverlappingAnnotations(a.getBegin().getTime(), a.getEnd().getTime())).size() > 1) {
                    this.correctTimeOverlaps(a);
                    this.correctDependingOverlaps(a);
                }
            } else {
                this.correctTimeOverlaps(a);
            }
        }
    }

    public void shiftAnnotations(long numMsToShift, long lowerBoundary, long upperBoundary) throws IllegalEditException, IllegalArgumentException {
        if (numMsToShift == 0L) {
            return;
        }
        if (lowerBoundary >= upperBoundary) {
            throw new IllegalArgumentException("The lower boundary is greater than or the same as the upper boundary.");
        }
        if (lowerBoundary < 0L) {
            throw new IllegalArgumentException("The lower boundary has a negative value: " + lowerBoundary);
        }
        if (this.hasParentTier() || !this.isTimeAlignable()) {
            throw new IllegalEditException("Shifting annotations is only supported for time-alignableroot tiers");
        }
        ArrayList<AlignableAnnotation> annosToShift = new ArrayList<AlignableAnnotation>();
        Iterator annIt = this.annotations.iterator();
        AlignableAnnotation ann2 = null;
        while (annIt.hasNext()) {
            ann2 = (AlignableAnnotation)annIt.next();
            if (ann2.getBegin().getTime() >= lowerBoundary && ann2.getEnd().getTime() <= upperBoundary) {
                annosToShift.add(ann2);
            }
            if (ann2.getBegin().getTime() < upperBoundary) continue;
        }
        if (annosToShift.size() == 0) {
            return;
        }
        long[] emptySpace = new long[2];
        if (numMsToShift < 0L) {
            ann2 = (AlignableAnnotation)annosToShift.get(0);
            emptySpace[0] = ann2.getBegin().getTime() + numMsToShift;
            emptySpace[1] = ann2.getBegin().getTime();
        } else {
            ann2 = (AlignableAnnotation)annosToShift.get(annosToShift.size() - 1);
            emptySpace[0] = ann2.getEnd().getTime();
            emptySpace[1] = ann2.getEnd().getTime() + numMsToShift;
        }
        for (AlignableAnnotation ann2 : this.annotations) {
            if (ann2.getEnd().getTime() <= emptySpace[0]) continue;
            if (ann2.getBegin().getTime() >= emptySpace[1]) break;
            if (ann2.getEnd().getTime() <= emptySpace[0] || ann2.getBegin().getTime() >= emptySpace[1] || annosToShift.contains(ann2)) continue;
            throw new IllegalEditException("There is at least one annotation in the time interval where annotations should be moved to. \nMove it out of the way first.\nB: " + ann2.getBegin().getTime() + " E: " + ann2.getEnd().getTime());
        }
        TreeSet annots = new TreeSet();
        TreeSet slots = new TreeSet();
        TranscriptionImpl trans = (TranscriptionImpl)this.getParent();
        TimeSlotImpl slot22 = null;
        if (numMsToShift < 0L) {
            for (int i = 0; i < annosToShift.size(); ++i) {
                ann2 = (AlignableAnnotation)annosToShift.get(i);
                annots.clear();
                slots.clear();
                slot22 = null;
                trans.getConnectedAnnots(annots, slots, ann2);
                for (TimeSlotImpl slot22 : slots) {
                    trans.getTimeOrder().removeTimeSlot(slot22);
                }
                for (TimeSlotImpl slot22 : slots) {
                    if (slot22.isAligned) {
                        slot22.updateTime(slot22.getTime() + numMsToShift);
                        continue;
                    }
                    slot22.setProposedTime(slot22.getProposedTime() + numMsToShift);
                }
                TimeSlotImpl slot1 = (TimeSlotImpl)slots.first();
                trans.getTimeOrder().insertTimeSlot(slot1);
                TimeSlotImpl slot2 = (TimeSlotImpl)slots.last();
                trans.getTimeOrder().insertTimeSlot(slot2);
                for (TimeSlotImpl slot22 : slots) {
                    if (slot22 == slot1) {
                        slot1 = slot22;
                        continue;
                    }
                    if (slot22 == slot2) continue;
                    if (slot22.isTimeAligned()) {
                        trans.getTimeOrder().insertTimeSlot(slot22);
                    } else {
                        trans.getTimeOrder().insertTimeSlot(slot22, slot1, slot2);
                    }
                    slot1 = slot22;
                }
            }
        } else {
            for (int i = annosToShift.size() - 1; i >= 0; --i) {
                ann2 = (AlignableAnnotation)annosToShift.get(i);
                annots.clear();
                slots.clear();
                slot22 = null;
                trans.getConnectedAnnots(annots, slots, ann2);
                for (TimeSlotImpl slot22 : slots) {
                    trans.getTimeOrder().removeTimeSlot(slot22);
                }
                for (TimeSlotImpl slot22 : slots) {
                    if (slot22.isAligned) {
                        slot22.updateTime(slot22.getTime() + numMsToShift);
                        continue;
                    }
                    slot22.setProposedTime(slot22.getProposedTime() + numMsToShift);
                }
                TimeSlotImpl slot1 = (TimeSlotImpl)slots.first();
                trans.getTimeOrder().insertTimeSlot(slot1);
                TimeSlotImpl slot2 = (TimeSlotImpl)slots.last();
                trans.getTimeOrder().insertTimeSlot(slot2);
                for (TimeSlotImpl slot22 : slots) {
                    if (slot22 == slot1) {
                        slot1 = slot22;
                        continue;
                    }
                    if (slot22 == slot2) continue;
                    if (slot22.isAligned) {
                        trans.getTimeOrder().insertTimeSlot(slot22);
                    } else {
                        trans.getTimeOrder().insertTimeSlot(slot22, slot1, slot2);
                    }
                    slot1 = slot22;
                }
            }
        }
    }

    public void insertAnnotation(Annotation theAnnotation) {
        this.annotations.add(theAnnotation);
    }

    public boolean checkAnnotationOrderConsistency() {
        Vector v = new Vector(this.annotations);
        for (int i = 0; i < v.size() - 1; ++i) {
            Annotation a2;
            Annotation a1 = (Annotation)v.get(i);
            if (a1.compareTo(a2 = (Annotation)v.get(i + 1)) != 1) continue;
            return false;
        }
        return true;
    }

    void resortAnnotations() {
        Vector v = new Vector(this.annotations);
        this.annotations.clear();
        this.annotations.addAll(v);
    }

    public Annotation createAnnotationBefore(Annotation beforeAnn) {
        Annotation a = null;
        Constraint c = this.linguisticType.getConstraints();
        if (c != null && c.supportsInsertion()) {
            a = c.insertBefore(beforeAnn, this);
            this.modified(4, a);
        }
        return a;
    }

    public Annotation createAnnotationAfter(Annotation afterAnn) {
        Annotation a = null;
        Constraint c = this.linguisticType.getConstraints();
        if (c != null && c.supportsInsertion()) {
            a = c.insertAfter(afterAnn, this);
            this.modified(5, a);
        }
        return a;
    }

    public void removeAnnotation(Annotation theAnnotation) {
        theAnnotation.markDeleted(true);
        ((TranscriptionImpl)this.parent).pruneAnnotations(this);
    }

    public void removeAllAnnotations() {
        for (Annotation annot : this.annotations) {
            annot.markDeleted(true);
        }
        ((TranscriptionImpl)this.parent).pruneAnnotations(this);
    }

    public Vector getAnnotations() {
        Vector annVector = new Vector(this.annotations);
        return annVector;
    }

    public Annotation getAnnotation(String id) {
        if (id == null) {
            return null;
        }
        Vector annVector = this.getAnnotations();
        for (int i = 0; i < annVector.size(); ++i) {
            if (!id.equals(((Annotation)annVector.get(i)).getId())) continue;
            return (Annotation)annVector.get(i);
        }
        return null;
    }

    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public Annotation getAnnotationBefore(Annotation theAnnotation) {
        Annotation previousAnnotation = null;
        Annotation currentAnnotation = null;
        Iterator iter = this.annotations.iterator();
        while (iter.hasNext()) {
            previousAnnotation = currentAnnotation;
            currentAnnotation = (Annotation)iter.next();
            if (!currentAnnotation.equals(theAnnotation)) continue;
            break;
        }
        return previousAnnotation;
    }

    public Annotation getAnnotationBefore(long time) {
        Annotation previousAnnotation = null;
        Annotation currentAnnotation = null;
        Annotation foundAnnotation = null;
        long lastEndTime = -1L;
        Iterator iter = this.annotations.iterator();
        while (iter.hasNext()) {
            previousAnnotation = currentAnnotation;
            currentAnnotation = (Annotation)iter.next();
            lastEndTime = currentAnnotation.getEndTimeBoundary();
            if (lastEndTime <= time) continue;
            foundAnnotation = previousAnnotation;
            break;
        }
        if (foundAnnotation != null) {
            return foundAnnotation;
        }
        if (lastEndTime > -1L && lastEndTime < time) {
            return currentAnnotation;
        }
        return null;
    }

    public Annotation getAnnotationAfter(Annotation theAnnotation) {
        Annotation nextAnnotation = null;
        Annotation currentAnnotation = null;
        Iterator iter = this.annotations.iterator();
        while (iter.hasNext()) {
            currentAnnotation = (Annotation)iter.next();
            if (!currentAnnotation.equals(theAnnotation)) continue;
            if (!iter.hasNext()) break;
            nextAnnotation = (Annotation)iter.next();
            break;
        }
        return nextAnnotation;
    }

    public Annotation getAnnotationAfter(long time) {
        Annotation currentAnnotation2 = null;
        Annotation resultAnnotation = null;
        for (Annotation currentAnnotation2 : this.annotations) {
            if (currentAnnotation2.getEndTimeBoundary() <= time) continue;
            resultAnnotation = currentAnnotation2;
            break;
        }
        return resultAnnotation;
    }

    public void correctTimeOverlaps(AlignableAnnotation fixedAnnotation) {
        TimeSlot fixedSlot1 = fixedAnnotation.getBegin();
        TimeSlot fixedSlot2 = fixedAnnotation.getEnd();
        if (!fixedSlot1.isTimeAligned()) {
            return;
        }
        if (!fixedSlot2.isTimeAligned()) {
            return;
        }
        TreeSet connectedAnnots = new TreeSet();
        TreeSet connectedTimeSlots = new TreeSet();
        ((TranscriptionImpl)this.parent).getConnectedAnnots(connectedAnnots, connectedTimeSlots, fixedAnnotation);
        Vector connectedAnnotVector = new Vector(connectedAnnots);
        ArrayList<AlignableAnnotation> correctedAnnos = new ArrayList<AlignableAnnotation>(connectedAnnotVector.size());
        TimeSlot[] graphEndpoints = this.getGraphEndpoints(connectedAnnotVector);
        TreeSet<AlignableAnnotation> overlappingAnnots = new TreeSet<AlignableAnnotation>();
        for (AlignableAnnotation ann : this.getOverlappingAnnotationsIncludeExtremes(fixedSlot1, fixedSlot2)) {
            Vector children;
            if (ann != fixedAnnotation) {
                overlappingAnnots.add(ann);
            }
            if ((children = ((TranscriptionImpl)this.parent).getChildAnnotationsOf(ann)).size() <= 0) continue;
            for (Annotation child : children) {
                if (!(child instanceof AlignableAnnotation)) continue;
                overlappingAnnots.add((AlignableAnnotation)child);
            }
        }
        Vector overlappingAnnotVector = new Vector(overlappingAnnots);
        overlappingAnnotVector = this.inGraphOrder(overlappingAnnotVector, graphEndpoints[0]);
        boolean forcedInside = false;
        for (AlignableAnnotation aa : overlappingAnnotVector) {
            if (correctedAnnos.contains(aa)) continue;
            correctedAnnos.add(aa);
            Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
            if (cc != null && cc.getStereoType() == 1) {
                if (fixedAnnotation.isAncestorOf(aa)) {
                    this.forceAnnotationInInterval(aa, fixedAnnotation);
                    continue;
                }
                this.forceOutOfFixedInterval(aa, fixedAnnotation);
                continue;
            }
            if (!connectedAnnotVector.contains(aa)) {
                if (aa.getTier() != fixedAnnotation.getTier()) continue;
                this.forceOutOfFixedInterval(aa, fixedAnnotation);
                this.forceChildAnnotationsOfAlignable(aa);
                continue;
            }
            if (!fixedAnnotation.hasParentAnnotation()) {
                if (!forcedInside) {
                    this.forceInsideFixedInterval(graphEndpoints, fixedAnnotation);
                    forcedInside = true;
                }
                if (cc == null || cc.getStereoType() != 0) continue;
                this.forceTSInsideFixedInterval(aa, graphEndpoints, fixedAnnotation);
                continue;
            }
            if (aa.getTier() != fixedAnnotation.getTier()) continue;
            this.forceAnnotChainOutOfFixedInterval(graphEndpoints, fixedSlot1, fixedSlot2);
            if (!aa.getBegin().isTimeAligned() || aa.getBegin().getTime() >= aa.getEnd().getTime()) continue;
            if (aa.getBegin().getTime() < fixedSlot1.getTime() && aa.getEnd().getTime() > fixedSlot1.getTime()) {
                this.forceChildChainOutOfInterval(aa, graphEndpoints, fixedSlot1, fixedSlot2, true);
                continue;
            }
            if (aa.getBegin().getTime() > fixedSlot2.getTime() || aa.getEnd().getTime() <= fixedSlot2.getTime()) continue;
            this.forceChildChainOutOfInterval(aa, graphEndpoints, fixedSlot1, fixedSlot2, false);
        }
        for (AlignableAnnotation aa : connectedAnnotVector) {
            if (correctedAnnos.contains(aa)) continue;
            correctedAnnos.add(aa);
            if (overlappingAnnotVector.contains(aa) || aa == fixedAnnotation || !((TierImpl)aa.getTier()).hasAncestor(this)) continue;
            Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
            if (cc != null && cc.getStereoType() == 1) {
                if (fixedAnnotation.isAncestorOf(aa)) {
                    this.forceAnnotationInInterval(aa, fixedAnnotation);
                } else {
                    this.forceOutOfFixedInterval(aa, fixedAnnotation);
                }
                overlappingAnnotVector.add(aa);
                continue;
            }
            if (cc == null || cc.getStereoType() != 0 || fixedAnnotation.isAncestorOf(aa)) continue;
            this.forceOutOfFixedInterval(aa, fixedAnnotation);
            overlappingAnnotVector.add(aa);
        }
        this.repositionUnalignedSlots(graphEndpoints[0]);
        if (overlappingAnnotVector.size() > 0) {
            this.markAnnotationsForDeletion(overlappingAnnotVector);
            ((TranscriptionImpl)this.parent).pruneAnnotations(this);
        }
    }

    public TimeSlot[] getGraphEndpoints(Vector connectedAnnotVector) {
        TimeSlot[] endpoints = new TimeSlot[2];
        for (AlignableAnnotation ann : connectedAnnotVector) {
            if (ann.hasParentAnnotation()) continue;
            endpoints[0] = ann.getBegin();
            endpoints[1] = ann.getEnd();
            break;
        }
        return endpoints;
    }

    public TimeSlot[] getEndpointsOfSubchain(TimeSlot theSlot, boolean stopAtAlignedSlot) {
        TimeSlot[] endpoints = new TimeSlot[]{this.getBeginSlotOfChain(theSlot, stopAtAlignedSlot), this.getEndSlotOfChain(theSlot, stopAtAlignedSlot)};
        return endpoints;
    }

    public TimeSlot getEndSlotOfChain(TimeSlot theSlot, boolean stopAtAlignedSlot) {
        TimeSlot endSlot = theSlot;
        if (this.getParentTier() != null && ((TierImpl)this.getParentTier()).getAnnotationsUsingTimeSlot(endSlot).size() > 0) {
            return endSlot;
        }
        Vector annotsFromSlot = this.getAnnotsBeginningAtTimeSlot(theSlot);
        if (annotsFromSlot.size() > 0) {
            AlignableAnnotation nextAnnot = (AlignableAnnotation)annotsFromSlot.firstElement();
            TimeSlot nextSlot = nextAnnot.getEnd();
            endSlot = nextSlot.isTimeAligned() && stopAtAlignedSlot || this.getParentTier() != null && ((TierImpl)this.getParentTier()).getAnnotationsUsingTimeSlot(nextSlot).size() > 0 ? nextSlot : this.getEndSlotOfChain(nextSlot, stopAtAlignedSlot);
        }
        return endSlot;
    }

    public TimeSlot getBeginSlotOfChain(TimeSlot theSlot, boolean stopAtAlignedSlot) {
        TimeSlot beginSlot = theSlot;
        if (this.getParentTier() != null && ((TierImpl)this.getParentTier()).getAnnotationsUsingTimeSlot(beginSlot).size() > 0) {
            return beginSlot;
        }
        Vector annotsToSlot = this.getAnnotsEndingAtTimeSlot(theSlot);
        if (annotsToSlot.size() > 0) {
            AlignableAnnotation prevAnnot = (AlignableAnnotation)annotsToSlot.firstElement();
            TimeSlot prevSlot = prevAnnot.getBegin();
            beginSlot = prevSlot.isTimeAligned() && stopAtAlignedSlot || this.getParentTier() != null && ((TierImpl)this.getParentTier()).getAnnotationsUsingTimeSlot(prevSlot).size() > 0 ? prevSlot : this.getBeginSlotOfChain(prevSlot, stopAtAlignedSlot);
        }
        return beginSlot;
    }

    private Vector inGraphOrder(Vector overlappingAnnots, TimeSlot graphBegin) {
        TimeSlot aBegin = graphBegin;
        TimeSlot aEnd = graphBegin;
        Vector annsForTS = null;
        AlignableAnnotation currentA = null;
        Vector<AlignableAnnotation> result = new Vector<AlignableAnnotation>();
        while (aEnd != null) {
            annsForTS = this.getAnnotsBeginningAtTimeSlot(aBegin);
            if (annsForTS != null && annsForTS.size() > 0) {
                currentA = (AlignableAnnotation)annsForTS.firstElement();
                aEnd = currentA.getEnd();
                if (overlappingAnnots.contains(currentA)) {
                    result.add(currentA);
                }
                aBegin = aEnd;
                continue;
            }
            aEnd = null;
        }
        for (AlignableAnnotation remA : overlappingAnnots) {
            if (result.contains(remA)) continue;
            result.add(remA);
        }
        return result;
    }

    private void forceOutOfFixedInterval(AlignableAnnotation aa, AlignableAnnotation fixedAnnotation) {
        TimeSlot begin = aa.getBegin();
        TimeSlot end = aa.getEnd();
        TimeSlot fixedSlot1 = fixedAnnotation.getBegin();
        TimeSlot fixedSlot2 = fixedAnnotation.getEnd();
        if (aa.getTier() == this) {
            boolean beginInFixedInterval = false;
            boolean endInFixedInterval = false;
            TreeSet connAnnots = new TreeSet();
            TreeSet connTimeSlots = new TreeSet();
            ((TranscriptionImpl)this.parent).getConnectedAnnots(connAnnots, connTimeSlots, begin);
            if (begin.isAfter(fixedSlot1) && fixedSlot2.isAfter(begin) || begin.getTime() == fixedSlot1.getTime()) {
                beginInFixedInterval = true;
            }
            if (end.isAfter(fixedSlot1) && fixedSlot2.isAfter(end) || end.getTime() == fixedSlot1.getTime()) {
                endInFixedInterval = true;
            }
            if (beginInFixedInterval && !endInFixedInterval) {
                this.shiftAfterTimeSlot(fixedSlot2, connTimeSlots);
            } else {
                this.shiftBeforeTimeSlot(fixedSlot1, connTimeSlots);
            }
        } else {
            Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
            if (cc != null && cc.getStereoType() == 1) {
                if (begin.getTime() >= fixedAnnotation.getBeginTimeBoundary() && begin.getTime() < fixedAnnotation.getEndTimeBoundary()) {
                    begin.setTime(fixedAnnotation.getEndTimeBoundary());
                    if (end.getTime() < fixedAnnotation.getEndTimeBoundary()) {
                        end.setTime(fixedAnnotation.getEndTimeBoundary());
                    }
                } else if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary() && end.getTime() > fixedAnnotation.getBeginTimeBoundary()) {
                    end.setTime(fixedAnnotation.getBeginTimeBoundary());
                } else if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary() && end.getTime() >= fixedAnnotation.getEndTimeBoundary()) {
                    end.setTime(fixedAnnotation.getBeginTimeBoundary());
                }
                this.forceChildAnnotationsOfAlignable(aa);
            } else if (cc != null && cc.getStereoType() == 0) {
                if (aa.getBegin().isTimeAligned() && aa.getEnd().isTimeAligned() && aa.getBegin().getTime() > fixedAnnotation.getBegin().getTime() && aa.getEnd().getTime() < fixedAnnotation.getEnd().getTime()) {
                    aa.markDeleted(true);
                } else if (aa.getBegin().isTimeAligned() && aa.getBegin().getTime() <= fixedAnnotation.getEnd().getTime() && aa.getBegin().getTime() > fixedAnnotation.getBegin().getTime() && aa.getEnd().getTime() >= fixedAnnotation.getEnd().getTime()) {
                    aa.setBegin(fixedAnnotation.getEnd());
                    this.forceChildAnnotationsOfAlignable(aa);
                }
            }
        }
    }

    private void shiftAfterTimeSlot(TimeSlot fixedSlot, TreeSet connTimeSlots) {
        TimeSlot lastShiftedSlot = null;
        for (TimeSlot ts : connTimeSlots) {
            if (!fixedSlot.isAfter(ts)) continue;
            if (ts.isTimeAligned()) {
                ts.setTime(fixedSlot.getTime());
                lastShiftedSlot = ts;
                continue;
            }
            ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(ts);
            ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(ts, lastShiftedSlot, null);
            lastShiftedSlot = ts;
        }
    }

    private void shiftBeforeTimeSlot(TimeSlot fixedSlot, TreeSet connTimeSlots) {
        TimeSlot lastShiftedSlot = null;
        TimeSlot afterThisSlot = null;
        ArrayList<TimeSlot> pending = new ArrayList<TimeSlot>();
        for (TimeSlot ts : connTimeSlots) {
            if (ts.isAfter(fixedSlot)) {
                if (ts.isTimeAligned()) {
                    ts.setTime(fixedSlot.getTime());
                    lastShiftedSlot = ts;
                    if (pending.size() <= 0) continue;
                    for (int i = 0; i < pending.size(); ++i) {
                        TimeSlot uts = (TimeSlot)pending.get(i);
                        ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(uts);
                        ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(uts, afterThisSlot, ts);
                    }
                    pending.clear();
                    continue;
                }
                pending.add(ts);
                continue;
            }
            afterThisSlot = ts;
        }
        if (pending.size() > 0) {
            for (int i = 0; i < pending.size(); ++i) {
                TimeSlot uts = (TimeSlot)pending.get(i);
                ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(uts);
                ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(uts, afterThisSlot, fixedSlot);
            }
            pending.clear();
        }
    }

    private void forceInsideFixedInterval(TimeSlot[] graphEndpoints, AlignableAnnotation fixedAnnotation) {
        TimeSlot annBegin = graphEndpoints[0];
        TimeSlot annEnd = graphEndpoints[0];
        Vector annotsForTS = null;
        AlignableAnnotation currentAnn = null;
        while (annEnd != null) {
            annotsForTS = this.getAnnotsBeginningAtTimeSlot(annBegin);
            if (annotsForTS != null && annotsForTS.size() > 0) {
                currentAnn = (AlignableAnnotation)annotsForTS.firstElement();
                annEnd = currentAnn.getEnd();
                if (annEnd.isTimeAligned() && annEnd.getTime() < fixedAnnotation.getBegin().getTime()) {
                    annEnd.setTime(fixedAnnotation.getBegin().getTime());
                }
                if (!annEnd.isTimeAligned() && fixedAnnotation.getBegin().isAfter(annEnd)) {
                    ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(annEnd);
                    ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(annEnd, fixedAnnotation.getBegin(), null);
                }
                annBegin = annEnd;
                continue;
            }
            annEnd = null;
        }
    }

    private void forceAnnotationInInterval(AlignableAnnotation aa, AlignableAnnotation fixedAnnotation) {
        TimeSlot begin = aa.getBegin();
        TimeSlot end = aa.getEnd();
        Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
        if (cc != null && cc.getStereoType() == 1) {
            if (begin.getTime() >= fixedAnnotation.getBeginTimeBoundary() && end.getTime() <= fixedAnnotation.getEndTimeBoundary()) {
                return;
            }
            if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary() && end.getTime() > fixedAnnotation.getBeginTimeBoundary()) {
                begin.setTime(fixedAnnotation.getBeginTimeBoundary());
                if (end.getTime() > fixedAnnotation.getEndTimeBoundary()) {
                    end.setTime(fixedAnnotation.getEndTimeBoundary());
                }
                this.forceChildAnnotationsOfAlignable(aa);
            } else if (end.getTime() > fixedAnnotation.getEndTimeBoundary() && begin.getTime() < fixedAnnotation.getEndTimeBoundary()) {
                end.setTime(fixedAnnotation.getEndTimeBoundary());
                if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary()) {
                    begin.setTime(fixedAnnotation.getBeginTimeBoundary());
                }
                this.forceChildAnnotationsOfAlignable(aa);
            } else {
                end.setTime(begin.getTime());
            }
        }
    }

    private void forceTSInsideFixedInterval(AlignableAnnotation aa, TimeSlot[] graphEndpoints, AlignableAnnotation fixedAnnotation) {
        Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
        if (cc == null || cc.getStereoType() != 0) {
            return;
        }
        if (!aa.getBegin().isTimeAligned() || !aa.getEnd().isTimeAligned()) {
            return;
        }
        TimeSlot begin = aa.getBegin();
        TimeSlot end = aa.getEnd();
        if (begin.getTime() < end.getTime() && end.getTime() < fixedAnnotation.getBegin().getTime() && begin != fixedAnnotation.getBegin() && begin != graphEndpoints[0]) {
            begin.setTime(fixedAnnotation.getBegin().getTime());
        } else if (begin.getTime() < end.getTime() && begin.getTime() > fixedAnnotation.getEnd().getTime() && end != fixedAnnotation.getEnd() && end != graphEndpoints[1]) {
            end.setTime(fixedAnnotation.getEnd().getTime());
        }
    }

    private void forceChildAnnotationsOfAlignable(AlignableAnnotation aa) {
        Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
        if (cc != null && cc.getStereoType() != 1 && cc.getStereoType() != 0) {
            return;
        }
        ArrayList chan = aa.getParentListeners();
        Constraint sc = null;
        HashMap tsChildren = null;
        for (int i = 0; i < chan.size(); ++i) {
            Object next = chan.get(i);
            if (!(next instanceof AlignableAnnotation)) continue;
            AlignableAnnotation ann = (AlignableAnnotation)next;
            sc = ((TierImpl)ann.getTier()).getLinguisticType().getConstraints();
            if (sc.getStereoType() == 1) {
                this.forceAnnotationInInterval(ann, aa);
                if (ann.getBegin().getTime() != ann.getEnd().getTime()) continue;
                ann.markDeleted(true);
                continue;
            }
            if (sc.getStereoType() != 0) continue;
            if (tsChildren == null) {
                tsChildren = new HashMap(3);
            }
            if (tsChildren.containsKey(ann.getTier())) {
                ((ArrayList)tsChildren.get(ann.getTier())).add(ann);
                continue;
            }
            ArrayList<AlignableAnnotation> al = new ArrayList<AlignableAnnotation>(5);
            al.add(ann);
            tsChildren.put(ann.getTier(), al);
        }
        if (tsChildren != null) {
            for (Object key : tsChildren.keySet()) {
                this.updateTSChildren(aa, (TierImpl)key, (ArrayList)tsChildren.get(key));
            }
        }
    }

    private void updateTSChildren(AlignableAnnotation parAnn, TierImpl tier, ArrayList tsAnnos) {
        if (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 0) {
            return;
        }
        Collections.sort(tsAnnos);
        boolean shouldPropagate = false;
        for (int i = 0; i < tsAnnos.size(); ++i) {
            AlignableAnnotation ann = (AlignableAnnotation)tsAnnos.get(i);
            shouldPropagate = false;
            if (ann.getBegin() == parAnn.getBegin()) {
                if (ann.getEnd().isTimeAligned() && ann.getEnd().getTime() < parAnn.getBegin().getTime()) {
                    ann.markDeleted(true);
                } else {
                    shouldPropagate = true;
                }
            } else {
                if (!ann.getBegin().isTimeAligned() && parAnn.getBegin().isAfter(ann.getEnd())) {
                    ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(ann.getBegin());
                    ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(ann.getBegin(), parAnn.getBegin(), null);
                    shouldPropagate = true;
                }
                if (ann.getEnd().isTimeAligned() && parAnn.getBegin().getTime() >= ann.getEnd().getTime() || ann.getBegin().isTimeAligned() && parAnn.getEnd().getTime() <= ann.getBegin().getTime()) {
                    ann.markDeleted(true);
                }
                if (ann.getBegin().isTimeAligned() && parAnn.getBegin().getTime() >= ann.getBegin().getTime() && ann.getBegin() != parAnn.getBegin()) {
                    ann.setBegin(parAnn.getBegin());
                    if (!ann.getEnd().isTimeAligned() && ann.getBegin().isAfter(ann.getEnd())) {
                        ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(ann.getEnd());
                        ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(ann.getEnd(), ann.getBegin(), parAnn.getEnd());
                    }
                    shouldPropagate = true;
                }
                if (ann.getEnd().isTimeAligned() && parAnn.getEnd().getTime() <= ann.getEnd().getTime() && ann.getEnd() != parAnn.getEnd()) {
                    ann.setEnd(parAnn.getEnd());
                    shouldPropagate = true;
                }
                if (!ann.getEnd().isTimeAligned() && ann.getEnd().isAfter(parAnn.getEnd())) {
                    ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(ann.getEnd());
                    ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(ann.getEnd(), ann.getBegin(), parAnn.getEnd());
                    shouldPropagate = true;
                }
                if (!ann.getBegin().isTimeAligned() && !ann.getEnd().isTimeAligned() && ann.getBegin().isAfter(ann.getEnd())) {
                    ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(ann.getEnd());
                    ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(ann.getEnd(), ann.getBegin(), parAnn.getEnd());
                    shouldPropagate = true;
                }
            }
            if (!shouldPropagate) continue;
            this.forceChildAnnotationsOfAlignable(ann);
        }
    }

    private void forceAnnotChainOutOfFixedInterval(TimeSlot[] graphEndpoints, TimeSlot fixedSlot1, TimeSlot fixedSlot2) {
        TimeSlot annBegin = graphEndpoints[0];
        TimeSlot annEnd = graphEndpoints[0];
        Vector annotsForTS = null;
        AlignableAnnotation currentAnn = null;
        boolean passedFixedSlot1 = false;
        boolean passedFixedSlot2 = false;
        if (annBegin == fixedSlot1 || annBegin.getTime() >= fixedSlot1.getTime()) {
            passedFixedSlot1 = true;
        }
        while (annEnd != null) {
            annotsForTS = this.getAnnotsBeginningAtTimeSlot(annBegin);
            if (annotsForTS != null && annotsForTS.size() > 0) {
                currentAnn = (AlignableAnnotation)annotsForTS.firstElement();
                annEnd = currentAnn.getEnd();
                if (passedFixedSlot1 && !passedFixedSlot2 && annEnd != fixedSlot2 && annEnd.isTimeAligned() && annEnd.getTime() > fixedSlot1.getTime()) {
                    annEnd.setTime(fixedSlot1.getTime());
                }
                if (passedFixedSlot2 && annEnd.isTimeAligned() && annEnd.getTime() < fixedSlot2.getTime()) {
                    annEnd.setTime(fixedSlot2.getTime());
                }
                if (annEnd.getTime() >= fixedSlot1.getTime()) {
                    passedFixedSlot1 = true;
                }
                if (annEnd == fixedSlot2) {
                    passedFixedSlot2 = true;
                }
                annBegin = annEnd;
                if (annEnd != graphEndpoints[1]) continue;
                break;
            }
            annEnd = null;
        }
    }

    private void forceChildChainOutOfInterval(AlignableAnnotation aa, TimeSlot[] graphEndpoints, TimeSlot fixedSlot1, TimeSlot fixedSlot2, boolean left) {
        Vector ct = this.getDependentTiers();
        block0: for (int i = 0; i < ct.size(); ++i) {
            TierImpl t = (TierImpl)ct.get(i);
            if (t.getLinguisticType().getConstraints().getStereoType() != 0) continue;
            if (left) {
                t.forceAnnotChainOutOfFixedInterval(new TimeSlot[]{aa.getBegin(), aa.getEnd()}, fixedSlot1, fixedSlot2);
                continue;
            }
            TimeSlot annBegin = aa.getBegin();
            TimeSlot annEnd = aa.getBegin();
            Vector annotsForTS = null;
            AlignableAnnotation currentAnn = null;
            boolean passedFixedSlot1 = false;
            boolean passedFixedSlot2 = false;
            if (annBegin == fixedSlot1 || annBegin.getTime() >= fixedSlot1.getTime()) {
                passedFixedSlot1 = true;
            }
            if (annBegin == fixedSlot2 || annBegin.getTime() >= fixedSlot2.getTime()) {
                passedFixedSlot2 = true;
            }
            while (annEnd != null) {
                annotsForTS = t.getAnnotsBeginningAtTimeSlot(annBegin);
                if (annotsForTS != null && annotsForTS.size() > 0) {
                    currentAnn = (AlignableAnnotation)annotsForTS.firstElement();
                    annEnd = currentAnn.getEnd();
                    if (passedFixedSlot1 && !passedFixedSlot2 && annEnd != fixedSlot2 && annEnd.isTimeAligned() && annEnd != graphEndpoints[1] && annEnd.getTime() > fixedSlot1.getTime()) {
                        annEnd.setTime(fixedSlot1.getTime());
                    }
                    if (passedFixedSlot2 && annEnd != graphEndpoints[1] && annEnd.isTimeAligned() && annEnd.getTime() < fixedSlot2.getTime()) {
                        annEnd.setTime(fixedSlot2.getTime());
                    }
                    if (annEnd.getTime() >= fixedSlot1.getTime()) {
                        passedFixedSlot1 = true;
                    }
                    if (annEnd == fixedSlot2) {
                        passedFixedSlot2 = true;
                    }
                    annBegin = annEnd;
                    if (annEnd != graphEndpoints[1]) continue;
                    continue block0;
                }
                annEnd = null;
            }
        }
    }

    private void repositionUnalignedSlots(TimeSlot graphBegin) {
        TimeSlot annBegin = graphBegin;
        TimeSlot annEnd = graphBegin;
        Vector annotsForTS = null;
        AlignableAnnotation currentAnn = null;
        while (annEnd != null) {
            annotsForTS = this.getAnnotsBeginningAtTimeSlot(annBegin);
            if (annotsForTS != null && annotsForTS.size() > 0) {
                currentAnn = (AlignableAnnotation)annotsForTS.firstElement();
                annEnd = currentAnn.getEnd();
                if (annBegin.isAfter(annEnd) && annBegin.isTimeAligned() && !annEnd.isTimeAligned() || annBegin.isAfter(annEnd) && !annBegin.isTimeAligned() && !annEnd.isTimeAligned()) {
                    ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(annEnd);
                    ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(annEnd, annBegin, null);
                }
                if (annBegin.isAfter(annEnd) && !annBegin.isTimeAligned() && annEnd.isTimeAligned()) {
                    ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(annBegin);
                    ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(annBegin, null, annEnd);
                }
                annBegin = annEnd;
                continue;
            }
            annEnd = null;
        }
    }

    public void correctOverlapsByPushing(AlignableAnnotation fixedAnnotation, long oldBegin, long oldEnd) {
        long timeGap;
        AlignableAnnotation a;
        long newBegin = fixedAnnotation.getBegin().getTime();
        long newEnd = fixedAnnotation.getEnd().getTime();
        long storeOldEnd = oldEnd;
        if (newEnd > oldEnd) {
            a = null;
            timeGap = 0L;
            long rightShift = newEnd - oldEnd;
            Iterator annIter = this.annotations.iterator();
            while (annIter.hasNext() && (a = (AlignableAnnotation)annIter.next()) != fixedAnnotation) {
            }
            while (annIter.hasNext()) {
                a = (AlignableAnnotation)annIter.next();
                timeGap = a.getBegin().getTime() - oldEnd;
                if (timeGap > 0L) {
                    rightShift -= timeGap;
                }
                if (rightShift > 0L) {
                    oldEnd = a.getEnd().getTime();
                    this.shiftConnectedAnnots(a, rightShift);
                }
                if (rightShift > 0L) continue;
            }
        }
        if (newBegin < oldBegin && fixedAnnotation.getBegin().isTimeAligned() || oldBegin == storeOldEnd) {
            a = null;
            timeGap = 0L;
            long leftShift = oldBegin - newBegin;
            boolean leftShiftNotYetSpecified = false;
            if (oldBegin == storeOldEnd) {
                leftShiftNotYetSpecified = true;
            }
            Vector annVector = new Vector(this.annotations);
            ListIterator annIter2 = annVector.listIterator();
            while (annIter2.hasNext() && (a = (AlignableAnnotation)annIter2.next()) != fixedAnnotation) {
            }
            boolean firstIteration = true;
            while (annIter2.hasPrevious()) {
                a = (AlignableAnnotation)annIter2.previous();
                if (a == fixedAnnotation) {
                    firstIteration = false;
                    continue;
                }
                timeGap = oldBegin - a.getEnd().getTime();
                if (timeGap > 0L) {
                    leftShift -= timeGap;
                }
                if ((leftShift > 0L || leftShiftNotYetSpecified) && !firstIteration) {
                    if (leftShiftNotYetSpecified) {
                        leftShift = a.getEnd().getTime() - storeOldEnd;
                        if (leftShift < 0L) {
                            leftShift = 0L;
                        }
                        leftShiftNotYetSpecified = false;
                    }
                    oldBegin = a.getBegin().getTime();
                    this.shiftConnectedAnnots(a, -leftShift);
                }
                if (leftShift <= 0L) break;
                firstIteration = false;
            }
        }
    }

    private void shiftConnectedAnnots(AlignableAnnotation ann, long shift) {
        TreeSet connectedAnnots = new TreeSet();
        TreeSet connectedTimeSlots = new TreeSet();
        ((TranscriptionImpl)this.getParent()).getConnectedAnnots(connectedAnnots, connectedTimeSlots, ann);
        TimeSlot prevSlot = null;
        for (TimeSlot ts : connectedTimeSlots) {
            if (ts.isTimeAligned()) {
                if (ts.getTime() + shift < 0L) {
                    ts.setTime(0L);
                } else if (prevSlot != null && !prevSlot.isTimeAligned()) {
                    ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(ts);
                    ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(ts, prevSlot, null);
                    ts.setTime(ts.getTime() + shift);
                } else {
                    ts.setTime(ts.getTime() + shift);
                }
            } else if (prevSlot != null) {
                ((TranscriptionImpl)this.parent).getTimeOrder().removeTimeSlot(ts);
                ((TranscriptionImpl)this.parent).getTimeOrder().insertTimeSlot(ts, prevSlot, null);
            }
            prevSlot = ts;
        }
        if (connectedAnnots.size() > 0) {
            this.markAnnotationsForDeletion(new Vector(connectedAnnots));
            ((TranscriptionImpl)this.parent).pruneAnnotations(this);
        }
    }

    private void markAnnotationsForDeletion(Vector annots) {
        for (Annotation ann : annots) {
            if (!(ann instanceof AlignableAnnotation) || ((AlignableAnnotation)ann).calculateBeginTime() < ((AlignableAnnotation)ann).calculateEndTime()) continue;
            ann.markDeleted(true);
        }
    }

    public void pruneAnnotations() {
        TreeSet copiedAnnotations = new TreeSet(this.annotations);
        for (Annotation ann : copiedAnnotations) {
            if (!ann.isMarkedDeleted()) continue;
            Constraint c = this.linguisticType.getConstraints();
            if (c != null) {
                c.detachAnnotation(ann, this);
            }
            this.annotations.remove(ann);
        }
    }

    public void setMetadata(String element, Object value) {
        if (element == null || value == null) {
            return;
        }
        this.tierMetadata.put(element, value);
        this.modified(2, null);
    }

    public Object getMetadataValue(String element) {
        if (element == null) {
            return null;
        }
        return this.tierMetadata.get(element);
    }

    public void setLinguisticType(LinguisticType theType) {
        this.linguisticType = theType;
        this.modified(2, null);
    }

    public LinguisticType getLinguisticType() {
        return this.linguisticType;
    }

    public String getParticipant() {
        String participant = "not specified";
        if (this.getMetadataValue("PARTICIPANT") != null) {
            participant = (String)this.getMetadataValue("PARTICIPANT");
        }
        return participant;
    }

    public void setParticipant(String theParticipant) {
        this.setMetadata("PARTICIPANT", theParticipant);
    }

    public String getAnnotator() {
        String annotator = (String)this.getMetadataValue("ANNOTATOR");
        return annotator != null ? annotator : "";
    }

    public void setAnnotator(String annotator) {
        this.setMetadata("ANNOTATOR", annotator);
    }

    public Locale getDefaultLocale() {
        Locale locale = null;
        Object val = this.getMetadataValue("DEFAULT_LOCALE");
        if (val instanceof Locale) {
            locale = (Locale)val;
        }
        return locale;
    }

    public void setDefaultLocale(Locale l) {
        if (l == null) {
            this.setMetadata("DEFAULT_LOCALE", "");
        } else {
            this.setMetadata("DEFAULT_LOCALE", l);
        }
    }

    public void setParentTier(Tier newParent) {
        if (this.annotations.size() > 0) {
            return;
        }
        this.parentTier = newParent;
        this.modified(2, null);
    }

    private void enforceConstraints() {
        if (this.linguisticType.hasConstraints()) {
            Constraint c = this.linguisticType.getConstraints();
            c.enforceOnWholeTier(this);
        }
    }

    private Annotation selectParentCandidate(Tier parent, Annotation forAnnotation) {
        Annotation selectedCandidate = null;
        long begin = forAnnotation.getBeginTimeBoundary();
        long end = forAnnotation.getEndTimeBoundary();
        Vector candidates = ((TierImpl)parent).getOverlappingAnnotations(begin, end);
        Iterator candIter = candidates.iterator();
        while (candIter.hasNext()) {
            boolean candAvailable = true;
            Annotation cand = (Annotation)candIter.next();
            for (Annotation listener : ((AbstractAnnotation)cand).getParentListeners()) {
                if (listener.getTier() != this) continue;
                candAvailable = false;
                break;
            }
            if (!candAvailable) continue;
            selectedCandidate = cand;
            break;
        }
        return selectedCandidate;
    }

    public Tier getParentTier() {
        return this.parentTier;
    }

    public boolean hasParentTier() {
        return this.parentTier != null;
    }

    public final TierImpl getRootTier() {
        if (this.parentTier == null) {
            return this;
        }
        return ((TierImpl)this.parentTier).getRootTier();
    }

    public final TierImpl getTimeSubDivAncestor() {
        Constraint constraint = this.getLinguisticType().getConstraints();
        if (constraint != null && constraint.getStereoType() == 0) {
            return this;
        }
        if (this.parentTier != null) {
            return ((TierImpl)this.parentTier).getTimeSubDivAncestor();
        }
        return null;
    }

    public boolean hasAncestor(Tier theTier) {
        boolean ancestor = false;
        if (this.parentTier != null) {
            ancestor = this.parentTier == theTier ? true : ((TierImpl)this.parentTier).hasAncestor(theTier);
        }
        return ancestor;
    }

    public Vector getDependentTiers() {
        Vector<TierImpl> depTiers = new Vector<TierImpl>();
        for (TierImpl t : ((TranscriptionImpl)this.parent).getTiers()) {
            if (!t.hasAncestor(this)) continue;
            depTiers.add(t);
        }
        return depTiers;
    }

    public Vector getChildTiers() {
        Vector<TierImpl> childTiers = new Vector<TierImpl>();
        for (TierImpl t : ((TranscriptionImpl)this.parent).getTiers()) {
            if (t.getParentTier() != this) continue;
            childTiers.add(t);
        }
        return childTiers;
    }

    public Annotation getAnnotationAtTime(long theTime, boolean forceRecalculation) {
        Annotation result = null;
        if (!this.isTimeAlignable() || !forceRecalculation) {
            for (Annotation ann : this.annotations) {
                if (ann.getBeginTimeBoundary() > theTime || ann.getEndTimeBoundary() <= theTime) continue;
                result = ann;
                break;
            }
        } else if (this.getParentTier() == null || this.linguisticType.getConstraints() != null && this.linguisticType.getConstraints().getStereoType() == 1) {
            for (AlignableAnnotation ann : this.annotations) {
                long b = ann.calculateBeginTime();
                long e = ann.calculateEndTime();
                if (b > theTime || e <= theTime) continue;
                result = ann;
                break;
            }
        } else {
            TierImpl root;
            AlignableAnnotation rootAnn;
            for (AlignableAnnotation ann : this.annotations) {
                if (!ann.getBegin().isTimeAligned() || !ann.getEnd().isTimeAligned()) continue;
                if (ann.getBegin().getTime() <= theTime && ann.getEnd().getTime() > theTime) {
                    result = ann;
                    break;
                }
                if (ann.getBegin().getTime() <= theTime) continue;
                break;
            }
            if (result == null && (rootAnn = (AlignableAnnotation)(root = this.getRootTier()).getAnnotationAtTime(theTime)) != null) {
                ArrayList<TierImpl> relTiers = new ArrayList<TierImpl>();
                relTiers.add(this);
                for (TierImpl pt = (TierImpl)this.getParentTier(); pt != null; pt = (TierImpl)pt.getParentTier()) {
                    relTiers.add(0, pt);
                }
                TimeProposer2 tp2 = new TimeProposer2();
                result = tp2.getAnnotationAtTime(relTiers, rootAnn, this, theTime);
            }
        }
        return result;
    }

    public Annotation getAnnotationAtTime(long theTime) {
        return this.getAnnotationAtTime(theTime, false);
    }

    public Vector getOverlappingAnnotations(long t1, long t2) {
        Vector<Annotation> annots = new Vector<Annotation>();
        for (Annotation ann : this.annotations) {
            long b = ann.getBeginTimeBoundary();
            long e = ann.getEndTimeBoundary();
            if (!(t1 <= b && b < t2 || t1 < e && e <= t2 || b <= t1 && t1 < e) && (b >= t2 || t2 > e)) continue;
            annots.add(ann);
        }
        return annots;
    }

    public Vector getOverlappingAnnotations(TimeSlot t1, TimeSlot t2) {
        Vector<AlignableAnnotation> v = new Vector<AlignableAnnotation>();
        if (!this.isTimeAlignable()) {
            return v;
        }
        for (AlignableAnnotation ann : this.annotations) {
            TimeSlot bt = ann.getBegin();
            TimeSlot et = ann.getEnd();
            if (!(et.getIndex() > t1.getIndex() && et.getIndex() < t2.getIndex() || bt.getIndex() > t1.getIndex() && bt.getIndex() < t2.getIndex()) && (bt.getIndex() >= t1.getIndex() || et.getIndex() <= t2.getIndex())) continue;
            v.add(ann);
        }
        return v;
    }

    public Vector getOverlappingAnnotationsIncludeExtremes(TimeSlot t1, TimeSlot t2) {
        Vector<AlignableAnnotation> v = new Vector<AlignableAnnotation>();
        if (!this.isTimeAlignable()) {
            return v;
        }
        for (AlignableAnnotation ann : this.annotations) {
            TimeSlot bt = ann.getBegin();
            TimeSlot et = ann.getEnd();
            if (!(et.getIndex() > t1.getIndex() && et.getIndex() <= t2.getIndex() || bt.getIndex() >= t1.getIndex() && bt.getIndex() < t2.getIndex()) && (bt.getIndex() >= t1.getIndex() || et.getIndex() <= t2.getIndex())) continue;
            v.add(ann);
        }
        return v;
    }

    public Vector getAnnotationsUsingTimeSlot(TimeSlot theSlot) {
        Vector<Annotation> resultAnnots = new Vector<Annotation>();
        if (!this.isTimeAlignable()) {
            return resultAnnots;
        }
        for (Annotation ann : this.annotations) {
            if (!(ann instanceof AlignableAnnotation) || ((AlignableAnnotation)ann).getBegin() != theSlot && ((AlignableAnnotation)ann).getEnd() != theSlot) continue;
            resultAnnots.add(ann);
        }
        return resultAnnots;
    }

    public Vector getAnnotsBeginningAtTimeSlot(TimeSlot theSlot) {
        Vector<Annotation> resultAnnots = new Vector<Annotation>();
        if (!this.isTimeAlignable()) {
            return resultAnnots;
        }
        boolean foundOne = false;
        for (Annotation ann : this.annotations) {
            if (!(ann instanceof AlignableAnnotation)) continue;
            if (((AlignableAnnotation)ann).getBegin() == theSlot) {
                foundOne = true;
                resultAnnots.add(ann);
                if (this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() == 0 || this.linguisticType.getConstraints().getStereoType() != 1) continue;
                continue;
            }
            if (!foundOne || this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() != 0 && this.linguisticType.getConstraints().getStereoType() != 1) continue;
            break;
        }
        return resultAnnots;
    }

    public Vector getAnnotsEndingAtTimeSlot(TimeSlot theSlot) {
        Vector<Annotation> resultAnnots = new Vector<Annotation>();
        if (!this.isTimeAlignable()) {
            return resultAnnots;
        }
        boolean foundOne = false;
        for (Annotation ann : this.annotations) {
            if (!(ann instanceof AlignableAnnotation)) continue;
            if (((AlignableAnnotation)ann).getEnd() == theSlot) {
                foundOne = true;
                resultAnnots.add(ann);
                if (this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() == 0 || this.linguisticType.getConstraints().getStereoType() != 1) continue;
                continue;
            }
            if (!foundOne || this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() != 0 && this.linguisticType.getConstraints().getStereoType() != 1) continue;
            break;
        }
        return resultAnnots;
    }

    public boolean isTimeAlignable() {
        boolean timeAlignable = true;
        if (this.linguisticType != null) {
            timeAlignable = this.linguisticType.isTimeAlignable();
        }
        return timeAlignable;
    }

    public boolean isInterlinearText() {
        boolean isInterlinearText = true;
        Vector depTiers = this.getDependentTiers();
        for (TierImpl t : depTiers) {
            Constraint c = t.getLinguisticType().getConstraints();
            if (c != null) {
                if (c.getStereoType() == 4 || c.getStereoType() == 3) continue;
                isInterlinearText = false;
                break;
            }
            isInterlinearText = false;
            break;
        }
        return isInterlinearText;
    }

    public long proposeTimeFor(TimeSlot theSlot) {
        long proposedTime = 0L;
        if (!this.hasParentTier()) {
            return ((TranscriptionImpl)this.parent).getTimeOrder().proposeTimeFor(theSlot);
        }
        TimeSlot[] graphEndpoints = this.getEndpointsOfSubchain(theSlot, true);
        TimeSlot aBegin = graphEndpoints[0];
        TimeSlot aEnd = graphEndpoints[0];
        Vector annsForTS = null;
        AlignableAnnotation currentA = null;
        boolean beginFound = false;
        int unalignedCounter = 1;
        int foundAtPosition = 0;
        TimeSlot segBegin = aBegin;
        TimeSlot segEnd = graphEndpoints[1];
        if (theSlot == aEnd) {
            aEnd = null;
        }
        while (aEnd != null) {
            annsForTS = this.getAnnotsBeginningAtTimeSlot(aBegin);
            if (annsForTS != null && annsForTS.size() > 0) {
                currentA = (AlignableAnnotation)annsForTS.firstElement();
                aEnd = currentA.getEnd();
                if (aEnd.isTimeAligned() && !beginFound) {
                    segBegin = aEnd;
                    unalignedCounter = 1;
                    foundAtPosition = 0;
                }
                if (!aEnd.isTimeAligned() && aEnd != segEnd) {
                    ++unalignedCounter;
                    if (!beginFound) {
                        ++foundAtPosition;
                    }
                }
                if (aEnd.isTimeAligned() && beginFound) {
                    segEnd = aEnd;
                    break;
                }
                if (aEnd == theSlot) {
                    beginFound = true;
                }
                aBegin = aEnd;
                continue;
            }
            aEnd = null;
        }
        long segB = 0L;
        long segE = 0L;
        if (this.getParentTier() != null) {
            segB = !segBegin.isTimeAligned() ? ((TierImpl)this.getParentTier()).proposeTimeFor(segBegin) : segBegin.getTime();
            segE = !segEnd.isTimeAligned() ? ((TierImpl)this.getParentTier()).proposeTimeFor(segEnd) : segEnd.getTime();
        }
        proposedTime = segB + (long)foundAtPosition * ((segE - segB) / (long)unalignedCounter);
        if (theSlot == segBegin && !segBegin.isTimeAligned()) {
            proposedTime = segB;
        }
        if (theSlot == segEnd && !segEnd.isTimeAligned()) {
            proposedTime = segE;
        }
        return proposedTime;
    }

    private void correctDependingOverlaps(AlignableAnnotation a) {
        int i;
        TierImpl tier;
        Vector depTiers = this.getDependentTiers();
        depTiers.add(0, this);
        ArrayList annots = new ArrayList();
        TimeSlot bts = a.getBegin();
        TimeSlot ets = a.getEnd();
        for (int i2 = 0; i2 < depTiers.size(); ++i2) {
            tier = (TierImpl)depTiers.get(i2);
            if (!tier.isTimeAlignable()) continue;
            this.getAnnotsChainStartingWithSlot(annots, tier, bts, ets);
            this.getAnnotsChainEndingWithSlot(annots, tier, ets, bts);
        }
        boolean pruneNeeded = false;
        for (i = 0; i < annots.size(); ++i) {
            AlignableAnnotation ann = (AlignableAnnotation)annots.get(i);
            if (ann == a || ann.isMarkedDeleted()) continue;
            ann.markDeleted(true);
            pruneNeeded = true;
        }
        for (i = 0; i < depTiers.size(); ++i) {
            tier = (TierImpl)depTiers.get(i);
            if (tier == this || !tier.isTimeAlignable()) continue;
            tier.repositionUnalignedSlots(a.getEnd());
        }
        if (pruneNeeded) {
            for (i = 0; i < depTiers.size(); ++i) {
                tier = (TierImpl)depTiers.get(i);
                tier.pruneAnnotationsWithoutDetach();
            }
        }
    }

    private void getAnnotsChainStartingWithSlot(ArrayList annots, TierImpl tier, TimeSlot bts, TimeSlot ets) {
        Vector v = tier.getAnnotsBeginningAtTimeSlot(bts);
        for (int i = 0; i < v.size(); ++i) {
            AlignableAnnotation ann = (AlignableAnnotation)v.get(i);
            if (annots.contains(ann)) continue;
            annots.add(ann);
            if (ann.getEnd() == ets) continue;
            this.getAnnotsChainStartingWithSlot(annots, tier, ann.getEnd(), ets);
        }
    }

    private void getAnnotsChainEndingWithSlot(ArrayList annots, TierImpl tier, TimeSlot ets, TimeSlot bts) {
        Vector v = tier.getAnnotsEndingAtTimeSlot(ets);
        for (int i = 0; i < v.size(); ++i) {
            AlignableAnnotation ann = (AlignableAnnotation)v.get(i);
            if (annots.contains(ann)) continue;
            annots.add(ann);
            if (ann.getBegin() == bts) continue;
            this.getAnnotsChainEndingWithSlot(annots, tier, ann.getBegin(), bts);
        }
    }

    public void pruneAnnotationsWithoutDetach() {
        Iterator annIter = this.annotations.iterator();
        while (annIter.hasNext()) {
            Annotation ann = (Annotation)annIter.next();
            if (!ann.isMarkedDeleted()) continue;
            annIter.remove();
        }
    }
}

