/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DataTreeNode;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeOrderImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeProposer;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientFactory;
import mpi.eudico.server.corpora.location.LocatorManager;
import mpi.eudico.server.corpora.util.ACMEditableObject;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

public class TranscriptionImpl
implements Transcription {
    private ArrayList listeners;
    protected Vector tiers;
    protected Vector mediaDescriptors;
    protected Vector linkedFileDescriptors;
    protected String url;
    protected String content_type = "text/plain";
    protected String name;
    protected String owner;
    private DataTreeNode parent;
    protected LocatorManager locatorManager;
    protected TimeOrder timeOrder;
    protected Vector linguisticTypes;
    protected String author;
    protected boolean isLoaded;
    private boolean changed = false;
    private int timeChangePropagationMode = 0;
    private TimeProposer timeProposer;
    protected Vector controlledVocabularies;
    private ArrayList docProperties;
    private HashMap<String, LexiconServiceClientFactory> lexiconServiceClientFactories;
    private boolean lexcionServicesLoaded = false;
    private HashMap<String, LexiconLink> lexiconLinks;
    protected boolean isNotifying;
    public static final String UNDEFINED_FILE_NAME = "aishug294879ryshfda9763afo8947a5gf";
    protected String fileName;
    protected String mediafileName;
    protected String svgFile;

    @Override
    public void addACMEditListener(ACMEditListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeACMEditListener(ACMEditListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void notifyListeners(ACMEditableObject source, int operation, Object modification) {
        Iterator i = this.listeners.iterator();
        ACMEditEvent event = new ACMEditEvent(source, operation, modification);
        while (i.hasNext()) {
            ((ACMEditListener)i.next()).ACMEdited(event);
        }
    }

    @Override
    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    @Override
    public void handleModification(ACMEditableObject source, int operation, Object modification) {
        if (!this.changed) {
            this.changed = true;
        }
        this.timeProposer.correctProposedTimes(this, source, operation, modification);
        if (this.isNotifying) {
            this.notifyListeners(source, operation, modification);
        }
    }

    public void setNotifying(boolean notify) {
        this.isNotifying = notify;
        if (this.isNotifying) {
            this.modified(14, null);
        }
    }

    public boolean isNotifying() {
        return this.isNotifying;
    }

    public TranscriptionImpl() {
        this(UNDEFINED_FILE_NAME);
    }

    public TranscriptionImpl(String eafFilePath) {
        this(eafFilePath.substring(eafFilePath.lastIndexOf(System.getProperty("file.separator")) + 1), null, null, "file:" + eafFilePath);
        this.initialize(eafFilePath.substring(eafFilePath.lastIndexOf(System.getProperty("file.separator")) + 1), eafFilePath, null);
    }

    public TranscriptionImpl(String sourceFilePath, DecoderInfo decoderInfo) {
        this(sourceFilePath.substring(sourceFilePath.lastIndexOf(System.getProperty("file.separator")) + 1), null, null, "file:" + sourceFilePath);
        this.initialize(sourceFilePath.substring(sourceFilePath.lastIndexOf(System.getProperty("file.separator")) + 1), sourceFilePath, decoderInfo);
    }

    public TranscriptionImpl(String theName, DataTreeNode theParent, LocatorManager theLocatorManager, String myURL) {
        this.name = theName;
        this.parent = theParent;
        this.url = myURL;
        this.locatorManager = theLocatorManager;
        this.tiers = new Vector();
        this.listeners = new ArrayList();
        this.timeOrder = new TimeOrderImpl(this);
        this.linguisticTypes = new Vector();
        this.mediaDescriptors = new Vector();
        this.linkedFileDescriptors = new Vector();
        this.controlledVocabularies = new Vector();
        this.docProperties = new ArrayList(5);
        this.isLoaded = false;
        this.isNotifying = true;
        this.timeProposer = new TimeProposer();
    }

    private void initialize(String name, String fileName, DecoderInfo decoderInfo) {
        String test;
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring(5);
        }
        this.author = "";
        File fff = new File(fileName);
        this.isLoaded = !fff.exists();
        this.fileName = fileName;
        String mimeType = "";
        this.mediafileName = null;
        if (this.mediafileName == null && fileName != null && fileName.length() > 3) {
            test = this.fileName.substring(0, this.fileName.length() - 3) + "mpg";
            if (test.startsWith("file:")) {
                test = test.substring(5);
            }
            if (new File(test).exists()) {
                this.mediafileName = test;
                mimeType = "video/mpeg";
            }
        }
        if (this.mediafileName == null && fileName != null && fileName.length() > 3) {
            test = this.fileName.substring(0, this.fileName.length() - 3) + "wav";
            if (test.startsWith("file:")) {
                test = test.substring(5);
            }
            if (new File(test).exists()) {
                this.mediafileName = test;
                mimeType = "audio/x-wav";
            }
        }
        if (this.mediafileName == null && fileName != null && fileName.length() > 3) {
            test = this.fileName.substring(0, this.fileName.length() - 3) + "mov";
            if (test.startsWith("file:")) {
                test = test.substring(5);
            }
            if (new File(test).exists()) {
                this.mediafileName = test;
            }
        }
        this.lexiconLinks = new HashMap();
        if (!this.isLoaded()) {
            ACMTranscriptionStore.getCurrentTranscriptionStore().loadTranscription(this, decoderInfo);
            this.timeProposer.correctProposedTimes(this, null, 14, null);
        }
        if (this.mediaDescriptors.size() == 0 && this.mediafileName != null && this.mediafileName.length() > 0) {
            String mediaURL = this.pathToURLString(this.mediafileName);
            MediaDescriptor masterMD = new MediaDescriptor(mediaURL, mimeType);
            this.mediaDescriptors.add(masterMD);
            String checkFile = this.fileName.substring(0, this.fileName.length() - 3) + "wav";
            if (checkFile.startsWith("file:")) {
                checkFile = checkFile.substring(5);
            }
            if (new File(checkFile).exists()) {
                String signalURL = this.pathToURLString(checkFile);
                mimeType = "audio/x-wav";
                MediaDescriptor signalMD = new MediaDescriptor(signalURL, mimeType);
                signalMD.extractedFrom = mediaURL;
                this.mediaDescriptors.add(signalMD);
            }
        }
        if (this.svgFile == null && fileName != null && fileName.length() > 3) {
            test = this.fileName.substring(0, this.fileName.length() - 3) + "svg";
            if (test.startsWith("file:")) {
                test = test.substring(5);
            }
            if (new File(test).exists()) {
                this.setSVGFile(test);
            }
        }
    }

    private String pathToURLString(String path) {
        if ((path = path.replace('\\', '/')).startsWith("file:")) {
            path = path.substring(5);
        }
        int n = 0;
        while (path.charAt(0) == '/') {
            path = path.substring(1);
            ++n;
        }
        if (n == 2) {
            return "file://" + path;
        }
        return "file:///" + path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public String getFullPath() {
        return this.url;
    }

    @Override
    public String getContentType() {
        return this.content_type;
    }

    @Override
    public InputStream getContentStream() {
        InputStream is = null;
        if (this.url != null) {
            try {
                is = new URL(this.url).openStream();
            }
            catch (Exception e) {
                is = null;
            }
        }
        return is;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Vector getMediaDescriptors() {
        return this.mediaDescriptors;
    }

    @Override
    public void setMediaDescriptors(Vector theMediaDescriptors) {
        this.mediaDescriptors = theMediaDescriptors;
    }

    @Override
    public Vector getLinkedFileDescriptors() {
        return this.linkedFileDescriptors;
    }

    @Override
    public void setLinkedFileDescriptors(Vector descriptors) {
        this.linkedFileDescriptors = descriptors;
    }

    @Override
    public void printStatistics() {
        System.out.println("");
        System.out.println(">>> Name: " + this.name);
        System.out.println(">>> Number of tiers: " + this.tiers.size());
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public boolean isTreeViewableLeaf() {
        return true;
    }

    @Override
    public Vector getChildren() {
        return new Vector();
    }

    public void unreferenced() {
        this.getParent().removeChild(this);
    }

    @Override
    public DataTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void removeChild(DataTreeNode theChild) {
        this.removeTier((Tier)theChild);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    @Override
    public void addTier(Tier theTier) {
        if (theTier == null || this.getTierWithId(theTier.getName()) != null) {
            return;
        }
        this.tiers.add(theTier);
        if (this.isLoaded()) {
            this.modified(0, theTier);
        }
    }

    @Override
    public void removeTier(Tier theTier) {
        ((TierImpl)theTier).removeAllAnnotations();
        Vector<Tier> deletedTiers = new Vector<Tier>();
        deletedTiers.add(theTier);
        for (TierImpl t : this.tiers) {
            if (t.getNumberOfAnnotations() != 0 || !t.hasAncestor((TierImpl)theTier)) continue;
            deletedTiers.add(t);
        }
        this.tiers.removeAll(deletedTiers);
        this.modified(1, theTier);
    }

    @Override
    public TimeOrder getTimeOrder() {
        return this.timeOrder;
    }

    public void pruneAnnotations() {
        Iterator tierIter = this.tiers.iterator();
        while (tierIter.hasNext()) {
            ((TierImpl)tierIter.next()).pruneAnnotations();
        }
        this.timeOrder.pruneTimeSlots();
        this.modified(6, null);
    }

    public void pruneAnnotations(Tier fromTier) {
        if (fromTier instanceof TierImpl) {
            Vector depTiers = ((TierImpl)fromTier).getDependentTiers();
            depTiers.add(0, fromTier);
            Iterator tierIter = depTiers.iterator();
            while (tierIter.hasNext()) {
                ((TierImpl)tierIter.next()).pruneAnnotations();
            }
            this.timeOrder.pruneTimeSlots();
            this.modified(6, null);
        }
    }

    @Override
    public void setAuthor(String theAuthor) {
        this.author = theAuthor;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setLinguisticTypes(Vector theTypes) {
        this.linguisticTypes = theTypes;
    }

    @Override
    public Vector getLinguisticTypes() {
        return this.linguisticTypes;
    }

    public LinguisticType getLinguisticTypeByName(String name) {
        LinguisticType lt = null;
        if (this.linguisticTypes != null) {
            Iterator typeIt = this.linguisticTypes.iterator();
            LinguisticType ct = null;
            while (typeIt.hasNext()) {
                ct = (LinguisticType)typeIt.next();
                if (!ct.getLinguisticTypeName().equals(name)) continue;
                lt = ct;
                break;
            }
        }
        return lt;
    }

    @Override
    public void addLinguisticType(LinguisticType theType) {
        this.linguisticTypes.add(theType);
        this.modified(9, theType);
    }

    @Override
    public void removeLinguisticType(LinguisticType theType) {
        this.linguisticTypes.remove(theType);
        this.modified(10, theType);
    }

    @Override
    public void changeLinguisticType(LinguisticType linType, String newTypeName, Vector constraints, String cvName, boolean newTimeAlignable, boolean newGraphicsAllowed, String dcId, LexiconQueryBundle2 queryBundle) {
        linType.setLinguisticTypeName(newTypeName);
        linType.removeConstraints();
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                linType.addConstraint(constraint);
            }
        }
        linType.setControlledVocabularyName(cvName);
        linType.setTimeAlignable(newTimeAlignable);
        linType.setGraphicReferences(newGraphicsAllowed);
        linType.setDataCategory(dcId);
        linType.setLexiconQueryBundle(queryBundle);
        this.modified(11, linType);
    }

    @Override
    public Vector getTiersWithLinguisticType(String typeID) {
        Vector<TierImpl> matchingTiers = new Vector<TierImpl>();
        for (TierImpl t : this.tiers) {
            if (!t.getLinguisticType().getLinguisticTypeName().equals(typeID)) continue;
            matchingTiers.add(t);
        }
        return matchingTiers;
    }

    public Vector getCandidateParentTiers(Tier forTier) {
        Vector<TierImpl> candidates = new Vector<TierImpl>();
        Enumeration e = null;
        e = this.getTiers().elements();
        while (e.hasMoreElements()) {
            try {
                TierImpl dTier = (TierImpl)e.nextElement();
                if (dTier.hasAncestor(forTier)) break;
                if (dTier == forTier) continue;
                candidates.add(dTier);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return candidates;
    }

    @Override
    public Tier getTierWithId(String theTierId) {
        Tier t2 = null;
        Tier result = null;
        for (Tier t2 : this.tiers) {
            if (!t2.getName().equals(theTierId)) continue;
            result = t2;
            break;
        }
        return result;
    }

    protected final Tier getTierByUniqueName(String name) {
        if (this.tiers == null) {
            return null;
        }
        Enumeration all = this.tiers.elements();
        while (all.hasMoreElements()) {
            Tier t = (Tier)all.nextElement();
            String n = t.getName();
            if (!n.equals(name)) continue;
            return t;
        }
        return null;
    }

    @Override
    public Vector getAnnotationsUsingTimeSlot(TimeSlot theSlot) {
        Vector resultAnnots = new Vector();
        for (TierImpl t : this.tiers) {
            resultAnnots.addAll(t.getAnnotationsUsingTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public Vector getAnnotsBeginningAtTimeSlot(TimeSlot theSlot) {
        Vector resultAnnots = new Vector();
        for (TierImpl t : this.tiers) {
            resultAnnots.addAll(t.getAnnotsBeginningAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public Vector getAnnotsBeginningAtTimeSlot(TimeSlot theSlot, Tier forTier, boolean includeThisTier) {
        Vector resultAnnots = new Vector();
        Vector depTiers = ((TierImpl)forTier).getDependentTiers();
        if (includeThisTier) {
            depTiers.add(0, forTier);
        }
        for (TierImpl t : depTiers) {
            resultAnnots.addAll(t.getAnnotsBeginningAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public Vector getAnnotsEndingAtTimeSlot(TimeSlot theSlot) {
        Vector resultAnnots = new Vector();
        for (TierImpl t : this.tiers) {
            resultAnnots.addAll(t.getAnnotsEndingAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public Vector getAnnotsEndingAtTimeSlot(TimeSlot theSlot, Tier forTier, boolean includeThisTier) {
        Vector resultAnnots = new Vector();
        Vector depTiers = ((TierImpl)forTier).getDependentTiers();
        if (includeThisTier) {
            depTiers.add(0, forTier);
        }
        for (TierImpl t : depTiers) {
            resultAnnots.addAll(t.getAnnotsEndingAtTimeSlot(theSlot));
        }
        return resultAnnots;
    }

    public HashSet getTimeSlotsInUse() {
        HashSet<TimeSlot> usedSlots = new HashSet<TimeSlot>(this.getTimeOrder().size());
        for (TierImpl t : this.tiers) {
            if (!t.isTimeAlignable()) continue;
            for (Object annObj : t.getAnnotations()) {
                if (!(annObj instanceof AlignableAnnotation)) continue;
                AlignableAnnotation aa = (AlignableAnnotation)annObj;
                usedSlots.add(aa.getBegin());
                usedSlots.add(aa.getEnd());
            }
        }
        return usedSlots;
    }

    @Override
    public Vector getAnnotationIdsAtTime(long time) {
        Vector<String> resultAnnots = new Vector<String>();
        for (TierImpl t : this.tiers) {
            Annotation ann = t.getAnnotationAtTime(time);
            if (ann == null) continue;
            resultAnnots.add(ann.getId());
        }
        return resultAnnots;
    }

    @Override
    public Annotation getAnnotation(String id) {
        if (id == null) {
            return null;
        }
        for (TierImpl t : this.tiers) {
            Annotation a = t.getAnnotation(id);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    @Override
    public long getLatestTime() {
        long latestTime = 0L;
        Enumeration elmts = this.getTimeOrder().elements();
        while (elmts.hasMoreElements()) {
            long t = ((TimeSlot)elmts.nextElement()).getTime();
            if (t <= latestTime) continue;
            latestTime = t;
        }
        return latestTime;
    }

    public Vector getChildAnnotationsOf(Annotation theAnnot) {
        Vector<Annotation> children = new Vector<Annotation>();
        if (theAnnot instanceof RefAnnotation) {
            children.addAll(((RefAnnotation)theAnnot).getParentListeners());
        } else {
            TreeSet connectedAnnots = new TreeSet();
            this.getConnectedSubtree(connectedAnnots, ((AlignableAnnotation)theAnnot).getBegin(), ((AlignableAnnotation)theAnnot).getEnd(), theAnnot.getTier());
            Vector connAnnotVector = new Vector(connectedAnnots);
            Vector<TierImpl> descTiers = new Vector<TierImpl>();
            for (TierImpl t : this.tiers) {
                if (!t.hasAncestor(theAnnot.getTier())) continue;
                descTiers.add(t);
            }
            block1: for (TierImpl descT : descTiers) {
                for (Annotation a : descT.getAnnotations()) {
                    if (a instanceof RefAnnotation) {
                        if (((RefAnnotation)a).getReferences().size() <= 0 || ((RefAnnotation)a).getReferences().firstElement() != theAnnot) continue;
                        children.add(a);
                        continue;
                    }
                    if (!(a instanceof AlignableAnnotation)) continue;
                    if (connAnnotVector.contains(a)) {
                        children.add(a);
                        continue;
                    }
                    if (descT.getLinguisticType().getConstraints().getStereoType() != 1) continue;
                    if (a.getBeginTimeBoundary() < theAnnot.getEndTimeBoundary() && a.getEndTimeBoundary() > theAnnot.getBeginTimeBoundary()) {
                        children.add(a);
                    }
                    if (a.getBeginTimeBoundary() <= theAnnot.getEndTimeBoundary()) continue;
                    continue block1;
                }
            }
        }
        return children;
    }

    public void getConnectedAnnots(TreeSet connectedAnnots, TreeSet connectedTimeSlots, AlignableAnnotation fromAnn) {
        this.getConnectedAnnots(connectedAnnots, connectedTimeSlots, fromAnn.getBegin());
        TierImpl t = (TierImpl)fromAnn.getTier();
        Vector depTiers = t.getDependentTiers();
        for (TierImpl tt : depTiers) {
            if (tt.getLinguisticType().getConstraints().getStereoType() != 1) continue;
            Vector anns = tt.getAnnotations();
            for (AlignableAnnotation aa : anns) {
                if (!fromAnn.isAncestorOf(aa)) continue;
                this.getConnectedAnnots(connectedAnnots, connectedTimeSlots, aa);
            }
        }
    }

    public void getConnectedAnnots(TreeSet connectedAnnots, TreeSet connectedTimeSlots, TimeSlot startingFromTimeSlot) {
        Vector annots = null;
        connectedTimeSlots.add(startingFromTimeSlot);
        annots = this.getAnnotationsUsingTimeSlot(startingFromTimeSlot);
        if (annots != null) {
            for (AlignableAnnotation aa : annots) {
                boolean added = connectedAnnots.add(aa);
                if (!added) continue;
                if (!connectedTimeSlots.contains(aa.getBegin())) {
                    this.getConnectedAnnots(connectedAnnots, connectedTimeSlots, aa.getBegin());
                }
                if (connectedTimeSlots.contains(aa.getEnd())) continue;
                this.getConnectedAnnots(connectedAnnots, connectedTimeSlots, aa.getEnd());
            }
        }
    }

    public boolean getConnectedSubtree(TreeSet connectedAnnots, TimeSlot startingFromTimeSlot, TimeSlot stopTimeSlot, Tier topTier) {
        Vector annots = null;
        boolean endFound = false;
        annots = topTier == null ? this.getAnnotsBeginningAtTimeSlot(startingFromTimeSlot) : this.getAnnotsBeginningAtTimeSlot(startingFromTimeSlot, topTier, true);
        if (annots != null) {
            for (AlignableAnnotation aa : annots) {
                if (aa.getEnd() != stopTimeSlot) {
                    endFound = this.getConnectedSubtree(connectedAnnots, aa.getEnd(), stopTimeSlot, aa.getTier());
                    if (!endFound) continue;
                    connectedAnnots.add(aa);
                    continue;
                }
                endFound = true;
                connectedAnnots.add(aa);
            }
        }
        return endFound;
    }

    public boolean eachRootHasSubdiv() {
        boolean eachRootHasSubdiv = true;
        Vector topTiers = this.getTopTiers();
        for (TierImpl t : topTiers) {
            Vector annots = t.getAnnotations();
            for (AbstractAnnotation a : annots) {
                ArrayList children = a.getParentListeners();
                if (children == null || children.size() == 0) {
                    return false;
                }
                boolean subdivFound = false;
                for (AbstractAnnotation ch : children) {
                    Constraint constraint = ((TierImpl)ch.getTier()).getLinguisticType().getConstraints();
                    if (constraint.getStereoType() != 3 && constraint.getStereoType() != 0) continue;
                    subdivFound = true;
                    break;
                }
                if (subdivFound) continue;
                return false;
            }
        }
        return eachRootHasSubdiv;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setUnchanged() {
        this.changed = false;
        if (this.controlledVocabularies != null) {
            for (int i = 0; i < this.controlledVocabularies.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)this.controlledVocabularies.get(i);
                cv.setChanged(false);
            }
        }
    }

    @Override
    public void setChanged() {
        this.changed = true;
    }

    @Override
    public int getTimeChangePropagationMode() {
        return this.timeChangePropagationMode;
    }

    @Override
    public void setTimeChangePropagationMode(int theMode) {
        this.timeChangePropagationMode = theMode;
    }

    public void correctOverlapsByShifting(AlignableAnnotation fixedAnnotation, Vector fixedSlots, long oldBegin, long oldEnd) {
        long newEnd = fixedAnnotation.getEnd().getTime();
        if (newEnd > oldEnd) {
            long shift = newEnd - oldEnd;
            Vector otherFixedSLots = this.getOtherFixedSlots(oldBegin, fixedAnnotation.getTier().getName());
            if (otherFixedSLots != null) {
                for (int i = 0; i < otherFixedSLots.size(); ++i) {
                    if (fixedSlots.contains(otherFixedSLots.get(i))) continue;
                    fixedSlots.add(otherFixedSLots.get(i));
                }
            }
            this.getTimeOrder().shift(oldBegin, shift, fixedAnnotation.getEnd(), fixedSlots);
        }
    }

    private Vector getOtherFixedSlots(long from, String excludeTimeSLotsFromTier) {
        Vector tiers = this.getTiers();
        Vector<TimeSlot> fixedSlots = null;
        for (int t = 0; t < tiers.size(); ++t) {
            TierImpl tier = (TierImpl)tiers.get(t);
            Vector childTiers = tier.getChildTiers();
            if (tier.getLinguisticType().getConstraints() != null || excludeTimeSLotsFromTier != null && tier.getName().equals(excludeTimeSLotsFromTier)) continue;
            for (AlignableAnnotation ann : tier.getAnnotations()) {
                if (ann.getBeginTimeBoundary() >= from || ann.getEndTimeBoundary() <= from) continue;
                if (fixedSlots == null) {
                    fixedSlots = new Vector<TimeSlot>();
                }
                fixedSlots.add(ann.endTime);
                if (childTiers == null) continue;
                for (int i = 0; i < childTiers.size(); ++i) {
                    Vector childAnnotations;
                    TierImpl dependTier = (TierImpl)childTiers.get(i);
                    if (dependTier.getLinguisticType().getConstraints().getStereoType() != 0 && dependTier.getLinguisticType().getConstraints().getStereoType() != 1 || (childAnnotations = ann.getChildrenOnTier((Tier)childTiers.get(i))) == null) continue;
                    for (int a = 0; a < childAnnotations.size(); ++a) {
                        AlignableAnnotation childAnn = (AlignableAnnotation)childAnnotations.get(a);
                        if (childAnn.getBeginTimeBoundary() > from) {
                            fixedSlots.add(childAnn.beginTime);
                        }
                        if (childAnn.getEndTimeBoundary() <= from) continue;
                        fixedSlots.add(childAnn.endTime);
                    }
                }
            }
        }
        return fixedSlots;
    }

    public void shiftBackward(long from, long amount) {
        if (amount < 0L) {
            this.getTimeOrder().shift(from, amount, null, this.getOtherFixedSlots(from, null));
            this.modified(14, null);
        }
    }

    public void shiftAllAnnotations(long shiftValue) throws IllegalArgumentException {
        this.timeOrder.shiftAll(shiftValue);
        this.modified(14, null);
    }

    @Override
    public Vector getTiers() {
        return this.tiers;
    }

    public boolean equals(Object obj) {
        return obj instanceof TranscriptionImpl && ((TranscriptionImpl)obj).getName() == this.name;
    }

    public String getPathName() {
        return this.fileName;
    }

    public void setPathName(String theFileName) {
        if (theFileName.startsWith("file:")) {
            theFileName = theFileName.substring(5);
        }
        this.fileName = theFileName;
        this.url = this.pathToURLString(this.fileName);
    }

    @Override
    public void setMainMediaFile(String pathName) {
        if (this.mediafileName == null) {
            this.mediafileName = pathName;
        }
    }

    public void setSVGFile(String fileName) {
        int i;
        LinkedFileDescriptor lfd;
        int i2;
        if (fileName == null) {
            this.removeSVGFile();
            return;
        }
        String svgURL = fileName;
        if (!svgURL.startsWith("file:")) {
            svgURL = this.pathToURLString(svgURL);
        }
        this.svgFile = svgURL;
        for (i2 = 0; i2 < this.linkedFileDescriptors.size(); ++i2) {
            lfd = (LinkedFileDescriptor)this.linkedFileDescriptors.get(i2);
            if (!lfd.linkURL.equals(svgURL)) continue;
            return;
        }
        for (i2 = 0; i2 < this.linkedFileDescriptors.size(); ++i2) {
            lfd = (LinkedFileDescriptor)this.linkedFileDescriptors.get(i2);
            if (!lfd.mimeType.equals("image/svg+xml")) continue;
            this.linkedFileDescriptors.remove(i2);
            break;
        }
        lfd = new LinkedFileDescriptor(svgURL, "image/svg+xml");
        this.linkedFileDescriptors.add(lfd);
        for (i = 0; i < this.mediaDescriptors.size(); ++i) {
            MediaDescriptor mmd = (MediaDescriptor)this.mediaDescriptors.get(i);
            if (!mmd.mediaURL.substring(0, mmd.mediaURL.lastIndexOf(46)).equals(svgURL.substring(0, svgURL.lastIndexOf(46))) || !mmd.mimeType.equals("video/mpeg") && !mmd.mimeType.equals("video/quicktime") && !mmd.mimeType.equals("video/*")) continue;
            lfd.associatedWith = mmd.mediaURL;
            break;
        }
        if (lfd.associatedWith == null) {
            for (i = 0; i < this.mediaDescriptors.size(); ++i) {
                MediaDescriptor mmd = (MediaDescriptor)this.mediaDescriptors.get(i);
                if (!mmd.mimeType.equals("video/mpeg") && !mmd.mimeType.equals("video/quicktime") && !mmd.mimeType.equals("video/*")) continue;
                lfd.associatedWith = mmd.mediaURL;
                break;
            }
        }
    }

    public String getSVGFile() {
        return this.svgFile;
    }

    private void removeSVGFile() {
        if (this.svgFile != null) {
            for (int i = 0; i < this.linkedFileDescriptors.size(); ++i) {
                LinkedFileDescriptor lfd = (LinkedFileDescriptor)this.linkedFileDescriptors.get(i);
                if (!lfd.linkURL.equals(this.svgFile)) continue;
                this.linkedFileDescriptors.remove(i);
                String svgFileString = this.svgFile.substring(5);
                File svgFile = new File(svgFileString);
                if (!svgFile.exists()) break;
                File renamed = new File(svgFileString + "_old");
                try {
                    svgFile.renameTo(renamed);
                }
                catch (Exception exc) {}
                break;
            }
            this.svgFile = null;
        }
    }

    public void setControlledVocabularies(Vector controlledVocabs) {
        if (controlledVocabs != null) {
            this.controlledVocabularies = controlledVocabs;
        }
    }

    public Vector getControlledVocabularies() {
        return this.controlledVocabularies;
    }

    public ControlledVocabulary getControlledVocabulary(String name) {
        if (name == null) {
            return null;
        }
        ControlledVocabulary conVoc = null;
        for (int i = 0; i < this.controlledVocabularies.size() && !(conVoc = (ControlledVocabulary)this.controlledVocabularies.get(i)).getName().equalsIgnoreCase(name); ++i) {
            conVoc = null;
        }
        return conVoc;
    }

    public void addControlledVocabulary(ControlledVocabulary cv) {
        if (cv == null) {
            return;
        }
        for (int i = 0; i < this.controlledVocabularies.size(); ++i) {
            ControlledVocabulary conVoc = (ControlledVocabulary)this.controlledVocabularies.get(i);
            if (conVoc != cv && !conVoc.getName().equalsIgnoreCase(cv.getName())) continue;
            return;
        }
        this.controlledVocabularies.add(cv);
        cv.setACMEditableObject(this);
        if (this.isLoaded) {
            this.modified(13, cv);
        }
    }

    public void removeControlledVocabulary(ControlledVocabulary cv) {
        if (cv == null) {
            return;
        }
        Vector types = this.getLinguisticTypesWithCV(cv.getName());
        for (int i = 0; i < types.size(); ++i) {
            ((LinguisticType)types.get(i)).setControlledVocabularyName(null);
        }
        cv.removeACMEditableObject();
        this.controlledVocabularies.remove(cv);
        this.modified(13, cv);
    }

    public void changeControlledVocabulary(ControlledVocabulary cv, String name, String description) {
        boolean newChange = false;
        String oldName = cv.getName();
        String oldDescription = cv.getDescription();
        for (int i = 0; i < this.controlledVocabularies.size(); ++i) {
            ControlledVocabulary conVoc = (ControlledVocabulary)this.controlledVocabularies.get(i);
            if (conVoc == cv || !conVoc.getName().equalsIgnoreCase(name)) continue;
            return;
        }
        if (!oldName.equals(name)) {
            newChange = true;
            Vector types = this.getLinguisticTypesWithCV(oldName);
            for (int i = 0; i < types.size(); ++i) {
                ((LinguisticType)types.get(i)).setControlledVocabularyName(name);
            }
            cv.setName(name);
        }
        if (!oldDescription.equals(description)) {
            cv.setDescription(description);
            newChange = true;
        }
        if (newChange) {
            this.modified(13, cv);
        }
    }

    public void checkAnnotECVConsistency() {
        for (TierImpl currentTier : this.tiers) {
            ExternalCV ecv;
            String cvName = currentTier.getLinguisticType().getControlledVocabylaryName();
            ControlledVocabulary cv = this.getControlledVocabulary(cvName);
            if (!(cv instanceof ExternalCV) || !(ecv = (ExternalCV)cv).isLoadedFromURL() && !ecv.isLoadedFromCache()) continue;
            for (AbstractAnnotation currentAnn : currentTier.getAnnotations()) {
                String cvEntryRefId = currentAnn.getExtRefValue(5);
                if (cvEntryRefId == null) continue;
                CVEntry entry = ecv.getEntrybyId(cvEntryRefId);
                if (entry != null && entry.getValue() != null && !entry.getValue().equals(currentAnn.getValue())) {
                    currentAnn.setValue(entry.getValue());
                    this.setChanged();
                    continue;
                }
                if (entry != null) continue;
                String value = currentAnn.getExtRefValue(5);
                ExternalReferenceImpl extRef = new ExternalReferenceImpl(value, 5);
                currentAnn.removeExtRef(extRef);
                this.setChanged();
            }
        }
    }

    public Vector getLinguisticTypesWithCV(String name) {
        Vector<LinguisticType> matchingTypes = new Vector<LinguisticType>();
        for (int i = 0; i < this.linguisticTypes.size(); ++i) {
            LinguisticType lt = (LinguisticType)this.linguisticTypes.get(i);
            String cvName = lt.getControlledVocabylaryName();
            if (cvName == null || !cvName.equalsIgnoreCase(name)) continue;
            matchingTypes.add(lt);
        }
        return matchingTypes;
    }

    public Vector getTiersWithCV(String name) {
        Vector matchingTiers = new Vector();
        if (name == null || name.length() == 0) {
            return matchingTiers;
        }
        Vector types = this.getLinguisticTypesWithCV(name);
        if (types.size() > 0) {
            for (int i = 0; i < types.size(); ++i) {
                LinguisticType type = (LinguisticType)types.get(i);
                Vector tv = this.getTiersWithLinguisticType(type.getLinguisticTypeName());
                if (tv.size() <= 0) continue;
                matchingTiers.addAll(tv);
            }
        }
        return matchingTiers;
    }

    public boolean allRootAnnotsUnaligned() {
        Vector topTiers = this.getTopTiers();
        for (TierImpl t : topTiers) {
            Vector annots = t.getAnnotations();
            for (AlignableAnnotation a : annots) {
                if (!a.getBegin().isTimeAligned() && !a.getEnd().isTimeAligned()) continue;
                return false;
            }
        }
        return true;
    }

    public void alignRootAnnots() {
        Vector<TimeSlot> rootTimeSlots = new Vector<TimeSlot>();
        Vector topTiers = this.getTopTiers();
        for (TierImpl t : topTiers) {
            Vector annots = t.getAnnotations();
            for (AlignableAnnotation a : annots) {
                rootTimeSlots.add(a.getBegin());
                rootTimeSlots.add(a.getEnd());
            }
        }
        int cnt = 0;
        Object[] tsArray = rootTimeSlots.toArray();
        Arrays.sort(tsArray);
        for (int i = 0; i < tsArray.length; ++i) {
            TimeSlot ts = (TimeSlot)tsArray[i];
            if (i % 2 == 0) {
                ts.setTime(1000 * cnt++);
                continue;
            }
            ts.setTime(1000 * cnt);
        }
    }

    public final Vector getTopTiers() {
        Vector<TierImpl> result = new Vector<TierImpl>();
        Enumeration e = this.getTiers().elements();
        while (e.hasMoreElements()) {
            TierImpl t;
            TierImpl dad;
            Object o = e.nextElement();
            if (!(o instanceof TierImpl) || (dad = (TierImpl)(t = (TierImpl)o).getParentTier()) != null) continue;
            result.add(t);
        }
        return result;
    }

    public void addDocProperties(ArrayList props) {
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                Object prop = props.get(i);
                if (!(prop instanceof Property) || this.docProperties.contains(prop)) continue;
                this.docProperties.add(prop);
            }
        }
    }

    public void addDocProperty(Property prop) {
        if (prop != null && !this.docProperties.contains(prop)) {
            this.docProperties.add(prop);
        }
    }

    public boolean removeDocProperty(Property prop) {
        if (prop != null) {
            return this.docProperties.remove(prop);
        }
        return false;
    }

    public ArrayList getDocProperties() {
        return this.docProperties;
    }

    public void clearDocProperties() {
        this.docProperties.clear();
    }

    public HashMap<String, LexiconServiceClientFactory> getLexiconServiceClientFactories() {
        return this.lexiconServiceClientFactories;
    }

    public void addLexiconServiceClientFactory(String name, LexiconServiceClientFactory fact) {
        if (this.lexiconServiceClientFactories == null) {
            this.lexiconServiceClientFactories = new HashMap(6);
        }
        this.lexiconServiceClientFactories.put(name, fact);
        this.lexcionServicesLoaded = true;
    }

    public void removeLexiconServiceClientFactory(String name) {
        if (this.lexiconServiceClientFactories != null) {
            this.lexiconServiceClientFactories.remove(name);
        }
    }

    public boolean isLexcionServicesLoaded() {
        return this.lexcionServicesLoaded;
    }

    public void setLexcionServicesLoaded(boolean lexcionServicesLoaded) {
        this.lexcionServicesLoaded = lexcionServicesLoaded;
    }

    @Override
    public HashMap<String, LexiconLink> getLexiconLinks() {
        return this.lexiconLinks;
    }

    @Override
    public void addLexiconLink(LexiconLink link) {
        this.lexiconLinks.put(link.getName(), link);
        if (this.isLoaded) {
            this.modified(19, link);
        }
    }

    @Override
    public void removeLexiconLink(LexiconLink link) {
        for (LinguisticType type : this.linguisticTypes) {
            if (!type.isUsingLexiconQueryBundle() || !type.getLexiconQueryBundle().getLink().getName().equals(link.getName())) continue;
            type.setLexiconQueryBundle(null);
        }
        this.lexiconLinks.remove(link.getName());
        if (this.isLoaded) {
            this.modified(18, link);
        }
    }

    @Override
    public LexiconLink getLexiconLink(String linkName) {
        return this.lexiconLinks.get(linkName);
    }

    public Vector<LinguisticType> getLinguisticTypesWithLexLink(String name) {
        Vector<LinguisticType> types = new Vector<LinguisticType>();
        for (LinguisticType type : this.linguisticTypes) {
            if (!type.isUsingLexiconQueryBundle() || !type.getLexiconQueryBundle().getLink().getName().equals(name)) continue;
            types.add(type);
        }
        return types;
    }
}

