/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.ParserFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeOrderImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotComparator;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoder;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF25Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxEncoder;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class ACM25TranscriptionStore
implements TranscriptionStore,
ServerLogger {
    public File fileToWriteXMLinto = null;
    public boolean debug = false;

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, int format) throws IOException {
        if (theTranscription instanceof TranscriptionImpl) {
            String pathName = ((TranscriptionImpl)theTranscription).getPathName();
            if (!pathName.substring(pathName.length() - 4, pathName.length() - 3).equals(".")) {
                pathName = pathName + ".eaf";
            } else {
                pathName = pathName.substring(0, pathName.length() - 3);
                pathName = pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, encoderInfo, tierOrder, pathName, format);
        }
    }

    @Override
    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String pathName, int format) throws IOException {
        if (theTranscription instanceof TranscriptionImpl) {
            if (!pathName.substring(pathName.length() - 4, pathName.length() - 3).equals(".")) {
                pathName = pathName + ".eaf";
            } else {
                pathName = pathName.substring(0, pathName.length() - 3);
                pathName = pathName + "eaf";
            }
            this.storeTranscriptionIn(theTranscription, encoderInfo, tierOrder, pathName, format);
        }
    }

    @Override
    public void storeTranscriptionIn(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path, int format) throws IOException {
        switch (format) {
            case 0: {
                if (this.fileToWriteXMLinto != null) {
                    path = this.fileToWriteXMLinto.getAbsolutePath();
                }
                new EAF25Encoder().encodeAndSave(theTranscription, null, tierOrder, path);
                break;
            }
            case 1: {
                new CHATEncoder().encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
            case 2: {
                new ShoeboxEncoder(path).encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
                break;
            }
        }
    }

    @Override
    public void storeTranscriptionAsTemplateIn(Transcription theTranscription, List tierOrder, String path) throws IOException {
        if (this.fileToWriteXMLinto != null) {
            path = this.fileToWriteXMLinto.getAbsolutePath();
        }
        new EAF25Encoder().encodeAsTemplateAndSave(theTranscription, tierOrder, path);
    }

    @Override
    public void loadTranscription(Transcription theTranscription) {
        this.loadTranscription(theTranscription, null);
    }

    @Override
    public void loadTranscription(Transcription theTranscription, DecoderInfo decoderInfo) {
        HashMap cvTable;
        ArrayList linkedFileDescriptors;
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        String trPathName = attisTr.getPathName();
        String lowerPathName = trPathName.toLowerCase();
        Parser parser = null;
        if (lowerPathName.endsWith("cha")) {
            parser = ParserFactory.getParser(1);
        } else if (decoderInfo instanceof DelimitedTextDecoderInfo) {
            parser = ParserFactory.getParser(10);
            parser.setDecoderInfo(decoderInfo);
        } else if (lowerPathName.endsWith("txt")) {
            parser = ParserFactory.getParser(2);
            parser.setDecoderInfo(decoderInfo);
        } else if (lowerPathName.endsWith("trs")) {
            parser = ParserFactory.getParser(3);
            parser.setDecoderInfo(decoderInfo);
        } else {
            parser = lowerPathName.endsWith("imdi") ? ParserFactory.getParser(4) : ParserFactory.getParser(9);
        }
        long beginTime = System.currentTimeMillis();
        String mediaFileName = parser.getMediaFile(trPathName);
        if (this.debug) {
            System.out.println("Parsing eaf took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if (mediaFileName != null && mediaFileName.startsWith("file:")) {
            mediaFileName = mediaFileName.substring(5);
        }
        attisTr.setMainMediaFile(mediaFileName);
        ArrayList mediaDescriptors = parser.getMediaDescriptors(trPathName);
        attisTr.setMediaDescriptors(new Vector(mediaDescriptors));
        String svgFile = parser.getSVGFile(trPathName);
        if (svgFile != null) {
            if (!svgFile.startsWith("file:")) {
                svgFile = "file:" + mediaFileName;
            }
            attisTr.setSVGFile(svgFile);
        }
        if ((linkedFileDescriptors = parser.getLinkedFileDescriptors(trPathName)) != null) {
            attisTr.setLinkedFileDescriptors(new Vector(linkedFileDescriptors));
        }
        ArrayList props = parser.getTranscriptionProperties(trPathName);
        int lastUsedAnnotationId = 0;
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                PropertyImpl pimpl = (PropertyImpl)props.get(i);
                if (!"lastUsedAnnotationId".equals(pimpl.getName())) continue;
                String val = (String)pimpl.getValue();
                if (val != null) {
                    try {
                        lastUsedAnnotationId = Integer.parseInt(val);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                props.remove(i);
                break;
            }
            attisTr.addDocProperties(props);
        }
        String author = parser.getAuthor(trPathName);
        if (attisTr.getAuthor().equals("")) {
            attisTr.setAuthor(author);
        }
        if (this.debug) {
            System.out.println("Extracting header took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        ArrayList linguisticTypes = parser.getLinguisticTypes(trPathName);
        ArrayList<LinguisticType> typesCopy = new ArrayList<LinguisticType>(linguisticTypes.size());
        for (int i = 0; i < linguisticTypes.size(); ++i) {
            LingTypeRecord ltr = (LingTypeRecord)linguisticTypes.get(i);
            LinguisticType lt = new LinguisticType(ltr.getLingTypeId());
            boolean timeAlignable = true;
            if (ltr.getTimeAlignable().equals("false")) {
                timeAlignable = false;
            }
            lt.setTimeAlignable(timeAlignable);
            boolean graphicReferences = false;
            if (ltr.getGraphicReferences().equals("true")) {
                graphicReferences = true;
            }
            lt.setGraphicReferences(graphicReferences);
            String stereotype = ltr.getStereoType();
            ConstraintImpl c = null;
            if (stereotype != null) {
                if ((stereotype = stereotype.replace('_', ' ')).equals(Constraint.stereoTypes[0])) {
                    c = new TimeSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[3])) {
                    c = new SymbolicSubdivision();
                } else if (stereotype.equals(Constraint.stereoTypes[4])) {
                    c = new SymbolicAssociation();
                } else if (stereotype.equals(Constraint.stereoTypes[1])) {
                    c = new IncludedIn();
                }
            }
            if (c != null) {
                lt.addConstraint(c);
            }
            lt.setControlledVocabularyName(ltr.getControlledVocabulary());
            typesCopy.add(lt);
        }
        attisTr.setLinguisticTypes(new Vector(typesCopy));
        if (this.debug) {
            System.out.println("Creating linguistic types took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        ArrayList order = parser.getTimeOrder(trPathName);
        HashMap slots = parser.getTimeSlots(trPathName);
        HashMap<String, TimeSlotImpl> timeSlothash = new HashMap<String, TimeSlotImpl>();
        Iterator orderedIter = order.iterator();
        TimeSlotImpl ts = null;
        String tsKey = null;
        ArrayList<TimeSlotImpl> tempSlots = new ArrayList<TimeSlotImpl>(order.size());
        int index = 0;
        while (orderedIter.hasNext()) {
            tsKey = (String)orderedIter.next();
            long time = Long.parseLong((String)slots.get(tsKey));
            ts = time != -1L ? new TimeSlotImpl(time, timeOrder) : new TimeSlotImpl(timeOrder);
            ts.setIndex(index++);
            tempSlots.add(ts);
            timeSlothash.put(tsKey, ts);
        }
        Collections.sort(tempSlots, new TimeSlotComparator());
        ((TimeOrderImpl)timeOrder).insertOrderedSlots(tempSlots);
        if (this.debug) {
            System.out.println("Creating time slots and time order took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        HashMap<TierImpl, String> parentHash = new HashMap<TierImpl, String>();
        if (!attisTr.isLoaded()) {
            Iterator iter = parser.getTierNames(trPathName).iterator();
            attisTr.setLoaded(true);
            while (iter.hasNext()) {
                String parentId;
                String tierName = (String)iter.next();
                TierImpl tier = new TierImpl(null, tierName, null, attisTr, null);
                String participant = parser.getParticipantOf(tierName, trPathName);
                String linguisticTypeID = parser.getLinguisticTypeIDOf(tierName, trPathName);
                String annotator = parser.getAnnotatorOf(tierName, trPathName);
                LinguisticType linguisticType = null;
                for (LinguisticType lt : typesCopy) {
                    if (!lt.getLinguisticTypeName().equals(linguisticTypeID)) continue;
                    linguisticType = lt;
                    break;
                }
                Locale defaultLanguage = parser.getDefaultLanguageOf(tierName, trPathName);
                tier.setMetadata("PARTICIPANT", participant);
                tier.setMetadata("ANNOTATOR", annotator);
                tier.setLinguisticType(linguisticType);
                if (defaultLanguage != null) {
                    tier.setMetadata("DEFAULT_LOCALE", defaultLanguage);
                }
                if ((parentId = parser.getParentNameOf(tierName, trPathName)) != null) {
                    parentHash.put(tier, parentId);
                }
                attisTr.addTier(tier);
            }
        }
        for (TierImpl t : parentHash.keySet()) {
            t.setParentTier(attisTr.getTierWithId((String)parentHash.get(t)));
        }
        if (this.debug) {
            System.out.println("Creating tiers took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Vector tiers = attisTr.getTiers();
        HashMap<String, RefAnnotation> idToAnnotation = new HashMap<String, RefAnnotation>();
        HashMap<String, String> references = new HashMap<String, String>();
        HashMap<String, String> referenceChains = new HashMap<String, String>();
        HashMap tempAnnotationsForTiers = new HashMap();
        for (Tier tier : tiers) {
            ArrayList annotationRecords = parser.getAnnotationsOf(tier.getName(), trPathName);
            ArrayList<RefAnnotation> tempAnnotations = new ArrayList<RefAnnotation>();
            Iterator it1 = annotationRecords.iterator();
            while (it1.hasNext()) {
                AbstractAnnotation annotation = null;
                AnnotationRecord annotationRecord = (AnnotationRecord)it1.next();
                if (annotationRecord.getAnnotationType().equals("alignable")) {
                    annotation = ((TierImpl)tier).getLinguisticType().hasGraphicReferences() ? new SVGAlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier, null) : new AlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier);
                } else if (annotationRecord.getAnnotationType().equals("alignable_svg")) {
                    annotation = new SVGAlignableAnnotation((TimeSlot)timeSlothash.get(annotationRecord.getBeginTimeSlotId()), (TimeSlot)timeSlothash.get(annotationRecord.getEndTimeSlotId()), tier, annotationRecord.getSvgReference());
                } else if (annotationRecord.getAnnotationType().equals("reference")) {
                    annotation = new RefAnnotation(null, tier);
                    references.put(annotationRecord.getAnnotationId(), annotationRecord.getReferredAnnotId());
                    if (annotationRecord.getPreviousAnnotId() != null) {
                        referenceChains.put(annotationRecord.getAnnotationId(), annotationRecord.getPreviousAnnotId());
                    }
                }
                if (annotationRecord.getValue() != null) {
                    annotation.setValue(annotationRecord.getValue());
                }
                annotation.setId(annotationRecord.getAnnotationId());
                idToAnnotation.put(annotationRecord.getAnnotationId(), (RefAnnotation)annotation);
                if (annotationRecord.getAnnotationId() != null && annotationRecord.getAnnotationId().charAt(0) == 'a') {
                    try {
                        int aid = Integer.parseInt(annotationRecord.getAnnotationId().substring(1));
                        if (aid > lastUsedAnnotationId) {
                            lastUsedAnnotationId = aid;
                        }
                    }
                    catch (NumberFormatException nfe) {
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                tempAnnotations.add((RefAnnotation)annotation);
            }
            tempAnnotationsForTiers.put(tier, tempAnnotations);
        }
        PropertyImpl luaid = new PropertyImpl();
        luaid.setName("lastUsedAnnotationId");
        luaid.setValue(String.valueOf(lastUsedAnnotationId));
        attisTr.addDocProperty(luaid);
        for (String key : references.keySet()) {
            Annotation referedAnnotation = (Annotation)idToAnnotation.get(references.get(key));
            RefAnnotation refAnnotation = null;
            try {
                refAnnotation = (RefAnnotation)idToAnnotation.get(key);
                refAnnotation.addReference(referedAnnotation);
            }
            catch (Exception ex) {
                Object o = idToAnnotation.get(key);
                LOG.warning("failed to add a refanno to  (" + referedAnnotation.getTier().getName() + ", " + referedAnnotation.getBeginTimeBoundary() + ", " + referedAnnotation.getEndTimeBoundary() + ") " + referedAnnotation.getValue());
                if (o instanceof AlignableAnnotation) {
                    Annotation a = (AlignableAnnotation)o;
                    LOG.warning("  found AlignableAnnotation (" + ((AbstractAnnotation)a).getTier().getName() + ", " + ((AlignableAnnotation)a).getBeginTimeBoundary() + ", " + ((AlignableAnnotation)a).getEndTimeBoundary() + ") " + ((AbstractAnnotation)a).getValue());
                    continue;
                }
                LOG.warning("  found " + o);
            }
        }
        for (String key : referenceChains.keySet()) {
            RefAnnotation previous = (RefAnnotation)idToAnnotation.get(referenceChains.get(key));
            RefAnnotation a = (RefAnnotation)idToAnnotation.get(key);
            if (previous == null) continue;
            previous.setNext(a);
        }
        for (TierImpl t : tempAnnotationsForTiers.keySet()) {
            ArrayList annots = (ArrayList)tempAnnotationsForTiers.get(t);
            Iterator aIter = annots.iterator();
            while (aIter.hasNext()) {
                t.insertAnnotation((Annotation)aIter.next());
            }
        }
        for (TierImpl t : tiers) {
            if (!t.isTimeAlignable() || !t.hasParentTier()) continue;
            for (Annotation a : t.getAnnotations()) {
                if (!(a instanceof AlignableAnnotation)) continue;
                ((AlignableAnnotation)a).registerWithParent();
            }
        }
        if (this.debug) {
            System.out.println("Creating and connecting annotations took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((cvTable = parser.getControlledVocabularies(trPathName)) != null && cvTable.size() > 0) {
            ControlledVocabulary cv = null;
            for (String cvName : cvTable.keySet()) {
                if (cvName == null) continue;
                cv = new ControlledVocabulary(cvName);
                ArrayList contents = (ArrayList)cvTable.get(cvName);
                if (contents.size() > 0) {
                    for (int i = 0; i < contents.size(); ++i) {
                        CVEntry entry;
                        Object next = contents.get(i);
                        if (next instanceof String) {
                            cv.setDescription((String)next);
                            continue;
                        }
                        if (!(next instanceof CVEntryRecord) || (entry = new CVEntry(((CVEntryRecord)next).getValue(), ((CVEntryRecord)next).getDescription())) == null) continue;
                        cv.addEntry(entry);
                    }
                }
                attisTr.addControlledVocabulary(cv);
            }
        }
        if (this.debug) {
            System.out.println("Creating CV's took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if (attisTr.allRootAnnotsUnaligned()) {
            attisTr.alignRootAnnots();
        }
        this.concatenateSymbolicAssociations(attisTr);
        if (this.debug) {
            System.out.println("Post-processing took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
    }

    public void concatenateSymbolicAssociations(TranscriptionImpl transcription) {
        Annotation lastParent = null;
        RefAnnotation lastAnnot = null;
        Vector<RefAnnotation> annotsToRemove = new Vector<RefAnnotation>();
        Vector tiers = transcription.getTiers();
        Iterator tierIter = tiers.iterator();
        while (tierIter.hasNext()) {
            lastParent = null;
            lastAnnot = null;
            annotsToRemove.clear();
            TierImpl t = (TierImpl)tierIter.next();
            LinguisticType lt = t.getLinguisticType();
            Constraint c = null;
            if (lt != null) {
                c = lt.getConstraints();
            }
            if (c == null || c.getStereoType() != 4) continue;
            for (RefAnnotation a : t.getAnnotations()) {
                if (a.getParentAnnotation() == lastParent) {
                    lastAnnot.setValue(lastAnnot.getValue() + " " + a.getValue());
                    annotsToRemove.add(a);
                    continue;
                }
                lastParent = a.getParentAnnotation();
                lastAnnot = a;
            }
            Iterator rIter = annotsToRemove.iterator();
            while (rIter.hasNext()) {
                t.removeAnnotation((Annotation)rIter.next());
            }
        }
    }
}

