/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class DAFParser
extends HandlerBase {
    private static DAFParser parser;
    private final Float ORDERED_KEYS_KEY = new Float(0.12345);
    private boolean verbose;
    private SAXParser saxParser;
    private String lastParsed;
    private String currentFileName;
    private File xmlFile;
    private boolean parseError;
    private Hashtable tiers;
    private Vector tierNames;
    private Hashtable tierAttributes;
    private String mediaFile;
    private String author;
    private Vector linguisticTypes;
    private Vector locales;
    private Hashtable timeSlots;
    private Vector timeOrder;
    private String currentTierId;
    private String currentAnnotationId;
    private String currentSpeakerId;
    private String currentStart;
    private String currentEnd;
    private String content;

    private DAFParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            this.saxParser = factory.newSAXParser();
            this.lastParsed = "";
            this.verbose = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DAFParser Instance() {
        if (parser == null) {
            parser = new DAFParser();
        }
        return parser;
    }

    public String getMediaFile(String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        return this.mediaFile;
    }

    public String getAuthor(String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        return this.author;
    }

    public Vector getLinguisticTypes(String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        return this.linguisticTypes;
    }

    public Vector getTimeOrder(String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        return this.timeOrder;
    }

    public Hashtable getTimeSlots(String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        return this.timeSlots;
    }

    public Vector getTierNames(String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        return this.tierNames;
    }

    public String getParticipantOf(String tierName, String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        String part = "";
        if (((Hashtable)this.tierAttributes.get(tierName)).get("PARTICIPANT") != null) {
            part = (String)((Hashtable)this.tierAttributes.get(tierName)).get("PARTICIPANT");
        }
        return part;
    }

    public LinguisticType getLinguisticTypeOf(String tierName, String fileName) {
        LinguisticType lt = null;
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        String lType = "";
        if (((Hashtable)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF") != null) {
            lType = (String)((Hashtable)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF");
        }
        for (LinguisticType l : this.linguisticTypes) {
            if (!l.getLinguisticTypeName().equals(lType)) continue;
            lt = l;
            break;
        }
        return lt;
    }

    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        Locale resultLoc = null;
        String localeId = (String)((Hashtable)this.tierAttributes.get(tierName)).get("DEFAULT_LOCALE");
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    public String getParentNameOf(String tierName, String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        return (String)((Hashtable)this.tierAttributes.get(tierName)).get("PARENT_REF");
    }

    public Vector getAnnotationsOf(String tierName, String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        long start = System.currentTimeMillis();
        Vector annotationVector = new Vector();
        Hashtable annotations = (Hashtable)this.tiers.get(tierName);
        Iterator iter = annotations.keySet().iterator();
        while (iter.hasNext()) {
            Vector annotationRecord = new Vector();
            Object key = iter.next();
            annotationRecord.add(key);
            annotationRecord.addAll((Vector)annotations.get(key));
            annotationVector.add(annotationRecord);
        }
        long duration = System.currentTimeMillis() - start;
        return annotationVector;
    }

    private void parse(String fileName) {
        long start = System.currentTimeMillis();
        try {
            if (this.lastParsed.equals(fileName)) {
                return;
            }
            this.tiers = new Hashtable();
            this.tierNames = new Vector();
            this.tierAttributes = new Hashtable();
            this.mediaFile = "";
            this.linguisticTypes = new Vector();
            this.locales = new Vector();
            this.timeSlots = new Hashtable();
            this.timeOrder = new Vector();
            this.xmlFile = new File(fileName);
            this.lastParsed = fileName;
            this.currentFileName = fileName;
            this.saxParser.parse(this.xmlFile, (HandlerBase)this);
        }
        catch (Exception e) {
            this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage());
        }
        long duration = System.currentTimeMillis() - start;
    }

    @Override
    public void startDocument() {
        this.parseError = false;
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String name, AttributeList attributes) {
        this.content = null;
        if (name.equals("ANNOTATION_DOCUMENT")) {
            this.author = attributes.getValue("AUTHOR");
        } else if (name.equals("HEADER")) {
            this.mediaFile = attributes.getValue("MEDIA_FILE");
        } else if (!name.equals("TIME_ORDER")) {
            if (name.equals("TIME_SLOT")) {
                String timeValue = String.valueOf(-1);
                if (attributes.getValue("TIME_VALUE") != null) {
                    timeValue = attributes.getValue("TIME_VALUE");
                }
                this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
            } else if (name.equals("TIER")) {
                this.currentTierId = attributes.getValue("TIER_ID");
                if (!this.tiers.containsKey(this.currentTierId)) {
                    this.tiers.put(this.currentTierId, new Hashtable());
                    this.tierAttributes.put(this.currentTierId, new Hashtable());
                    this.tierNames.add(this.currentTierId);
                }
                Hashtable attrHash = (Hashtable)this.tierAttributes.get(this.currentTierId);
                if (attributes.getValue("PARTICIPANT") != null) {
                    attrHash.put("PARTICIPANT", attributes.getValue("PARTICIPANT"));
                }
                attrHash.put("LINGUISTIC_TYPE_REF", attributes.getValue("LINGUISTIC_TYPE_REF"));
                attrHash.put("DEFAULT_LOCALE", attributes.getValue("DEFAULT_LOCALE"));
                if (attributes.getValue("PARENT_REF") != null) {
                    attrHash.put("PARENT_REF", attributes.getValue("PARENT_REF"));
                }
            } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                ((Hashtable)this.tiers.get(this.currentTierId)).put(this.currentAnnotationId, new Vector());
                ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add("alignable");
                ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add(attributes.getValue("TIME_SLOT_REF1"));
                ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add(attributes.getValue("TIME_SLOT_REF2"));
            } else if (name.equals("REF_ANNOTATION")) {
                this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                ((Hashtable)this.tiers.get(this.currentTierId)).put(this.currentAnnotationId, new Vector());
                ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add("reference");
                ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add(attributes.getValue("ANNOTATION_REF"));
                if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                    ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add(attributes.getValue("PREVIOUS_ANNOTATION"));
                } else {
                    ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add("");
                }
            } else if (name.equals("LINGUISTIC_TYPE")) {
                this.linguisticTypes.add(new LinguisticType(attributes.getValue("LINGUISTIC_TYPE_ID")));
            } else if (name.equals("LOCALE")) {
                String variant;
                String langCode = attributes.getValue("LANGUAGE_CODE");
                String countryCode = attributes.getValue("COUNTRY_CODE");
                if (countryCode == null) {
                    countryCode = "";
                }
                if ((variant = attributes.getValue("VARIANT")) == null) {
                    variant = "";
                }
                Locale l = new Locale(langCode, countryCode, variant);
                this.locales.add(l);
            }
        }
    }

    @Override
    public void endElement(String name) {
        if (name.equals("ANNOTATION_VALUE")) {
            ((Vector)((Hashtable)this.tiers.get(this.currentTierId)).get(this.currentAnnotationId)).add(this.content);
        }
    }

    @Override
    public void characters(char[] buf, int start, int length) {
        this.content = this.content == null ? this.removeWhiteSpace(buf, start, length) : this.content + this.removeWhiteSpace(buf, start, length);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource inputSource = null;
        return inputSource;
    }

    @Override
    public void error(SAXParseException e) {
        this.printErrorLocationInfo("Parse error " + e.getMessage());
        this.parseError = true;
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.printErrorLocationInfo("Fatal Parse Error " + e.getMessage());
        this.parseError = true;
    }

    private String removeWhiteSpace(char[] buf, int start, int length) {
        int from = start;
        int to = start + length;
        return new String(buf, from, to - from);
    }

    private void println(String s) {
        if (this.verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
        System.out.println("Tier id " + this.currentTierId);
        System.out.println("Annotation id " + this.currentAnnotationId);
    }
}

