/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF25;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF25Encoder
implements AnnotationDocEncoder,
ServerLogger {
    public static final String VERSION = "2.5";
    public static boolean debug = false;

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path) throws IOException {
        Element documentElement = EAF25Encoder.createDOM(theTranscription, tierOrder);
        EAF25Encoder.save(documentElement, path);
    }

    public void encodeAsTemplateAndSave(Transcription theTranscription, List tierOrder, String path) throws IOException {
        Element documentElement = EAF25Encoder.createTemplateDOM(theTranscription, tierOrder);
        EAF25Encoder.save(documentElement, path);
    }

    public static Element createDOM(Transcription theTranscription, List tierOrder) {
        Vector vector;
        long beginTime = System.currentTimeMillis();
        if (debug) {
            System.out.println("Encoder creating DOM...");
        }
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<TimeSlot, String> timeSlotIds = new Hashtable<TimeSlot, String>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF25 eafFactory = null;
        try {
            eafFactory = new EAF25();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF25Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        for (MediaDescriptor md : attisTr.getMediaDescriptors()) {
            String origin = null;
            if (md.timeOrigin != 0L) {
                origin = String.valueOf(md.timeOrigin);
            }
            String extrFrom = null;
            if (md.extractedFrom != null && md.extractedFrom != "") {
                extrFrom = md.extractedFrom;
            }
            Element mdElement = eafFactory.newMediaDescriptor(md.mediaURL, md.relativeMediaURL, md.mimeType, origin, extrFrom);
            header.appendChild(mdElement);
        }
        for (LinkedFileDescriptor lfd : attisTr.getLinkedFileDescriptors()) {
            String origin = null;
            if (lfd.timeOrigin != 0L) {
                origin = String.valueOf(lfd.timeOrigin);
            }
            Element lfdElement = eafFactory.newLinkedFileDescriptor(lfd.linkURL, lfd.relativeLinkURL, lfd.mimeType, origin, lfd.associatedWith);
            header.appendChild(lfdElement);
        }
        int lastUsedAnnId = 0;
        ArrayList props = attisTr.getDocProperties();
        if (props.size() > 0) {
            for (int i = 0; i < props.size(); ++i) {
                PropertyImpl prop = (PropertyImpl)props.get(i);
                if (prop == null || prop.getName() == null && prop.getValue() == null) continue;
                if (prop.getName().equals("lastUsedAnnotationId")) {
                    if (prop.getValue() == null) continue;
                    try {
                        lastUsedAnnId = Integer.parseInt((String)prop.getValue());
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Could not retrieve the last used annotation id.");
                    }
                    continue;
                }
                if (prop.getValue() != null) {
                    header.appendChild(eafFactory.newProperty(prop.getName(), prop.getValue().toString()));
                    continue;
                }
                header.appendChild(eafFactory.newProperty(prop.getName(), null));
            }
        }
        if (debug) {
            System.out.println("Header creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Enumeration tsElements = timeOrder.elements();
        while (tsElements.hasMoreElements()) {
            TimeSlot ts = (TimeSlot)tsElements.nextElement();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, tsId);
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        if (debug) {
            System.out.println("TimeSlots creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        int svgIndex = 1;
        int annIndex = lastUsedAnnId;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String string = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String annotator = (String)tierImpl.getMetadataValue("ANNOTATOR");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(string, participant, annotator, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                if (ann.getId() != null && !ann.getId().equals("")) {
                    annotationIds.put(ann, ann.getId());
                    continue;
                }
                annotationIds.put(ann, "a" + ++annIndex);
            }
        }
        header.appendChild(eafFactory.newProperty("lastUsedAnnotationId", String.valueOf(annIndex)));
        for (TierImpl tierImpl : storeOrder) {
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                Element annElement = eafFactory.newAnnotation();
                ((Element)tierElements.get(tierImpl.getName())).appendChild(annElement);
                Node annSubElement = null;
                String annId = (String)annotationIds.get(ann);
                if (ann instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getBegin());
                    String endTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getEnd());
                    if (ann instanceof SVGAlignableAnnotation) {
                        if (((SVGAlignableAnnotation)ann).getShape() != null) {
                            String svgId = "ga" + svgIndex;
                            ((SVGAlignableAnnotation)ann).setSVGElementID(svgId);
                            ++svgIndex;
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, svgId);
                        } else {
                            ((SVGAlignableAnnotation)ann).setSVGElementID(null);
                            annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null);
                        }
                    } else {
                        annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, null);
                    }
                } else if (ann instanceof RefAnnotation) {
                    String refId = null;
                    String prevId = null;
                    Vector refs = ((RefAnnotation)ann).getReferences();
                    RefAnnotation prev = ((RefAnnotation)ann).getPrevious();
                    if (refs.size() > 0) {
                        refId = (String)annotationIds.get((Annotation)refs.firstElement());
                    }
                    if (prev != null) {
                        prevId = (String)annotationIds.get(prev);
                    }
                    annSubElement = eafFactory.newRefAnnotation(annId, refId, prevId);
                }
                annElement.appendChild(annSubElement);
                Element valueElement = eafFactory.newAnnotationValue(ann.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        if (debug) {
            System.out.println("Tiers and Annotations creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((vector = attisTr.getLinguisticTypes()) != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype, lt.getControlledVocabylaryName());
                annotDocument.appendChild(typeElement);
            }
        }
        if (debug) {
            System.out.println("Linguistic Types creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        Vector conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            for (int i = 0; i < conVocs.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)conVocs.get(i);
                Element cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription());
                    cvElement.appendChild(entryElement);
                }
                annotDocument.appendChild(cvElement);
            }
        }
        if (debug) {
            System.out.println("Constraints and CV's creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        return eafFactory.getDocumentElement();
    }

    public static Element createTemplateDOM(Transcription theTranscription, List tierOrder) {
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF25 eafFactory = null;
        try {
            eafFactory = new EAF25();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm z");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        String author = attisTr.getAuthor();
        author = "";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        boolean annIndex = true;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String id = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String annotator = (String)tierImpl.getMetadataValue("ANNOTATOR");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, annotator, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
        }
        Vector vector = attisTr.getLinguisticTypes();
        if (vector != null) {
            for (LinguisticType lt : vector) {
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), lt.hasGraphicReferences(), stereotype, lt.getControlledVocabylaryName());
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        Vector conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            for (int i = 0; i < conVocs.size(); ++i) {
                ControlledVocabulary cv = (ControlledVocabulary)conVocs.get(i);
                Element cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription());
                    cvElement.appendChild(entryElement);
                }
                annotDocument.appendChild(cvElement);
            }
        }
        return eafFactory.getDocumentElement();
    }

    private static String correctDate(String strIn) {
        String strResult = new String(strIn);
        try {
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            String strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = strOffset + "0";
            }
            strOffset = strOffset + offsetGMT + ":00";
            int indexSpace = (strResult = strResult + strOffset).indexOf(" ");
            if (indexSpace != -1) {
                String strEnd = strResult.substring(indexSpace + 1);
                strResult = strResult.substring(0, indexSpace);
                strResult = strResult + "T";
                strResult = strResult + strEnd;
            }
            strResult = strResult.replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }

    private static void save(Element documentElement, String path) throws IOException {
        LOG.info(path + " <----XML output\n");
        try {
            if (("" + documentElement).length() == 0) {
                throw new IOException("Unable to save this file (zero length).");
            }
            long beginTime = System.currentTimeMillis();
            IoUtil.writeEncodedEAFFile("UTF-8", path, documentElement);
            if (debug) {
                System.out.println("Saving file took: " + (System.currentTimeMillis() - beginTime) + " ms");
            }
        }
        catch (Exception eee) {
            throw new IOException("Unable to save this file: " + eee.getMessage());
        }
    }
}

