/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.flex;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Flex2EAF
extends DefaultHandler {
    int currentTimeSlot = 1;
    int totalTime = 300000;
    Properties typeRenamings = null;
    Properties extTypes = null;
    String mediaFile = null;
    String mimeType = null;
    String noSynch = "word";
    boolean addSynchData = true;
    HashMap<String, tierObject> tiers = new HashMap();
    HashMap<String, itemObject> items = new HashMap();
    ArrayList<String> tierNames = new ArrayList();
    Stack<String> stack = new Stack();
    Stack<Integer> timeStack = new Stack();
    HashMap<String, String> tierOfItem = new HashMap();
    Stack<String> parentTiersIDStack = new Stack();
    Stack<String> parentItemIDStack = new Stack();
    String currentItemID = "";
    StringBuffer itemVal = new StringBuffer();
    PrintWriter pW = null;
    boolean debugOn = false;
    private int annotation_ID = 1;

    public Flex2EAF(Writer w) {
        this.pW = new PrintWriter(w, true);
        this.extTypes = this.readExtTypes();
    }

    public Flex2EAF(Writer w, boolean dbg, int totTime, String typePairs, String mediaFileStr, String noSynchStr) throws Exception {
        this.mediaFile = mediaFileStr;
        this.noSynch = noSynchStr;
        this.pW = new PrintWriter(w, true);
        if (typePairs != null && typePairs.length() > 0) {
            this.typeRenamings = new Properties();
            String[] pairs = typePairs.split(",");
            for (int i = 0; i < pairs.length; ++i) {
                String[] pair = pairs[i].split(":");
                if (pair == null || pair.length != 2) continue;
                this.typeRenamings.setProperty(pair[0], pair[1]);
            }
        }
        this.debugOn = dbg;
        this.totalTime = totTime;
        this.extTypes = this.readExtTypes();
        if (this.mediaFile != null) {
            String[] fp = this.mediaFile.split("[.]");
            this.mimeType = this.extTypes.getProperty(fp[fp.length - 1]);
        }
    }

    public Flex2EAF(Writer w, boolean dbg, int totTime) {
        this.debugOn = dbg;
        this.totalTime = totTime;
        this.pW = new PrintWriter(w, true);
        this.extTypes = this.readExtTypes();
    }

    public Flex2EAF(Writer w, int totTime) {
        this.totalTime = totTime;
        this.pW = new PrintWriter(w, true);
        this.extTypes = this.readExtTypes();
    }

    public void addTier(tierObject tOb) {
        this.tierNames.add(tOb.tierID);
        this.tiers.put(tOb.tierID, tOb);
    }

    public void writeDocEltOpen() {
        this.pW.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        this.pW.write("<ANNOTATION_DOCUMENT AUTHOR='' DATE='2004-02-12T14:59:03+01:00'  FORMAT='2.6' VERSION='2.6'  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'  xsi:noNamespaceSchemaLocation='http://www.mpi.nl/tools/elan/EAFv2.6.xsd'>\n");
    }

    public void writeHeader() {
        if (this.mediaFile == null) {
            this.pW.write(" <HEADER MEDIA_FILE='' TIME_UNITS='milliseconds'>\n   <MEDIA_DESCRIPTOR MEDIA_URL='file:///home/tjm/elan-example1.mpg' MIME_TYPE='video/mpeg' RELATIVE_MEDIA_URL='file:/./elan-example1.mpg'/>\n  <MEDIA_DESCRIPTOR MEDIA_URL='file:///home/tjm/elan-example1.wav' MIME_TYPE='audio/x-wav' RELATIVE_MEDIA_URL='file:/./elan-example1.wav' EXTRACTED_FROM='file:///home/tjm/elan-example1.mpg'/>\n</HEADER>\n");
        } else if (this.mediaFile.startsWith("http://")) {
            this.pW.write(" <HEADER MEDIA_FILE='' TIME_UNITS='milliseconds'>\n   <MEDIA_DESCRIPTOR MIME_TYPE='" + this.mimeType + "' MEDIA_URL='" + this.mediaFile + "'/>\n" + "</HEADER>\n");
        } else {
            this.pW.write(" <HEADER MEDIA_FILE='' TIME_UNITS='milliseconds'>\n   <MEDIA_DESCRIPTOR MIME_TYPE='" + this.mimeType + "' MEDIA_URL='file:/./" + this.mediaFile + "'/>\n" + "</HEADER>\n");
        }
    }

    public void parse(InputSource iSource) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            try {
                spf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException e) {
                this.pW.write("error " + e + " in setting up parser feature");
            }
            SAXParser parser = spf.newSAXParser();
            parser.parse(iSource, (DefaultHandler)this);
        }
        catch (Exception ex) {
            ex.printStackTrace(this.pW);
        }
    }

    @Override
    public void startDocument() {
        this.writeDocEltOpen();
        this.writeHeader();
    }

    @Override
    public void characters(char[] ch, int offset, int len) {
        int lim = offset + len;
        while (offset < lim) {
            char c;
            if ((c = ch[offset++]) == '&') {
                this.itemVal.append("&amp;");
                continue;
            }
            if (c == '<') {
                this.itemVal.append("&lt;");
                continue;
            }
            if (c == '>') {
                this.itemVal.append("&gt;");
                continue;
            }
            this.itemVal.append(c);
        }
    }

    public void startItem(String uri, String localName, String qName, Attributes atts) throws SAXException {
        new itemObject(atts);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("item".equals(qName)) {
            this.startItem(uri, localName, qName, atts);
        }
        if (this.debugOn) {
            this.pW.write("<" + qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.pW.write(" " + atts.getQName(i) + "='" + atts.getValue(i) + "'\n");
            }
            this.pW.write(">");
        }
        this.stack.push(qName);
        this.itemVal.setLength(0);
        this.timeStack.push(this.currentTimeSlot);
        if (qName.equals(this.noSynch)) {
            this.addSynchData = false;
        }
    }

    private int newAnnotationID() {
        return this.annotation_ID++;
    }

    private void endItem(String uri, String localName, String qName) throws SAXException {
        try {
            this.stack.pop();
            this.timeStack.pop();
            if (this.debugOn) {
                this.pW.write(this.itemVal.toString());
                this.pW.write("</item>");
            }
            itemObject item = this.items.get(this.currentItemID);
            item.append(this.itemVal.toString());
            this.itemVal.setLength(0);
        }
        catch (Exception ex) {
            this.pW.write("Exception in endItem: " + ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Object itemID = null;
        Object tierID = null;
        if ("item".equals(qName)) {
            this.endItem(uri, localName, qName);
        } else {
            this.clearTiers(qName + "-");
            if (this.debugOn) {
                this.pW.write("</" + qName + ">\n");
            }
            this.stack.pop();
            this.timeStack.pop();
            if (qName.equals(this.noSynch)) {
                this.addSynchData = true;
            }
        }
    }

    private void clearTiers(String tierPrefix) {
        while (this.parentTiersIDStack.size() > 0) {
            String tierID = this.parentTiersIDStack.peek();
            if (!tierID.startsWith(tierPrefix)) {
                return;
            }
            this.parentTiersIDStack.pop();
            if (this.debugOn) {
                this.pW.write("<POPPINGTIER>" + tierID + "</POPPINGTIER>\n");
            }
            this.clearTierItems(tierID);
        }
    }

    private void clearTierItems(String tierID) {
        while (this.parentItemIDStack.size() > 0) {
            String itemID = this.parentItemIDStack.peek();
            if (!tierID.equals(this.tierOfItem.get(itemID))) {
                return;
            }
            this.parentItemIDStack.pop();
            itemObject item = this.items.get(itemID);
            if (this.currentTimeSlot == item.ts1) {
                // empty if block
            }
            item.ts2 = ++this.currentTimeSlot;
            if (!this.debugOn) continue;
            this.pW.write("<POPPING>" + itemID + ": " + tierID + " =" + item.value + "\n</POPPING>\n");
        }
    }

    @Override
    public void endDocument() {
        String tierID;
        int i;
        int aveTime = this.totalTime / (1 + this.currentTimeSlot);
        HashSet<Integer> synchedTimeSlots = new HashSet<Integer>();
        for (i = 0; i < this.tierNames.size(); ++i) {
            tierID = this.tierNames.get(i);
            this.tiers.get(tierID).addTimeSlots(synchedTimeSlots);
        }
        this.pW.write("<TIME_ORDER>");
        for (i = 0; i < this.currentTimeSlot; ++i) {
            if (synchedTimeSlots.contains(i + 1)) {
                this.pW.write("<TIME_SLOT TIME_SLOT_ID='ts" + (i + 1) + "' TIME_VALUE='" + i * aveTime + "'/>\n");
                continue;
            }
            this.pW.write("<TIME_SLOT TIME_SLOT_ID='ts" + (i + 1) + "'/>\n");
        }
        this.pW.write("</TIME_ORDER>\n");
        for (i = 0; i < this.tierNames.size(); ++i) {
            tierID = this.tierNames.get(i);
            this.pW.write(this.tiers.get(tierID).toString());
        }
        this.pW.write("<LINGUISTIC_TYPE LINGUISTIC_TYPE_ID='text' TIME_ALIGNABLE='true' GRAPHIC_REFERENCES='false'/>\n");
        this.pW.write("<LINGUISTIC_TYPE LINGUISTIC_TYPE_ID='chunk' TIME_ALIGNABLE='false' GRAPHIC_REFERENCES='false' CONSTRAINTS='Symbolic_Subdivision'/>\n");
        this.pW.write("<LINGUISTIC_TYPE LINGUISTIC_TYPE_ID='gloss' TIME_ALIGNABLE='false' GRAPHIC_REFERENCES='false' CONSTRAINTS='Symbolic_Association'/>\n");
        this.pW.write("<LOCALE LANGUAGE_CODE='en' COUNTRY_CODE='US'/>\n");
        this.pW.write("<CONSTRAINT STEREOTYPE='Time_Subdivision' DESCRIPTION=\"Time subdivision of parent annotation's time interval, no time gaps allowed within this interval\"/>\n");
        this.pW.write("<CONSTRAINT STEREOTYPE='Symbolic_Subdivision' DESCRIPTION='Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered'/>\n");
        this.pW.write("<CONSTRAINT STEREOTYPE='Symbolic_Association' DESCRIPTION='1-1 association with a parent annotation'/>\n");
        this.pW.write("<CONSTRAINT STEREOTYPE='Included_In' DESCRIPTION=\"Time alignable annotations within the parent annotation's time interval, gaps are allowed\"/>\n");
        this.pW.write("</ANNOTATION_DOCUMENT>\n");
        this.pW.flush();
    }

    private Properties readExtTypes() {
        Properties extTypes = new Properties();
        String[][] extTypePairs = new String[][]{{"abs", "audio/x-mpeg"}, {"aif", "audio/x-aiff"}, {"aifc", "audio/x-aiff"}, {"aiff", "audio/x-aiff"}, {"asf", "video/x-ms-asf"}, {"asx", "video/x-ms-asf"}, {"au", "audio/basic"}, {"avi", "video/x-msvideo"}, {"avx", "video/x-rad-screenplay"}, {"dv", "video/x-dv"}, {"kar", "audio/midi"}, {"m3u", "audio/x-mpegurl"}, {"mid", "audio/midi"}, {"midi", "audio/midi"}, {"mov", "video/quicktime"}, {"movie", "video/x-sgi-movie"}, {"mp1", "audio/x-mpeg"}, {"mp2", "audio/mpeg"}, {"mp3", "audio/mpeg"}, {"mp4", "video/mp4"}, {"mpa", "audio/x-mpeg"}, {"mpe", "video/mpeg"}, {"mpeg", "video/mpeg"}, {"mpega", "audio/x-mpeg"}, {"mpg", "video/mpeg"}, {"mpv2", "video/mpeg2"}, {"qt", "video/quicktime"}, {"smf", "audio/x-midi"}, {"snd", "audio/basic"}, {"ulw", "audio/basic"}, {"wav", "audio/x-wav"}, {"wmv", "video/x-ms-wmv"}};
        for (int i = 0; i < extTypePairs.length; ++i) {
            String[] p = extTypePairs[i];
            extTypes.setProperty(p[0], p[1]);
        }
        if (this.debugOn) {
            this.pW.println(extTypes.toString());
        }
        return extTypes;
    }

    public static void main(String[] args) throws Exception {
        String filePathPrefix = "";
        if (args.length < 1) {
            System.out.println("usage: java Flex2EAF flexFile.xml [timeInMSec [mediaFile [noSynch [renamings [showDebug]]]]]");
            System.out.println(" e.g.: java Flex2EAF khinalug.xml 37000 khinalug.mpg word word-txt-en:word,word-txt-ru:word true");
            System.out.println(" which uses renaming to merge two tiers into the single tier 'word' and shows debugging output");
            System.out.println(" or  : java Flex2EAF khinalug.xml");
            System.out.println("        which defaults to 300000 msec, i.e. five minutes and elan-example1.mpg");
            System.exit(0);
        }
        InputStreamReader reader = null;
        String fileName = args[0];
        int totalTime = 300000;
        if (args.length > 1) {
            try {
                totalTime = Integer.parseInt(args[1]);
            }
            catch (Exception ex) {
                System.out.println("total Time in milliseconds=[" + args[1] + "]");
                System.exit(1);
            }
        }
        String mediaFileStr = null;
        if (args.length > 2) {
            mediaFileStr = args[2];
        }
        String noSynchStr = null;
        if (args.length > 3) {
            noSynchStr = args[3];
        }
        String typeRenamings = null;
        if (args.length > 4 && args[4].length() > 0) {
            typeRenamings = args[4];
        }
        boolean showDebug = false;
        if (args.length > 5) {
            showDebug = "true".equalsIgnoreCase(args[5]);
        }
        String filePath = filePathPrefix + fileName;
        reader = new InputStreamReader((InputStream)new FileInputStream(filePath), "utf-8");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath + ".eaf"), "utf-8");
        if (reader != null) {
            Flex2EAF f2e = new Flex2EAF(writer, showDebug, totalTime, typeRenamings, mediaFileStr, noSynchStr);
            PushbackReader pbReader = new PushbackReader(reader);
            int first = pbReader.read();
            if (first != -1 && first != 65279) {
                pbReader.unread(first);
            }
            f2e.parse(new InputSource(pbReader));
        }
    }

    class itemObject {
        String itemType = null;
        String itemLang = null;
        public boolean isAlign = false;
        public boolean isParent = false;
        public int ts1;
        public int ts2 = 0;
        public int tierLoc = -1;
        public String itemID;
        public String refID;
        public String defaultTierID;
        public String tierID;
        public String pTierID = "";
        public String prevAnnotationRefID = null;
        public String prevAnnotationID = null;
        private StringBuffer value = null;

        public itemObject(Attributes atts) {
            this.itemType = atts.getValue("type");
            this.itemLang = atts.getValue("lang");
            String tierPrefix = Flex2EAF.this.stack.peek() + "-";
            this.defaultTierID = tierPrefix + this.itemType + "-" + this.itemLang;
            this.tierID = Flex2EAF.this.typeRenamings == null ? this.defaultTierID : Flex2EAF.this.typeRenamings.getProperty(this.defaultTierID, this.defaultTierID);
            try {
                this.pTierID = Flex2EAF.this.parentTiersIDStack.peek();
            }
            catch (EmptyStackException ese) {
                this.pTierID = null;
            }
            try {
                this.refID = Flex2EAF.this.parentItemIDStack.peek();
            }
            catch (EmptyStackException ese) {
                this.refID = null;
            }
            this.ts1 = Flex2EAF.this.timeStack.peek();
            this.itemID = "a" + Flex2EAF.this.newAnnotationID();
            Flex2EAF.this.items.put(this.itemID, this);
            Flex2EAF.this.currentItemID = this.itemID;
            this.value = new StringBuffer();
            this.isParent = this.pTierID == null || !this.pTierID.startsWith(tierPrefix);
            this.isAlign = Flex2EAF.this.addSynchData && this.isParent;
            tierObject tOb = Flex2EAF.this.tiers.get(this.tierID);
            if (null == tOb) {
                tOb = new tierObject(this.tierID, this.pTierID, this.isAlign, "", "", "", this.isParent);
                Flex2EAF.this.tierNames.add(tOb.tierID);
                Flex2EAF.this.tiers.put(tOb.tierID, tOb);
            }
            tOb.default_locale = this.itemLang;
            if (this.isParent) {
                Flex2EAF.this.parentTiersIDStack.push(this.tierID);
                if (Flex2EAF.this.debugOn) {
                    Flex2EAF.this.pW.write("<PUSHINGTIER>" + this.tierID + "</PUSHINGTIER>\n");
                }
            }
            this.tierLoc = tOb.items.size();
            tOb.items.add(this);
            if (this.isParent) {
                Flex2EAF.this.parentItemIDStack.push(this.itemID);
                Flex2EAF.this.tierOfItem.put(this.itemID, this.tierID);
                if (Flex2EAF.this.debugOn) {
                    Flex2EAF.this.pW.write("<PUSHING>" + this.itemID + "</PUSHING>\n");
                }
            }
            if (!this.isAlign && this.isParent && this.tierLoc > 0) {
                itemObject prevItem = (itemObject)tOb.items.get(this.tierLoc - 1);
                this.prevAnnotationRefID = prevItem.refID;
                this.prevAnnotationID = prevItem.itemID;
            }
        }

        public void append(String val) {
            this.value.append(val);
        }

        public String toString() {
            StringBuffer sBuff = new StringBuffer("<ANNOTATION>");
            if (this.isAlign) {
                sBuff.append("<ALIGNABLE_ANNOTATION TIME_SLOT_REF1='ts").append(this.ts1).append("' TIME_SLOT_REF2='ts").append(this.ts2).append("' ANNOTATION_ID='").append(this.itemID).append("'>\n<ANNOTATION_VALUE>").append(this.value.toString()).append("</ANNOTATION_VALUE></ALIGNABLE_ANNOTATION>\n");
            } else if (this.refID.equals(this.prevAnnotationRefID)) {
                sBuff.append("<REF_ANNOTATION ANNOTATION_REF='").append(this.refID).append("' PREVIOUS_ANNOTATION='").append(this.prevAnnotationID).append("' ANNOTATION_ID='").append(this.itemID).append("'>\n<ANNOTATION_VALUE>").append(this.value.toString()).append("</ANNOTATION_VALUE></REF_ANNOTATION>\n");
            } else {
                sBuff.append("<REF_ANNOTATION ANNOTATION_REF='").append(this.refID).append("' ANNOTATION_ID='").append(this.itemID).append("'>\n<ANNOTATION_VALUE>").append(this.value.toString()).append("</ANNOTATION_VALUE></REF_ANNOTATION>\n");
            }
            sBuff.append("</ANNOTATION>\n");
            return sBuff.toString();
        }
    }

    class tierObject {
        public String tierID = "";
        public String parent_ref = "";
        public boolean isAlignable = false;
        public boolean isParent = false;
        public String default_locale = "";
        public String linguistic_type_ref = "";
        public String participant = "";
        private ArrayList<itemObject> items = null;

        public tierObject(String xtierID, String xparent_ref, boolean xisAlignable, String xdefault_locale, String xlinguistic_type_ref, String xparticipant, boolean xisParent) {
            this.tierID = xtierID;
            this.parent_ref = xparent_ref;
            this.isAlignable = xisAlignable;
            this.isParent = xisParent;
            this.default_locale = xdefault_locale;
            if (this.default_locale == null || this.default_locale.equals("")) {
                this.default_locale = "en";
            }
            this.linguistic_type_ref = xlinguistic_type_ref;
            if (this.linguistic_type_ref == null || this.linguistic_type_ref.equals("")) {
                this.linguistic_type_ref = this.isAlignable ? "text" : (this.isParent ? "chunk" : "gloss");
            }
            this.participant = xparticipant;
            this.items = new ArrayList();
        }

        public String toString() {
            StringBuffer sBuff = new StringBuffer("<TIER TIER_ID='" + this.tierID + "'");
            if (this.parent_ref != null && !"".equals(this.parent_ref)) {
                sBuff.append(" PARENT_REF='" + this.parent_ref + "'");
            }
            sBuff.append(" DEFAULT_LOCALE='" + this.default_locale + "'");
            sBuff.append(" LINGUISTIC_TYPE_REF='" + this.linguistic_type_ref + "'");
            if (this.participant != null && this.participant.length() > 0) {
                sBuff.append(" PARTICIPANT='" + this.participant + "'");
            }
            sBuff.append(">\n");
            for (int i = 0; i < this.items.size(); ++i) {
                sBuff.append(this.items.get(i).toString());
            }
            sBuff.append("</TIER>\n");
            return sBuff.toString();
        }

        public void addTimeSlots(HashSet<Integer> synchedTimeSlots) {
            for (int i = 0; i < this.items.size(); ++i) {
                itemObject item = this.items.get(i);
                if (!item.isAlign) continue;
                synchedTimeSlots.add(item.ts1);
                synchedTimeSlots.add(item.ts2);
            }
        }
    }
}

